/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.vai.controls;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.AlgorithmDescriptorDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDependencyDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.lang.ScriptParser;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.calculated.FormulaNode;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableInstanceExplicitDependency;
import de.elpro.ewms.core.variable.custom.AlgorithmDescriptor;
import de.elpro.ewms.core.variable.custom.AlgorithmParameter;
import de.elpro.ewms.engin.gui.navi.server.vai.controls.DependencyOperation;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.cells.uimodel.UIModelListCell;
import de.elpro.ui.fx.cells.uimodel.UIModelTreeCell;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.TaskUtils;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.model.UIModelElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import jidefx.scene.control.decoration.DecorationPane;
import jidefx.scene.control.validation.ValidationEvent;
import jidefx.scene.control.validation.ValidationGroup;
import jidefx.scene.control.validation.ValidationMode;
import jidefx.scene.control.validation.ValidationUtils;
import jidefx.scene.control.validation.Validator;
import org.controlsfx.dialog.Wizard;
import org.controlsfx.dialog.WizardPane;

public class AddOrEditDependenciesWizard
extends Wizard {
    private static final double PREF_HEIGHT = 700.0;
    private static final double PREF_WIDTH = 800.0;
    private final SimpleObjectProperty<Object> formula = new SimpleObjectProperty();
    private final ObservableList<VariableInstance> variableDstInstances;
    private final SimpleStringProperty dependencyKey = new SimpleStringProperty();
    private final SimpleObjectProperty<DependencyLocationType> locationType = new SimpleObjectProperty();
    private final SimpleObjectProperty<SearchPolicy> searchPolicy = new SimpleObjectProperty();
    private final SimpleObjectProperty<Variable> dependencyVariable = new SimpleObjectProperty();
    private final ObservableList<VariableInstance> fixedDependencyInstances;
    private final SimpleBooleanProperty deleteOldInstaces = new SimpleBooleanProperty();
    private final SimpleBooleanProperty deleteOldKeys = new SimpleBooleanProperty();
    private final List<DependencyOperation> operations = new LinkedList<DependencyOperation>();

    public AddOrEditDependenciesWizard(Variable variable, Scene scene) {
        super((Object)scene.getWindow());
        this.setTitle(String.format("%s dependencies ", variable));
        DstInstancesWizardPane firstPane = new DstInstancesWizardPane(variable);
        this.formula.bind((ObservableValue)firstPane.formulaFilter.valueProperty());
        this.variableDstInstances = firstPane.getDstInstances();
        DependenciesWizardPane secondPane = new DependenciesWizardPane(variable.getStructureClass());
        this.dependencyKey.bind((ObservableValue)secondPane.keyName.valueProperty());
        this.locationType.bind((ObservableValue)secondPane.locationType.valueProperty());
        this.dependencyVariable.bind((ObservableValue)secondPane.dependencyVariable.valueProperty());
        this.fixedDependencyInstances = secondPane.fixedInstances.getSelectionModel().getSelectedItems();
        DependenciesPreferencePane thirdPane = new DependenciesPreferencePane();
        this.deleteOldInstaces.bind((ObservableValue)thirdPane.deleteSameInstances.selectedProperty());
        this.deleteOldKeys.bind((ObservableValue)thirdPane.deleteSameKeys.selectedProperty());
        this.setFlow((Wizard.Flow)new Wizard.LinearFlow(new WizardPane[]{firstPane, secondPane, thirdPane, new ChangesWizardPane(), new InfoWizardPane()}));
    }

    public Collection<DependencyOperation> getOperations() {
        return this.operations;
    }

    private static final class ChangesWizardPane
    extends WizardPane {
        private final GridPane grid = new GridPane();
        private final TreeItem<UIModelElement> addRootItem = new TreeItem();
        private final TreeItem<UIModelElement> deleteRootItem = new TreeItem();
        private final TreeView<UIModelElement> addChangesView = new TreeView(this.addRootItem);
        private final TreeView<UIModelElement> deleteChangesView = new TreeView(this.deleteRootItem);
        private final ProgressIndicatorPane progressIndicator = new ProgressIndicatorPane((Node)this.grid);

        public ChangesWizardPane() {
            VBox box = new VBox(5.0);
            box.setPadding(new Insets(5.0));
            Label label = new Label(String.format("Execute following changes?", new Object[0]));
            label.setPadding(new Insets(15.0));
            label.setStyle("-fx-font-weight: bold;");
            this.grid.setHgap(10.0);
            this.grid.setVgap(5.0);
            Label addChangesLabel = new Label("Insert dependencies");
            GridPane.setValignment((Node)addChangesLabel, (VPos)VPos.BASELINE);
            this.addChangesView.setShowRoot(false);
            this.addChangesView.setCellFactory(cf -> new UIModelTreeCell());
            GridPane.setVgrow(this.addChangesView, (Priority)Priority.ALWAYS);
            GridPane.setHgrow(this.addChangesView, (Priority)Priority.ALWAYS);
            this.grid.addRow(0, new Node[]{addChangesLabel, this.addChangesView});
            Label deleteChangesLabel = new Label("Delete dependencies");
            GridPane.setValignment((Node)deleteChangesLabel, (VPos)VPos.BASELINE);
            this.deleteChangesView.setShowRoot(false);
            this.deleteChangesView.setCellFactory(cf -> new UIModelTreeCell());
            this.deleteChangesView.setPrefHeight(200.0);
            GridPane.setHgrow(this.deleteChangesView, (Priority)Priority.ALWAYS);
            this.grid.addRow(1, new Node[]{deleteChangesLabel, this.deleteChangesView});
            VBox.setVgrow((Node)this.progressIndicator, (Priority)Priority.ALWAYS);
            box.getChildren().addAll((Object[])new Node[]{label, this.progressIndicator});
            this.setContent((Node)box);
            this.setPrefWidth(800.0);
            this.setPrefHeight(700.0);
        }

        public void onEnteringPage(Wizard wizard) {
            this.addRootItem.getChildren().clear();
            this.deleteRootItem.getChildren().clear();
            final AddOrEditDependenciesWizard depWizard = (AddOrEditDependenciesWizard)wizard;
            depWizard.operations.clear();
            CallableTask<Map<VariableInstance, List<DependencyOperation>>> computeOperationsTask = new CallableTask<Map<VariableInstance, List<DependencyOperation>>>(){

                public Map<VariableInstance, List<DependencyOperation>> call() throws Exception {
                    LinkedHashMap<VariableInstance, List<DependencyOperation>> result = new LinkedHashMap<VariableInstance, List<DependencyOperation>>();
                    boolean deleteDepsWithSameKey = depWizard.deleteOldKeys.get();
                    boolean deleteSameInstancesDeps = depWizard.deleteOldInstaces.get();
                    DependencyLocationType locationType = (DependencyLocationType)((Object)depWizard.locationType.get());
                    Variable depVariable = (Variable)depWizard.dependencyVariable.get();
                    Transaction trx = Transactions.begin();
                    try {
                        for (VariableInstance dstInstance : depWizard.variableDstInstances) {
                            LinkedList<DependencyOperation> operations = new LinkedList<DependencyOperation>();
                            String newKey = depWizard.dependencyKey.get();
                            if (newKey != null && (newKey = newKey.trim()).isEmpty()) {
                                newKey = null;
                            }
                            if (locationType == DependencyLocationType.Static) {
                                for (VariableInstance depInstance : depWizard.fixedDependencyInstances) {
                                    depInstance.setVariable(depVariable);
                                    VariableInstanceExplicitDependency newDep = new VariableInstanceExplicitDependency(dstInstance, depInstance, newKey);
                                    operations.add(new DependencyOperation(newDep, false));
                                }
                            } else {
                                HashSet<VariableInstance> newDependencies = new HashSet<VariableInstance>();
                                VariableInstance[] variableInstanceArray = VariableDAO.findInstances((Transaction)trx, (Variable)depVariable, (StructureObject)dstInstance.getStructureObject(), (SearchPolicy)((SearchPolicy)depWizard.searchPolicy.get()));
                                int n = variableInstanceArray.length;
                                int newDep = 0;
                                while (newDep < n) {
                                    VariableInstance depInstance = variableInstanceArray[newDep];
                                    if (!newDependencies.contains(depInstance)) {
                                        newDependencies.add(depInstance);
                                        depInstance.setVariable(depVariable);
                                        VariableInstanceExplicitDependency newDep2 = new VariableInstanceExplicitDependency(dstInstance, depInstance, newKey);
                                        operations.add(new DependencyOperation(newDep2, false));
                                    }
                                    ++newDep;
                                }
                            }
                            for (VariableInstanceExplicitDependency oldDependency : dstInstance.getDependencies()) {
                                VariableInstance dependentOn = VariableInstanceDAO.get((Transaction)trx, (int)oldDependency.getDependentOn().getId());
                                dependentOn.setVariable(VariableDAO.get((Transaction)trx, (int)dependentOn.getVariable().getId()));
                                oldDependency.setDependentOn(dependentOn);
                                if (deleteDepsWithSameKey && (newKey == null && oldDependency.getKey() == null || newKey != null && newKey.equals(oldDependency.getKey()))) {
                                    DependencyOperation deleteOperation = new DependencyOperation(oldDependency, true);
                                    operations.add(deleteOperation);
                                    continue;
                                }
                                if (!deleteSameInstancesDeps) continue;
                                LinkedList<DependencyOperation> delOperations = new LinkedList<DependencyOperation>();
                                for (DependencyOperation operation : operations) {
                                    if (operation.isDelete() || !operation.getDependency().getDependentOn().equals((Object)oldDependency.getDependentOn())) continue;
                                    DependencyOperation deleteOperation = new DependencyOperation(oldDependency, true);
                                    delOperations.add(deleteOperation);
                                }
                                operations.addAll(delOperations);
                            }
                            result.put(dstInstance, operations);
                        }
                    }
                    finally {
                        Transactions.close((Transaction)trx);
                    }
                    return result;
                }
            };
            TaskUtils.executeUITask((ProgressIndicatorPane)this.progressIndicator, (CallableTask)computeOperationsTask).consumeResult((status, result) -> {
                if (status == Worker.State.SUCCEEDED) {
                    Platform.runLater(() -> {
                        for (Map.Entry entry : result.entrySet()) {
                            VariableInstance dstInstance = (VariableInstance)entry.getKey();
                            TreeItem dstInstanceAddItem = new TreeItem((Object)dstInstance);
                            TreeItem dstInstanceDeleteItem = new TreeItem((Object)dstInstance);
                            for (DependencyOperation depOperation : (List)entry.getValue()) {
                                TreeItem depOperationItem = new TreeItem((Object)depOperation);
                                if (depOperation.isDelete()) {
                                    dstInstanceDeleteItem.getChildren().add((Object)depOperationItem);
                                } else {
                                    dstInstanceAddItem.getChildren().add((Object)depOperationItem);
                                }
                                addOrEditDependenciesWizard.operations.add(depOperation);
                            }
                            dstInstanceAddItem.setExpanded(true);
                            dstInstanceDeleteItem.setExpanded(true);
                            this.addRootItem.getChildren().add((Object)dstInstanceAddItem);
                            if (dstInstanceDeleteItem.getChildren().isEmpty()) continue;
                            this.deleteRootItem.getChildren().add((Object)dstInstanceDeleteItem);
                        }
                    });
                }
            });
        }
    }

    private static final class DependenciesPreferencePane
    extends WizardPane {
        private final CheckBox deleteSameInstances = new CheckBox("Delete old dependencies with same dependency instance");
        private final CheckBox deleteSameKeys = new CheckBox("Delete old dependencies with same dependency key");

        public DependenciesPreferencePane() {
            VBox box = new VBox(5.0);
            box.setPadding(new Insets(5.0));
            Label label = new Label(String.format("Dependency insertment preferences", new Object[0]));
            label.setPadding(new Insets(15.0));
            label.setStyle("-fx-font-weight: bold;");
            box.getChildren().add((Object)label);
            this.deleteSameInstances.setSelected(true);
            box.getChildren().add((Object)this.deleteSameInstances);
            this.deleteSameKeys.setSelected(true);
            box.getChildren().add((Object)this.deleteSameKeys);
            this.setContent((Node)box);
            this.setPrefWidth(800.0);
            this.setPrefHeight(700.0);
        }

        public void onEnteringPage(Wizard wizard) {
            wizard.invalidProperty().unbind();
            wizard.setInvalid(false);
        }
    }

    private static final class DependenciesWizardPane
    extends WizardPane {
        private final ComboBox<String> keyName = new ComboBox();
        private final ComboBox<DependencyLocationType> locationType = new ComboBox(FXCollections.observableArrayList((Object[])DependencyLocationType.values()));
        private final ComboBox<StructureClass> dependencyClass = new ComboBox();
        private final ComboBox<Variable> dependencyVariable = new ComboBox();
        private final ComboBox<SearchPolicy> searchPolicyCb = new ComboBox();
        private final Label fixedInstancesLabel = new Label("Fixed instances");
        private final ListView<VariableInstance> fixedInstances = new ListView();

        public DependenciesWizardPane(StructureClass sourceClass) {
            GridPane grid = new GridPane();
            grid.setHgap(10.0);
            grid.setVgap(5.0);
            grid.setPadding(new Insets(5.0));
            Label label = new Label(String.format("Select dependencies references", new Object[0]));
            label.setPadding(new Insets(15.0));
            label.setStyle("-fx-font-weight: bold;");
            GridPane.setColumnSpan((Node)label, (Integer)2);
            grid.addRow(0, new Node[]{label});
            Label dependencyKeyLabel = new Label("Key");
            this.keyName.setEditable(true);
            GridPane.setHgrow(this.keyName, (Priority)Priority.ALWAYS);
            this.keyName.setMaxWidth(Double.MAX_VALUE);
            ValidationUtils.install(this.keyName, param -> {
                Object nv = param.getNewValue();
                if (nv == null || ((String)nv).isEmpty()) {
                    return new ValidationEvent(ValidationEvent.VALIDATION_WARNING, 1, "Dependency key schold be not empty");
                }
                try {
                    String text = ((String)nv).trim();
                    if (text.contains(" ") || text.contains(",")) {
                        return new ValidationEvent(ValidationEvent.VALIDATION_ERROR, 0, "Key schould not contain empty chars or ','");
                    }
                    Double.parseDouble(text);
                    return new ValidationEvent(ValidationEvent.VALIDATION_ERROR, 0, "Dependency key must be not a number");
                }
                catch (Exception exception) {
                    return ValidationEvent.OK;
                }
            });
            GridPane.setHgrow(this.keyName, (Priority)Priority.ALWAYS);
            grid.addRow(1, new Node[]{dependencyKeyLabel, this.keyName});
            Label dependencyClassLabel = new Label("Object class");
            Transaction trx = Transactions.begin();
            try {
                this.dependencyClass.getItems().addAll((Object[])StructureClassDAO.getAll((Transaction)trx));
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            this.dependencyClass.valueProperty().addListener((o, ov, nv) -> {
                Transaction td = Transactions.begin();
                try {
                    if (nv != null) {
                        this.dependencyVariable.getItems().setAll((Object[])StructureClassDAO.getAllVariables((Transaction)td, (int)((StructureClass)this.dependencyClass.getValue()).getId()));
                        if (this.dependencyVariable.getValue() != null && !this.dependencyVariable.getItems().contains(this.dependencyVariable.getValue())) {
                            this.dependencyVariable.setValue(null);
                        }
                    } else {
                        this.dependencyVariable.getItems().clear();
                    }
                    ValidationUtils.forceValidate(this.dependencyVariable, (ValidationMode)ValidationMode.ON_FLY);
                    ValidationUtils.forceValidate(this.fixedInstances, (ValidationMode)ValidationMode.ON_FLY);
                }
                finally {
                    Transactions.close((Transaction)td);
                }
            });
            this.dependencyClass.setMaxWidth(Double.MAX_VALUE);
            GridPane.setHgrow(this.dependencyClass, (Priority)Priority.ALWAYS);
            ValidationUtils.install(this.dependencyClass, (Validator)Validators.createNotEmptyValidator((String)"Select class to update variables filter"));
            grid.addRow(2, new Node[]{dependencyClassLabel, this.dependencyClass});
            Label dependencyVariableLabel = new Label("Variable");
            this.dependencyVariable.valueProperty().addListener((o, ov, nv) -> {
                this.updateFixedInstacesList();
                ValidationUtils.forceValidate(this.fixedInstances, (ValidationMode)ValidationMode.ON_FLY);
            });
            this.dependencyVariable.setMaxWidth(Double.MAX_VALUE);
            GridPane.setHgrow(this.dependencyVariable, (Priority)Priority.ALWAYS);
            ValidationUtils.install(this.dependencyVariable, (Validator)Validators.createNotEmptyValidator((String)"Select dependency variable"));
            grid.addRow(3, new Node[]{dependencyVariableLabel, this.dependencyVariable});
            Label locationTypeLabel = new Label("Instance location");
            this.locationType.setValue((Object)DependencyLocationType.Static);
            GridPane.setHgrow(this.locationType, (Priority)Priority.ALWAYS);
            this.locationType.setMaxWidth(Double.MAX_VALUE);
            grid.addRow(4, new Node[]{locationTypeLabel, this.locationType});
            Label searchPolicyLabel = new Label("Search Policy");
            this.searchPolicyCb.getItems().setAll((Object[])SearchPolicy.values());
            this.searchPolicyCb.setValue((Object)SearchPolicy.Auto);
            this.searchPolicyCb.setDisable(true);
            GridPane.setHgrow(this.searchPolicyCb, (Priority)Priority.ALWAYS);
            grid.addRow(5, new Node[]{searchPolicyLabel, this.searchPolicyCb});
            this.locationType.valueProperty().addListener((o, ov, nv) -> {
                this.updateFixedInstacesList();
                ValidationUtils.forceValidate(this.fixedInstances, (ValidationMode)ValidationMode.ON_FLY);
                this.searchPolicyCb.setDisable(nv == DependencyLocationType.Static);
            });
            GridPane.setValignment((Node)this.fixedInstancesLabel, (VPos)VPos.BASELINE);
            this.fixedInstances.setCellFactory(cf -> new UIModelListCell());
            this.fixedInstances.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            ValidationUtils.install(this.fixedInstances, (Validator)Validators.createValidator((o, ov, nv) -> DependencyLocationType.Automatic == this.locationType.getValue() || nv instanceof VariableInstance, (String)"Select static instances to add as dependency"));
            GridPane.setVgrow(this.fixedInstances, (Priority)Priority.ALWAYS);
            grid.addRow(6, new Node[]{this.fixedInstancesLabel, this.fixedInstances});
            this.setContent((Node)new DecorationPane((Parent)grid));
            this.setPrefWidth(800.0);
            this.setPrefHeight(700.0);
        }

        private void updateFixedInstacesList() {
            if (DependencyLocationType.Automatic == this.locationType.getValue()) {
                this.fixedInstances.getItems().clear();
                this.fixedInstancesLabel.setDisable(true);
                this.fixedInstances.setDisable(true);
            } else {
                this.fixedInstancesLabel.setDisable(false);
                this.fixedInstances.setDisable(false);
                Variable var = (Variable)this.dependencyVariable.getValue();
                if (var != null) {
                    Transaction trx = Transactions.begin();
                    try {
                        this.fixedInstances.getItems().setAll(Arrays.asList(VariableInstanceDAO.getAll((Transaction)trx, (Variable)var)));
                    }
                    finally {
                        Transactions.close((Transaction)trx);
                    }
                } else {
                    this.fixedInstances.getItems().clear();
                }
            }
        }

        public void onEnteringPage(Wizard wizard) {
            wizard.invalidProperty().unbind();
            ValidationGroup validationGroup = new ValidationGroup(new Node[]{this.keyName, this.dependencyClass, this.dependencyVariable, this.fixedInstances});
            wizard.invalidProperty().bind((ObservableValue)validationGroup.invalidProperty());
            AddOrEditDependenciesWizard depWizard = (AddOrEditDependenciesWizard)wizard;
            try {
                Object formulaObj = depWizard.formula.get();
                if (formulaObj instanceof String) {
                    FormulaNode formulaNode = ScriptParser.parseFormula((String)formulaObj.toString());
                    this.keyName.getItems().setAll(formulaNode.getAllArgs());
                } else if (formulaObj instanceof AlgorithmDescriptor) {
                    AlgorithmDescriptor descr = (AlgorithmDescriptor)formulaObj;
                    TreeSet<String> keys = new TreeSet<String>();
                    AlgorithmParameter[] algorithmParameterArray = descr.getParameters();
                    int n = algorithmParameterArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AlgorithmParameter param = algorithmParameterArray[n2];
                        keys.add(param.getKey());
                        ++n2;
                    }
                    this.keyName.getItems().setAll(keys);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            depWizard.searchPolicy.bind((ObservableValue)this.searchPolicyCb.valueProperty());
            ValidationUtils.forceValidate(this.keyName, (ValidationMode)ValidationMode.ON_FLY);
            ValidationUtils.forceValidate(this.dependencyClass, (ValidationMode)ValidationMode.ON_FLY);
            ValidationUtils.forceValidate(this.dependencyVariable, (ValidationMode)ValidationMode.ON_FLY);
            ValidationUtils.forceValidate(this.fixedInstances, (ValidationMode)ValidationMode.ON_FLY);
        }
    }

    private static enum DependencyLocationType {
        Static,
        Automatic;


        public String toString() {
            switch (this) {
                case Static: {
                    return "Static";
                }
            }
            return "Automatic";
        }
    }

    private static final class DstInstancesWizardPane
    extends WizardPane {
        private final ComboBox<Object> formulaFilter = new ComboBox();
        private final TreeView<StructureObject> objectTreeView = new TreeView();
        private ListView<VariableInstance> dstInstancesView = new ListView();
        private ObservableList<VariableInstance> selectedInstances = this.dstInstancesView.getSelectionModel().getSelectedItems();
        private final List<VariableInstance> availableInstances = new LinkedList<VariableInstance>();
        private final Set<Object> filterFormulas = new TreeSet<Object>();
        private final Map<Object, List<VariableInstance>> formulaInstances = new HashMap<Object, List<VariableInstance>>();

        public DstInstancesWizardPane(Variable variable) {
            this.filterFormulas.add("");
            HashMap<StructureObject, TreeItem> objectTree = new HashMap<StructureObject, TreeItem>();
            Transaction trx = Transactions.begin();
            try {
                LinkedList<StructureObject> objects = new LinkedList<StructureObject>();
                VariableInstance[] variableInstanceArray = VariableInstanceDAO.getAll((Transaction)trx, (Variable)variable);
                int n = variableInstanceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VariableInstance instance = variableInstanceArray[n2];
                    if (instance.getType() == VariableInstanceType.Calculated || instance.getType() == VariableInstanceType.Custom) {
                        this.availableInstances.add(instance);
                        instance.setVariable(variable);
                        Object formulaObj = instance.getType() == VariableInstanceType.Calculated ? instance.getResultCalculationFormula() : (instance.getResultCustomAlgorithmId() != null ? AlgorithmDescriptorDAO.get((String)instance.getResultCustomAlgorithmId()) : null);
                        if (formulaObj != null && !formulaObj.toString().trim().isEmpty()) {
                            List<VariableInstance> fi;
                            if (formulaObj instanceof String) {
                                formulaObj = formulaObj.toString().replaceAll("\r", " ").replaceAll("\n", " ").replaceAll("\t", " ");
                            }
                            if ((fi = this.formulaInstances.get(formulaObj)) == null) {
                                fi = new LinkedList<VariableInstance>();
                                this.formulaInstances.put(formulaObj, fi);
                            }
                            fi.add(instance);
                            this.filterFormulas.add(formulaObj);
                        }
                        objects.add(StructureObjectDAO.get((Transaction)trx, (int)instance.getStructureObject().getId()));
                    }
                    ++n2;
                }
                while (!objects.isEmpty()) {
                    StructureObject object = (StructureObject)objects.removeFirst();
                    TreeItem treeItem = (TreeItem)objectTree.get(object);
                    if (treeItem == null) {
                        treeItem = new TreeItem((Object)object);
                        objectTree.put(object, treeItem);
                    }
                    for (StructureObject parent : object.getParents()) {
                        Object parentTreeItem = (TreeItem)objectTree.get(parent);
                        if (parentTreeItem == null) {
                            parent = StructureObjectDAO.get((Transaction)trx, (int)parent.getId());
                            parentTreeItem = new TreeItem((Object)parent);
                            objects.add(parent);
                            objectTree.put(parent, (TreeItem)parentTreeItem);
                        }
                        parentTreeItem.getChildren().add((Object)treeItem);
                    }
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            GridPane grid = new GridPane();
            grid.setHgap(10.0);
            grid.setVgap(5.0);
            grid.setPadding(new Insets(5.0));
            Label label = new Label(String.format("Select instances of %s to insert depencencies (i.e. formula parameters)", variable));
            label.setPadding(new Insets(15.0));
            label.setStyle("-fx-font-weight: bold;");
            GridPane.setColumnSpan((Node)label, (Integer)2);
            grid.addRow(0, new Node[]{label});
            this.formulaFilter.getItems().setAll(this.filterFormulas);
            this.formulaFilter.getSelectionModel().select((Object)"");
            this.formulaFilter.setMaxWidth(Double.MAX_VALUE);
            GridPane.setHgrow(this.formulaFilter, (Priority)Priority.ALWAYS);
            this.formulaFilter.valueProperty().addListener((o, ov, nv) -> this.updateInstances());
            GridPane.setHgrow(this.formulaFilter, (Priority)Priority.ALWAYS);
            Label formulaLabel = new Label("Formula");
            GridPane.setValignment((Node)formulaLabel, (VPos)VPos.BASELINE);
            grid.addRow(1, new Node[]{formulaLabel, this.formulaFilter});
            this.objectTreeView.setCellFactory(cf -> new UIModelTreeCell());
            this.objectTreeView.setShowRoot(false);
            TreeItem root = new TreeItem();
            for (TreeItem treeItem : objectTree.values()) {
                if (treeItem.getParent() != null) continue;
                root.getChildren().add((Object)treeItem);
            }
            this.objectTreeView.setRoot(root);
            this.objectTreeView.setPrefHeight(150.0);
            this.objectTreeView.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> this.updateInstances());
            Label objectTreeLabel = new Label("Objects");
            GridPane.setValignment((Node)objectTreeLabel, (VPos)VPos.BASELINE);
            grid.addRow(2, new Node[]{objectTreeLabel, this.objectTreeView});
            this.dstInstancesView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            this.dstInstancesView.setCellFactory(cf -> new UIModelListCell());
            ValidationUtils.install(this.dstInstancesView, (Validator)Validators.createValidator((o, ov, nv) -> nv instanceof VariableInstance, (String)"Select at least one variable instance as destination for dependencies"));
            Label dstInstancesLabel = new Label("Instances");
            GridPane.setValignment((Node)dstInstancesLabel, (VPos)VPos.BASELINE);
            GridPane.setVgrow(this.dstInstancesView, (Priority)Priority.ALWAYS);
            grid.addRow(3, new Node[]{dstInstancesLabel, this.dstInstancesView});
            this.setContent((Node)new DecorationPane((Parent)grid));
            this.setPrefWidth(800.0);
            this.setPrefHeight(700.0);
            this.updateInstances();
            if (this.filterFormulas.size() == 2) {
                this.formulaFilter.setValue(this.formulaFilter.getItems().get(1));
            }
            ValidationUtils.forceValidate(this.dstInstancesView, (ValidationMode)ValidationMode.ON_FLY);
        }

        private ObservableList<VariableInstance> getDstInstances() {
            return this.selectedInstances;
        }

        private void updateInstances() {
            LinkedList<VariableInstance> instances = new LinkedList<VariableInstance>();
            List<VariableInstance> filteredFormulaInstances = this.formulaFilter.getSelectionModel().getSelectedItem().equals("") ? this.availableInstances : this.formulaInstances.get(this.formulaFilter.getValue());
            HashMap<StructureObject, VariableInstance> instancesPool = new HashMap<StructureObject, VariableInstance>();
            for (VariableInstance instance : filteredFormulaInstances) {
                instancesPool.put(instance.getStructureObject(), instance);
            }
            if (this.objectTreeView.getSelectionModel().getSelectedItem() != null) {
                LinkedList<TreeItem> objectPool = new LinkedList<TreeItem>();
                objectPool.add((TreeItem)this.objectTreeView.getSelectionModel().getSelectedItem());
                while (!objectPool.isEmpty()) {
                    TreeItem ti = (TreeItem)objectPool.removeFirst();
                    VariableInstance instance = (VariableInstance)instancesPool.get(ti.getValue());
                    if (instance != null) {
                        instances.add(instance);
                    }
                    objectPool.addAll((Collection<TreeItem>)ti.getChildren());
                }
            } else {
                instances.addAll(filteredFormulaInstances);
            }
            this.dstInstancesView.getItems().setAll(instances);
        }

        public void onEnteringPage(Wizard wizard) {
            wizard.invalidProperty().unbind();
            wizard.invalidProperty().bind((ObservableValue)Bindings.isEmpty(this.selectedInstances));
        }
    }

    private static final class InfoWizardPane
    extends WizardPane {
        private TextFlow errorInfo = new TextFlow();
        private Label successLabel = new Label("Success!");
        private BorderPane container = new BorderPane();
        private ProgressIndicatorPane progressIndicatorPane = new ProgressIndicatorPane((Node)this.container);

        public InfoWizardPane() {
            this.successLabel.setStyle("-fx-font-weight: bold; -fx-font-size:16px;");
            this.errorInfo.setPadding(new Insets(10.0));
            this.setContent((Node)this.progressIndicatorPane);
            this.setPrefWidth(800.0);
            this.setPrefHeight(700.0);
        }

        public void onEnteringPage(Wizard wizard) {
            AddOrEditDependenciesWizard depWizard = (AddOrEditDependenciesWizard)wizard;
            this.progressIndicatorPane.setProgress(0.0);
            this.container.setCenter(null);
            this.progressIndicatorPane.showIndicator();
            final LinkedList<VariableInstanceExplicitDependency> depsToDelete = new LinkedList<VariableInstanceExplicitDependency>();
            final LinkedList<VariableInstanceExplicitDependency> depsToInsert = new LinkedList<VariableInstanceExplicitDependency>();
            for (DependencyOperation operation : depWizard.operations) {
                if (operation.isDelete()) {
                    depsToDelete.add(operation.getDependency());
                    continue;
                }
                depsToInsert.add(operation.getDependency());
            }
            CallableTask<OperationResult> updateDependencies = new CallableTask<OperationResult>(){

                public OperationResult call() throws Exception {
                    Transaction trx = Transactions.begin();
                    try {
                        VariableInstanceDependencyDAO.deleteAll((Transaction)trx, (VariableInstanceExplicitDependency[])depsToDelete.toArray(new VariableInstanceExplicitDependency[0]));
                        Platform.runLater(() -> progressIndicatorPane.setProgress(0.2));
                        VariableInstanceDependencyDAO.saveAll((Transaction)trx, (VariableInstanceExplicitDependency[])depsToInsert.toArray(new VariableInstanceExplicitDependency[0]));
                        Platform.runLater(() -> progressIndicatorPane.setProgress(0.4));
                        Transactions.commitAsync((Transaction)trx);
                        Platform.runLater(() -> progressIndicatorPane.setProgress(1.0));
                        OperationResult operationResult = OperationResult.SUCCESS;
                        return operationResult;
                    }
                    catch (DAOOperationException exc) {
                        Transactions.rollback((Transaction)trx);
                        OperationResult operationResult = exc.getOperationResult();
                        return operationResult;
                    }
                    finally {
                        Transactions.close((Transaction)trx);
                    }
                }
            };
            TaskUtils.executeUITask(null, (CallableTask)updateDependencies).consumeResult((status, result) -> {
                if (status == Worker.State.SUCCEEDED) {
                    Platform.runLater(() -> {
                        if (result.getType() == ResultType.Success) {
                            this.container.setCenter((Node)this.successLabel);
                        } else {
                            Text messageText = new Text(result.getMessage());
                            messageText.setFill((Paint)Color.DARKRED);
                            messageText.setFont(Font.font((String)"Helvetica", (FontWeight)FontWeight.BOLD, (double)12.0));
                            if (result.getInternalMessage() == null) {
                                this.errorInfo.getChildren().setAll((Object[])new Node[]{messageText});
                            } else {
                                Text pathText = new Text("\r\n\t" + result.getInternalMessage());
                                this.errorInfo.getChildren().setAll((Object[])new Node[]{messageText, pathText});
                            }
                            this.container.setCenter((Node)this.errorInfo);
                        }
                        this.progressIndicatorPane.hideIndicator();
                    });
                }
            });
            this.progressIndicatorPane.setProgress(0.0);
        }
    }
}

