/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.vai.controls;

import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.validator.Validators;
import java.util.Collection;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.stage.Window;
import org.controlsfx.control.PropertySheet;

public class ConvertPLCValuesDialog
extends Dialog<ButtonType> {
    private final SimpleObjectProperty<MeasuringUnit> sourceMU = new SimpleObjectProperty();
    private final SimpleObjectProperty<MeasuringUnit> targetMU = new SimpleObjectProperty();

    public ConvertPLCValuesDialog(Window window, PhysicalUnit physicalUnit) {
        PropertySheet propertySheet = new PropertySheet();
        ChoicePropertyItem sourceMUItem = new ChoicePropertyItem("Source MU", this.sourceMU, physicalUnit.getMeasuringUnits());
        sourceMUItem.setNullable(false);
        sourceMUItem.setValidator(Validators.createNotEmptyValidator((String)"Source Measuring Unit should be set"));
        ChoicePropertyItem targetMUItem = new ChoicePropertyItem("Target MU", this.targetMU, physicalUnit.getMeasuringUnits());
        targetMUItem.setNullable(false);
        targetMUItem.setValidator(Validators.createNotEmptyValidator((String)"Target Measuring Unit should be set"));
        propertySheet.getItems().addAll((Object[])new PropertySheet.Item[]{sourceMUItem, targetMUItem});
        propertySheet.setPrefWidth(300.0);
        propertySheet.setPrefHeight(150.0);
        this.getDialogPane().setContent((Node)propertySheet);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        ((Button)this.getDialogPane().lookupButton(ButtonType.OK)).disableProperty().bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)propertySheet.getItems()));
        this.initOwner(window);
    }

    public MeasuringUnit getSourceMU() {
        return (MeasuringUnit)this.sourceMU.get();
    }

    public MeasuringUnit getTargetMU() {
        return (MeasuringUnit)this.targetMU.get();
    }
}

