/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.vai.controls;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableInstanceExplicitDependency;
import de.elpro.ewms.engin.gui.navi.server.vai.controls.DependencyOperation;
import de.elpro.ui.fx.cells.uimodel.UIModelListCell;
import de.elpro.ui.fx.cells.uimodel.UIModelTreeCell;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Window;

public class RemoveDependenciesDialog
extends Dialog<ButtonType> {
    private final Collection<VariableInstanceExplicitDependency> allDependencies = new LinkedList<VariableInstanceExplicitDependency>();
    private final Collection<VariableInstanceExplicitDependency> deleteDependencies = new LinkedList<VariableInstanceExplicitDependency>();
    private final Map<String, List<VariableInstanceExplicitDependency>> keys = new TreeMap<String, List<VariableInstanceExplicitDependency>>();
    private final Map<Variable, List<VariableInstanceExplicitDependency>> vars = new TreeMap<Variable, List<VariableInstanceExplicitDependency>>();
    private final TreeItem<UIModelElement> deleteChangesRoot = new TreeItem();
    private final ObservableValue<String> keyProperty;
    private final ObservableValue<Variable> variableProperty;
    private static final Variable NULL_VARIABLE = new Variable(){

        public URL getIconUrl() {
            return null;
        }

        public String toString() {
            return null;
        }
    };

    public RemoveDependenciesDialog(Window window, Collection<VariableInstance> instances) {
        Transaction trx = Transactions.begin();
        try {
            for (VariableInstance instance : instances) {
                for (VariableInstanceExplicitDependency dep : instance.getDependencies()) {
                    String key = dep.getKey() == null || dep.getKey().isEmpty() ? "" : dep.getKey();
                    VariableInstance dependentOnInstance = VariableInstanceDAO.get((Transaction)trx, (int)dep.getDependentOn().getId());
                    dependentOnInstance.setVariable(VariableDAO.get((Transaction)trx, (int)dependentOnInstance.getVariable().getId()));
                    dep.setDependentOn(dependentOnInstance);
                    Variable var = dep.getDependentOn().getVariable();
                    List<VariableInstanceExplicitDependency> keyDeps = this.keys.get(key);
                    if (keyDeps == null) {
                        keyDeps = new LinkedList<VariableInstanceExplicitDependency>();
                        this.keys.put(key, keyDeps);
                    }
                    keyDeps.add(dep);
                    List<VariableInstanceExplicitDependency> varDeps = this.vars.get(var);
                    if (varDeps == null) {
                        varDeps = new LinkedList<VariableInstanceExplicitDependency>();
                        this.vars.put(var, varDeps);
                    }
                    varDeps.add(dep);
                    this.allDependencies.add(dep);
                }
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0));
        grid.setPrefWidth(600.0);
        ObservableList keysList = FXCollections.observableArrayList(this.keys.keySet());
        if (!keysList.contains((Object)"")) {
            keysList.add(0, (Object)"");
        }
        ComboBox keysCb = new ComboBox(keysList);
        keysCb.setValue((Object)"");
        keysCb.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)keysCb, (Priority)Priority.ALWAYS);
        this.keyProperty = keysCb.valueProperty();
        this.keyProperty.addListener((o, ov, nv) -> this.updateChangesView());
        grid.addRow(0, new Node[]{new Label("Dep. Key"), keysCb});
        ObservableList variablesList = FXCollections.observableArrayList(this.vars.keySet());
        variablesList.add(0, (Object)NULL_VARIABLE);
        ComboBox variablesCb = new ComboBox(variablesList);
        variablesCb.setButtonCell((ListCell)new UIModelListCell());
        variablesCb.setCellFactory(cf -> new UIModelListCell());
        variablesCb.setValue((Object)NULL_VARIABLE);
        variablesCb.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)variablesCb, (Priority)Priority.ALWAYS);
        this.variableProperty = variablesCb.valueProperty();
        this.variableProperty.addListener((o, ov, nv) -> this.updateChangesView());
        grid.addRow(1, new Node[]{new Label("Dep. Variable"), variablesCb});
        Label deleteChangesLabel = new Label("Changes");
        GridPane.setValignment((Node)deleteChangesLabel, (VPos)VPos.BASELINE);
        TreeView deleteChangesView = new TreeView(this.deleteChangesRoot);
        deleteChangesView.setShowRoot(false);
        deleteChangesView.setCellFactory(cf -> new UIModelTreeCell());
        GridPane.setHgrow((Node)deleteChangesView, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)deleteChangesView, (Priority)Priority.ALWAYS);
        grid.addRow(2, new Node[]{deleteChangesLabel, deleteChangesView});
        this.updateChangesView();
        this.getDialogPane().setContent((Node)grid);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        this.initOwner(window);
    }

    private void updateDeleteDeps() {
        this.deleteDependencies.clear();
        for (VariableInstanceExplicitDependency dep : this.allDependencies) {
            if (!"".equals(this.keyProperty.getValue()) && !((String)this.keyProperty.getValue()).equals(dep.getKey()) || this.variableProperty.getValue() != null && this.variableProperty.getValue() != NULL_VARIABLE && !dep.getDependentOn().getVariable().equals(this.variableProperty.getValue())) continue;
            this.deleteDependencies.add(dep);
        }
    }

    private void updateChangesView() {
        this.updateDeleteDeps();
        TreeMap<VariableInstance, TreeItem> sourceInstances = new TreeMap<VariableInstance, TreeItem>();
        for (VariableInstanceExplicitDependency delDep : this.deleteDependencies) {
            TreeItem sourceInstanceTI = (TreeItem)sourceInstances.get(delDep.getVariableInstance());
            if (sourceInstanceTI == null) {
                sourceInstanceTI = new TreeItem((Object)delDep.getVariableInstance());
                sourceInstances.put(delDep.getVariableInstance(), sourceInstanceTI);
                sourceInstanceTI.setExpanded(true);
            }
            sourceInstanceTI.getChildren().add((Object)new TreeItem((Object)new DependencyOperation(delDep, true)));
        }
        this.deleteChangesRoot.getChildren().setAll(sourceInstances.values());
    }

    public Collection<VariableInstanceExplicitDependency> getDeleteDeps() {
        return this.deleteDependencies;
    }
}

