/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.vai.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.engin.gui.navi.server.vai.controls.AddOrEditDependenciesWizard;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TreeItem;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;

public class AddOrEditDependenciesHandler {
    @Execute
    public void execute(@org.eclipse.e4.core.di.annotations.Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> treeItem, Scene scene) {
        Variable variable = (Variable)treeItem.getValue();
        VariableInstance[] instances = null;
        boolean hasDependentInstances = false;
        Transaction trx = Transactions.begin();
        try {
            variable = VariableDAO.get((Transaction)trx, (int)variable.getId());
            VariableInstance[] variableInstanceArray = instances = VariableInstanceDAO.getAll((Transaction)trx, (Variable)variable);
            int n = instances.length;
            int n2 = 0;
            while (n2 < n) {
                VariableInstance instance = variableInstanceArray[n2];
                if (instance.getType() == VariableInstanceType.Calculated || instance.getType() == VariableInstanceType.Custom) {
                    hasDependentInstances = true;
                    break;
                }
                ++n2;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        if (hasDependentInstances) {
            AddOrEditDependenciesWizard wizard = new AddOrEditDependenciesWizard(variable, scene);
            Platform.runLater(() -> {
                Optional optional = wizard.showAndWait();
            });
        } else {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setHeaderText("Illegal variable config");
            alert.setContentText(String.format("Variable %s contains no Instances of 'Calculated' or 'Custom' type", variable));
            alert.show();
        }
    }

    @CanExecute
    public boolean canExecute(@org.eclipse.e4.core.di.annotations.Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> treeItem) {
        return treeItem != null && treeItem.getValue() instanceof Variable;
    }
}

