/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.vai.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ui.fx.controls.tree.LazyTreeItem;
import de.elpro.ui.model.UIModelElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.scene.Scene;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.TreeItem;
import javax.inject.Named;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public class ChangeVAISupplStrategyHandler {
    @Execute
    public void execute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<UIModelElement> singleSelection, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") List<TreeItem<UIModelElement>> multiSelection, Scene scene) {
        Map<VariableInstance, TreeItem<UIModelElement>> instances = this.getInstances(singleSelection, multiSelection);
        if (!instances.isEmpty()) {
            LinkedList<String> keys = new LinkedList<String>();
            keys.add("");
            SupplementValueStrategy[] supplementValueStrategyArray = SupplementValueStrategy.values();
            int n = supplementValueStrategyArray.length;
            int n2 = 0;
            while (n2 < n) {
                SupplementValueStrategy s = supplementValueStrategyArray[n2];
                keys.add(s.name());
                ++n2;
            }
            ChoiceDialog typeDlg = new ChoiceDialog(null, keys);
            typeDlg.initOwner(scene.getWindow());
            typeDlg.setHeaderText("Select supplement strategy");
            typeDlg.showAndWait().ifPresent(key -> {
                HashSet<VariableInstance> instancesToConvert = new HashSet<VariableInstance>();
                SupplementValueStrategy strategy = null;
                if (!key.equals("")) {
                    strategy = SupplementValueStrategy.valueOf((String)key);
                }
                for (VariableInstance instance : instances.keySet()) {
                    if (strategy == instance.getSupplementValueStrategy()) continue;
                    instancesToConvert.add(instance);
                }
                if (!instancesToConvert.isEmpty()) {
                    Transaction trx = Transactions.begin();
                    try {
                        try {
                            VariableInstanceDAO.changeInstanceSupplementValuesStrategy((Transaction)trx, (SupplementValueStrategy)strategy, instancesToConvert);
                            Transactions.commitAsync((Transaction)trx);
                            for (TreeItem treeItem : instances.values()) {
                                if (treeItem.getValue() instanceof VariableInstance) {
                                    VariableInstance instance = (VariableInstance)treeItem.getValue();
                                    treeItem.setValue(null);
                                    instance.setSupplementValueStrategy(strategy);
                                    treeItem.setValue((Object)instance);
                                    continue;
                                }
                                if (!(treeItem.getValue() instanceof Variable) || treeItem instanceof LazyTreeItem && !treeItem.isExpanded()) continue;
                                for (TreeItem child : treeItem.getChildren()) {
                                    VariableInstance instance = (VariableInstance)child.getValue();
                                    child.setValue(null);
                                    instance.setSupplementValueStrategy(strategy);
                                    child.setValue((Object)instance);
                                }
                            }
                        }
                        catch (DAOOperationException exc) {
                            Transactions.rollback((Transaction)trx);
                            ExceptionDialog excDlg = new ExceptionDialog((Throwable)exc);
                            excDlg.setContentText("Error ocured during changing of instance type");
                            excDlg.show();
                            Transactions.close((Transaction)trx);
                        }
                    }
                    finally {
                        Transactions.close((Transaction)trx);
                    }
                }
            });
        }
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<UIModelElement> singleSelection, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") List<TreeItem<UIModelElement>> multiSelection) {
        ArrayList<TreeItem<UIModelElement>> selections = new ArrayList<TreeItem<UIModelElement>>();
        if (singleSelection != null) {
            selections.add(singleSelection);
        }
        if (multiSelection != null) {
            selections.addAll(multiSelection);
        }
        return selections.stream().map(ti -> (UIModelElement)ti.getValue()).anyMatch(ui -> ui instanceof VariableInstance || ui instanceof Variable);
    }

    private Map<VariableInstance, TreeItem<UIModelElement>> getInstances(TreeItem<UIModelElement> singleSelection, List<TreeItem<UIModelElement>> multiSelection) {
        ArrayList<TreeItem<UIModelElement>> selections = new ArrayList<TreeItem<UIModelElement>>();
        if (singleSelection != null) {
            selections.add(singleSelection);
        }
        if (multiSelection != null) {
            selections.addAll(multiSelection);
        }
        HashMap<VariableInstance, TreeItem<UIModelElement>> instances = new HashMap<VariableInstance, TreeItem<UIModelElement>>();
        if (selections.isEmpty()) {
            return instances;
        }
        Transaction trx = Transactions.begin();
        try {
            for (TreeItem treeItem : selections) {
                VariableInstance[] varInstances;
                if (treeItem == null) continue;
                if (treeItem.getValue() instanceof VariableInstance) {
                    VariableInstance instance = VariableInstanceDAO.get((Transaction)trx, (int)((VariableInstance)treeItem.getValue()).getId());
                    instances.put(instance, (TreeItem<UIModelElement>)treeItem);
                    continue;
                }
                if (!(treeItem.getValue() instanceof Variable)) continue;
                VariableInstance[] variableInstanceArray = varInstances = VariableInstanceDAO.getAll((Transaction)trx, (Variable)((Variable)treeItem.getValue()));
                int n = varInstances.length;
                int n2 = 0;
                while (n2 < n) {
                    VariableInstance instance = variableInstanceArray[n2];
                    instances.put(instance, (TreeItem<UIModelElement>)treeItem);
                    ++n2;
                }
            }
            HashMap<VariableInstance, TreeItem<UIModelElement>> hashMap = instances;
            return hashMap;
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }
}

