/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.vai.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.engin.gui.navi.server.vai.controls.ConvertPLCValuesDialog;
import de.elpro.ui.model.UIModelElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public class ConvertPLCValuesHandler {
    @Execute
    public void execute(Scene scene, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<UIModelElement> selectedElement, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") LinkedList<TreeItem<UIModelElement>> selectedElements) {
        Collection<VariableInstance> instances = ConvertPLCValuesHandler.getInstances(selectedElement, selectedElements);
        if (instances.isEmpty()) {
            return;
        }
        Variable var = instances.iterator().next().getVariable();
        Transaction trx = Transactions.begin();
        try {
            var = VariableDAO.get((Transaction)trx, (int)var.getId());
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        ConvertPLCValuesDialog dlg = new ConvertPLCValuesDialog(scene.getWindow(), var.getPhysicalUnit());
        if (dlg.showAndWait().get() == ButtonType.OK) {
            VariableInstanceDAO.convertPLCValues((VariableInstance[])instances.toArray(new VariableInstance[0]), (MeasuringUnit)dlg.getSourceMU(), (MeasuringUnit)dlg.getTargetMU());
        }
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<UIModelElement> selectedElement, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") LinkedList<TreeItem<UIModelElement>> selectedElements) {
        return !ConvertPLCValuesHandler.getInstances(selectedElement, selectedElements).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<VariableInstance> getInstances(TreeItem<UIModelElement> selectedElement, LinkedList<TreeItem<UIModelElement>> selectedElements) {
        HashSet<VariableInstance> instances = new HashSet<VariableInstance>();
        LinkedList<UIModelElement> candidates = new LinkedList<UIModelElement>();
        if (selectedElement != null && (selectedElement.getValue() instanceof Variable || selectedElement.getValue() instanceof VariableInstance)) {
            candidates.add((UIModelElement)selectedElement.getValue());
        } else if (selectedElements != null) {
            for (TreeItem treeItem : selectedElements) {
                if (treeItem.getValue() instanceof Variable || treeItem.getValue() instanceof VariableInstance) {
                    candidates.add((UIModelElement)treeItem.getValue());
                    continue;
                }
                return instances;
            }
        }
        if (candidates.isEmpty()) {
            return instances;
        }
        Object var4_6 = null;
        Transaction trx = Transactions.begin();
        try {
            for (UIModelElement candidate : candidates) {
                VariableInstance instance;
                void var4_7;
                if (candidate instanceof Variable) {
                    if (var4_7 == null) {
                        Variable variable = VariableDAO.get((Transaction)trx, (int)((Variable)candidate).getId());
                        VariableInstance[] variableInstanceArray = VariableInstanceDAO.getAll((Transaction)trx, (Variable)variable);
                        int n = variableInstanceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            instance = variableInstanceArray[n2];
                            if (instance.getType() == VariableInstanceType.PLC) {
                                instances.add(instance);
                            }
                            ++n2;
                        }
                        continue;
                    }
                    if (var4_7.equals((Object)candidate)) continue;
                    instances.clear();
                    HashSet<VariableInstance> hashSet = instances;
                    return hashSet;
                }
                if (!(candidate instanceof VariableInstance)) continue;
                instance = (VariableInstance)candidate;
                if (var4_7 == null) {
                    Variable variable = VariableDAO.get((Transaction)trx, (int)((VariableInstance)candidate).getVariable().getId());
                } else if (!var4_7.equals((Object)instance.getVariable())) {
                    instances.clear();
                    HashSet<VariableInstance> hashSet = instances;
                    return hashSet;
                }
                instance = VariableInstanceDAO.get((Transaction)trx, (int)instance.getId());
                if (instance.getType() != VariableInstanceType.PLC) continue;
                instances.add(instance);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        return instances;
    }
}

