/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.vai.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.datasource.DataGroupDAO;
import de.elpro.ewms.core.client.datasource.DataSourceDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Location;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.engin.gui.navi.model.INavigationTreeElement;
import de.elpro.ewms.engin.gui.navi.model.LazyNavigationContribution;
import de.elpro.ewms.engin.gui.navi.server.vai.handlers.VariablesAndInstancesEditHandler;
import de.elpro.ewms.gui.utils.e4.EOSPartUtils;
import de.elpro.resources.Icons;
import de.elpro.ui.model.CustomUILabelElement;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.utils.TextUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import javafx.scene.control.TreeItem;
import javafx.scene.input.TransferMode;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class CreateNaviTreeHandler
extends LazyNavigationContribution<UIModelElement> {
    @Inject
    @Log
    private Logger logger;
    @Inject
    private MApplication app;
    @Inject
    private EModelService modelService;
    private Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> LIST_CREATOR = new Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>>(){

        @Override
        public List<TreeItem<UIModelElement>> apply(TreeItem<UIModelElement> item) {
            LinkedList<TreeItem<UIModelElement>> elements = new LinkedList<TreeItem<UIModelElement>>();
            Transaction trx = Transactions.begin();
            try {
                if (item.getValue() == null || item.getValue() instanceof INavigationTreeElement) {
                    StructureClass[] structureClasses;
                    StructureClass[] structureClassArray = structureClasses = StructureClassDAO.getAll((Transaction)trx);
                    int n = structureClasses.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StructureClass structureClass;
                        structureClass.setEnabled(!(structureClass = structureClassArray[n2]).getVariables().isEmpty());
                        ++n2;
                    }
                    Arrays.sort(structureClasses, (c1, c2) -> c1.isEnabled() == c2.isEnabled() ? c1.compareTo(c2) : (c1.isEnabled() ? -1 : 1));
                    elements.addAll(CreateNaviTreeHandler.this.createLazyTreeItemCollection((UIModelElement[])structureClasses));
                } else if (item.getValue() instanceof StructureClass) {
                    StructureClass structureClass = (StructureClass)item.getValue();
                    elements.addAll(CreateNaviTreeHandler.this.createLazyTreeItemCollection((UIModelElement[])VariableDAO.getByClass((Transaction)trx, (StructureClass)structureClass)));
                    if (!structureClass.isEnabled() && !elements.isEmpty()) {
                        structureClass.setEnabled(true);
                        item.setValue(null);
                        item.setValue((Object)structureClass);
                    }
                } else if (item.getValue() instanceof Variable) {
                    Variable variable = (Variable)item.getValue();
                    Object[] instances = VariableInstanceDAO.getAll((Transaction)trx, (Variable)variable);
                    StructureObject[] objects = StructureObjectDAO.get((Transaction)trx, (int[])Arrays.stream(instances).mapToInt(i -> i.getStructureObject().getId()).toArray());
                    int i2 = 0;
                    while (i2 < instances.length) {
                        Object instance = instances[i2];
                        instance.setStructureObject(objects[i2]);
                        instance.setBuildTextLabelCallback(arg_0 -> 1.lambda$2((VariableInstance)instance, arg_0));
                        ++i2;
                    }
                    Arrays.sort(instances);
                    elements.addAll(CreateNaviTreeHandler.this.createTreeItemCollection((UIModelElement[])instances));
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            return elements;
        }

        private static /* synthetic */ String lambda$2(VariableInstance variableInstance, CustomUILabelElement o) {
            if (variableInstance.getStructureObject().getKey() != null && !variableInstance.getStructureObject().getKey().isBlank()) {
                return String.format("%s [key: %s]", variableInstance.getStructureObject(), variableInstance.getStructureObject().getKey());
            }
            if (variableInstance.getDescription() != null && !variableInstance.getDescription().isBlank()) {
                return String.format("%s (%s)", variableInstance.getStructureObject(), TextUtils.getFirstLine((String)variableInstance.getDescription(), (int)20));
            }
            return variableInstance.getStructureObject().toString();
        }
    };

    @Override
    public Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> getChildrenCreator() {
        return this.LIST_CREATOR;
    }

    @Execute
    public void execute() {
    }

    public List<TreeItem<UIModelElement>> getChildren() {
        Variable[] variables = this.loadVariables();
        if (variables != null) {
            return this.createNavigationTree(variables);
        }
        return null;
    }

    @Override
    public String getContextMenuId() {
        return "de.elpro.ewms.engin.gui.menu.navi.vai";
    }

    private Variable[] loadVariables() {
        Transaction trx = Transactions.begin();
        try {
            Variable[] allVars;
            HashMap<Integer, StructureClass> classes = new HashMap<Integer, StructureClass>();
            Variable[] variableArray = allVars = VariableDAO.getAll((Transaction)trx);
            int n = allVars.length;
            int n2 = 0;
            while (n2 < n) {
                Variable var = variableArray[n2];
                var.getInstances().clear();
                Collections.addAll(var.getInstances(), VariableInstanceDAO.getAll((Transaction)trx, (Variable)var));
                StructureClass clazz = (StructureClass)classes.get(var.getStructureClass().getId());
                if (clazz == null) {
                    clazz = StructureClassDAO.get((Transaction)trx, (int)var.getStructureClass().getId());
                    classes.put(clazz.getId(), clazz);
                }
                var.setStructureClass(clazz);
                ++n2;
            }
            Variable[] variableArray2 = allVars;
            return variableArray2;
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private List<TreeItem<UIModelElement>> createNavigationTree(Variable[] variables) {
        LinkedList<TreeItem<UIModelElement>> items = new LinkedList<TreeItem<UIModelElement>>();
        TreeSet<FolderElement> folders = new TreeSet<FolderElement>();
        TreeMap<FolderElement, LinkedList<Variable>> folderedVariables = new TreeMap<FolderElement, LinkedList<Variable>>();
        Variable[] variableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            LinkedList<Variable> folderVariables;
            Variable var = variableArray[n2];
            Location location = var.getLocation();
            FolderElement folder = new FolderElement(var.getStructureClass(), null);
            folders.add(folder);
            if (location != null) {
                folder = new FolderElement(var.getStructureClass(), location);
                folders.add(folder);
            }
            if ((folderVariables = (LinkedList<Variable>)folderedVariables.get(folder)) == null) {
                folderVariables = new LinkedList<Variable>();
                folderedVariables.put(folder, folderVariables);
            }
            folderVariables.add(var);
            ++n2;
        }
        TreeItem prevRootFolder = null;
        for (FolderElement folder : folders) {
            TreeItem folderItem;
            if (folder.location == null) {
                prevRootFolder = folderItem = new TreeItem((Object)folder.structureClass);
                items.add((TreeItem<UIModelElement>)folderItem);
            } else {
                folderItem = new TreeItem((Object)folder);
                prevRootFolder.getChildren().add((Object)folderItem);
            }
            List folderVariables = (List)folderedVariables.get(folder);
            if (folderVariables == null) continue;
            for (Variable variable : folderVariables) {
                TreeItem varItem = new TreeItem((Object)variable);
                folderItem.getChildren().add((Object)varItem);
                for (VariableInstance instance : variable.getInstances()) {
                    varItem.getChildren().add((Object)new TreeItem((Object)instance));
                }
            }
        }
        return items;
    }

    @Override
    public void onTreeItemClick(Object sender, TreeItem<UIModelElement> treeItem) {
        new VariablesAndInstancesEditHandler().execute(this.app, treeItem);
    }

    @Override
    public void onTreeItemDoubleClick(Object sender, TreeItem<UIModelElement> treeItem) {
        EOSPartUtils.pinSelectedMPart((EModelService)this.modelService, (MApplication)this.app, (String)"de.elpro.ewms.engin.gui.partstack.editors");
    }

    @Override
    public boolean canDragItem(UIModelElement item) {
        return item instanceof VariableInstance || item instanceof Variable;
    }

    @Override
    public TransferMode[] getDropModes(UIModelElement target, String clipboardContent) {
        if (target instanceof VariableInstance && ((VariableInstance)target).getType() == VariableInstanceType.PLC) {
            return new TransferMode[]{TransferMode.COPY};
        }
        return TransferMode.NONE;
    }

    @Override
    public void onDropItem(UIModelElement target, String clipboardContent) {
        VariableInstance vai = (VariableInstance)target;
        String[] fields = clipboardContent.split("\\|");
        if (fields.length < 3) {
            return;
        }
        String sourceName = fields[0];
        String namespace = fields[1];
        String objectIdentifier = fields[2];
        Transaction trx = Transactions.begin();
        try {
            try {
                DataGroup[] dataGroups;
                VariableInstance vi = VariableInstanceDAO.get((Transaction)trx, (int)vai.getId());
                DataGroup[] dataGroupArray = dataGroups = DataGroupDAO.getAll((Transaction)trx);
                int n = dataGroups.length;
                int n2 = 0;
                while (n2 < n) {
                    DataGroup dataGroup = dataGroupArray[n2];
                    Integer id = dataGroup.getDataSource().getId();
                    DataSource ds = DataSourceDAO.get((Transaction)trx, (int)id);
                    if (ds.getName().toLowerCase().equals(sourceName.toLowerCase()) && dataGroup.getNamespace().toLowerCase().equals(namespace.toLowerCase())) {
                        vi.setPlcDataGroup(dataGroup);
                        break;
                    }
                    ++n2;
                }
                vi.setPlcDatasourceKey(objectIdentifier);
                VariableInstanceDAO.saveOrUpdate((Transaction)trx, (VariableInstance)vi);
                Transactions.commitSync((Transaction)trx);
            }
            catch (DAOOperationException e) {
                this.logger.error("onDropItem-> VariableInstanceDAO.saveOrUpdate(trx, vai);", (Throwable)e);
                e.printStackTrace();
                Transactions.close((Transaction)trx);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    class FolderElement
    implements UIModelElement {
        private final StructureClass structureClass;
        private final Location location;

        public FolderElement(StructureClass structureClass, Location location) {
            this.structureClass = structureClass;
            this.location = location;
        }

        public StructureClass getStructureClass() {
            return this.structureClass;
        }

        public Location getLocation() {
            return this.location;
        }

        public String getIconUri() {
            if (this.location != null) {
                return Icons.FOLDER_ITEM_URL.toString();
            }
            return this.structureClass.getIconUri();
        }

        public String toString() {
            return this.location == null ? this.structureClass.toString() : this.location.getName();
        }

        public int hashCode() {
            return this.structureClass.hashCode() + (this.location != null ? this.location.hashCode() * 17 : 0);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FolderElement)) {
                return false;
            }
            FolderElement fo = (FolderElement)obj;
            if (!this.structureClass.equals((Object)fo.structureClass)) {
                return false;
            }
            if (this.location == null) {
                return this.location == fo.location;
            }
            if (fo.location == null) {
                return false;
            }
            return this.location.equals((Object)fo.location);
        }

        public int compareTo(Object o) {
            if (!(o instanceof FolderElement)) {
                return 1;
            }
            FolderElement fo = (FolderElement)o;
            if (!this.structureClass.equals((Object)fo.structureClass)) {
                return this.structureClass.compareTo((Object)fo.structureClass);
            }
            if (this.location == null && fo.location == null) {
                return 0;
            }
            if (this.location == null && fo.location != null) {
                return -1;
            }
            if (fo.location == null && this.location != null) {
                return 1;
            }
            return this.location.compareTo((Object)fo.location);
        }
    }
}

