/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.vai.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDependencyDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableInstanceExplicitDependency;
import de.elpro.ewms.engin.gui.navi.server.vai.controls.RemoveDependenciesDialog;
import de.elpro.ui.model.UIModelElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public class RemoveDependenciesHandler {
    @Execute
    public void execute(Scene scene, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<UIModelElement> selectedElement, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") LinkedList<TreeItem<UIModelElement>> selectedElements) {
        RemoveDependenciesDialog dlg = new RemoveDependenciesDialog(scene.getWindow(), RemoveDependenciesHandler.getInstances(selectedElement, selectedElements));
        dlg.showAndWait().ifPresent(btn -> {
            if (btn == ButtonType.OK) {
                Collection<VariableInstanceExplicitDependency> deleteDeps = dlg.getDeleteDeps();
                if (deleteDeps.isEmpty()) {
                    return;
                }
                Transaction trx = Transactions.begin();
                try {
                    try {
                        VariableInstanceDependencyDAO.deleteAll((Transaction)trx, (VariableInstanceExplicitDependency[])deleteDeps.toArray(new VariableInstanceExplicitDependency[0]));
                        Transactions.commitAsync((Transaction)trx);
                        Alert alert = new Alert(Alert.AlertType.INFORMATION);
                        alert.initOwner(scene.getWindow());
                        alert.setContentText(String.format("%d dependencies removed!", deleteDeps.size()));
                        alert.show();
                    }
                    catch (Exception exception) {
                        Transactions.rollback((Transaction)trx);
                        Alert alert = new Alert(Alert.AlertType.WARNING);
                        alert.initOwner(scene.getWindow());
                        alert.setHeaderText("Delete erorr");
                        alert.setContentText(String.format("Cannot delete instance dependencies", new Object[0]));
                        alert.show();
                        Transactions.close((Transaction)trx);
                    }
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        });
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<UIModelElement> selectedElement, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") LinkedList<TreeItem<UIModelElement>> selectedElements) {
        return !RemoveDependenciesHandler.getInstances(selectedElement, selectedElements).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<VariableInstance> getInstances(TreeItem<UIModelElement> selectedElement, LinkedList<TreeItem<UIModelElement>> selectedElements) {
        HashSet<VariableInstance> instances = new HashSet<VariableInstance>();
        LinkedList<UIModelElement> candidates = new LinkedList<UIModelElement>();
        if (selectedElement != null && (selectedElement.getValue() instanceof Variable || selectedElement.getValue() instanceof VariableInstance)) {
            candidates.add((UIModelElement)selectedElement.getValue());
        } else if (selectedElements != null) {
            for (TreeItem treeItem : selectedElements) {
                if (treeItem.getValue() instanceof Variable || treeItem.getValue() instanceof VariableInstance) {
                    candidates.add((UIModelElement)treeItem.getValue());
                    continue;
                }
                return instances;
            }
        }
        if (candidates.isEmpty()) {
            return instances;
        }
        Object var4_6 = null;
        Transaction trx = Transactions.begin();
        try {
            for (UIModelElement candidate : candidates) {
                VariableInstance instance;
                void var4_7;
                if (candidate instanceof Variable) {
                    if (var4_7 == null) {
                        Variable variable = VariableDAO.get((Transaction)trx, (int)((Variable)candidate).getId());
                        VariableInstance[] variableInstanceArray = VariableInstanceDAO.getAll((Transaction)trx, (Variable)variable);
                        int n = variableInstanceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            instance = variableInstanceArray[n2];
                            instances.add(instance);
                            ++n2;
                        }
                        continue;
                    }
                    if (var4_7.equals((Object)candidate)) continue;
                    instances.clear();
                    HashSet<VariableInstance> hashSet = instances;
                    return hashSet;
                }
                if (!(candidate instanceof VariableInstance)) continue;
                instance = (VariableInstance)candidate;
                if (var4_7 == null) {
                    Variable variable = VariableDAO.get((Transaction)trx, (int)((VariableInstance)candidate).getVariable().getId());
                } else if (!var4_7.equals((Object)instance.getVariable())) {
                    instances.clear();
                    HashSet<VariableInstance> hashSet = instances;
                    return hashSet;
                }
                instances.add(VariableInstanceDAO.get((Transaction)trx, (int)instance.getId()));
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        return instances;
    }
}

