/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.vai.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.PropertyDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.lang.Script;
import de.elpro.ewms.core.lang.ScriptParser;
import de.elpro.ewms.core.lang.script.CalculationExpressionRootNode;
import de.elpro.ewms.core.lang.script.PropertyInstanceReferenceNode;
import de.elpro.ewms.core.lang.script.PropertyReferenceNode;
import de.elpro.ewms.core.lang.script.ScriptTree;
import de.elpro.ewms.core.lang.script.VariableInstanceReferenceNode;
import de.elpro.ewms.core.lang.script.VariableReferenceNode;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.PropertyInstanceReference;
import de.elpro.ewms.core.variable.calculated.PropertyReference;
import de.elpro.ewms.core.variable.calculated.VariableInstanceReference;
import de.elpro.ewms.core.variable.calculated.VariableReference;
import de.elpro.ewms.core.variable.calculated.dependencies.CustomAlgorithmDependencies;
import de.elpro.ewms.core.variable.custom.AlgorithmParameter;
import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.model.IdObject;
import java.util.ArrayList;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.TransferMode;
import javafx.util.StringConverter;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.PropertyEditor;

public class AlgorithmParameterInfoEditor
implements PropertyEditor<AlgorithmParameter[]> {
    private static final StringConverter<Object> DEPENDENCY_CONVERTER = new StringConverter<Object>(){

        public String toString(Object object) {
            if (object instanceof VariableReference) {
                return object.toString();
            }
            if (object instanceof VariableInstanceReference) {
                return object.toString();
            }
            if (object instanceof PropertyReference) {
                return object.toString();
            }
            if (object instanceof PropertyInstanceReference) {
                return object.toString();
            }
            return null;
        }

        public Object fromString(String string) {
            Script script = ScriptParser.parse((String)string);
            if (script == null) {
                return null;
            }
            if (!script.getErrors().isEmpty()) {
                return null;
            }
            ScriptTree tree = script.getTree();
            if (!(tree.getNode() instanceof CalculationExpressionRootNode)) {
                return null;
            }
            if (tree.getSubTrees().size() != 1) {
                return null;
            }
            de.elpro.ewms.core.lang.script.Node node = ((ScriptTree)tree.getSubTrees().get(0)).getNode();
            if (node instanceof VariableReferenceNode) {
                VariableReferenceNode refNode = (VariableReferenceNode)node;
                return refNode.getContent();
            }
            if (node instanceof VariableInstanceReferenceNode) {
                VariableInstanceReferenceNode refNode = (VariableInstanceReferenceNode)node;
                return refNode.getContent();
            }
            if (node instanceof PropertyReferenceNode) {
                PropertyReferenceNode refNode = (PropertyReferenceNode)node;
                return refNode.getContent();
            }
            if (node instanceof PropertyInstanceReferenceNode) {
                PropertyInstanceReferenceNode refNode = (PropertyInstanceReferenceNode)node;
                return refNode.getContent();
            }
            return null;
        }
    };
    private ObservableList<CustomAlgorithmDependencyRow> rows = FXCollections.observableArrayList();
    private ObjectProperty<CustomAlgorithmDependencies> dependenciesProperty = new SimpleObjectProperty();

    public AlgorithmParameterInfoEditor(PropertySheet.Item item) {
        ((PropertyItem)item).valueProperty().addListener((o, ov, nv) -> this.setValue((AlgorithmParameter[])nv));
    }

    public Node getEditor() {
        TableView tableView = new TableView(this.rows);
        tableView.setEditable(true);
        TableColumn keyColumn = new TableColumn("Key");
        keyColumn.setCellValueFactory(cf -> new ReadOnlyStringWrapper(((CustomAlgorithmDependencyRow)cf.getValue()).getParameter().getKey()));
        keyColumn.setPrefWidth(150.0);
        TableColumn dependencyTextColumn = new TableColumn("Dependency");
        dependencyTextColumn.setCellValueFactory(cf -> ((CustomAlgorithmDependencyRow)cf.getValue()).dependencyProperty());
        dependencyTextColumn.setCellFactory(cf -> new TextFieldTableCell(DEPENDENCY_CONVERTER));
        dependencyTextColumn.setPrefWidth(300.0);
        dependencyTextColumn.setEditable(true);
        TableColumn nameColumn = new TableColumn("Name");
        nameColumn.setCellValueFactory(cf -> new ReadOnlyStringWrapper(((CustomAlgorithmDependencyRow)cf.getValue()).getParameter().getName()));
        nameColumn.setPrefWidth(150.0);
        TableColumn descriptionColumn = new TableColumn("Description");
        descriptionColumn.setCellValueFactory(cf -> new ReadOnlyStringWrapper(((CustomAlgorithmDependencyRow)cf.getValue()).getParameter().getDescription()));
        descriptionColumn.setPrefWidth(400.0);
        tableView.getColumns().addAll((Object[])new TableColumn[]{keyColumn, dependencyTextColumn, nameColumn, descriptionColumn});
        tableView.setPrefHeight(150.0);
        tableView.setOnDragOver(event -> {
            String clipboardContent;
            if (event.getGestureSource() != tableView && (clipboardContent = event.getDragboard().getString()) != null) {
                IdObject o = IdObject.getObjectByFullId((ClassLoader)this.getClass().getClassLoader(), (String)clipboardContent);
                if (o instanceof VariableInstance) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.LINK});
                } else if (o instanceof Variable) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.LINK});
                } else if (o instanceof Property) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.LINK});
                }
            }
            event.consume();
        });
        tableView.setOnDragDropped(event -> {
            if (!(event.getTarget() instanceof Node)) {
                return;
            }
            TableCell cell = (TableCell)FXUtils.findParent((Node)((Node)event.getTarget()), TableCell.class);
            if (cell == null) {
                return;
            }
            TableRow tableRow = cell.getTableRow();
            CustomAlgorithmDependencyRow row = (CustomAlgorithmDependencyRow)tableRow.getItem();
            if (row == null) {
                return;
            }
            String clipboardContent = event.getDragboard().getString();
            if (clipboardContent != null) {
                Transaction trx = Transactions.begin();
                try {
                    IdObject o = IdObject.getObjectByFullId((ClassLoader)this.getClass().getClassLoader(), (String)clipboardContent);
                    if (o instanceof VariableInstance) {
                        VariableInstance instance = (VariableInstance)o;
                        instance = VariableInstanceDAO.get((Transaction)trx, (int)instance.getId());
                        instance.setVariable(VariableDAO.get((Transaction)trx, (int)instance.getVariable().getId()));
                        instance.setStructureObject(StructureObjectDAO.get((Transaction)trx, (int)instance.getStructureObject().getId()));
                        if (instance.getStructureObject().getKey() != null && !instance.getStructureObject().getKey().trim().isEmpty()) {
                            row.setDependency(new VariableInstanceReference(instance.getVariable().toString(), instance.getStructureObject().getKey()));
                        } else {
                            row.setDependency(new VariableInstanceReference(instance.getVariable().toString(), "unknown_object_key"));
                        }
                    } else if (o instanceof Variable) {
                        Variable var = (Variable)o;
                        var = VariableDAO.get((Transaction)trx, (int)var.getId());
                        row.setDependency(new VariableReference(var.toString(), SearchPolicy.Auto));
                    } else if (o instanceof Property) {
                        Property objectProperty = (Property)o;
                        objectProperty = PropertyDAO.get((Transaction)trx, (Integer)objectProperty.getId());
                        PropertyReference ref = new PropertyReference(objectProperty, SearchPolicy.Auto);
                        row.setDependency(ref);
                    }
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
            event.consume();
        });
        return tableView;
    }

    public ObjectProperty<CustomAlgorithmDependencies> dependenciesProperty() {
        return this.dependenciesProperty;
    }

    public CustomAlgorithmDependencies getDependencies() {
        return (CustomAlgorithmDependencies)this.dependenciesProperty().get();
    }

    public void setDependencies(CustomAlgorithmDependencies deps) {
        this.dependenciesProperty.set((Object)deps);
    }

    public AlgorithmParameter[] getValue() {
        return (AlgorithmParameter[])this.rows.stream().map(r -> r.getParameter()).toArray(AlgorithmParameter[]::new);
    }

    public void setValue(AlgorithmParameter[] arg0) {
        if (arg0 != null) {
            ArrayList<CustomAlgorithmDependencyRow> rows = new ArrayList<CustomAlgorithmDependencyRow>();
            CustomAlgorithmDependencies deps = this.getDependencies();
            AlgorithmParameter[] algorithmParameterArray = arg0;
            int n = arg0.length;
            int n2 = 0;
            while (n2 < n) {
                AlgorithmParameter param = algorithmParameterArray[n2];
                CustomAlgorithmDependencyRow row = new CustomAlgorithmDependencyRow(param);
                if (deps != null) {
                    row.setDependency(deps.getDependency(param.getKey()));
                }
                row.dependencyProperty().addListener(il -> this.updateDependencies());
                rows.add(row);
                ++n2;
            }
            this.rows.setAll(rows);
        } else {
            this.rows.clear();
        }
    }

    private void updateDependencies() {
        CustomAlgorithmDependencies deps = null;
        for (CustomAlgorithmDependencyRow row : this.rows) {
            Object dep = row.getDependency();
            if (dep == null) continue;
            if (deps == null) {
                deps = new CustomAlgorithmDependencies();
            }
            deps.setDependency(row.getParameter().getKey(), dep);
        }
        this.setDependencies(deps);
    }

    private static final class CustomAlgorithmDependencyRow {
        private final AlgorithmParameter parameter;
        private final ObjectProperty<Object> dependency = new SimpleObjectProperty();

        public CustomAlgorithmDependencyRow(AlgorithmParameter parameter) {
            this.parameter = parameter;
        }

        public AlgorithmParameter getParameter() {
            return this.parameter;
        }

        public ObjectProperty<Object> dependencyProperty() {
            return this.dependency;
        }

        public Object getDependency() {
            return this.dependencyProperty().get();
        }

        public void setDependency(Object object) {
            this.dependency.set(object);
        }
    }
}

