/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.vai.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableInstanceExplicitDependency;
import de.elpro.resources.Icons;
import de.elpro.ui.fx.cells.editable.TextFieldTableCell;
import de.elpro.ui.fx.cells.uimodel.UIModelTableCell;
import de.elpro.ui.fx.propertysheet.CustomEditorPropertyItem;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.utils.TextUtils;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputDialog;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.TransferMode;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.PropertyEditor;
import org.eclipse.e4.ui.model.application.MApplication;

public class DependenciesPropertyEditor
implements PropertyEditor<List<VariableInstanceExplicitDependency>> {
    private final ObservableList<VariableInstanceExplicitDependency> dependencies = FXCollections.observableArrayList();
    private final CustomEditorPropertyItem<List<VariableInstanceExplicitDependency>> customItem;
    private final VariableInstance instance;
    private final MApplication app;

    public DependenciesPropertyEditor(PropertySheet.Item item, MApplication app) {
        this.customItem = (CustomEditorPropertyItem)item;
        this.instance = (VariableInstance)this.customItem.getEditItem();
        this.app = app;
    }

    public Node getEditor() {
        TableView view = new TableView(this.dependencies);
        view.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        TableColumn keyColumn = new TableColumn("Key");
        keyColumn.setPrefWidth(50.0);
        keyColumn.setCellFactory(cf -> new TextFieldTableCell((StringConverter)new WrappedStringConverter()));
        keyColumn.setCellValueFactory(cf -> ((VariableInstanceExplicitDependency)cf.getValue()).keyProperty());
        TableColumn dependentOnColumn = new TableColumn("Dependent on Instance");
        dependentOnColumn.setPrefWidth(350.0);
        dependentOnColumn.setCellFactory(cf -> new UIModelTableCell(instance -> {
            String description;
            String fullName = instance.getFullName();
            String string = description = instance.getDescription() != null && !instance.getDescription().isEmpty() ? instance.getDescription() : instance.getVariable().getDescription();
            if (description == null || description.isEmpty()) {
                return fullName;
            }
            return String.format("%s (%s)", fullName, TextUtils.getFirstLine((String)description, (int)150));
        }));
        dependentOnColumn.setCellValueFactory(cf -> ((VariableInstanceExplicitDependency)cf.getValue()).dependentOnProperty());
        TableColumn descriptionColumn = new TableColumn("Description");
        descriptionColumn.setPrefWidth(500.0);
        descriptionColumn.setCellFactory(cf -> new TextFieldTableCell((StringConverter)new WrappedStringConverter()));
        descriptionColumn.setCellValueFactory(cf -> ((VariableInstanceExplicitDependency)cf.getValue()).descriptionProperty());
        view.getColumns().addAll((Object[])new TableColumn[]{keyColumn, dependentOnColumn, descriptionColumn});
        view.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 2 && view.getSelectionModel().getSelectedItem() instanceof VariableInstanceExplicitDependency) {
                if (FXUtils.findParent((Node)e.getPickResult().getIntersectedNode(), TextFieldTableCell.class, (int)1) != null) {
                    return;
                }
                PartUtils.showPart((String)"de.elpro.ewms.engin.gui.partstack.editors", (String)"de.elpro.ewms.engin.gui.partdescriptor.vai.instanceedit", (MApplication)this.app, (Object[])new Object[]{((VariableInstanceExplicitDependency)view.getSelectionModel().getSelectedItem()).getDependentOn()});
            }
        });
        view.setOnDragOver(event -> {
            String[] stringArray;
            String clipboardContent;
            if (event.getGestureSource() != view && (clipboardContent = event.getDragboard().getString()) != null && (stringArray = clipboardContent.split(";")).length != 0) {
                String part = stringArray[0];
                IdObject o = IdObject.getObjectByFullId((ClassLoader)this.getClass().getClassLoader(), (String)part);
                if (o instanceof VariableInstance) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.LINK});
                } else if (o instanceof Variable) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.LINK});
                }
            }
            event.consume();
        });
        view.setOnDragDropped(event -> {
            String clipboardContent = event.getDragboard().getString();
            if (clipboardContent != null) {
                Transaction trx = Transactions.begin();
                try {
                    AbstractCollection instancesToAdd = new HashSet();
                    String[] stringArray = clipboardContent.split(";");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String part = stringArray[n2];
                        IdObject o = IdObject.getObjectByFullId((ClassLoader)this.getClass().getClassLoader(), (String)part);
                        if (o instanceof VariableInstance) {
                            VariableInstance dependentOn = (VariableInstance)o;
                            dependentOn = VariableInstanceDAO.get((Transaction)trx, (int)dependentOn.getId());
                            dependentOn.setVariable(VariableDAO.get((Transaction)trx, (int)dependentOn.getVariable().getId()));
                            dependentOn.setStructureObject(StructureObjectDAO.get((Transaction)trx, (int)dependentOn.getStructureObject().getId()));
                            instancesToAdd.add(dependentOn);
                        } else if (o instanceof Variable) {
                            Variable var = (Variable)o;
                            var = VariableDAO.get((Transaction)trx, (int)var.getId());
                            for (VariableInstance dependentOn : var.getInstances()) {
                                dependentOn = VariableInstanceDAO.get((Transaction)trx, (int)dependentOn.getId());
                                dependentOn.setVariable(var);
                                dependentOn.setStructureObject(StructureObjectDAO.get((Transaction)trx, (int)dependentOn.getStructureObject().getId()));
                                instancesToAdd.add(dependentOn);
                            }
                        }
                        ++n2;
                    }
                    instancesToAdd = new LinkedList(instancesToAdd);
                    Collections.sort((List)((Object)instancesToAdd));
                    String defaultKey = null;
                    if (instancesToAdd.size() > 1) {
                        TextInputDialog defaultKeyDialog = new TextInputDialog();
                        defaultKeyDialog.setTitle("Default Dependeny Key");
                        defaultKeyDialog.setHeaderText("Please input default key for dependency if need");
                        defaultKeyDialog.setContentText("Key");
                        defaultKey = (String)defaultKeyDialog.showAndWait().get();
                    }
                    for (VariableInstance dependentOn : instancesToAdd) {
                        VariableInstanceExplicitDependency dep = new VariableInstanceExplicitDependency(this.instance, dependentOn);
                        if (defaultKey != null) {
                            dep.setKey(defaultKey);
                        }
                        this.dependencies.add((Object)dep);
                        this.instance.getDependencies().add(dep);
                    }
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
            event.consume();
        });
        this.dependencies.addListener((ListChangeListener)new ListChangeListener<VariableInstanceExplicitDependency>(){

            public void onChanged(ListChangeListener.Change<? extends VariableInstanceExplicitDependency> c) {
                DependenciesPropertyEditor.this.customItem.valueChanged();
            }
        });
        view.setEditable(true);
        MenuItem showVarDeclarationItem = new MenuItem("Show Variable", (Node)new ImageView(Variable.DEFAULT_ICON.toString()));
        showVarDeclarationItem.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)view.getSelectionModel().getSelectedItems()));
        showVarDeclarationItem.setOnAction(event -> {
            VariableInstanceExplicitDependency dep = (VariableInstanceExplicitDependency)view.getSelectionModel().getSelectedItem();
            PartUtils.showPart((String)"de.elpro.ewms.engin.gui.partstack.editors", (String)"de.elpro.ewms.engin.gui.partdescriptor.vai.variableedit", (MApplication)this.app, (Object[])new Object[]{dep.getDependentOn().getVariable()});
        });
        MenuItem deleteItem = new MenuItem("Remove", (Node)new ImageView(Icons.DELETE_ITEM_URL.toString()));
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{showVarDeclarationItem, new SeparatorMenuItem(), deleteItem});
        deleteItem.setOnAction(event -> {
            LinkedList selectedItems = new LinkedList(view.getSelectionModel().getSelectedItems());
            for (VariableInstanceExplicitDependency dependency : selectedItems) {
                this.instance.removeDependency(dependency.getDependentOn(), dependency.getKey());
            }
            view.getSelectionModel().clearSelection();
            this.dependencies.removeAll(selectedItems);
        });
        view.setContextMenu(contextMenu);
        return view;
    }

    public List<VariableInstanceExplicitDependency> getValue() {
        return new LinkedList<VariableInstanceExplicitDependency>((Collection<VariableInstanceExplicitDependency>)this.dependencies);
    }

    public void setValue(List<VariableInstanceExplicitDependency> value) {
        this.dependencies.setAll(value);
    }

    private class WrappedStringConverter
    extends DefaultStringConverter {
        private WrappedStringConverter() {
        }

        public String fromString(String value) {
            DependenciesPropertyEditor.this.customItem.valueChanged();
            return super.fromString(value);
        }
    }
}

