/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.vai.parts;

import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.characteristic.Characteristic3DInstance;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.characteristic.Characteristic2DDAO;
import de.elpro.ewms.core.client.characteristic.Characteristic2DInstanceDAO;
import de.elpro.ewms.core.client.characteristic.Characteristic3DDAO;
import de.elpro.ewms.core.client.characteristic.Characteristic3DInstanceDAO;
import de.elpro.ewms.core.client.structure.PropertyDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.editors.formula.FormulaInput;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.Characteristic2DInstanceReference;
import de.elpro.ewms.core.variable.calculated.Characteristic2DReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DInstanceReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DReference;
import de.elpro.ewms.core.variable.calculated.PropertyReference;
import de.elpro.ewms.core.variable.calculated.VariableInstanceReference;
import de.elpro.ewms.core.variable.calculated.VariableReference;
import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.model.IdObject;
import java.util.HashMap;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.DataFormat;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import org.controlsfx.property.editor.PropertyEditor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.code.editor.fx.TextEditor;

public class FormulaPropertyEditor
implements PropertyEditor<String> {
    private final PropertyItem<String> propetyItem;
    private final FormulaInput input;
    private final IEclipseContext context;
    private final TextEditor textEditor;
    private final BorderPane editorNode;

    public FormulaPropertyEditor(PropertyItem<String> property, IEclipseContext parentContext) {
        this.propetyItem = property;
        this.input = new FormulaInput((StringProperty)property.valueProperty());
        this.context = parentContext.createChild("TextEditor");
        this.context.set(Input.class, (Object)this.input);
        this.editorNode = new BorderPane();
        this.editorNode.setPrefHeight(400.0);
        parentContext.set(BorderPane.class, (Object)this.editorNode);
        this.textEditor = (TextEditor)ContextInjectionFactory.make(TextEditor.class, (IEclipseContext)this.context);
        this.textEditor.getSourceViewer().getTextWidget().skinProperty().addListener((obs, ov, nv) -> {
            if (nv == null) {
                return;
            }
            Pane dndPane = FXUtils.findChildren((Node)nv.getNode(), Pane.class, e -> e.getOnDragDropped() != null).stream().findAny().orElse(null);
            if (dndPane != null) {
                EventHandler dragDropped = dndPane.getOnDragDropped();
                dndPane.setOnDragDropped(e -> {
                    String dropText;
                    if (e.getDragboard().hasContent(DataFormat.PLAIN_TEXT) && (dropText = this.clipboardToDnDText(e.getDragboard().getContent(DataFormat.PLAIN_TEXT).toString())) != null) {
                        HashMap<DataFormat, String> dragContent = new HashMap<DataFormat, String>();
                        dragContent.put(DataFormat.PLAIN_TEXT, dropText);
                        e.getDragboard().setContent(dragContent);
                    }
                    dragDropped.handle(e);
                    e.consume();
                });
            }
        });
    }

    private String clipboardToDnDText(String clipboardContent) {
        if (clipboardContent != null) {
            Transaction trx = Transactions.begin();
            try {
                String[] stringArray = clipboardContent.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    IdObject o = IdObject.getObjectByFullId((ClassLoader)this.getClass().getClassLoader(), (String)part);
                    if (o instanceof Variable) {
                        Variable var = (Variable)o;
                        var = VariableDAO.get((Transaction)trx, (int)var.getId());
                        VariableReference ref = new VariableReference(var.toString(), SearchPolicy.Auto);
                        String string = ref.toString();
                        return string;
                    }
                    if (o instanceof VariableInstance) {
                        VariableInstance dependentOn = (VariableInstance)o;
                        dependentOn = VariableInstanceDAO.get((Transaction)trx, (int)dependentOn.getId());
                        dependentOn.setVariable(VariableDAO.get((Transaction)trx, (int)dependentOn.getVariable().getId()));
                        dependentOn.setStructureObject(StructureObjectDAO.get((Transaction)trx, (int)dependentOn.getStructureObject().getId()));
                        VariableInstanceReference ref = new VariableInstanceReference(dependentOn.getVariable().toString(), dependentOn.getStructureObject().getKey());
                        String string = ref.toString();
                        return string;
                    }
                    if (o instanceof Characteristic2D) {
                        Characteristic2D c2d = (Characteristic2D)o;
                        c2d = Characteristic2DDAO.get((Transaction)trx, (int)c2d.getId());
                        Characteristic2DReference ref = new Characteristic2DReference(c2d.toString(), SearchPolicy.Auto);
                        String string = String.valueOf(ref.toString()) + "(x_param)";
                        return string;
                    }
                    if (o instanceof Characteristic2DInstance) {
                        Characteristic2DInstance c2di = (Characteristic2DInstance)o;
                        c2di = Characteristic2DInstanceDAO.get((Transaction)trx, (int)c2di.getId());
                        Characteristic2D c2d = Characteristic2DDAO.get((Transaction)trx, (int)c2di.getCharacteristic().getId());
                        StructureObject object = StructureObjectDAO.get((Transaction)trx, (int)c2di.getStructureObject().getId());
                        Characteristic2DInstanceReference ref = new Characteristic2DInstanceReference(c2d.toString(), object.getKey());
                        String string = String.valueOf(ref.toString()) + "(x_param)";
                        return string;
                    }
                    if (o instanceof Characteristic3D) {
                        Characteristic3D c3d = (Characteristic3D)o;
                        c3d = Characteristic3DDAO.get((Transaction)trx, (int)c3d.getId());
                        Characteristic3DReference ref = new Characteristic3DReference(c3d.toString(), SearchPolicy.Auto, "z");
                        String string = String.valueOf(ref.toString()) + "(x_param, y_param)";
                        return string;
                    }
                    if (o instanceof Characteristic3DInstance) {
                        Characteristic3DInstance c3di = (Characteristic3DInstance)o;
                        c3di = Characteristic3DInstanceDAO.get((Transaction)trx, (int)c3di.getId());
                        Characteristic3D c3d = Characteristic3DDAO.get((Transaction)trx, (int)c3di.getCharacteristic().getId());
                        StructureObject object = StructureObjectDAO.get((Transaction)trx, (int)c3di.getStructureObject().getId());
                        Characteristic3DInstanceReference ref = new Characteristic3DInstanceReference(c3d.toString(), object.getKey(), "z");
                        String string = String.valueOf(ref.toString()) + "(x_param, y_param)";
                        return string;
                    }
                    if (o instanceof Property) {
                        Property objectProperty = (Property)o;
                        objectProperty = PropertyDAO.get((Transaction)trx, (Integer)objectProperty.getId());
                        PropertyReference ref = new PropertyReference(objectProperty, SearchPolicy.Auto);
                        String string = ref.toString();
                        return string;
                    }
                    ++n2;
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
        }
        return null;
    }

    public Node getEditor() {
        return this.editorNode;
    }

    public String getValue() {
        return this.input.getData();
    }

    public void setValue(String value) {
        this.input.setData(value);
    }
}

