/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.vai.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.datasource.DataGroupDAO;
import de.elpro.ewms.core.client.datasource.DataSourceDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.AlgorithmDescriptorDAO;
import de.elpro.ewms.core.client.variable.ValuesBoundsDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.Interpolation;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.variable.PLCVariableInstanceType;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.ValuesBounds;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.calculated.dependencies.CustomAlgorithmDependencies;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableInstanceExplicitDependency;
import de.elpro.ewms.core.variable.custom.AlgorithmDescriptor;
import de.elpro.ewms.core.variable.custom.AlgorithmParameter;
import de.elpro.ewms.engin.gui.navi.server.vai.parts.AlgorithmParameterInfoEditor;
import de.elpro.ewms.engin.gui.navi.server.vai.parts.DependenciesPropertyEditor;
import de.elpro.ewms.engin.gui.navi.server.vai.parts.FormulaPropertyEditor;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ewms.gui.dialogs.DialogFactory;
import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.CustomEditorPropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.model.CustomUILabelElement;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.PropertyEditor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class InstanceEditPart {
    @Inject
    @Log
    private Logger logger;
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.vai.instanceedit";
    private static final String MAIN_CATEGORY = "Main";
    private static final String ARCHIVE_CATEGORY = "PLC";
    private static final String CALC_CATEGORY = "Calculated";
    private static final String CUSTOM_CATEGORY = "Custom";
    @Inject
    private MApplication app;
    @Inject
    private VariableInstance instance;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private final List<DataGroup> dataGroups = new LinkedList<DataGroup>();
    private final List<Variable> writeSourceVariables = new LinkedList<Variable>();

    @PostConstruct
    public void postConstruct(BorderPane parent, IEclipseContext context) {
        LinkedList<AlgorithmDescriptor> algorithmDescriptors = new LinkedList<AlgorithmDescriptor>();
        SimpleObjectProperty algorithmDescriptor = new SimpleObjectProperty();
        AlgorithmDescriptor defaultAlgorithm = null;
        Transaction trx = Transactions.begin();
        List<ValuesBounds> boundsChoices = null;
        try {
            CustomUILabelElement.BuildTextLabelCallback textLabelCallback = this.instance.getBuildTextLabelCallback();
            this.instance = VariableInstanceDAO.get((Transaction)trx, (int)this.instance.getId());
            this.instance.setBuildTextLabelCallback(textLabelCallback);
            Variable var = VariableDAO.get((Transaction)trx, (int)this.instance.getVariable().getId());
            if (var.getPlcDefaultDataGroup() != null) {
                DataGroup dg2 = DataGroupDAO.get((Transaction)trx, (int)var.getPlcDefaultDataGroup().getId());
                dg2.setDataSource(DataSourceDAO.get((Transaction)trx, (int)dg2.getDataSource().getId()));
                var.setPlcDefaultDataGroup(dg2);
            }
            this.instance.setVariable(var);
            this.instance.setStructureObject(StructureObjectDAO.get((Transaction)trx, (int)this.instance.getStructureObject().getId()));
            if (this.instance.getValuesBounds() != null) {
                this.instance.setValuesBounds(ValuesBoundsDAO.get((Transaction)trx, (int)this.instance.getValuesBounds().getId()));
            }
            if (this.instance.getWriteValuesSource() != null) {
                VariableInstance writeInstance = this.instance.getWriteValuesSource();
                if (writeInstance != null) {
                    writeInstance = VariableInstanceDAO.get((Transaction)trx, (int)writeInstance.getId());
                    this.instance.setWriteValuesSource(writeInstance);
                }
                this.instance.getWriteValuesSource().setVariable(VariableDAO.get((Transaction)trx, (int)this.instance.getWriteValuesSource().getVariable().getId()));
            }
            if (this.instance.getPlcDataGroup() != null) {
                this.instance.setPlcDataGroup(DataGroupDAO.get((Transaction)trx, (int)this.instance.getPlcDataGroup().getId()));
            }
            for (VariableInstanceExplicitDependency dep : this.instance.getDependencies()) {
                VariableInstance dependentOn = VariableInstanceDAO.get((Transaction)trx, (int)dep.getDependentOn().getId());
                dependentOn.setVariable(VariableDAO.get((Transaction)trx, (int)dependentOn.getVariable().getId()));
                dep.setDependentOn(dependentOn);
            }
            boundsChoices = Arrays.asList(ValuesBoundsDAO.getAll((Transaction)trx, (PhysicalUnit)this.instance.getVariable().getPhysicalUnit()));
            this.loadChoises(trx);
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        AlgorithmDescriptor[] algorithmDescriptorArray = AlgorithmDescriptorDAO.getAll();
        int dep = algorithmDescriptorArray.length;
        int var = 0;
        while (var < dep) {
            AlgorithmDescriptor ad = algorithmDescriptorArray[var];
            if (ad.getId().equals(this.instance.getCustomAlgorithmId())) {
                algorithmDescriptor.set((Object)ad);
            }
            if (ad.getId().equals(this.instance.getVariable().getDefaultCustomAlgorithmId())) {
                defaultAlgorithm = ad;
            }
            algorithmDescriptors.add(ad);
            ++var;
        }
        algorithmDescriptor.addListener((o, ov, nv) -> this.instance.setCustomAlgorithmId(nv != null ? nv.getId() : null));
        IntegerPropertyItem idItem = new IntegerPropertyItem(MAIN_CATEGORY, "Id", this.instance.idProperty());
        EnumPropertyItem typeItem = new EnumPropertyItem(MAIN_CATEGORY, "Type", null, VariableInstanceType.class, (ObservableValue)this.instance.typeProperty());
        typeItem.setNullable(false);
        typeItem.setReadOnly(true);
        ChoicePropertyItem variableItem = new ChoicePropertyItem(MAIN_CATEGORY, "Variable", (ObservableValue)this.instance.variableProperty());
        ChoicePropertyItem structureObjectItem = new ChoicePropertyItem(MAIN_CATEGORY, "Object", (ObservableValue)this.instance.structureObjectProperty());
        EnumPropertyItem valueStrategyItem = new EnumPropertyItem(MAIN_CATEGORY, "Supplement Strategy", null, SupplementValueStrategy.class, (ObservableValue)this.instance.supplementValueStrategy());
        EnumPropertyItem interpolationItem = new EnumPropertyItem(MAIN_CATEGORY, "Interpolation Type", null, Interpolation.class, (ObservableValue)this.instance.interpolationProperty());
        ChoicePropertyItem valuesBoundsItem = new ChoicePropertyItem(MAIN_CATEGORY, "Values Bounds", (ObservableValue)this.instance.valuesBoundsProperty(), boundsChoices);
        StringPropertyItem descriptionItem = new StringPropertyItem(MAIN_CATEGORY, "Description", (ObservableValue)this.instance.descriptionProperty());
        descriptionItem.setPromptText(this.instance.getVariable().getDescription());
        descriptionItem.useAreaEditor(true);
        descriptionItem.setEditorVgrow(Priority.ALWAYS);
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{idItem, typeItem, variableItem, structureObjectItem, valueStrategyItem, interpolationItem, valuesBoundsItem, descriptionItem});
        if (this.instance.getType() == VariableInstanceType.PLC) {
            ChoicePropertyItem measuringUnitItem = new ChoicePropertyItem(ARCHIVE_CATEGORY, "Source measuring unit", (ObservableValue)this.instance.plcSourceMUProperty(), this.instance.getVariable().getPhysicalUnit().getMeasuringUnits());
            measuringUnitItem.setPromptText(String.format("default (%s)", this.instance.getResultArchiveMeasuringUnit()));
            EnumPropertyItem archAggrItem = new EnumPropertyItem(ARCHIVE_CATEGORY, "PLC raw value aggregation", null, Aggregation.class, (ObservableValue)this.instance.plcRawValueAggregationProperty());
            archAggrItem.setPromptText(String.format("Default: %s", this.instance.getVariable().getResultPlcRawValueAggregation()));
            ChoicePropertyItem dataGroupItem = new ChoicePropertyItem(ARCHIVE_CATEGORY, "Data Group", (ObservableValue)this.instance.plcDataGroupProperty(), this.dataGroups);
            dataGroupItem.setTextCallback(dg -> String.format("%s (%s)", dg.getName(), dg.getDataSource().getName()));
            if (this.instance.getVariable().getPlcDefaultDataGroup() != null) {
                DataGroup dg3 = this.instance.getVariable().getPlcDefaultDataGroup();
                dataGroupItem.setPromptText(String.format("Default: %s (%s)", dg3.getName(), dg3.getDataSource().getName()));
            }
            SimpleObjectProperty writeSourceVariableProperty = new SimpleObjectProperty();
            if (this.instance.getWriteValuesSource() != null) {
                writeSourceVariableProperty.set((Object)this.instance.getWriteValuesSource().getVariable());
            }
            ChoicePropertyItem writeValuesSourceVariableItem = new ChoicePropertyItem(ARCHIVE_CATEGORY, "Write Values Source Variable", (ObservableValue)writeSourceVariableProperty, this.writeSourceVariables);
            writeValuesSourceVariableItem.setNullable(false);
            writeValuesSourceVariableItem.setValidator(Validators.createValidator((o, ov, nv) -> this.instance.getResultPlcDataGroup() != null && (!this.instance.getResultPlcDataGroup().getType().isWrite() || nv != null), (String)"Write Values Source Variable must be selected"));
            writeValuesSourceVariableItem.setHidden(!this.writeSourceItemsVisible());
            ChoicePropertyItem writeValuesSourceItem = new ChoicePropertyItem(ARCHIVE_CATEGORY, "Write Values Source Instance", (ObservableValue)this.instance.writeValuesSourceProperty(), this.loadVariableInstances((Variable)writeSourceVariableProperty.get()));
            writeValuesSourceItem.setNullable(false);
            writeValuesSourceItem.setValidator(Validators.createValidator((o, ov, nv) -> this.instance.getResultPlcDataGroup() != null && (!this.instance.getResultPlcDataGroup().getType().isWrite() || nv != null), (String)"Write Values Source Variable Instance must be selected"));
            writeSourceVariableProperty.addListener((o, ov, nv) -> writeValuesSourceItem.setChoices(this.loadVariableInstances((Variable)nv)));
            writeValuesSourceItem.setHidden(!this.writeSourceItemsVisible());
            this.instance.plcDataGroupProperty().addListener((o, ov, nv) -> {
                writeValuesSourceVariableItem.setHidden(!this.writeSourceItemsVisible());
                writeValuesSourceItem.setHidden(!this.writeSourceItemsVisible());
                writeValuesSourceVariableItem.forceValidate();
                writeValuesSourceItem.forceValidate();
            });
            Map aliasMap = this.instance.getStructureObject().getPlcAliasMap();
            String aliases = "";
            if (aliasMap != null) {
                for (Map.Entry alias : aliasMap.entrySet()) {
                    aliases = String.valueOf(aliases) + String.format("%s=%s; ", alias.getKey(), alias.getValue());
                }
            }
            StringPropertyItem objectOpcKeyItem = new StringPropertyItem(ARCHIVE_CATEGORY, "Alias Map", (ObservableValue)new ReadOnlyStringWrapper(aliases));
            objectOpcKeyItem.setReadOnly(true);
            EnumPropertyItem plcTypeItem = new EnumPropertyItem(ARCHIVE_CATEGORY, "Type", PLCVariableInstanceType.class, (ObservableValue)this.instance.plcInstanceTypeProperty());
            plcTypeItem.setNullable(false);
            StringPropertyItem datasourceKeyItem = new StringPropertyItem(ARCHIVE_CATEGORY, "Data Source Key", (ObservableValue)this.instance.plcDataSourceKeyProperty());
            datasourceKeyItem.setPromptText(this.instance.getResultPlcDatasourceKey());
            this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{measuringUnitItem, archAggrItem, dataGroupItem, writeValuesSourceVariableItem, writeValuesSourceItem, objectOpcKeyItem, plcTypeItem, datasourceKeyItem});
        }
        if (this.instance.getType() == VariableInstanceType.Calculated) {
            CustomEditorPropertyItem formulaPropertyItem = new CustomEditorPropertyItem(CALC_CATEGORY, "Formula", FormulaPropertyEditor.class, (ObservableValue)this.instance.calculationFormulaProperty());
            formulaPropertyItem.setEditorVgrow(Priority.ALWAYS);
            Callback defaultFactory = this.sheet.getPropertyEditorFactory();
            this.sheet.setPropertyEditorFactory(item -> {
                if (item != formulaPropertyItem) {
                    return (PropertyEditor)defaultFactory.call(item);
                }
                return new FormulaPropertyEditor((PropertyItem<String>)((PropertyItem)item), context);
            });
            this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{formulaPropertyItem});
        } else if (this.instance.getType() == VariableInstanceType.Custom) {
            ChoicePropertyItem algItem = new ChoicePropertyItem(CUSTOM_CATEGORY, "Algorithm", (ObservableValue)algorithmDescriptor, algorithmDescriptors);
            if (defaultAlgorithm != null) {
                algItem.setPromptText(defaultAlgorithm.getName());
            }
            AlgorithmParameter[] defaultAlgParams = defaultAlgorithm != null ? defaultAlgorithm.getParameters() : null;
            SimpleObjectProperty algParameters = new SimpleObjectProperty();
            if (algorithmDescriptor.get() != null) {
                algParameters.set((Object)((AlgorithmDescriptor)algorithmDescriptor.get()).getParameters());
            } else {
                algParameters.set((Object)defaultAlgParams);
            }
            algorithmDescriptor.addListener((o, ov, nv) -> algParameters.set((Object)(nv != null ? nv.getParameters() : defaultAlgParams)));
            CustomEditorPropertyItem paramInfoItem = new CustomEditorPropertyItem(CUSTOM_CATEGORY, "Parameters", AlgorithmParameterInfoEditor.class, (ObservableValue)algParameters);
            StringPropertyItem customAlgDepsItem = new StringPropertyItem(CUSTOM_CATEGORY, "Custom Alg Deps", (ObservableValue)this.instance.customAlgorithmDependenciesDef());
            customAlgDepsItem.useAreaEditor(true);
            customAlgDepsItem.setHidden(true);
            Callback defaultFactory = this.sheet.getPropertyEditorFactory();
            this.sheet.setPropertyEditorFactory(item -> {
                if (item == paramInfoItem) {
                    AlgorithmParameterInfoEditor algEditor = new AlgorithmParameterInfoEditor((PropertySheet.Item)item);
                    if (this.instance.getCustomAlgorithmDependenciesDef() != null) {
                        CustomAlgorithmDependencies deps = CustomAlgorithmDependencies.parse((String)this.instance.getCustomAlgorithmDependenciesDef());
                        algEditor.setDependencies(deps);
                    }
                    algEditor.dependenciesProperty().addListener((o, ov, nv) -> {
                        if (nv != null) {
                            String json = nv.toJson();
                            this.instance.setCustomAlgorithmDependenciesDef(json);
                        } else {
                            this.instance.setCustomAlgorithmDependenciesDef(null);
                        }
                    });
                    return algEditor;
                }
                return (PropertyEditor)defaultFactory.call(item);
            });
            this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{algItem, paramInfoItem, customAlgDepsItem});
        }
        if (this.instance.getType().isDependentType()) {
            SimpleObjectProperty depsProperty = new SimpleObjectProperty(new ArrayList(this.instance.getDependencies()));
            CustomEditorPropertyItem depsItem = new CustomEditorPropertyItem(this.instance.getType() == VariableInstanceType.Calculated ? CALC_CATEGORY : CUSTOM_CATEGORY, "Dependencies", DependenciesPropertyEditor.class, (Object)this.instance, (ObservableValue)depsProperty);
            depsItem.setEditorMinHeight(Double.valueOf(150.0));
            depsItem.setEditorPrefHeight(Double.valueOf(200.0));
            Callback defaultFactory = this.sheet.getPropertyEditorFactory();
            this.sheet.setPropertyEditorFactory(item -> {
                if (item != depsItem) {
                    return (PropertyEditor)defaultFactory.call(item);
                }
                return new DependenciesPropertyEditor((PropertySheet.Item)item, this.app);
            });
            this.sheet.getItems().add((Object)depsItem);
        }
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.sheet.setMode(PropertySheet.Mode.CATEGORY);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        this.part.setLabel(String.format("Instance: %s", this.instance.getFullName()));
    }

    private void loadChoises(Transaction trx) {
        this.dataGroups.clear();
        Collections.addAll(this.dataGroups, DataGroupDAO.getAll((Transaction)trx));
        this.dataGroups.forEach(dg -> dg.setDataSource(DataSourceDAO.get((Transaction)trx, (int)dg.getDataSource().getId())));
        this.writeSourceVariables.clear();
        Variable[] variableArray = VariableDAO.getAll((Transaction)trx, (PhysicalUnit)this.instance.getVariable().getPhysicalUnit());
        int n = variableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variable writeVar = variableArray[n2];
            if (!writeVar.equals((Object)this.instance.getVariable())) {
                this.writeSourceVariables.add(writeVar);
            }
            ++n2;
        }
    }

    private Collection<VariableInstance> loadVariableInstances(Variable variable) {
        if (variable == null) {
            return Collections.emptyList();
        }
        Transaction trx = Transactions.begin();
        try {
            VariableInstance[] instances = VariableInstanceDAO.getAll((Transaction)trx, (Variable)variable);
            VariableInstanceDAO.loadStructureObjects((Transaction)trx, (VariableInstance[])instances);
            List<VariableInstance> list = Arrays.asList(instances);
            return list;
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private boolean writeSourceItemsVisible() {
        return this.instance.getResultPlcDataGroup() != null && this.instance.getResultPlcDataGroup().getType().isWrite();
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.instance.getFullName()));
            alert.initOwner(this.sheet.getScene().getWindow());
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                VariableInstanceDAO.saveOrUpdate((Transaction)trx, (VariableInstance)this.instance);
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                EnginPartUtils.refreshItems(this.instance, this.part);
            }
            catch (Exception exc) {
                Transactions.rollback((Transaction)trx);
                DialogFactory.showExceptionDialog((String)"Save variable instance", (Exception)exc, (Window)this.sheet.getScene().getWindow());
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Variable.class);
        this.part.setLabel(String.format("Instance: %s", this.instance.getFullName()));
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

