/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.vai.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.datasource.DataGroupDAO;
import de.elpro.ewms.core.client.datasource.DataSourceDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.variable.AlgorithmDescriptorDAO;
import de.elpro.ewms.core.client.variable.LocationDAO;
import de.elpro.ewms.core.client.variable.MediumDAO;
import de.elpro.ewms.core.client.variable.SourceDAO;
import de.elpro.ewms.core.client.variable.SpecializationDAO;
import de.elpro.ewms.core.client.variable.ValuesBoundsDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableRoleDAO;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.units.PhysicalUnitRegistry;
import de.elpro.ewms.core.variable.Location;
import de.elpro.ewms.core.variable.Medium;
import de.elpro.ewms.core.variable.Source;
import de.elpro.ewms.core.variable.Specialization;
import de.elpro.ewms.core.variable.ValuesBounds;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.VariableProperties;
import de.elpro.ewms.core.variable.VariableProperty;
import de.elpro.ewms.core.variable.VariableRole;
import de.elpro.ewms.core.variable.calculated.dependencies.CustomAlgorithmDependencies;
import de.elpro.ewms.core.variable.custom.AlgorithmDescriptor;
import de.elpro.ewms.engin.gui.navi.server.vai.parts.AlgorithmParameterInfoEditor;
import de.elpro.ewms.engin.gui.navi.server.vai.parts.CreateNewVariableDialog;
import de.elpro.ewms.engin.gui.navi.server.vai.parts.FormulaPropertyEditor;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ewms.gui.dialogs.DialogFactory;
import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.controlsfx.propertysheet.SeparatorItem;
import de.elpro.ui.di.Refresh;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.CustomEditorPropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.MultChoicesPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.PropertyEditor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class VariableEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.vai.variableedit";
    private static final String ARCH_CATEGORY = VariableProperties.GROUP_ARCH.getName();
    private static final String CALC_CATEGORY = VariableProperties.GROUP_CALC.getName();
    private static final String CUSTOM_CATEGORY = VariableProperties.GROUP_CUSTOM.getName();
    private static final String MISC_CATEGORY = VariableProperties.GROUP_MISC.getName();
    private Variable variable;
    private List<VariableProperty> genericProperties = new LinkedList<VariableProperty>();
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    @Inject
    private Scene scene;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private final ObservableList<Location> locations = FXCollections.observableArrayList();
    private final ObservableList<Medium> mediums = FXCollections.observableArrayList();
    private final ObservableList<Specialization> specializations = FXCollections.observableArrayList();
    private final ObservableList<Source> sources = FXCollections.observableArrayList();
    private final ObservableList<ValuesBounds> valuesBounds = FXCollections.observableArrayList();
    private final ObservableList<VariableRole> roles = FXCollections.observableArrayList();
    private final ObservableList<DataGroup> dataGroups = FXCollections.observableArrayList();
    private NumberPropertyItem<Integer> idItem;
    private StructureClass prevVariableStructureClass;

    @Inject
    public VariableEditPart(Variable variable) {
        this.variable = variable;
    }

    @PostConstruct
    public void postConstruct(BorderPane parent, IEclipseContext context) {
        LinkedList<AlgorithmDescriptor> algorithmDescriptors = new LinkedList<AlgorithmDescriptor>();
        SimpleObjectProperty algorithmDescriptor = new SimpleObjectProperty();
        ArrayList<StructureClass> allClasses = new ArrayList<StructureClass>();
        Transaction trx = Transactions.begin();
        try {
            if (this.variable.getId() != null) {
                this.variable = VariableDAO.get((Transaction)trx, (int)this.variable.getId());
            }
            allClasses.addAll(Arrays.asList(StructureClassDAO.getAll((Transaction)trx)));
            this.variable.setStructureClass(StructureClassDAO.get((Transaction)trx, (int)this.variable.getStructureClass().getId()));
            this.prevVariableStructureClass = this.variable.getStructureClass();
            if (this.variable.getValuesBounds() != null) {
                this.variable.setValuesBounds(ValuesBoundsDAO.get((Transaction)trx, (int)this.variable.getValuesBounds().getId()));
            }
            this.loadChoises(trx);
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        AlgorithmDescriptor[] algorithmDescriptorArray = AlgorithmDescriptorDAO.getAll();
        int n = algorithmDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlgorithmDescriptor ad = algorithmDescriptorArray[n2];
            if (ad.getId().equals(this.variable.getDefaultCustomAlgorithmId())) {
                algorithmDescriptor.set((Object)ad);
            }
            algorithmDescriptors.add(ad);
            ++n2;
        }
        algorithmDescriptor.addListener((o, ov, nv) -> this.variable.setDefaultCustomAlgorithmId(nv != null ? nv.getId() : null));
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.variable.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem structureClassItem = new ChoicePropertyItem("Structure Class", (ObservableValue)this.variable.structureClassProperty(), allClasses);
        structureClassItem.setNullable(false);
        structureClassItem.setValidator(Validators.createNotEmptyValidator((String)"Structure Class must be not empty"));
        ChoicePropertyItem locationItem = new ChoicePropertyItem("Location", (ObservableValue)this.variable.locationProperty(), this.locations);
        ChoicePropertyItem mediumItem = new ChoicePropertyItem("Medium", (ObservableValue)this.variable.mediumProperty(), this.mediums);
        mediumItem.setNullable(false);
        mediumItem.setValidator(Validators.createNotEmptyValidator((String)"Medium must be not empty"));
        ChoicePropertyItem physicalUnitItem = new ChoicePropertyItem("Physical Unit", (ObservableValue)this.variable.physicalUnitProperty(), PhysicalUnitRegistry.getPhysicalUnits());
        physicalUnitItem.setNullable(false);
        physicalUnitItem.setValidator(Validators.createNotEmptyValidator((String)"Physical Unit must be not empty"));
        Collection availableUnits = new ArrayList();
        if (this.variable.getPhysicalUnit() != null) {
            availableUnits = this.variable.getPhysicalUnit().getMeasuringUnits();
        }
        ChoicePropertyItem measuringUnitItem = new ChoicePropertyItem("Measuring Unit", (ObservableValue)this.variable.measuringUnitProperty(), availableUnits);
        measuringUnitItem.setNullable(false);
        measuringUnitItem.setValidator(Validators.createNotEmptyValidator((String)"Measuring Unit must be not empty"));
        ChoicePropertyItem specItem = new ChoicePropertyItem("Specialization\t1.", (ObservableValue)this.variable.specializationProperty(), this.specializations);
        ChoicePropertyItem spec2Item = new ChoicePropertyItem("\t\t\t2.", (ObservableValue)this.variable.specialization2Property(), this.specializations);
        ChoicePropertyItem sourceItem = new ChoicePropertyItem("Source", (ObservableValue)this.variable.sourceProperty(), this.sources);
        sourceItem.setNullable(false);
        sourceItem.setValidator(Validators.createNotEmptyValidator((String)"Source must be not empty"));
        ChoicePropertyItem valuesBoundsItem = new ChoicePropertyItem("Values Bounds", (ObservableValue)this.variable.valuesBoundsProperty(), this.valuesBounds);
        EnumPropertyItem aggrItem = new EnumPropertyItem("Aggregation", Aggregation.class, (ObservableValue)this.variable.aggregationProperty());
        if (this.variable.getPhysicalUnit() != null) {
            aggrItem.setPromptText(String.format("Default: %s", this.variable.getPhysicalUnit().getAggregation()));
        }
        this.variable.physicalUnitProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$1(measuringUnitItem, (PropertyItem)aggrItem, arg_0, arg_1, arg_2));
        ObservableList selectedRoles = FXCollections.observableArrayList();
        for (String roleId : this.variable.getRoleIds()) {
            selectedRoles.add((Object)VariableRoleDAO.get((String)roleId));
        }
        selectedRoles.addListener(il -> {
            this.variable.getRoleIds().clear();
            selectedRoles.forEach(r -> {
                boolean bl = this.variable.getRoleIds().add(r.getId());
            });
        });
        MultChoicesPropertyItem rolesItem = new MultChoicesPropertyItem("Roles", (Collection)selectedRoles, this.roles);
        StringPropertyItem descriptionItem = new StringPropertyItem("Description", (ObservableValue)this.variable.descriptionProperty());
        descriptionItem.useAreaEditor(true);
        descriptionItem.setEditorVgrow(Priority.ALWAYS);
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, structureClassItem, locationItem, mediumItem, new SeparatorItem(), physicalUnitItem, measuringUnitItem, new SeparatorItem(), specItem, spec2Item, new SeparatorItem(), sourceItem, new SeparatorItem(), valuesBoundsItem, rolesItem, aggrItem, descriptionItem});
        ChoicePropertyItem plcMUItem = new ChoicePropertyItem(ARCH_CATEGORY, "Default source measuring unit", null, (ObservableValue)this.variable.plcSourceMUProperty(), availableUnits);
        if (this.variable.getMeasuringUnit() != null) {
            plcMUItem.setPromptText(String.format("Default: %s", this.variable.getMeasuringUnit()));
        }
        EnumPropertyItem plcAggrItem = new EnumPropertyItem(ARCH_CATEGORY, "PLC raw value aggregation", null, Aggregation.class, (ObservableValue)this.variable.plcRawValueAggregationProperty());
        if (this.variable.getPhysicalUnit() != null) {
            plcAggrItem.setPromptText(String.format("Default: %s", this.variable.getResultAggregation()));
        }
        ChoicePropertyItem plcDefaultDataGroupItem = new ChoicePropertyItem(ARCH_CATEGORY, "Default Data Group", (ObservableValue)this.variable.plcDefaultDataGroupProperty(), this.dataGroups);
        plcDefaultDataGroupItem.setTextCallback(ds -> String.format("%s (%s)", ds.getName(), ds.getDataSource().getName()));
        StringPropertyItem plcDatasourceKeyPattern = new StringPropertyItem(ARCH_CATEGORY, "Datasource Key Pattern", (ObservableValue)this.variable.plcDatasourceKeyPatternProperty());
        plcDatasourceKeyPattern.setPromptText("Ex.: t|some_partial_identifier{alias_key1}/{alias_key2}_suffix");
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{plcMUItem, plcAggrItem, plcDefaultDataGroupItem, plcDatasourceKeyPattern});
        CustomEditorPropertyItem formulaPropertyItem = new CustomEditorPropertyItem(CALC_CATEGORY, "Default Formula", FormulaPropertyEditor.class, (ObservableValue)this.variable.defaultCalculationFormulaProperty());
        formulaPropertyItem.setEditorVgrow(Priority.ALWAYS);
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{formulaPropertyItem});
        ChoicePropertyItem defAlgItem = new ChoicePropertyItem(CUSTOM_CATEGORY, "Default Custom Algorithm", (ObservableValue)algorithmDescriptor, algorithmDescriptors);
        SimpleObjectProperty algParameters = new SimpleObjectProperty();
        if (algorithmDescriptor.get() != null) {
            algParameters.set((Object)((AlgorithmDescriptor)algorithmDescriptor.get()).getParameters());
        } else {
            algParameters.set(null);
        }
        algorithmDescriptor.addListener((o, ov, nv) -> algParameters.set((Object)(nv != null ? nv.getParameters() : null)));
        CustomEditorPropertyItem paramInfoItem = new CustomEditorPropertyItem(CUSTOM_CATEGORY, "Parameters", AlgorithmParameterInfoEditor.class, (ObservableValue)algParameters);
        paramInfoItem.setEditorVgrow(Priority.ALWAYS);
        StringPropertyItem defaultCustomAlgDepsItem = new StringPropertyItem(CUSTOM_CATEGORY, "Custom Alg Deps", (ObservableValue)this.variable.defaultCustomAlgorithmDependenciesDef());
        defaultCustomAlgDepsItem.useAreaEditor(true);
        defaultCustomAlgDepsItem.setHidden(true);
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{defAlgItem, paramInfoItem, defaultCustomAlgDepsItem});
        this.variable.physicalUnitProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$6(plcMUItem, (PropertyItem)plcAggrItem, rolesItem, arg_0, arg_1, arg_2));
        this.variable.measuringUnitProperty().addListener((o, ov, nv) -> {
            if (nv != null) {
                plcMUItem.setPromptText(String.format("Default: %s", nv));
            } else {
                plcMUItem.setPromptText(null);
            }
        });
        this.variable.aggregationProperty().addListener(arg_0 -> this.lambda$8((PropertyItem)plcAggrItem, arg_0));
        Callback defaultFactory = this.sheet.getPropertyEditorFactory();
        this.sheet.setPropertyEditorFactory(item -> {
            if (item == formulaPropertyItem) {
                return new FormulaPropertyEditor((PropertyItem<String>)((PropertyItem)item), context);
            }
            if (item == paramInfoItem) {
                AlgorithmParameterInfoEditor algEditor = new AlgorithmParameterInfoEditor((PropertySheet.Item)item);
                if (this.variable.getDefaultCustomAlgorithmDependenciesDef() != null) {
                    CustomAlgorithmDependencies deps = CustomAlgorithmDependencies.parse((String)this.variable.getDefaultCustomAlgorithmDependenciesDef());
                    algEditor.setDependencies(deps);
                }
                algEditor.dependenciesProperty().addListener((o, ov, nv) -> {
                    if (nv != null) {
                        String json = nv.toJson();
                        this.variable.setDefaultCustomAlgorithmDependenciesDef(json);
                    } else {
                        this.variable.setDefaultCustomAlgorithmDependenciesDef(null);
                    }
                });
                return algEditor;
            }
            return (PropertyEditor)defaultFactory.call(item);
        });
        for (VariableProperties.VariablePropertyGroup group : VariableProperties.getGroups()) {
            for (VariableProperties.VariablePropertyDescription description : VariableProperties.getDescriptions((VariableProperties.VariablePropertyGroup)group)) {
                VariableProperty variableProperty = new VariableProperty(this.variable, description.getKey());
                this.genericProperties.add(variableProperty);
                variableProperty.setValue(this.variable.getDefaultProperty(description.getKey()));
                StringPropertyItem genericPropertyItem = new StringPropertyItem(group.getName(), description.getName(), (ObservableValue)variableProperty.valueProperty());
                genericPropertyItem.useAreaEditor(description.getUseAreaEditor());
                this.sheet.getItems().add((Object)genericPropertyItem);
            }
        }
        for (VariableProperty property : this.variable.getDefaultProperties()) {
            if (this.genericProperties.contains(property)) continue;
            this.genericProperties.add(property);
            StringPropertyItem genericPropertyItem = new StringPropertyItem(MISC_CATEGORY, property.getKey(), (ObservableValue)property.valueProperty());
            if (property.getValue() != null && property.getValue().contains("\n")) {
                genericPropertyItem.useAreaEditor(true);
            }
            this.sheet.getItems().add((Object)genericPropertyItem);
        }
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        this.sheet.setMode(PropertySheet.Mode.CATEGORY);
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv != false || this.idItem.getValue() == null));
        if (this.variable.getId() != null) {
            this.part.setLabel(String.format("Variable: %s", this.variable.toString()));
        }
    }

    private void loadChoises(Transaction trx) {
        this.locations.setAll((Object[])LocationDAO.getAll((Transaction)trx));
        this.mediums.setAll((Object[])MediumDAO.getAll((Transaction)trx));
        this.sources.setAll((Object[])SourceDAO.getAll((Transaction)trx));
        this.specializations.setAll((Object[])SpecializationDAO.getAll((Transaction)trx));
        if (this.variable.getPhysicalUnit() != null) {
            this.valuesBounds.setAll((Object[])ValuesBoundsDAO.getAll((Transaction)trx, (PhysicalUnit)this.variable.getPhysicalUnit()));
            this.roles.setAll((Object[])VariableRoleDAO.getAll((Transaction)trx, (StructureClass)this.variable.getStructureClass(), (PhysicalUnit)this.variable.getPhysicalUnit()));
        } else {
            this.valuesBounds.clear();
            this.roles.clear();
        }
        this.dataGroups.setAll((Object[])DataGroupDAO.getAll((Transaction)trx));
        this.dataGroups.forEach(dg -> dg.setDataSource(DataSourceDAO.get((Transaction)trx, (int)dg.getDataSource().getId())));
    }

    @Refresh(refreshClasses={Location.class})
    public void updateLocations() {
        Transaction trx = Transactions.begin();
        try {
            this.locations.setAll((Object[])LocationDAO.getAll((Transaction)trx));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @Refresh(refreshClasses={Medium.class})
    public void updateMediums() {
        Transaction trx = Transactions.begin();
        try {
            this.mediums.setAll((Object[])MediumDAO.getAll((Transaction)trx));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @Refresh(refreshClasses={Source.class})
    public void updateSources() {
        Transaction trx = Transactions.begin();
        try {
            this.sources.setAll((Object[])SourceDAO.getAll((Transaction)trx));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @Refresh(refreshClasses={Specialization.class})
    public void updateSpecialization() {
        Transaction trx = Transactions.begin();
        try {
            this.specializations.setAll((Object[])SpecializationDAO.getAll((Transaction)trx));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @Refresh(refreshClasses={DataGroup.class})
    public void updateDataGroup() {
        Transaction trx = Transactions.begin();
        try {
            this.dataGroups.setAll((Object[])DataGroupDAO.getAll((Transaction)trx));
            this.dataGroups.forEach(dg -> dg.setDataSource(DataSourceDAO.get((Transaction)trx, (int)dg.getDataSource().getId())));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @Refresh(refreshClasses={ValuesBounds.class})
    public void updateValuesBounds() {
        if (this.variable.getPhysicalUnit() == null) {
            this.valuesBounds.clear();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            this.valuesBounds.setAll((Object[])ValuesBoundsDAO.getAll((Transaction)trx, (PhysicalUnit)this.variable.getPhysicalUnit()));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Persist
    public void save() {
        if (!this.hasChanges.get() && this.idItem.getValue() != null) {
            return;
        }
        if (this.hasErrors.get()) {
            alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", new Object[]{this.variable.toString()}));
            alert.initOwner(this.scene.getWindow());
            alert.showAndWait();
            return;
        }
        structureClassChanges = false;
        if (!this.prevVariableStructureClass.equals((Object)this.variable.getStructureClass())) {
            alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText("You are about to change variables structure class.\r\nIt will create/delete variables instances. Proceed?");
            alert.initOwner(this.scene.getWindow());
            alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
            button = alert.showAndWait().orElse(ButtonType.CANCEL);
            if (button != ButtonType.OK) {
                return;
            }
            structureClassChanges = true;
        }
        trx = Transactions.begin();
        try {
            this.variable.getDefaultProperties().clear();
            for (VariableProperty property : this.genericProperties) {
                if (property.getValue() == null || property.getValue().trim().isEmpty()) continue;
                this.variable.getDefaultProperties().add(property);
            }
            isNew = this.variable.getId() == null;
            defaultType = VariableInstanceType.None;
            defaultStrategy = null;
            if (!isNew && !structureClassChanges) ** GOTO lbl42
            newVarDlg = new CreateNewVariableDialog(this.sheet.getScene().getWindow(), this.variable.getSource().getDefaultType(), this.variable.getSource().getDefaultSupplementValueStrategy());
            type = newVarDlg.showAndWait();
            if (!type.isPresent()) {
                return;
            }
            if (type.get() != ButtonType.OK) {
                return;
            }
            try {
                defaultType = newVarDlg.getType();
                defaultStrategy = newVarDlg.getStrategy();
lbl42:
                // 2 sources

                this.idItem.setValue((Object)VariableDAO.saveOrUpdate((Transaction)trx, (Variable)this.variable));
                VariableDAO.updateVariableInstances((Transaction)trx, (Variable)this.variable, (VariableInstanceType)defaultType, defaultStrategy);
                Transactions.commitSync((Transaction)trx);
                this.prevVariableStructureClass = this.variable.getStructureClass();
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(String.format("Variable: %s", new Object[]{this.variable.toString()}));
                if (isNew || structureClassChanges) {
                    EnginPartUtils.refreshItems(this.variable.getStructureClass(), this.part);
                }
                EnginPartUtils.refreshItems(this.variable, this.part);
            }
            catch (Exception exc) {
                Transactions.rollback((Transaction)trx);
                DialogFactory.showExceptionDialog((String)"Save variable", (Exception)exc, (Window)this.sheet.getScene().getWindow());
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Variable.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }

    private /* synthetic */ void lambda$1(ChoicePropertyItem choicePropertyItem, PropertyItem propertyItem, ObservableValue o, PhysicalUnit ov, PhysicalUnit nv) {
        choicePropertyItem.setChoices(nv == null ? new ArrayList() : new ArrayList(nv.getMeasuringUnits()));
        this.updateValuesBounds();
        if (nv != null) {
            propertyItem.setPromptText(String.format("Default: %s", nv.getAggregation()));
        } else {
            propertyItem.setPromptText(null);
        }
    }

    private /* synthetic */ void lambda$6(ChoicePropertyItem choicePropertyItem, PropertyItem propertyItem, MultChoicesPropertyItem multChoicesPropertyItem, ObservableValue o, PhysicalUnit ov, PhysicalUnit nv) {
        choicePropertyItem.setChoices(nv == null ? new ArrayList() : new ArrayList(nv.getMeasuringUnits()));
        Aggregation aggr = this.variable.getAggregation();
        if (aggr == null && nv != null) {
            aggr = nv.getAggregation();
        }
        if (aggr != null) {
            propertyItem.setPromptText(String.format("Default: %s", aggr));
        } else {
            propertyItem.setPromptText(null);
        }
        if (nv == null) {
            multChoicesPropertyItem.setChoises(Collections.emptyList());
        } else {
            Transaction updateTrx = Transactions.begin();
            try {
                multChoicesPropertyItem.setChoises(Arrays.asList(VariableRoleDAO.getAll((Transaction)updateTrx, (StructureClass)this.variable.getStructureClass(), (PhysicalUnit)nv)));
            }
            finally {
                Transactions.close((Transaction)updateTrx);
            }
        }
    }

    private /* synthetic */ void lambda$8(PropertyItem propertyItem, Observable il) {
        Aggregation aggr = this.variable.getAggregation();
        if (aggr == null && this.variable.getPhysicalUnit() != null) {
            aggr = this.variable.getPhysicalUnit().getAggregation();
        }
        if (aggr != null) {
            propertyItem.setPromptText(String.format("Default: %s", aggr));
        } else {
            propertyItem.setPromptText(null);
        }
    }
}

