/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.varconst.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.variable.LocationDAO;
import de.elpro.ewms.core.client.variable.MediumDAO;
import de.elpro.ewms.core.client.variable.SourceDAO;
import de.elpro.ewms.core.client.variable.SpecializationDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.variable.IVariableKeyPart;
import de.elpro.ewms.core.variable.Location;
import de.elpro.ewms.core.variable.Medium;
import de.elpro.ewms.core.variable.Source;
import de.elpro.ewms.core.variable.Specialization;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.engin.gui.tools.validators.ValidatorUtils;
import de.elpro.resources.Icons;
import de.elpro.ui.fx.cells.editable.TextFieldTableCell;
import de.elpro.ui.fx.utils.FXUtilsColumnPersister;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.util.Pair;
import javafx.util.StringConverter;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.prefs.BackingStoreException;

public class AbstractListPart {
    @Inject
    protected MPart part;
    @Inject
    protected EPartService partService;
    private final Class<?> valClass;
    private final ObservableList<IVariableKeyPart> values = FXCollections.observableArrayList();
    private final Map<Integer, Pair<String, String>> source = new HashMap<Integer, Pair<String, String>>();
    private final Map<Integer, VariableInstanceType> sourceType = new HashMap<Integer, VariableInstanceType>();
    private final Map<Integer, SupplementValueStrategy> sourceStrategy = new HashMap<Integer, SupplementValueStrategy>();
    private final TableView<IVariableKeyPart> tableView = new TableView();

    public AbstractListPart(Class<?> valClass) {
        this.valClass = valClass;
        Transaction trx = Transactions.begin();
        try {
            if (valClass == Location.class) {
                var6_3 = LocationDAO.getAll((Transaction)trx);
                var5_4 = var6_3.length;
                var4_5 = 0;
                while (var4_5 < var5_4) {
                    obj = var6_3[var4_5];
                    this.values.add((Object)obj);
                    ++var4_5;
                }
            } else if (valClass == Medium.class) {
                var6_3 = MediumDAO.getAll((Transaction)trx);
                var5_4 = var6_3.length;
                var4_5 = 0;
                while (var4_5 < var5_4) {
                    obj = var6_3[var4_5];
                    this.values.add((Object)obj);
                    ++var4_5;
                }
            } else if (valClass == Source.class) {
                var6_3 = SourceDAO.getAll((Transaction)trx);
                var5_4 = var6_3.length;
                var4_5 = 0;
                while (var4_5 < var5_4) {
                    obj = var6_3[var4_5];
                    this.values.add((Object)obj);
                    ++var4_5;
                }
            } else if (valClass == Specialization.class) {
                var6_3 = SpecializationDAO.getAll((Transaction)trx);
                var5_4 = var6_3.length;
                var4_5 = 0;
                while (var4_5 < var5_4) {
                    obj = var6_3[var4_5];
                    this.values.add((Object)obj);
                    ++var4_5;
                }
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        for (IVariableKeyPart val : this.values) {
            this.source.put(val.getId(), (Pair<String, String>)new Pair((Object)val.getValue(), (Object)val.getName()));
            if (!(val instanceof Source)) continue;
            this.sourceType.put(val.getId(), ((Source)val).getDefaultType());
            this.sourceStrategy.put(val.getId(), ((Source)val).getDefaultSupplementValueStrategy());
        }
    }

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        this.tableView.setEditable(true);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        StringConverter<String> fictiveConverter = new StringConverter<String>(){

            public String toString(String object) {
                return object;
            }

            public String fromString(String string) {
                AbstractListPart.this.part.setDirty(true);
                return string;
            }
        };
        TableColumn valueColumn = new TableColumn("Value");
        valueColumn.setId("variable-key-part-column-value");
        valueColumn.setCellValueFactory(cf -> ((IVariableKeyPart)cf.getValue()).valueProperty());
        valueColumn.setCellFactory(arg_0 -> AbstractListPart.lambda$1((StringConverter)fictiveConverter, arg_0));
        TableColumn nameColumn = new TableColumn("Name");
        nameColumn.setId("variable-key-part-column-name");
        nameColumn.setCellValueFactory(cf -> ((IVariableKeyPart)cf.getValue()).nameProperty());
        nameColumn.setCellFactory(arg_0 -> AbstractListPart.lambda$3((StringConverter)fictiveConverter, arg_0));
        this.tableView.getColumns().addAll((Object[])new TableColumn[]{valueColumn, nameColumn});
        if (this.valClass == Source.class) {
            TableColumn defaultTypeColumn = new TableColumn("Default Type");
            defaultTypeColumn.setId("variable-key-part-column-default-type");
            defaultTypeColumn.setCellValueFactory(cf -> {
                ObjectProperty prop = ((Source)cf.getValue()).defaultTypeProperty();
                prop.addListener(i -> this.part.setDirty(true));
                return prop;
            });
            defaultTypeColumn.setCellFactory(cf -> new ComboBoxTableCell((Object[])VariableInstanceType.values()));
            this.tableView.getColumns().add((Object)defaultTypeColumn);
            TableColumn defaultSupplValStratColumn = new TableColumn("Default Supplement Value Strategy");
            defaultSupplValStratColumn.setId("variable-key-part-column-default-supplement-value-strategy");
            defaultSupplValStratColumn.setCellValueFactory(cf -> {
                ObjectProperty prop = ((Source)cf.getValue()).defaultSupplementValueStrategyProperty();
                prop.addListener(i -> this.part.setDirty(true));
                return prop;
            });
            defaultSupplValStratColumn.setCellFactory(cf -> new ComboBoxTableCell((Object[])SupplementValueStrategy.values()));
            this.tableView.getColumns().add((Object)defaultSupplValStratColumn);
        }
        parent.setCenter(this.tableView);
        this.tableView.setItems(this.values);
        MenuItem addItem = new MenuItem("Add", (Node)new ImageView(Icons.ADD_ITEM_URL.toString()));
        addItem.setOnAction(e -> {
            this.values.add((Object)this.createNewElement());
            this.part.setDirty(true);
        });
        final MenuItem deleteItem = new MenuItem("Delete", (Node)new ImageView(Icons.DELETE_ITEM_URL.toString()));
        deleteItem.setOnAction(e -> {
            LinkedList toRemove = new LinkedList(this.tableView.getSelectionModel().getSelectedItems());
            this.tableView.getSelectionModel().clearSelection();
            this.values.removeAll(toRemove);
            this.part.setDirty(true);
        });
        this.tableView.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<IVariableKeyPart>(){

            public void onChanged(ListChangeListener.Change<? extends IVariableKeyPart> c) {
                deleteItem.setDisable(AbstractListPart.this.tableView.getSelectionModel().getSelectedItems().isEmpty());
            }
        });
        this.tableView.setContextMenu(new ContextMenu(new MenuItem[]{addItem, deleteItem}));
        FXUtilsColumnPersister.loadColumnsState((String)("variable-key-part-" + this.valClass.getSimpleName()), (ObservableList)this.tableView.getColumns());
    }

    protected IVariableKeyPart createNewElement() {
        Location element = null;
        if (this.valClass == Location.class) {
            element = new Location();
        } else if (this.valClass == Medium.class) {
            element = new Medium();
        } else if (this.valClass == Source.class) {
            element = new Source();
        } else if (this.valClass == Specialization.class) {
            element = new Specialization();
        }
        element.setValue("Value");
        element.setName("Display name");
        return element;
    }

    @Persist
    public void save() {
        HashSet<String> newEntryVals = new HashSet<String>();
        for (IVariableKeyPart keyPart : this.values) {
            if (newEntryVals.contains(keyPart.getValue())) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setContentText(String.format("Duplicate entry with '%s' value", keyPart.getValue()));
                alert.showAndWait();
                return;
            }
            newEntryVals.add(keyPart.getValue());
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                for (Map.Entry<Integer, Pair<String, String>> oldValue : this.source.entrySet()) {
                    if (!this.values.filtered(p -> ((Integer)oldValue.getKey()).equals(p.getId())).isEmpty()) continue;
                    if (this.valClass == Location.class) {
                        LocationDAO.delete((Transaction)trx, (int)oldValue.getKey());
                        continue;
                    }
                    if (this.valClass == Medium.class) {
                        MediumDAO.delete((Transaction)trx, (int)oldValue.getKey());
                        continue;
                    }
                    if (this.valClass == Source.class) {
                        SourceDAO.delete((Transaction)trx, (int)oldValue.getKey());
                        continue;
                    }
                    if (this.valClass != Specialization.class) continue;
                    SpecializationDAO.delete((Transaction)trx, (int)oldValue.getKey());
                }
                for (IVariableKeyPart entry : this.values) {
                    Pair<String, String> oldEntry;
                    if (entry.getId() != null && this.source.containsKey(entry.getId()) && ((String)(oldEntry = this.source.get(entry.getId())).getKey()).equals(entry.getValue()) && ((String)oldEntry.getValue()).equals(entry.getName())) {
                        if (this.valClass != Source.class) continue;
                        VariableInstanceType oldType = this.sourceType.get(entry.getId());
                        SupplementValueStrategy oldStrategy = this.sourceStrategy.get(entry.getId());
                        Source newSource = (Source)entry;
                        if (oldType == newSource.getDefaultType() && oldStrategy == newSource.getDefaultSupplementValueStrategy()) continue;
                    }
                    if (this.valClass == Location.class) {
                        entry.setId(LocationDAO.saveOrUpdate((Transaction)trx, (Location)((Location)entry)));
                        continue;
                    }
                    if (this.valClass == Medium.class) {
                        entry.setId(MediumDAO.saveOrUpdate((Transaction)trx, (Medium)((Medium)entry)));
                        continue;
                    }
                    if (this.valClass == Source.class) {
                        entry.setId(SourceDAO.saveOrUpdate((Transaction)trx, (Source)((Source)entry)));
                        continue;
                    }
                    if (this.valClass != Specialization.class) continue;
                    entry.setId(SpecializationDAO.saveOrUpdate((Transaction)trx, (Specialization)((Specialization)entry)));
                }
                Transactions.commitSync((Transaction)trx);
                this.source.clear();
                this.sourceType.clear();
                for (IVariableKeyPart keyPart : this.values) {
                    this.source.put(keyPart.getId(), (Pair<String, String>)new Pair((Object)keyPart.getValue(), (Object)keyPart.getName()));
                    if (!(keyPart instanceof Source)) continue;
                    this.sourceType.put(keyPart.getId(), ((Source)keyPart).getDefaultType());
                    this.sourceStrategy.put(keyPart.getId(), ((Source)keyPart).getDefaultSupplementValueStrategy());
                }
                PartUtils.refreshParts((EPartService)this.partService, this.valClass);
                this.part.setDirty(false);
            }
            catch (DAOOperationException exc) {
                ExceptionDialog excDlg = new ExceptionDialog((Throwable)exc);
                excDlg.setContentText("Error during delete/change entry. Check if modified entry is referenced by some variable");
                excDlg.show();
                Transactions.rollback((Transaction)trx);
                Transactions.close((Transaction)trx);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @PreDestroy
    protected void close() throws BackingStoreException {
        this.part.setDirty(false);
        FXUtilsColumnPersister.persistColumnsState((String)("variable-key-part-" + this.valClass.getSimpleName()), (ObservableList)this.tableView.getColumns());
    }

    private static /* synthetic */ TableCell lambda$1(StringConverter stringConverter, TableColumn cf) {
        return new TextFieldTableCell(stringConverter, ValidatorUtils.VAR_NAME_TOKEN_VALIDATOR);
    }

    private static /* synthetic */ TableCell lambda$3(StringConverter stringConverter, TableColumn cf) {
        return new TextFieldTableCell(stringConverter);
    }
}

