/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.varconst.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.variable.ValuesBoundsDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.PhysicalUnitRegistry;
import de.elpro.ewms.core.variable.ValuesBounds;
import de.elpro.resources.Icons;
import de.elpro.ui.formats.NumberFormats;
import de.elpro.ui.fx.cells.editable.DoubleFieldTableCell;
import de.elpro.ui.fx.cells.editable.DynamicComboBoxTableCell;
import de.elpro.ui.fx.cells.editable.StringTextFieldTableCell;
import de.elpro.ui.fx.utils.FXUtilsColumnPersister;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.prefs.BackingStoreException;

public class ValuesBoundsPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.valuesbounds";
    private final ObservableList<ValuesBounds> items = FXCollections.observableArrayList();
    private final TableView<ValuesBounds> view = new TableView(this.items);
    private final Set<ValuesBounds> changedItems = new HashSet<ValuesBounds>();
    private final Set<ValuesBounds> deletedItems = new HashSet<ValuesBounds>();
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;

    @PostConstruct
    public void postConstruct(BorderPane parent, Scene scene) {
        Transaction trx = Transactions.begin();
        try {
            ValuesBounds[] valuesBoundsArray = ValuesBoundsDAO.getAll((Transaction)trx);
            int n = valuesBoundsArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValuesBounds valuesBounds = valuesBoundsArray[n2];
                this.items.add((Object)valuesBounds);
                this.addInvalidationListener(valuesBounds);
                ++n2;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        TableColumn nameColumn = new TableColumn("Name");
        nameColumn.setId("values-bounds-part-column-name");
        nameColumn.setCellValueFactory(cf -> ((ValuesBounds)cf.getValue()).nameProperty());
        nameColumn.setCellFactory(cf -> new StringTextFieldTableCell());
        nameColumn.setPrefWidth(150.0);
        TableColumn physicalUnitColumn = new TableColumn("Physical Unit");
        physicalUnitColumn.setId("values-bounds-part-column-physical-unit");
        physicalUnitColumn.setCellValueFactory(cf -> new SimpleObjectProperty((Object)((ValuesBounds)cf.getValue()).getMeasuringUnit().getPhysicalUnit()));
        TableColumn measuringUnitColumn = new TableColumn("Measuring Unit");
        measuringUnitColumn.setId("values-bounds-part-column-measuring-unit");
        measuringUnitColumn.setCellFactory(cf -> new DynamicComboBoxTableCell(mu -> mu.getPhysicalUnit().getMeasuringUnits()));
        measuringUnitColumn.setCellValueFactory(cf -> ((ValuesBounds)cf.getValue()).measuringUnitProperty());
        TableColumn highLimitColumn = new TableColumn("High lim.");
        highLimitColumn.setId("values-bounds-part-column-high-limit");
        highLimitColumn.setCellFactory(cf -> new DoubleFieldTableCell(NumberFormats.DEFAULT_DOUBLE));
        highLimitColumn.setCellValueFactory(cf -> ((ValuesBounds)cf.getValue()).highLimitProperty());
        TableColumn lowLimitColumn = new TableColumn("Low lim.");
        lowLimitColumn.setId("values-bounds-part-column-low-limit");
        lowLimitColumn.setCellFactory(cf -> new DoubleFieldTableCell(NumberFormats.DEFAULT_DOUBLE));
        lowLimitColumn.setCellValueFactory(cf -> ((ValuesBounds)cf.getValue()).lowLimitProperty());
        TableColumn descriptionColumn = new TableColumn("Description");
        descriptionColumn.setId("values-bounds-part-column-low-description");
        descriptionColumn.setCellValueFactory(cf -> ((ValuesBounds)cf.getValue()).descriptionProperty());
        descriptionColumn.setCellFactory(cf -> new StringTextFieldTableCell());
        descriptionColumn.setPrefWidth(300.0);
        this.view.setEditable(true);
        this.view.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.view.getColumns().addAll((Object[])new TableColumn[]{nameColumn, physicalUnitColumn, measuringUnitColumn, lowLimitColumn, highLimitColumn, descriptionColumn});
        MenuItem addItem = new MenuItem("Add", (Node)new ImageView(Icons.ADD_ITEM_URL.toString()));
        addItem.setOnAction(e -> {
            ChoiceDialog typeDlg = new ChoiceDialog(null, PhysicalUnitRegistry.getPhysicalUnits());
            typeDlg.initOwner(scene.getWindow());
            typeDlg.setHeaderText("Select Physical Unit");
            typeDlg.showAndWait().ifPresent(unit -> {
                ValuesBounds bounds = new ValuesBounds();
                this.addInvalidationListener(bounds);
                MeasuringUnit mu = (MeasuringUnit)unit.getMeasuringUnits().iterator().next();
                bounds.setMeasuringUnit(mu);
                this.items.add((Object)bounds);
                this.part.setDirty(true);
                this.changedItems.add(bounds);
            });
        });
        final MenuItem deleteItem = new MenuItem("Delete", (Node)new ImageView(Icons.DELETE_ITEM_URL.toString()));
        deleteItem.setOnAction(e -> {
            LinkedList toRemove = new LinkedList(this.view.getSelectionModel().getSelectedItems());
            this.view.getSelectionModel().clearSelection();
            this.items.removeAll(toRemove);
            this.part.setDirty(true);
            this.deletedItems.addAll(toRemove);
        });
        this.view.setContextMenu(new ContextMenu(new MenuItem[]{addItem, deleteItem}));
        this.view.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<ValuesBounds>(){

            public void onChanged(ListChangeListener.Change<? extends ValuesBounds> c) {
                deleteItem.setDisable(ValuesBoundsPart.this.view.getSelectionModel().getSelectedItems().isEmpty());
            }
        });
        FXUtilsColumnPersister.loadColumnsState((String)"values-bounds-part", (ObservableList)this.view.getColumns());
        parent.setCenter(this.view);
    }

    public void addInvalidationListener(ValuesBounds valuesBounds) {
        InvalidationListener il = l -> {
            this.changedItems.add(valuesBounds);
            this.part.setDirty(true);
        };
        valuesBounds.nameProperty().addListener(il);
        valuesBounds.measuringUnitProperty().addListener(il);
        valuesBounds.highLimitProperty().addListener(il);
        valuesBounds.lowLimitProperty().addListener(il);
        valuesBounds.descriptionProperty().addListener(il);
    }

    @Persist
    public void save() {
        if (!this.part.isDirty()) {
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                for (ValuesBounds changedItem : this.changedItems) {
                    changedItem.setId(Integer.valueOf(ValuesBoundsDAO.saveOrUpdate((Transaction)trx, (ValuesBounds)changedItem)));
                }
                for (ValuesBounds deletedItem : this.deletedItems) {
                    if (deletedItem.getId() == null) continue;
                    ValuesBoundsDAO.delete((Transaction)trx, (int)deletedItem.getId());
                }
                Transactions.commitSync((Transaction)trx);
                PartUtils.refreshParts((EPartService)this.partService, ValuesBounds.class);
                this.changedItems.clear();
                this.deletedItems.clear();
                this.part.setDirty(false);
            }
            catch (DAOOperationException exc) {
                ExceptionDialog excDlg = new ExceptionDialog((Throwable)exc);
                excDlg.setContentText("Error during delete/change entry. Check if modified entry is referenced by some variable");
                excDlg.show();
                Transactions.rollback((Transaction)trx);
                Transactions.close((Transaction)trx);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @PreDestroy
    protected void close() throws BackingStoreException {
        this.part.setDirty(false);
        FXUtilsColumnPersister.persistColumnsState((String)"values-bounds-part", (ObservableList)this.view.getColumns());
    }
}

