/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.services;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.engin.gui.navi.model.INavigationTreeElement;
import de.elpro.ewms.gui.dialogs.DialogFactory;
import de.elpro.ui.fx.controls.tree.LazyTreeItem;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.utils.e4.NamedContextValue;
import de.elpro.ui.utils.e4.PartUtils;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javafx.stage.Window;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class EnginPartUtils {
    public static <T extends UIModelElement> void refreshItems(T item, MPart part) {
        IEclipseContext partContext = part.getContext();
        Object editTreeItem = partContext.get("de.elpro.ewms.engin.gui.services.edittreeitem");
        Object parentTreeItem = partContext.get("de.elpro.ewms.engin.gui.services.parenttreeitem");
        if (editTreeItem instanceof TreeItem) {
            ((TreeItem)editTreeItem).setValue(item);
        } else if (parentTreeItem instanceof LazyTreeItem) {
            LazyTreeItem lazyParentTreeItem = (LazyTreeItem)parentTreeItem;
            lazyParentTreeItem.refreshChildren();
        }
    }

    public static <T extends UIModelElement> void showCreateRootItemPart(String partId, MApplication app, T newElement, TreeItem<? extends UIModelElement> selectedItem) {
        while (selectedItem.getParent() != null && !(selectedItem.getParent().getValue() instanceof INavigationTreeElement)) {
            selectedItem = selectedItem.getParent();
        }
        EnginPartUtils.showCreatePart(partId, app, newElement, selectedItem);
    }

    public static <T extends UIModelElement> void showCreatePart(String partId, MApplication app, T newElement, TreeItem<? extends UIModelElement> parentItem) {
        PartUtils.showOrReplacePartWithNamedContext((String)"de.elpro.ewms.engin.gui.partstack.editors", (String)partId, (MApplication)app, (boolean)false, (NamedContextValue[])new NamedContextValue[]{new NamedContextValue((Object)newElement.getClass().getName(), newElement), new NamedContextValue((Object)"de.elpro.ewms.engin.gui.services.parenttreeitem", parentItem)}).setDirty(true);
    }

    public static <T extends UIModelElement> void showEditPart(String partId, MApplication app, T newElement, TreeItem<? extends UIModelElement> editItem) {
        MPart part = PartUtils.findPart((String)partId, (MApplication)app, (Object[])new Object[]{newElement});
        if (part != null) {
            IEclipseContext context = app.getContext();
            EPartService partService = (EPartService)context.get(EPartService.class);
            partService.showPart(part, EPartService.PartState.ACTIVATE);
            return;
        }
        PartUtils.showOrReplacePartWithNamedContext((String)"de.elpro.ewms.engin.gui.partstack.editors", (String)partId, (MApplication)app, (boolean)true, (NamedContextValue[])new NamedContextValue[]{new NamedContextValue((Object)newElement.getClass().getName(), newElement), new NamedContextValue((Object)"de.elpro.ewms.engin.gui.services.edittreeitem", editItem)});
    }

    public static <T extends UIModelElement> void showDeleteDialog(Window owner, MApplication app, TreeItem<T> selection, IOnDeleteAction<T> deleteCallback, IClosePartsOnDeleteAction<T> closePartsAction) {
        EnginPartUtils.showDeleteDialog(null, owner, app, selection, deleteCallback, closePartsAction);
    }

    public static <T extends UIModelElement> void showDeleteDialog(String dialogContentText, Window owner, MApplication app, TreeItem<T> selection, IOnDeleteAction<T> deleteCallback, IClosePartsOnDeleteAction<T> closePartsAction) {
        if (selection == null || selection.getValue() == null) {
            return;
        }
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.initOwner(owner);
        alert.setTitle("Confirmation Dialog");
        if (dialogContentText == null) {
            dialogContentText = String.format("Do you really want do delete '%s'?", ((UIModelElement)selection.getValue()).toString());
        }
        alert.setContentText(dialogContentText);
        alert.showAndWait().ifPresent(buttonType -> {
            if (buttonType == ButtonType.OK) {
                Transaction trx = Transactions.begin();
                try {
                    try {
                        if (deleteCallback.delete(trx, (UIModelElement)selection.getValue())) {
                            Transactions.commitSync((Transaction)trx);
                            if (selection.getParent() != null) {
                                selection.getParent().getChildren().remove((Object)selection);
                            }
                            closePartsAction.closeParts(app, (UIModelElement)selection.getValue());
                        }
                    }
                    catch (Exception exc) {
                        Transactions.rollback((Transaction)trx);
                        DialogFactory.showExceptionDialog((String)String.format("Error ocured during deleting of '%s'", selection.getValue()), (Exception)exc, (Window)owner);
                        Transactions.close((Transaction)trx);
                    }
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        });
    }

    public static interface IClosePartsOnDeleteAction<T extends UIModelElement> {
        public void closeParts(MApplication var1, T var2);
    }

    public static interface IOnDeleteAction<T extends UIModelElement> {
        public boolean delete(Transaction var1, T var2) throws DAOOperationException;
    }
}

