/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.tools.controls;

import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.IkonHandler;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.javafx.IkonResolver;

public class FontIconPickerDialog
extends Dialog<ButtonType> {
    private final Property<Color> paintProperty = new SimpleObjectProperty((Object)Color.valueOf((String)"#004e86ff"));
    private final StringProperty uriProperty = new SimpleStringProperty();
    private final SimpleObjectProperty<Ikon> ikonProperty = new SimpleObjectProperty();

    public FontIconPickerDialog(Window owner) {
        this.initOwner(owner);
        this.setResizable(true);
        TabPane tabPane = new TabPane();
        tabPane.setPrefWidth(800.0);
        tabPane.setPrefHeight(600.0);
        VBox.setVgrow((Node)tabPane, (Priority)Priority.ALWAYS);
        IkonResolver.resolveServiceLoader().forEach(handler -> {
            if ("Ikonli".equals(handler.getFontFamily())) {
                return;
            }
            tabPane.getTabs().add((Object)this.createTab((IkonHandler)handler));
        });
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        ColorPicker colorPicker = new ColorPicker((Color)this.paintProperty.getValue());
        this.paintProperty.bind((ObservableValue)colorPicker.valueProperty());
        TextField uriField = new TextField();
        this.uriProperty.bindBidirectional((Property)uriField.textProperty());
        grid.addRow(0, new Node[]{new Label("Color"), colorPicker});
        grid.addRow(1, new Node[]{new Label("URI"), uriField});
        ColumnConstraints cc0 = new ColumnConstraints();
        cc0.setPrefWidth(120.0);
        ColumnConstraints cc1 = new ColumnConstraints();
        cc1.setHgrow(Priority.ALWAYS);
        grid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{cc0, cc1});
        VBox container = new VBox(5.0, new Node[]{tabPane, grid, new Separator()});
        this.getDialogPane().setContent((Node)container);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        this.getDialogPane().getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("fonticon-picker-dialog.css").toExternalForm());
        this.updateURI();
        this.paintProperty.addListener(o -> this.updateURI());
        this.ikonProperty.addListener(o -> this.updateURI());
    }

    private void updateURI() {
        String uriText;
        Ikon ikon = (Ikon)this.ikonProperty.get();
        if (ikon == null) {
            uriText = null;
        } else {
            Color c = (Color)this.paintProperty.getValue();
            String colorCode = String.format("#%02X%02X%02X", (int)(c.getRed() * 255.0), (int)(c.getGreen() * 255.0), (int)(c.getBlue() * 255.0));
            uriText = String.format("%s/%s/%s.%s?%s=%s", "icon:", "ikonli", ikon.getDescription(), "font", "color", colorCode);
        }
        this.uriProperty.set(uriText);
    }

    private Tab createTab(IkonHandler ikonHandler) {
        Tab tab = new Tab(ikonHandler.getFontFamily());
        FlowPane pane = new FlowPane(Orientation.HORIZONTAL, 5.0, 5.0);
        pane.setPadding(new Insets(10.0));
        pane.setMaxWidth(Double.MAX_VALUE);
        pane.setMaxHeight(Double.MAX_VALUE);
        ScrollPane scrollPane = new ScrollPane((Node)pane);
        pane.prefWrapLengthProperty().bind((ObservableValue)Bindings.max((ObservableNumberValue)new SimpleIntegerProperty(400), (ObservableNumberValue)Bindings.add((int)-40, (ObservableNumberValue)scrollPane.widthProperty())));
        Ikon[] ikonArray = ikonHandler.getIkons();
        int n = ikonArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ikon ikon = ikonArray[n2];
            FontIcon view = FontIcon.of((Ikon)ikon, (int)32, (Color)((Color)this.paintProperty.getValue()));
            this.paintProperty.addListener((o, ov, nv) -> view.setFill((Paint)nv));
            Button button = new Button(null, (Node)view);
            button.getStyleClass().add((Object)"font-picker-button");
            button.setOnAction(e -> this.ikonProperty.set((Object)ikon));
            pane.getChildren().add((Object)button);
            ++n2;
        }
        tab.setContent((Node)scrollPane);
        return tab;
    }
}

