/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.tools.controls;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ui.fx.binding.Bindings;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.LocalDateTimePropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.validator.Validators;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.stage.Window;
import jidefx.scene.control.validation.Validator;
import org.controlsfx.control.PropertySheet;

public class StructureObjectCopyMeasuredValuesDialog
extends Dialog<ButtonType> {
    private ObjectProperty<StructureClass> structureClass = new SimpleObjectProperty();
    private ObjectProperty<StructureObject> srcObject = new SimpleObjectProperty();
    private ObjectProperty<StructureObject> dstObject = new SimpleObjectProperty();
    private ObjectProperty<Instant> from = new SimpleObjectProperty();
    private ObjectProperty<Instant> to = new SimpleObjectProperty();
    private final ChoicePropertyItem<StructureObject> srcObjectItem;
    private final ChoicePropertyItem<StructureObject> dstObjectItem;

    public StructureObjectCopyMeasuredValuesDialog(Window window) {
        this.initOwner(window);
        this.setResizable(true);
        this.getDialogPane().setPrefSize(600.0, 400.0);
        ArrayList<StructureClass> classes = new ArrayList<StructureClass>();
        Transaction trx = Transactions.begin();
        try {
            classes.addAll(Arrays.asList(StructureClassDAO.getAll((Transaction)trx)));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        ChoicePropertyItem classItem = new ChoicePropertyItem("Structure Class", this.structureClass, classes);
        classItem.valueProperty().addListener(il -> this.updateObjectChoices((StructureClass)this.structureClass.get()));
        this.srcObjectItem = new ChoicePropertyItem("Src Object", this.srcObject, new ArrayList());
        this.srcObjectItem.setValidator(Validators.createNotEmptyValidator());
        this.dstObjectItem = new ChoicePropertyItem("Dst Object", this.dstObject, new ArrayList());
        this.dstObjectItem.setValidator(Validators.combine((Validator[])new Validator[]{Validators.createNotEmptyValidator(), Validators.createValidator((o, ov, nv) -> ov == null || nv == null || !ov.equals(nv), (String)"Source Object must differ from Destination Object")}));
        LocalDateTimePropertyItem fromItem = new LocalDateTimePropertyItem("From", (ObservableValue)Bindings.mapBidirectionalToLocalDateTime(this.from));
        LocalDateTimePropertyItem toItem = new LocalDateTimePropertyItem("To", (ObservableValue)Bindings.mapBidirectionalToLocalDateTime(this.to));
        fromItem.setValidator(Validators.combine((Validator[])new Validator[]{Validators.createNotEmptyValidator(), Validators.createValidator((o, ov, nv) -> this.from.get() == null || this.to.get() == null || ((Instant)this.from.get()).isBefore((Instant)this.to.get()), (String)"From must be before To")}));
        toItem.setValidator(Validators.createValidator((o, ov, nv) -> this.from.get() == null || this.to.get() == null || ((Instant)this.from.get()).isBefore((Instant)this.to.get()), (String)"From must be before To"));
        PropertySheet sheet = new PropertySheet();
        sheet.getItems().addAll((Object[])new PropertySheet.Item[]{classItem, this.srcObjectItem, this.dstObjectItem, fromItem, toItem});
        SimpleBooleanProperty hasChanges = new SimpleBooleanProperty();
        SimpleBooleanProperty hasErrors = new SimpleBooleanProperty();
        hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)sheet.getItems()));
        hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)sheet.getItems()));
        this.getDialogPane().setContent((Node)sheet);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL});
        Button applyButton = (Button)this.getDialogPane().lookupButton(ButtonType.APPLY);
        applyButton.disableProperty().bind((ObservableValue)hasErrors);
    }

    private void updateObjectChoices(StructureClass structureClass) {
        Transaction trx = Transactions.begin();
        try {
            Object[] objects = StructureClassDAO.getAllObjects((Transaction)trx, (StructureClass)structureClass);
            this.srcObjectItem.setChoicesArray(objects);
            this.dstObjectItem.setChoicesArray(objects);
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private final ObjectProperty<StructureObject> srcObjectProperty() {
        return this.srcObject;
    }

    public final StructureObject getSrcObject() {
        return (StructureObject)this.srcObjectProperty().get();
    }

    private final ObjectProperty<StructureObject> dstObjectProperty() {
        return this.dstObject;
    }

    public final StructureObject getDstObject() {
        return (StructureObject)this.dstObjectProperty().get();
    }

    private final ObjectProperty<Instant> fromProperty() {
        return this.from;
    }

    public final Instant getFrom() {
        return (Instant)this.fromProperty().get();
    }

    private final ObjectProperty<Instant> toProperty() {
        return this.to;
    }

    public final Instant getTo() {
        return (Instant)this.toProperty().get();
    }
}

