/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.tools.controls;

import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.engin.gui.Messages;
import de.elpro.ui.fx.propertysheet.LocalDateTimePropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.validator.Validators;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.stage.Window;
import jidefx.scene.control.validation.Validator;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.fx.core.ThreadSynchronize;

public class TimeRangeActionDialog
extends Dialog<ButtonType> {
    private ObjectProperty<LocalDateTime> from = new SimpleObjectProperty();
    private ObjectProperty<LocalDateTime> to = new SimpleObjectProperty();

    public TimeRangeActionDialog(Window owner, ThreadSynchronize sync, ITimeRangeFilter timeRangeFilter, TimeRangeFuntion function) {
        this.initOwner(owner);
        this.setTitle(Messages.tools_TimeRangeActionDialog_title);
        if (timeRangeFilter != null) {
            this.from.setValue((Object)LocalDateTime.ofInstant(timeRangeFilter.getFrom(), ZoneId.systemDefault()));
            this.to.setValue((Object)LocalDateTime.ofInstant(timeRangeFilter.getTo(), ZoneId.systemDefault()));
        }
        LocalDateTimePropertyItem fromItem = new LocalDateTimePropertyItem(Messages.tools_TimeRangeActionDialog_from, this.from);
        LocalDateTimePropertyItem toItem = new LocalDateTimePropertyItem(Messages.tools_TimeRangeActionDialog_to, this.to);
        fromItem.setValidator(Validators.combine((Validator[])new Validator[]{Validators.createNotEmptyValidator(), Validators.createValidator((o, ov, nv) -> this.getFrom() == null || this.getTo() == null || this.getFrom().isBefore(this.getTo()), (String)Messages.tools_TimeRangeActionDialog_from_to_error)}));
        toItem.setValidator(Validators.combine((Validator[])new Validator[]{Validators.createNotEmptyValidator(), Validators.createValidator((o, ov, nv) -> this.getFrom() == null || this.getTo() == null || this.getFrom().isBefore(this.getTo()), (String)"'From' must be before 'To'")}));
        PropertySheet sheet = new PropertySheet();
        sheet.getItems().addAll((Object[])new PropertySheet.Item[]{fromItem, toItem});
        sheet.setPrefWidth(400.0);
        sheet.setPrefHeight(210.0);
        this.getDialogPane().setContent((Node)sheet);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        SimpleBooleanProperty okDisabled = new SimpleBooleanProperty(false);
        this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)okDisabled, (ObservableBooleanValue)PropertyItemsHelper.createHasErrorsProperty((Collection)sheet.getItems())));
        this.setResultConverter(btn -> {
            if (btn != ButtonType.OK) {
                return btn;
            }
            ThreadSynchronize.BlockCondition condition = new ThreadSynchronize.BlockCondition();
            Button okButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
            ProgressIndicator indicator = new ProgressIndicator();
            indicator.setPrefSize(20.0, 20.0);
            okButton.setGraphic((Node)indicator);
            Button cancelButton = (Button)this.getDialogPane().lookupButton(ButtonType.CANCEL);
            cancelButton.setDisable(true);
            cancelButton.requestFocus();
            Runnable task = () -> {
                try {
                    ZonedDateTime from = this.getFrom().atZone(ZoneId.systemDefault());
                    ZonedDateTime to = this.getTo().atZone(ZoneId.systemDefault());
                    OperationResult result = function.call(from.toInstant(), to.toInstant());
                    if (result.getType() == ResultType.Success) {
                        Platform.runLater(() -> {
                            new SuccessMsgDialog(owner, result.getMessage()).showAndWait();
                            sync.asyncExec(() -> condition.release((Object)ButtonType.OK));
                        });
                    } else {
                        Platform.runLater(() -> {
                            Alert alert = new Alert(Alert.AlertType.ERROR);
                            alert.initOwner(owner);
                            alert.setContentText(result.getMessage());
                            alert.initOwner(owner);
                            alert.showAndWait();
                            sync.asyncExec(() -> condition.release((Object)ButtonType.CANCEL));
                        });
                    }
                }
                catch (Exception e) {
                    Platform.runLater(() -> {
                        ExceptionDialog excDlg = new ExceptionDialog((Throwable)e);
                        excDlg.initOwner(owner);
                        excDlg.show();
                        sync.asyncExec(() -> condition.release((Object)ButtonType.CANCEL));
                    });
                }
            };
            new Thread(task).start();
            return (ButtonType)sync.block(condition);
        });
    }

    public LocalDateTime getFrom() {
        return (LocalDateTime)this.from.get();
    }

    public LocalDateTime getTo() {
        return (LocalDateTime)this.to.get();
    }

    private static class SuccessMsgDialog
    extends Dialog<ButtonType> {
        public SuccessMsgDialog(Window owner, String msg) {
            this.initOwner(owner);
            this.setTitle(Messages.tools_TimeRangeActionDialog_success);
            TextArea text = new TextArea(msg);
            text.setEditable(false);
            text.setMaxHeight(Double.MAX_VALUE);
            text.setMaxWidth(Double.MAX_VALUE);
            ScrollPane pane = new ScrollPane((Node)text);
            pane.setPrefHeight(600.0);
            pane.setPrefWidth(800.0);
            this.setResizable(true);
            this.getDialogPane().setContent((Node)text);
            this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
        }
    }

    public static interface TimeRangeFuntion {
        public OperationResult call(Instant var1, Instant var2);
    }
}

