/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.tools.handlers.test;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.measurements.MeasurementsDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.client.variable.VariableRoleDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.GetValuesRequest;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.core.variable.value.VarInstanceMeasuredValuesMap;
import de.elpro.ewms.core.variable.value.VarInstanceValuesCollectionMap;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.TextInputDialog;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.di.annotations.Execute;

public class ImportExampleData {
    @Execute
    public void execute() throws DAOOperationException {
        TextInputDialog dialog = new TextInputDialog("Count");
        dialog.setTitle("Instances");
        dialog.setHeaderText("Instances");
        Optional result = dialog.showAndWait();
        if (!result.isPresent()) {
            return;
        }
        result.ifPresent(name -> System.out.println("Nodes count: " + name));
        Thread t = new Thread(() -> {
            VariableInstance[] instancesI;
            VariableInstance[] instancesU;
            int[] timeArray = new int[101];
            long totalGenerateMs = 0L;
            long totalImportMs = 0L;
            int counter = 0;
            Transaction trx = Transactions.begin();
            try {
                try {
                    Variable varU = VariableRoleDAO.getUniqueVariable((Transaction)trx, (String)"com.eos.guwplus.core.roles.variables.NX_U");
                    Variable varI = VariableRoleDAO.getUniqueVariable((Transaction)trx, (String)"com.eos.guwplus.core.roles.variables.NX_I");
                    instancesU = VariableInstanceDAO.getAll((Transaction)trx, (Variable)varU);
                    instancesI = VariableInstanceDAO.getAll((Transaction)trx, (Variable)varI);
                    VariableRoleDAO.getVariableInstance((Transaction)trx, (String)"com.eos.guwplus.core.roles.variables.NX_U", (String)"nd11");
                }
                catch (IllegalConfigException exc) {
                    ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                    dlg.show();
                    Transactions.close((Transaction)trx);
                    return;
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            Raster raster = Raster.Milli_200;
            long now = Instant.now().toEpochMilli();
            raster.getRasterBegin(now - Raster.Hour.toMilli() * 2L);
            raster.getRasterEnd(now);
            System.err.println("Init Done");
            long fromTs = raster.getRasterBegin(Instant.now().toEpochMilli() - Raster.Milli_200.toMilli());
            while (counter <= 3000000) {
                try {
                    int timeArrayIndex;
                    IVarValuesCollection[] resultValues;
                    Raster rasterStep = raster;
                    long startTs = Instant.now().toEpochMilli();
                    long toTs = raster.getRasterEnd(startTs);
                    if (fromTs == toTs) {
                        Thread.sleep(1L);
                        continue;
                    }
                    VarInstanceMeasuredValuesMap request = this.createMVAppendRequest(rasterStep, fromTs, toTs, instancesU, instancesI);
                    long ts = Instant.now().toEpochMilli();
                    totalGenerateMs += ts - startTs;
                    if (request instanceof VarInstanceMeasuredValuesMap) {
                        MeasurementsDAO.appendMeasuredValues((VarInstanceMeasuredValuesMap)request, (boolean)true);
                    } else {
                        MeasurementsDAO.appendMeasuredValues((VarInstanceValuesCollectionMap)((VarInstanceValuesCollectionMap)request), (boolean)true);
                    }
                    VarInstanceMeasuredValuesMap futureImportRequest = this.createMVAppendRequest(Raster.Second_10, toTs, toTs + Raster.Hour.toMilli() * 48L, instancesU, instancesI);
                    MeasurementsDAO.importPredictedMeasuredValues((VarInstanceMeasuredValuesMap)futureImportRequest);
                    GetValuesRequest readRequest = new GetValuesRequest(RawValuesViewType.RealtimeView, null, Long.valueOf(fromTs), Long.valueOf(toTs), ComplexRaster.of((Raster)raster));
                    Arrays.stream(instancesU).forEach(u -> readRequest.addInstance(u.getId().intValue()));
                    Arrays.stream(instancesI).forEach(i -> readRequest.addInstance(i.getId().intValue()));
                    IVarValuesCollection[] iVarValuesCollectionArray = resultValues = VariableInstanceDAO.getVarValues((GetValuesRequest)readRequest);
                    int n = resultValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVarValuesCollection collection = iVarValuesCollectionArray[n2];
                        for (IVarValue val : collection) {
                            if (val.isValid()) continue;
                            System.err.println("Error: " + val);
                        }
                        ++n2;
                    }
                    VariableInstanceDAO.getDVals((GetValuesRequest)readRequest);
                    long endTs = Instant.now().toEpochMilli();
                    long execTime = endTs - ts;
                    totalImportMs += execTime;
                    fromTs = raster.getRasterBegin(Math.max(toTs, endTs - Raster.Milli_500.toMilli()));
                    int n3 = timeArrayIndex = Math.min((int)(execTime / 2L), timeArray.length - 1);
                    timeArray[n3] = timeArray[n3] + 1;
                    long sleepMs = raster.getRasterEnd(endTs) - endTs;
                    if (sleepMs == 0L) {
                        sleepMs = 1L;
                    }
                    if (++counter % 20 == 0) {
                        StringBuilder text = new StringBuilder("\r\n");
                        text.append(String.format("Avg execution Time: %dms. Avg generate Time: %dms\r\n", (int)(totalImportMs / (long)counter), (int)(totalGenerateMs / (long)counter)));
                        text.append(String.format("Timespread for %d iterations:\r\n", counter));
                        int contentLength = timeArray.length;
                        int i2 = timeArray.length - 1;
                        while (i2 >= 0) {
                            if (timeArray[i2] != 0) break;
                            --contentLength;
                            --i2;
                        }
                        i2 = 0;
                        while (i2 < contentLength) {
                            if (i2 < 100) {
                                text.append(String.format("\t%dms", (i2 + 1) * 2));
                            } else {
                                text.append("\t> 200ms");
                            }
                            ++i2;
                        }
                        text.append("\r\n");
                        i2 = 0;
                        while (i2 < contentLength) {
                            text.append(String.format("\t%d", timeArray[i2]));
                            ++i2;
                        }
                        System.out.println(text);
                    }
                    Thread.sleep(sleepMs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Platform.runLater(() -> {
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setContentText("Done");
                alert.showAndWait();
            });
        });
        t.start();
    }

    private VarInstanceMeasuredValuesMap createMVAppendRequest(Raster stepRaster, long from, long to, VariableInstance[] instancesU, VariableInstance[] instancesI) throws DAOOperationException, InterruptedException {
        VarInstanceMeasuredValuesMap request = new VarInstanceMeasuredValuesMap();
        int i = 0;
        while (i < instancesU.length) {
            MeasuredValue mv;
            double mvVal;
            double angle;
            long endTs;
            IVarValuesCollection values;
            VariableInstance instanceU = instancesU[i];
            VariableInstance instanceI = instancesI[i];
            long step = stepRaster.toMilli();
            Throwable throwable = null;
            Object var15_14 = null;
            try {
                values = new IVarValuesCollection();
                try {
                    double valU = 220.0;
                    endTs = from + step;
                    while (endTs <= to) {
                        angle = (double)(i * 30) + (double)(endTs % (Raster.Minute_1.toMilli() * 10L)) * 360.0 / (double)(Raster.Minute_1.toMilli() * 10L);
                        mvVal = valU + Math.sin(angle * Math.PI / 180.0) * 10.0 + Math.random() - 0.5;
                        mv = new MeasuredValue(endTs - step, endTs, mvVal, 1.0);
                        values.add((IVarValue)mv);
                        endTs += step;
                    }
                    values.close();
                    request.put(instanceU, (MeasuredValue[])values.stream().toArray(MeasuredValue[]::new));
                }
                finally {
                    if (values != null) {
                        values.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var15_14 = null;
            try {
                values = new IVarValuesCollection();
                try {
                    double valI = 300.0;
                    endTs = from + step;
                    while (endTs <= to) {
                        angle = (double)(i * 23) + (double)(endTs % (Raster.Minute_1.toMilli() * 27L)) * 360.0 / (double)(Raster.Minute_1.toMilli() * 27L);
                        mvVal = valI + Math.sin(angle * Math.PI / 180.0) * 50.0 + Math.random() - 0.5;
                        mv = new MeasuredValue(endTs - step, endTs, mvVal, 1.0);
                        values.add((IVarValue)mv);
                        endTs += step;
                    }
                    values.close();
                    request.put(instanceI, (MeasuredValue[])values.stream().toArray(MeasuredValue[]::new));
                }
                finally {
                    if (values != null) {
                        values.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            ++i;
        }
        return request;
    }

    private VarInstanceValuesCollectionMap createVCAppendRequest(Raster stepRaster, long from, long to, VariableInstance[] instancesU, VariableInstance[] instancesI) {
        VarInstanceValuesCollectionMap request = new VarInstanceValuesCollectionMap();
        int i = 0;
        while (i < instancesU.length) {
            MeasuredValue mv;
            double mvVal;
            double angle;
            long endTs;
            IVarValuesCollection values;
            VariableInstance instanceU = instancesU[i];
            VariableInstance instanceI = instancesI[i];
            long step = stepRaster.toMilli();
            Throwable throwable = null;
            Object var15_14 = null;
            try {
                values = new IVarValuesCollection();
                try {
                    double valU = 220.0;
                    endTs = from + step;
                    while (endTs <= to) {
                        angle = (double)(i * 30) + (double)(endTs % (Raster.Minute_1.toMilli() * 10L)) * 360.0 / (double)(Raster.Minute_1.toMilli() * 10L);
                        mvVal = valU + Math.sin(angle * Math.PI / 180.0) * 10.0 + Math.random() - 0.5;
                        mv = new MeasuredValue(endTs - step, endTs, mvVal, 1.0);
                        values.add((IVarValue)mv);
                        endTs += step;
                    }
                    request.put(instanceU, values);
                }
                finally {
                    if (values != null) {
                        values.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var15_14 = null;
            try {
                values = new IVarValuesCollection();
                try {
                    double valI = 300.0;
                    endTs = from + step;
                    while (endTs <= to) {
                        angle = (double)(i * 23) + (double)(endTs % (Raster.Minute_1.toMilli() * 27L)) * 360.0 / (double)(Raster.Minute_1.toMilli() * 27L);
                        mvVal = valI + Math.sin(angle * Math.PI / 180.0) * 50.0 + Math.random() - 0.5;
                        mv = new MeasuredValue(endTs - step, endTs, mvVal, 1.0);
                        values.add((IVarValue)mv);
                        endTs += step;
                    }
                    request.put(instanceI, values);
                }
                finally {
                    if (values != null) {
                        values.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            ++i;
        }
        return request;
    }
}

