/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.tools.validators;

import de.elpro.ewms.core.lang.LogicalAnalyzer;
import de.elpro.ewms.core.lang.model.AnalysisError;
import java.util.List;
import jidefx.scene.control.validation.ValidationEvent;
import jidefx.scene.control.validation.Validator;

public class ValidatorUtils {
    public static final Validator VAR_NAME_TOKEN_VALIDATOR = vo -> {
        Object value = vo.getNewValue();
        if (!(value instanceof String)) {
            return new ValidationEvent(ValidationEvent.VALIDATION_ERROR, 0, "Token not of String type");
        }
        String token = (String)value;
        List errors = LogicalAnalyzer.checkVarNameToken((String)token);
        if (errors != null && !errors.isEmpty()) {
            return new ValidationEvent(ValidationEvent.VALIDATION_ERROR, 0, ((AnalysisError)errors.get(0)).getMessage());
        }
        return ValidationEvent.OK;
    };
    public static final Validator UNIT_KEY_VALIDATOR = vo -> {
        Object value = vo.getNewValue();
        if (value == null) {
            return new ValidationEvent(ValidationEvent.VALIDATION_ERROR, 0, "Unit key should be not empty.");
        }
        if (!(value instanceof String)) {
            return new ValidationEvent(ValidationEvent.VALIDATION_ERROR, 0, "Unit key not of String type.");
        }
        String token = (String)value;
        if (token.isBlank()) {
            return new ValidationEvent(ValidationEvent.VALIDATION_ERROR, 0, "Unit key should be not empty.");
        }
        int i = 0;
        while (i < LogicalAnalyzer.SPECIAL_CHARS.length) {
            if (token.indexOf(LogicalAnalyzer.SPECIAL_CHARS[i]) >= 0) {
                return new ValidationEvent(ValidationEvent.VALIDATION_ERROR, 0, (Object)"Unit key should not contain none of special characters: %s", new String(LogicalAnalyzer.SPECIAL_CHARS));
            }
            ++i;
        }
        return ValidationEvent.OK;
    };
}

