/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.login;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.locale.LocaleDefinitionDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.locale.LocaleDefinition;
import de.elpro.ewms.gui.model.ILifeCycleHook;
import de.elpro.ui.text.LocaleDescriptor;
import de.elpro.ui.text.LocaleDescriptors;
import de.elpro.ui.text.LocaleText;
import java.util.Locale;
import javafx.application.Platform;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.component.annotations.Component;

@Component
public class InitLocalesHook
implements ILifeCycleHook {
    @Inject
    private IEventBroker eventBroker;

    public int getPriority() {
        return -1000;
    }

    public String getJobName() {
        return "Init Locales";
    }

    public ILifeCycleHook.HookResult hook(IEclipseContext context, Stage loaderStage) throws Exception {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Transaction trx = Transactions.begin();){
                LocaleDescriptor[] descrs;
                LocaleDescriptor fallbackLocaleDescriptor;
                LocaleDefinition[] fallbackLocales = LocaleDefinitionDAO.getFallbackLocales((Transaction)trx);
                if (fallbackLocales.length > 0 && (fallbackLocaleDescriptor = fallbackLocales[0].toDescriptor()) != null) {
                    LocaleText.setFallbackLocale((Locale)fallbackLocaleDescriptor.getLocale());
                }
                if ((descrs = LocaleDefinitionDAO.getDescriptors((Transaction)trx)) != null && descrs.length > 0) {
                    LocaleDescriptors.init((LocaleDescriptor[])descrs);
                } else {
                    LocaleDescriptors.init((LocaleDescriptor[])new LocaleDescriptor[]{new LocaleDescriptor(Locale.getDefault(), null, Locale.getDefault().toString())});
                }
                Locale bestMatch = null;
                if (descrs.length > 0) {
                    LocaleDescriptor[] localeDescriptorArray = descrs;
                    int n = descrs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LocaleDescriptor ld = localeDescriptorArray[n2];
                        Locale candidate = ld.getLocale();
                        if (ld.getLocale().equals(Locale.getDefault())) {
                            return CONTINUE;
                        }
                        if (Locale.getDefault().toString().startsWith(candidate.toString()) && (bestMatch == null || bestMatch.toString().length() < candidate.toString().length())) {
                            bestMatch = candidate;
                        }
                        ++n2;
                    }
                    if (bestMatch == null) {
                        bestMatch = descrs[0].getLocale();
                    }
                    Locale.setDefault(bestMatch);
                    context.set("org.eclipse.e4.core.locale", (Object)bestMatch);
                    this.eventBroker.post("org/eclipse/e4/core/NLS/LOCALE_CHANGE", (Object)bestMatch);
                }
                return CONTINUE;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exc) {
            Platform.runLater(() -> {
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.show();
            });
            return SHUTDOWN;
        }
    }
}

