/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.login;

import de.elpro.ewms.gui.lifecycle.SplashScreen;
import de.elpro.ewms.gui.login.LoginUI;
import de.elpro.ewms.gui.model.ILifeCycleHook;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.stage.Stage;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.fx.core.ThreadSynchronize;
import org.osgi.service.component.annotations.Component;

@Component
public class LoginHook
implements ILifeCycleHook {
    public int getPriority() {
        return 0;
    }

    public String getJobName() {
        return "Login";
    }

    public ILifeCycleHook.HookResult hook(IEclipseContext context, Stage stage) {
        ThreadSynchronize uiSync = (ThreadSynchronize)context.get(ThreadSynchronize.class);
        SplashScreen sScreen = (SplashScreen)stage;
        FutureTask<ILifeCycleHook.HookResult> task = new FutureTask<ILifeCycleHook.HookResult>(() -> {
            LoginUI newLoginPane = new LoginUI(sScreen.getStatusBarText(), () -> stage.close());
            ContextInjectionFactory.inject((Object)((Object)newLoginPane), (IEclipseContext)context);
            sScreen.getStackPane().getChildren().add((Object)newLoginPane);
            newLoginPane.clearPersisedStateProperty().addListener((o, ov, nv) -> {
                if (nv != null) {
                    context.set("clearPersistedState", nv);
                }
            });
            sScreen.show();
            newLoginPane.requestFocus();
            return (ILifeCycleHook.HookResult)uiSync.block(newLoginPane.getLoginBlock());
        });
        Platform.runLater(task);
        try {
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return SHUTDOWN;
        }
    }
}

