/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.login;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.component.ClientInfo;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.gui.login.Messages;
import de.elpro.ewms.gui.login.controllers.LoginController;
import de.elpro.ewms.gui.model.ILifeCycleHook;
import de.elpro.java.common.utils.JavaSystemUtils;
import de.elpro.ui.fx.controls.NumericField;
import de.elpro.ui.fx.controls.UIControlUtils;
import de.elpro.ui.fx.dialog.utils.AlertDialogUtils;
import de.elpro.ui.fx.utils.ColorUtils;
import de.elpro.ui.fx.utils.TransitionUtils;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.net.InetUtils;
import java.text.DecimalFormat;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.Separator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;
import javax.inject.Inject;
import jidefx.scene.control.validation.ValidationEvent;
import jidefx.scene.control.validation.ValidationGroup;
import jidefx.scene.control.validation.ValidationMode;
import jidefx.scene.control.validation.ValidationUtils;
import jidefx.scene.control.validation.Validator;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.ui.services.restart.LifecycleRV;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.dashicons.Dashicons;
import org.kordamp.ikonli.javafx.FontIcon;
import org.osgi.framework.FrameworkUtil;

public class LoginUI
extends StackPane {
    private static final String COPY_RIGHTS_MSG = "\u00a9 2023 Elpro GmbH. All rights reserved.";
    private static final String EOS_SPLASH_PATH = "css/images/eos_background.svg";
    private static final String EOS_SPLASH_LINES_PATH = "css/images/eos_lines.png";
    private final Tab settingsTab = LoginUI.createTab(Messages.loginpane_settings_tab_lbl, false);
    private final Tab loginTab = LoginUI.createTab(Messages.loginpane_login_tab_lbl, false);
    private final Tab registrationTab = LoginUI.createTab(Messages.loginpane_register_tab_lbl, false);
    private final TabPane tabPane = new TabPane(new Tab[]{this.settingsTab, this.loginTab});
    private Hyperlink createAccHyperlink;
    private final BooleanProperty applyBtnDisabled = new SimpleBooleanProperty();
    private final ThreadSynchronize.BlockCondition<ILifeCycleHook.HookResult> loginBlock = new ThreadSynchronize.BlockCondition();
    @Inject
    private ThreadSynchronize uiSync;
    @Inject
    private ClientInfo clientInfo;
    private Runnable onCloseRequest;
    private final BooleanProperty clearPersistedState = new SimpleBooleanProperty();
    private final BooleanProperty submitBooleanProp = new SimpleBooleanProperty(false);
    private final StringProperty userName = new SimpleStringProperty();
    private final StringProperty password = new SimpleStringProperty();
    private final User registrationUser = new User();
    private final LoginController loginControl = new LoginController();

    public LoginUI(StringProperty statusBarText, Runnable onCloseRequest) {
        this.onCloseRequest = onCloseRequest;
        this.userName.set((Object)this.loginControl.getConnDef().getLogin());
        this.password.set((Object)this.loginControl.getConnDef().getPassword());
        this.initLoginUI();
        this.createContent(statusBarText);
        this.getStylesheets().add((Object)LoginUI.class.getResource("default.css").toExternalForm());
    }

    private void initLoginUI() {
        this.settingsTab.setContent((Node)this.createSettingContents());
        this.loginTab.setContent((Node)this.createLoginContents());
        this.tabPane.setPrefWidth(350.0);
        this.tabPane.setSide(Side.BOTTOM);
        this.tabPane.setBackground(ColorUtils.getBackGround((Color)ColorUtils.getWhiteTranspColor((double)0.6)));
        this.registrationUser.setDomain(InetUtils.getDomainName());
        this.registrationUser.setLogin(JavaSystemUtils.getUserName());
        this.setTabSelection();
    }

    private void createContent(StringProperty statusBarText) {
        ImageView eosSplash = UIControlUtils.getImageView(((Object)((Object)this)).getClass(), (String)EOS_SPLASH_PATH);
        eosSplash.setTranslateX(180.0);
        eosSplash.setTranslateY(100.0);
        eosSplash.setScaleX(1.5);
        eosSplash.setScaleY(1.5);
        ImageView eosSplashLines = UIControlUtils.getImageView(((Object)((Object)this)).getClass(), (String)EOS_SPLASH_LINES_PATH);
        Button closeBtn = new Button(null, (Node)FontIcon.of((Ikon)Dashicons.NO_ALT, (int)16, (Color)new Color(0.9411764705882353, 0.9411764705882353, 0.9411764705882353, 0.9)));
        closeBtn.getStyleClass().add((Object)"close-btn");
        closeBtn.setBackground(ColorUtils.getBackGround((Color)ColorUtils.getWhiteTranspColor((double)0.0)));
        closeBtn.setOnAction(e -> this.shutdownApplication());
        closeBtn.setDefaultButton(false);
        StackPane.setAlignment((Node)closeBtn, (Pos)Pos.TOP_RIGHT);
        Label statusBarTextLabel = new Label();
        statusBarTextLabel.textProperty().bind((ObservableValue)statusBarText);
        statusBarTextLabel.setStyle(this.getWhiteColorStyle(12));
        HBox.setHgrow((Node)statusBarTextLabel, (Priority)Priority.ALWAYS);
        statusBarTextLabel.setMaxWidth(Double.MAX_VALUE);
        Label copyRightsLbl = new Label();
        copyRightsLbl.setStyle(this.getWhiteColorStyle(10));
        copyRightsLbl.setText(COPY_RIGHTS_MSG);
        VBox infoPane = new VBox(5.0, new Node[]{statusBarTextLabel, copyRightsLbl});
        infoPane.setAlignment(Pos.BOTTOM_LEFT);
        infoPane.setPadding(new Insets(0.0, 0.0, 5.0, 5.0));
        StackPane.setAlignment((Node)infoPane, (Pos)Pos.BOTTOM_LEFT);
        Label versionLabel = new Label();
        versionLabel.setStyle(this.getWhiteColorStyle(10));
        versionLabel.setText(String.format("Runtime Version: %s, Build Version: %s", System.getProperty("java.version"), FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getVersion()));
        VBox versionPane = new VBox(5.0, new Node[]{versionLabel});
        versionPane.setAlignment(Pos.BOTTOM_RIGHT);
        versionPane.setPadding(new Insets(0.0, 5.0, 5.0, 0.0));
        StackPane.setAlignment((Node)versionPane, (Pos)Pos.BOTTOM_RIGHT);
        HBox inputPane = new HBox();
        inputPane.setAlignment(Pos.BOTTOM_RIGHT);
        inputPane.setVisible(false);
        inputPane.getChildren().addAll((Object[])new Node[]{this.tabPane});
        StackPane.setAlignment((Node)inputPane, (Pos)Pos.BOTTOM_RIGHT);
        TransitionUtils.playTimeline((Node)inputPane, (int)1, (int)1);
        TranslateTransition translate = TransitionUtils.getSetByXTranslateTransition((Node)eosSplash, (int)1, (int)1, (int)-180, (int)-100);
        ScaleTransition wavesTrans = TransitionUtils.getScaleTransition((Node)eosSplash, (int)1, (int)1, (double)1.0, (double)1.0);
        FadeTransition fadeSplashLinesPaneTrans = TransitionUtils.getFadeTransition((Node)eosSplashLines, (double)0.0, (double)1.0, (int)2, (int)1);
        FadeTransition fadeInputPaneTrans = TransitionUtils.getFadeTransition((Node)inputPane, (double)0.0, (double)1.0, (int)2, (int)1);
        FadeTransition fadeVersionPaneTrans = TransitionUtils.getFadeTransition((Node)versionPane, (double)1.0, (double)0.0, (int)2, (int)1);
        ParallelTransition paraTran = new ParallelTransition(new Animation[]{translate, wavesTrans, fadeSplashLinesPaneTrans, fadeInputPaneTrans, fadeVersionPaneTrans});
        paraTran.play();
        this.getChildren().addAll((Object[])new Node[]{eosSplash, eosSplashLines, infoPane, versionPane, inputPane, closeBtn});
    }

    private GridPane createSettingContents() {
        Label serverSetLbl = new Label(Messages.loginpane_connectionsettings_lbl);
        serverSetLbl.setStyle(this.getFontStyle(12));
        Separator hSepServerSet = new Separator(Orientation.HORIZONTAL);
        Label serverURLLbl = new Label(Messages.loginpane_server_settings_server_url);
        serverURLLbl.setStyle(this.getFontStyle(10));
        TextField serverInfoTxt = new TextField();
        serverInfoTxt.setPromptText(Messages.login_LoginDialog_Server);
        GridPane.setHgrow((Node)serverInfoTxt, (Priority)Priority.ALWAYS);
        String hostName = this.loginControl.getConnDef().getHostName();
        serverInfoTxt.setText(hostName == null ? null : hostName);
        serverInfoTxt.textProperty().bindBidirectional(this.loginControl.getConnDef().hostNameProperty());
        ValidationUtils.install((Node)serverInfoTxt, (Validator)Validators.createNotEmptyValidator((String)Messages.loginpane_server_settings_serverinfo_empty_msg));
        Label portNoLbl = new Label(Messages.loginpane_server_settings_portno);
        portNoLbl.setStyle(this.getFontStyle(10));
        NumericField portNoTxt = new NumericField(Integer.class, new DecimalFormat("#####0"));
        portNoTxt.setPositiveOnly(true);
        portNoTxt.setPromptText(Messages.loginpane_server_settings_portno_msg);
        portNoTxt.setText(Integer.toString(this.loginControl.getConnDef().getPort()));
        GridPane.setHgrow((Node)portNoTxt, (Priority)Priority.ALWAYS);
        portNoTxt.valueProperty().addListener((o, ov, nv) -> this.loginControl.getConnDef().portProperty().setValue((Object)(nv != null ? (Number)((Number)nv) : (Number)443)));
        ValidationUtils.install((Node)portNoTxt, (Validator)Validators.createNotEmptyValidator((String)Messages.loginpane_server_settings_portinfo_empty_msg));
        ValidationGroup applyValidGrp = new ValidationGroup(new Node[]{serverInfoTxt, portNoTxt});
        Button applyBtn = new Button(Messages.loginpane_server_settings_apply);
        HBox.setHgrow((Node)applyBtn, (Priority)Priority.ALWAYS);
        applyBtn.disableProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)applyValidGrp.invalidProperty(), (ObservableBooleanValue)this.applyBtnDisabled));
        applyBtn.defaultButtonProperty().bind((ObservableValue)this.settingsTab.selectedProperty());
        applyBtn.setOnAction(e -> this.applyServerInfo());
        HBox buttonsPane = new HBox();
        buttonsPane.setAlignment(Pos.BOTTOM_RIGHT);
        buttonsPane.getChildren().add((Object)applyBtn);
        Label userIntSetLbl = new Label(Messages.loginpane_userInterfaceSettings_lbl);
        userIntSetLbl.setStyle(this.getFontStyle(12));
        Separator hSepUserIntSet = new Separator(Orientation.HORIZONTAL);
        Label resetLbl = new Label(Messages.loginpane_userInterface_reset_lbl);
        resetLbl.setStyle(this.getFontStyle(10));
        CheckBox resetUIBtn = new CheckBox("");
        resetUIBtn.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        resetUIBtn.setOnAction(e -> this.resetUISettings(resetUIBtn.selectedProperty()));
        resetUIBtn.setStyle(this.getWhiteColorStyle(12));
        GridPane grid = this.createGridPane(Pos.BOTTOM_CENTER, Color.TRANSPARENT);
        grid.setPadding(new Insets(10.0));
        grid.add((Node)serverSetLbl, 0, 0, 3, 1);
        grid.add((Node)hSepServerSet, 0, 1, 3, 1);
        grid.add((Node)serverURLLbl, 1, 2);
        grid.add((Node)serverInfoTxt, 2, 2);
        grid.add((Node)portNoLbl, 1, 3);
        grid.add((Node)portNoTxt, 2, 3);
        grid.add((Node)userIntSetLbl, 0, 4, 3, 1);
        grid.add((Node)hSepUserIntSet, 0, 5, 3, 1);
        grid.add((Node)resetLbl, 1, 6);
        grid.add((Node)resetUIBtn, 2, 6);
        grid.add((Node)buttonsPane, 0, 7, 3, 1);
        return grid;
    }

    private GridPane createLoginContents() {
        Label userNameLbl = new Label(Messages.loginpane_logindata_username);
        userNameLbl.setStyle(this.getFontStyle(10));
        TextField userNameTxt = new TextField();
        userNameTxt.requestFocus();
        userNameTxt.textProperty().bindBidirectional((Property)this.userName);
        userNameTxt.setPromptText(Messages.loginpane_logindata_username_msg);
        GridPane.setHgrow((Node)userNameTxt, (Priority)Priority.ALWAYS);
        Label pwdLbl = new Label(Messages.loginpane_logindata_pwd);
        pwdLbl.setStyle(this.getFontStyle(10));
        PasswordField pwdTxt = new PasswordField();
        pwdTxt.setText("");
        pwdTxt.textProperty().bindBidirectional((Property)this.password);
        pwdTxt.setPromptText(Messages.login_LoginDialog_Password);
        pwdTxt.setText(this.loginControl.getConnDef().getPassword());
        GridPane.setHgrow((Node)pwdTxt, (Priority)Priority.ALWAYS);
        CheckBox saveChkBtn = new CheckBox(Messages.login_LoginDialog_save);
        Tooltip saveTooltip = new Tooltip();
        saveTooltip.setText(Messages.login_LoginDialog_save);
        saveChkBtn.setTooltip(saveTooltip);
        saveChkBtn.selectedProperty().bindBidirectional(this.loginControl.getConnDef().savePasswordProperty());
        this.createAccHyperlink = new Hyperlink(Messages.loginpane_logindata_create_account);
        this.createAccHyperlink.setTextFill((Paint)Color.DARKBLUE);
        this.createAccHyperlink.setStyle("-fx-font-weight: bold;");
        this.createAccHyperlink.getStyleClass().add((Object)"link-create-account");
        this.createAccHyperlink.setOnAction(e -> this.showRegsTab());
        Button loginBtn = new Button(Messages.login_LoginDialog_login);
        loginBtn.defaultButtonProperty().bind((ObservableValue)this.loginTab.selectedProperty());
        HBox.setHgrow((Node)loginBtn, (Priority)Priority.ALWAYS);
        loginBtn.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableStringValue)this.userName));
        loginBtn.setOnAction(e -> this.handleLogin());
        HBox hb = new HBox();
        hb.setAlignment(Pos.BOTTOM_RIGHT);
        hb.setSpacing(10.0);
        hb.getChildren().addAll((Object[])new Node[]{this.createAccHyperlink, loginBtn});
        GridPane grid = this.createGridPane(Pos.BOTTOM_CENTER, Color.TRANSPARENT);
        grid.setPadding(new Insets(10.0));
        int row = 0;
        grid.addRow(row++, new Node[]{userNameLbl, userNameTxt});
        grid.addRow(row++, new Node[]{pwdLbl, pwdTxt});
        grid.add((Node)saveChkBtn, 1, row++);
        grid.add((Node)hb, 1, row++, 1, 1);
        userNameTxt.textProperty().addListener((o, ov, nv) -> {
            pwdTxt.setText(null);
            boolean domainNotEmpty = false;
            if (nv != null) {
                User user = LoginController.parseUserCredentials(nv);
                boolean bl = domainNotEmpty = user != null && user.getDomain() != null && !user.getDomain().isBlank();
            }
            if (domainNotEmpty) {
                saveChkBtn.setSelected(false);
                saveChkBtn.setDisable(true);
            } else {
                saveChkBtn.setDisable(false);
            }
        });
        boolean domainNotEmpty = false;
        if (this.userName.get() != null) {
            User user = LoginController.parseUserCredentials((String)this.userName.get());
            boolean bl = domainNotEmpty = user != null && user.getDomain() != null && !user.getDomain().isBlank();
        }
        if (domainNotEmpty) {
            saveChkBtn.setSelected(false);
            saveChkBtn.setDisable(true);
        }
        return grid;
    }

    private GridPane createRegistrationContents() {
        Label domainLbl = new Label(Messages.loginpane_createuser_domain);
        domainLbl.setStyle(this.getFontStyle(10));
        TextField domainTxt = new TextField();
        domainTxt.setPromptText(Messages.loginpane_createuser_domain_msg);
        domainTxt.textProperty().bindBidirectional((Property)this.registrationUser.domainProperty());
        Label userNameLbl = new Label(Messages.loginpane_createuser_username);
        userNameLbl.setStyle(this.getFontStyle(10));
        TextField userNameTxt = new TextField();
        userNameTxt.setPromptText(Messages.loginpane_createuser_username_msg);
        userNameTxt.textProperty().bindBidirectional((Property)this.registrationUser.loginProperty());
        GridPane.setHgrow((Node)userNameTxt, (Priority)Priority.ALWAYS);
        ValidationUtils.install((Node)userNameTxt, (Validator)Validators.createNotEmptyValidator((String)Messages.login_RegistrationDialog_Enter_login));
        Label firstNameLbl = new Label(Messages.loginpane_createuser_firstname);
        firstNameLbl.setStyle(this.getFontStyle(10));
        TextField firstNameTxt = new TextField();
        firstNameTxt.setPromptText(Messages.loginpane_createuser_firstname_msg);
        firstNameTxt.textProperty().bindBidirectional((Property)this.registrationUser.firstNameProperty());
        GridPane.setHgrow((Node)firstNameTxt, (Priority)Priority.ALWAYS);
        Label lastNameLbl = new Label(Messages.loginpane_createuser_lastname);
        lastNameLbl.setStyle(this.getFontStyle(10));
        TextField lastNameTxt = new TextField();
        lastNameTxt.setPromptText(Messages.loginpane_createuser_lastname_msg);
        lastNameTxt.textProperty().bindBidirectional((Property)this.registrationUser.lastNameProperty());
        GridPane.setHgrow((Node)lastNameTxt, (Priority)Priority.ALWAYS);
        Label eMailLbl = new Label(Messages.loginpane_createuser_email);
        eMailLbl.setStyle(this.getFontStyle(10));
        TextField eMailTxt = new TextField();
        eMailTxt.setPromptText(Messages.loginpane_createuser_email_msg);
        eMailTxt.textProperty().bindBidirectional((Property)this.registrationUser.emailProperty());
        GridPane.setHgrow((Node)eMailTxt, (Priority)Priority.ALWAYS);
        ValidationUtils.install((Node)eMailTxt, (Validator)Validators.combine((Validator[])new Validator[]{Validators.createEmailValidator((String)Messages.login_createuser_invalid_email), Validators.createNotEmptyValidator((String)Messages.login_createuser_empty_email, (EventType)ValidationEvent.VALIDATION_WARNING)}));
        Label pwdLbl = new Label(Messages.loginpane_createuser_pwd);
        pwdLbl.setStyle(this.getFontStyle(10));
        PasswordField pwdTxt = new PasswordField();
        pwdTxt.setText("");
        pwdTxt.setPromptText(Messages.loginpane_createuser_pwd_msg);
        GridPane.setHgrow((Node)pwdTxt, (Priority)Priority.ALWAYS);
        Label pwdConfLbl = new Label(Messages.loginpane_createuser_pwdconf);
        pwdConfLbl.setStyle(this.getFontStyle(10));
        PasswordField pwdConfTxt = new PasswordField();
        pwdConfTxt.setText("");
        pwdConfTxt.setPromptText(Messages.loginpane_createuser_pwdconf_msg);
        GridPane.setHgrow((Node)pwdConfTxt, (Priority)Priority.ALWAYS);
        this.validatePwdEquals(pwdTxt, pwdConfTxt);
        pwdTxt.textProperty().addListener(il -> ValidationUtils.forceValidate((Node)pwdConfTxt, (ValidationMode)ValidationMode.ON_FLY));
        pwdConfTxt.textProperty().addListener(il -> ValidationUtils.forceValidate((Node)pwdTxt, (ValidationMode)ValidationMode.ON_FLY));
        Button submitBtn = new Button(Messages.loginpane_createuser_submit);
        submitBtn.defaultButtonProperty().bind((ObservableValue)this.registrationTab.selectedProperty());
        HBox.setHgrow((Node)submitBtn, (Priority)Priority.ALWAYS);
        Button cancelBtn = new Button(Messages.loginpane_createuser_cancel);
        cancelBtn.setOnAction(e -> this.cancelRegOrServerSet(cancelBtn.getText()));
        HBox.setHgrow((Node)cancelBtn, (Priority)Priority.ALWAYS);
        HBox hb = new HBox();
        hb.setSpacing(10.0);
        hb.setAlignment(Pos.BOTTOM_RIGHT);
        hb.getChildren().addAll((Object[])new Node[]{submitBtn, cancelBtn});
        GridPane grid = this.createGridPane(Pos.BOTTOM_CENTER, Color.TRANSPARENT);
        grid.setPadding(new Insets(10.0));
        submitBtn.setOnAction(e -> this.submitRegistrationInfo(pwdTxt.getText()));
        int row = 0;
        grid.addRow(row++, new Node[]{domainLbl, domainTxt});
        grid.addRow(row++, new Node[]{userNameLbl, userNameTxt});
        grid.addRow(row++, new Node[]{firstNameLbl, firstNameTxt});
        grid.addRow(row++, new Node[]{lastNameLbl, lastNameTxt});
        grid.addRow(row++, new Node[]{eMailLbl, eMailTxt});
        grid.addRow(row++, new Node[]{pwdLbl, pwdTxt});
        grid.addRow(row++, new Node[]{pwdConfLbl, pwdConfTxt});
        grid.add((Node)hb, 0, row++, 2, 1);
        ValidationGroup submitValidGrp = new ValidationGroup(new Node[]{userNameTxt, eMailTxt, pwdTxt, pwdConfTxt});
        submitBtn.disableProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)submitValidGrp.invalidProperty(), (ObservableBooleanValue)this.submitBooleanProp));
        cancelBtn.disableProperty().bind((ObservableValue)this.submitBooleanProp);
        ValidationUtils.forceValidate((Node)userNameTxt, (ValidationMode)ValidationMode.ON_FLY);
        ValidationUtils.forceValidate((Node)eMailTxt, (ValidationMode)ValidationMode.ON_FLY);
        ValidationUtils.forceValidate((Node)pwdTxt, (ValidationMode)ValidationMode.ON_FLY);
        ValidationUtils.forceValidate((Node)pwdConfTxt, (ValidationMode)ValidationMode.ON_FLY);
        domainTxt.textProperty().addListener((o, ov, nv) -> {
            boolean domainNotEmpty = nv != null && !nv.isBlank();
            pwdTxt.setDisable(domainNotEmpty);
            pwdConfTxt.setDisable(domainNotEmpty);
            if (domainNotEmpty) {
                pwdTxt.setText(null);
                pwdConfTxt.setText(null);
            }
            ValidationUtils.forceValidate((Node)pwdTxt, (ValidationMode)ValidationMode.ON_FLY);
            ValidationUtils.forceValidate((Node)pwdConfTxt, (ValidationMode)ValidationMode.ON_FLY);
        });
        return grid;
    }

    private void showRegsTab() {
        this.registrationTab.setContent((Node)this.createRegistrationContents());
        if (!this.tabPane.getTabs().contains((Object)this.registrationTab)) {
            this.tabPane.getTabs().add((Object)this.registrationTab);
        }
        this.tabPane.getSelectionModel().select((Object)this.registrationTab);
    }

    private static Tab createTab(String tabName, boolean isCloseable) {
        Tab tab = new Tab(tabName);
        tab.getStyleClass().add((Object)"tab-style-class");
        tab.setClosable(isCloseable);
        return tab;
    }

    private void resetUISettings(BooleanProperty bProperty) {
        this.clearPersistedState.bind((ObservableValue)bProperty);
    }

    private void applyServerInfo() {
        this.tabPane.getSelectionModel().select((Object)this.loginTab);
        this.requestFocus();
    }

    private void cancelRegOrServerSet(String cancelBtnLbl) {
        this.tabPane.getSelectionModel().select((Object)this.loginTab);
        if (3 == this.tabPane.getTabs().size() && Messages.loginpane_createuser_cancel.equals(cancelBtnLbl)) {
            this.tabPane.getTabs().remove((Object)this.registrationTab);
            this.createAccHyperlink.setDisable(false);
        }
        this.requestFocus();
    }

    private void submitRegistrationInfo(String registrationUserPassword) {
        this.submitBooleanProp.set(true);
        this.loginControl.invokeNewUserRegn(this.getScene(), this.registrationUser, registrationUserPassword).consumeResult((s, r) -> Platform.runLater(() -> {
            if (ResultType.Success == r.getType()) {
                Label infoLbl = new Label(Messages.loginpane_register_contact_eos_admin_info);
                infoLbl.setWrapText(true);
                infoLbl.setPadding(new Insets(10.0));
                this.registrationTab.setContent((Node)new BorderPane((Node)infoLbl));
                if (this.registrationUser.getDomain() != null && !this.registrationUser.getDomain().isBlank()) {
                    this.userName.set((Object)String.format("%s\\%s", this.registrationUser.getDomain(), this.registrationUser.getLogin()));
                } else {
                    this.userName.set((Object)this.registrationUser.getLogin());
                }
            } else {
                AlertDialogUtils.showAlert((Alert.AlertType)Alert.AlertType.ERROR, (Window)this.getScene().getWindow(), null, (String)r.getMessage());
            }
            this.submitBooleanProp.set(false);
        }));
    }

    private GridPane createGridPane(Pos alignment, Color color) {
        GridPane grid = new GridPane();
        grid.setAlignment(alignment);
        grid.setHgap(10.0);
        grid.setVgap(12.0);
        grid.setBackground(ColorUtils.getBackGround((Color)color));
        return grid;
    }

    private String getFontStyle(int fontSize) {
        return "-fx-text-fill: WHITE; -fx-stroke: BLACK; -fx-font-size: " + fontSize + "px; -fx-font-weight: bold;";
    }

    public ThreadSynchronize.BlockCondition<ILifeCycleHook.HookResult> getLoginBlock() {
        return this.loginBlock;
    }

    private void handleLogin() {
        this.tabPane.setDisable(true);
        boolean loginSuccessfull = this.loginControl.handleUserLogin((String)this.userName.get(), (String)this.password.get(), this.getScene(), this.uiSync, this.clientInfo, this.loginBlock);
        this.tabPane.setDisable(loginSuccessfull);
    }

    public BooleanProperty clearPersisedStateProperty() {
        return this.clearPersistedState;
    }

    private void validatePwdEquals(PasswordField tField1, PasswordField tField2) {
        Validator passwdEqValidator = Validators.createValidator((o, ov, nv) -> {
            if (tField1.getText() != null && tField2.getText() == null) {
                return false;
            }
            if (tField1.getText() == null && tField2.getText() != null) {
                return false;
            }
            if (tField1.getText() != null && tField2.getText() != null) {
                return tField1.getText().equals(tField2.getText());
            }
            return true;
        }, (String)Messages.login_createuser_pwd_and_confirmation);
        Validator shortPasswdValidator = Validators.createValidator((o, ov, nv) -> nv != null && ((String)nv).length() >= 4, (EventType)ValidationEvent.VALIDATION_WARNING, (String)Messages.login_createuser_pwd_too_short);
        ValidationUtils.install((Node)tField1, (Validator)Validators.combine((Validator[])new Validator[]{passwdEqValidator, shortPasswdValidator}));
        ValidationUtils.install((Node)tField2, (Validator)Validators.combine((Validator[])new Validator[]{passwdEqValidator, shortPasswdValidator}));
    }

    private void shutdownApplication() {
        if (this.loginBlock.isBlocked()) {
            this.uiSync.syncExec(() -> this.loginBlock.release((Object)new ILifeCycleHook.HookResult(LifecycleRV.SHUTDOWN)));
        }
        this.onCloseRequest.run();
    }

    private String getWhiteColorStyle(int fontSize) {
        return "-fx-text-fill: WHITE; -fx-stroke: WHITE; -fx-font:" + fontSize + "px \"Calibri\"";
    }

    public void requestFocus() {
        super.requestFocus();
        this.tabPane.requestFocus();
    }

    private void setTabSelection() {
        String hostName = this.loginControl.getConnDef().getHostName();
        int port = this.loginControl.getConnDef().getPort();
        if (hostName == null || "localhost".equals(hostName) || port == 0 || 443 == port) {
            this.tabPane.getSelectionModel().select((Object)this.settingsTab);
        } else {
            this.tabPane.getSelectionModel().select((Object)this.loginTab);
        }
    }
}

