/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.login;

import de.elpro.ewms.gui.login.Messages;
import de.elpro.ui.formats.TimeFormatType;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public class UntrustedCertDialog
extends Dialog<UntrustedCertDialogResult> {
    private final ButtonType acceptBT = new ButtonType(Messages.login_UntrustedCertDialog_Accept, ButtonBar.ButtonData.OK_DONE);
    private final ButtonType acceptAndSaveBT = new ButtonType(Messages.login_UntrustedCertDialog_AcceptAndSave, ButtonBar.ButtonData.BACK_PREVIOUS);
    private final ButtonType rejectBT = new ButtonType(Messages.login_UntrustedCertDialog_Reject, ButtonBar.ButtonData.CANCEL_CLOSE);

    public UntrustedCertDialog(Scene owner, X509Certificate cert) {
        this.initOwner(owner.getWindow());
        this.setTitle(Messages.login_UntrustedCertDialog_UntrustedCertificate);
        GridPane pane = new GridPane();
        pane.setHgap(5.0);
        pane.setVgap(10.0);
        pane.setPadding(new Insets(10.0));
        pane.setPrefWidth(500.0);
        pane.getColumnConstraints().add((Object)new ColumnConstraints(){
            {
                this.setMinWidth(100.0);
            }
        });
        pane.getColumnConstraints().add((Object)new ColumnConstraints(){
            {
                this.setHgrow(Priority.ALWAYS);
            }
        });
        LocalDateTime notBefore = LocalDateTime.ofInstant(cert.getNotBefore().toInstant(), ZoneOffset.systemDefault());
        LocalDateTime notAfter = LocalDateTime.ofInstant(cert.getNotAfter().toInstant(), ZoneOffset.systemDefault());
        int row = 0;
        pane.addRow(row++, new Node[]{new Label(Messages.login_UntrustedCertDialog_Subject), UntrustedCertDialog.certValFielt(cert.getSubjectDN().toString())});
        pane.addRow(row++, new Node[]{new Label(Messages.login_UntrustedCertDialog_Issuer), UntrustedCertDialog.certValFielt(cert.getIssuerDN().toString())});
        pane.addRow(row++, new Node[]{new Label(Messages.login_UntrustedCertDialog_ValidFrom), UntrustedCertDialog.certValFielt(TimeFormatType.DateTimeHMs.format((TemporalAccessor)notBefore))});
        pane.addRow(row++, new Node[]{new Label(Messages.login_UntrustedCertDialog_ValidUntil), UntrustedCertDialog.certValFielt(TimeFormatType.DateTimeHMs.format((TemporalAccessor)notAfter))});
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = cert.getSerialNumber().toByteArray();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            stringBuilder.append(String.format("%02x", b & 0xFF));
            ++n2;
        }
        String serial = "0x" + stringBuilder.toString().toUpperCase();
        pane.addRow(row++, new Node[]{new Label(Messages.login_UntrustedCertDialog_SerialNumber), UntrustedCertDialog.certValFielt(serial)});
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(Messages.login_UntrustedCertDialog_SHA1);
            messageDigest.update(cert.getEncoded());
            stringBuilder = new StringBuilder();
            byte[] byArray2 = messageDigest.digest();
            int n3 = byArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                byte b = byArray2[n4];
                stringBuilder.append(String.format("%02x", b & 0xFF)).append(':');
                ++n4;
            }
            String sigText = stringBuilder.toString().toUpperCase(Locale.getDefault());
            sigText = sigText.substring(0, sigText.length() - 1);
            pane.addRow(row++, new Node[]{new Label(Messages.login_UntrustedCertDialog_ThumbprintSHA1), UntrustedCertDialog.certValFielt(sigText)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getDialogPane().setContent((Node)pane);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{this.acceptAndSaveBT, this.acceptBT, this.rejectBT});
        this.setOnCloseRequest(event -> {
            if (this.getResult() == null) {
                return;
            }
        });
        this.setResultConverter(bt -> {
            if (bt == this.rejectBT) {
                return UntrustedCertDialogResult.Reject;
            }
            if (bt == this.acceptBT) {
                return UntrustedCertDialogResult.Accept;
            }
            if (bt == this.acceptAndSaveBT) {
                return UntrustedCertDialogResult.AcceptAndSave;
            }
            return UntrustedCertDialogResult.Reject;
        });
    }

    private static TextField certValFielt(String text) {
        TextField tf = new TextField(text);
        tf.setEditable(false);
        return tf;
    }

    public static enum UntrustedCertDialogResult {
        Accept,
        AcceptAndSave,
        Reject;

    }
}

