/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.login.controllers;

import de.elpro.ewms.core.auth.LoginRequest;
import de.elpro.ewms.core.auth.LoginResponse;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.client.ConnectionDefinition;
import de.elpro.ewms.core.client.KeyStoreManager;
import de.elpro.ewms.core.client.UntrustedCertException;
import de.elpro.ewms.core.client.auth.UserDAO;
import de.elpro.ewms.core.client.config.ClientConfigDAO;
import de.elpro.ewms.core.component.ClientInfo;
import de.elpro.ewms.core.component.CompatibilityException;
import de.elpro.ewms.core.component.ServerInfo;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.gui.lifecycle.Manager;
import de.elpro.ewms.gui.login.LoginUI;
import de.elpro.ewms.gui.login.Messages;
import de.elpro.ewms.gui.login.UntrustedCertDialog;
import de.elpro.ewms.gui.login.bundle.Activator;
import de.elpro.ewms.gui.model.ILifeCycleHook;
import de.elpro.java.common.utils.JavaSystemUtils;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.dialog.utils.AlertDialogUtils;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.fx.utils.TaskUtils;
import de.elpro.ui.net.InetUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Optional;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.stage.Window;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.net.ssl.SSLHandshakeException;
import javax.ws.rs.ProcessingException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.services.restart.LifecycleRV;

public class LoginController {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(LoginUI.class.getName());
    private static final Cipher AUTH_ENCRYPTOR;
    private static final boolean ENCODE_PASSPHRASE = true;
    private final ConnectionDefinition connDef = ConnectionDefinition.INSTANCE;

    static {
        byte[] byArray = new byte[294];
        byArray[0] = 48;
        byArray[1] = -126;
        byArray[2] = 1;
        byArray[3] = 34;
        byArray[4] = 48;
        byArray[5] = 13;
        byArray[6] = 6;
        byArray[7] = 9;
        byArray[8] = 42;
        byArray[9] = -122;
        byArray[10] = 72;
        byArray[11] = -122;
        byArray[12] = -9;
        byArray[13] = 13;
        byArray[14] = 1;
        byArray[15] = 1;
        byArray[16] = 1;
        byArray[17] = 5;
        byArray[19] = 3;
        byArray[20] = -126;
        byArray[21] = 1;
        byArray[22] = 15;
        byArray[24] = 48;
        byArray[25] = -126;
        byArray[26] = 1;
        byArray[27] = 10;
        byArray[28] = 2;
        byArray[29] = -126;
        byArray[30] = 1;
        byArray[31] = 1;
        byArray[33] = -88;
        byArray[34] = -10;
        byArray[35] = -19;
        byArray[36] = -63;
        byArray[37] = 51;
        byArray[38] = 28;
        byArray[39] = -52;
        byArray[40] = -105;
        byArray[41] = -5;
        byArray[42] = 105;
        byArray[43] = -66;
        byArray[44] = 41;
        byArray[45] = -125;
        byArray[46] = -39;
        byArray[47] = -52;
        byArray[48] = 67;
        byArray[49] = -38;
        byArray[50] = -112;
        byArray[51] = -42;
        byArray[52] = 123;
        byArray[53] = 114;
        byArray[54] = 99;
        byArray[55] = 34;
        byArray[56] = 27;
        byArray[57] = -70;
        byArray[58] = -44;
        byArray[59] = -32;
        byArray[60] = -124;
        byArray[61] = 116;
        byArray[62] = 120;
        byArray[63] = -121;
        byArray[64] = -101;
        byArray[65] = -69;
        byArray[66] = -81;
        byArray[67] = 44;
        byArray[68] = 83;
        byArray[69] = -72;
        byArray[70] = 123;
        byArray[71] = 15;
        byArray[72] = 68;
        byArray[73] = -45;
        byArray[74] = -30;
        byArray[75] = -125;
        byArray[76] = 11;
        byArray[77] = -33;
        byArray[78] = 23;
        byArray[79] = 78;
        byArray[80] = 52;
        byArray[81] = -81;
        byArray[82] = -39;
        byArray[83] = 40;
        byArray[84] = -35;
        byArray[85] = -78;
        byArray[86] = -66;
        byArray[87] = -42;
        byArray[88] = 3;
        byArray[89] = 94;
        byArray[90] = 29;
        byArray[91] = 59;
        byArray[92] = 120;
        byArray[93] = -17;
        byArray[94] = 78;
        byArray[95] = -3;
        byArray[96] = 55;
        byArray[97] = 108;
        byArray[98] = 120;
        byArray[99] = 20;
        byArray[100] = -114;
        byArray[101] = 17;
        byArray[102] = 66;
        byArray[103] = -114;
        byArray[104] = 36;
        byArray[105] = 24;
        byArray[106] = -83;
        byArray[107] = -114;
        byArray[108] = -39;
        byArray[109] = -103;
        byArray[110] = 73;
        byArray[111] = 3;
        byArray[112] = 52;
        byArray[113] = -86;
        byArray[114] = -95;
        byArray[115] = -119;
        byArray[116] = 75;
        byArray[117] = -99;
        byArray[118] = 85;
        byArray[119] = -40;
        byArray[121] = 46;
        byArray[122] = 92;
        byArray[123] = 53;
        byArray[124] = -120;
        byArray[125] = 125;
        byArray[126] = 11;
        byArray[127] = 1;
        byArray[128] = 22;
        byArray[129] = 113;
        byArray[130] = -54;
        byArray[131] = -35;
        byArray[132] = -94;
        byArray[133] = -85;
        byArray[134] = -12;
        byArray[135] = 79;
        byArray[136] = -43;
        byArray[137] = -104;
        byArray[138] = -70;
        byArray[139] = 6;
        byArray[140] = 107;
        byArray[141] = 87;
        byArray[142] = 104;
        byArray[143] = -17;
        byArray[144] = 99;
        byArray[145] = 2;
        byArray[146] = -8;
        byArray[147] = 89;
        byArray[148] = 72;
        byArray[149] = -12;
        byArray[150] = -33;
        byArray[151] = 93;
        byArray[152] = -2;
        byArray[153] = -52;
        byArray[154] = 96;
        byArray[155] = -89;
        byArray[156] = -33;
        byArray[157] = -35;
        byArray[158] = -23;
        byArray[159] = -56;
        byArray[160] = -104;
        byArray[161] = -24;
        byArray[162] = -33;
        byArray[163] = 61;
        byArray[164] = 25;
        byArray[165] = -92;
        byArray[166] = -6;
        byArray[167] = 101;
        byArray[168] = 102;
        byArray[169] = 73;
        byArray[170] = 44;
        byArray[171] = 31;
        byArray[172] = -56;
        byArray[173] = -82;
        byArray[175] = -122;
        byArray[176] = -69;
        byArray[177] = -32;
        byArray[178] = -38;
        byArray[179] = -61;
        byArray[180] = 41;
        byArray[181] = -36;
        byArray[182] = -89;
        byArray[183] = -42;
        byArray[184] = -125;
        byArray[185] = 45;
        byArray[186] = -4;
        byArray[187] = 58;
        byArray[188] = -77;
        byArray[189] = -125;
        byArray[190] = 9;
        byArray[191] = -18;
        byArray[192] = -29;
        byArray[193] = -37;
        byArray[194] = -74;
        byArray[195] = 2;
        byArray[196] = 92;
        byArray[197] = -94;
        byArray[198] = -56;
        byArray[199] = -21;
        byArray[200] = 49;
        byArray[201] = 52;
        byArray[202] = -1;
        byArray[203] = 94;
        byArray[204] = 67;
        byArray[205] = 33;
        byArray[206] = -86;
        byArray[207] = -72;
        byArray[208] = 112;
        byArray[209] = -109;
        byArray[210] = -79;
        byArray[211] = 35;
        byArray[212] = -113;
        byArray[213] = 22;
        byArray[214] = 120;
        byArray[215] = 21;
        byArray[216] = -124;
        byArray[217] = -111;
        byArray[218] = 45;
        byArray[219] = 73;
        byArray[220] = 55;
        byArray[221] = 30;
        byArray[222] = 123;
        byArray[223] = -48;
        byArray[224] = -11;
        byArray[225] = -95;
        byArray[226] = -83;
        byArray[227] = -84;
        byArray[228] = -15;
        byArray[229] = -65;
        byArray[230] = 62;
        byArray[231] = 102;
        byArray[232] = 38;
        byArray[233] = -37;
        byArray[234] = 58;
        byArray[235] = 90;
        byArray[236] = -36;
        byArray[237] = 87;
        byArray[238] = 88;
        byArray[239] = 126;
        byArray[240] = -28;
        byArray[241] = -64;
        byArray[242] = 73;
        byArray[243] = -88;
        byArray[244] = 127;
        byArray[245] = -22;
        byArray[246] = 7;
        byArray[247] = 47;
        byArray[248] = -65;
        byArray[249] = 31;
        byArray[250] = 83;
        byArray[251] = -31;
        byArray[252] = -107;
        byArray[253] = -36;
        byArray[254] = -32;
        byArray[255] = 68;
        byArray[256] = 75;
        byArray[257] = -23;
        byArray[258] = 51;
        byArray[259] = 97;
        byArray[260] = -106;
        byArray[261] = -87;
        byArray[262] = -7;
        byArray[263] = -47;
        byArray[264] = 34;
        byArray[265] = 47;
        byArray[266] = 18;
        byArray[267] = -69;
        byArray[268] = 2;
        byArray[269] = 84;
        byArray[270] = -42;
        byArray[271] = -21;
        byArray[272] = 112;
        byArray[273] = 10;
        byArray[274] = 49;
        byArray[275] = -96;
        byArray[276] = -43;
        byArray[277] = -85;
        byArray[278] = 2;
        byArray[279] = -59;
        byArray[280] = -99;
        byArray[281] = -71;
        byArray[282] = -119;
        byArray[283] = 96;
        byArray[284] = 111;
        byArray[285] = 75;
        byArray[286] = 105;
        byArray[287] = 8;
        byArray[288] = -107;
        byArray[289] = 2;
        byArray[290] = 3;
        byArray[291] = 1;
        byArray[293] = 1;
        byte[] privateKeyBytes = byArray;
        X509EncodedKeySpec spec = new X509EncodedKeySpec(privateKeyBytes);
        Cipher cipher = null;
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PublicKey publicKey = kf.generatePublic(spec);
            cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException exc) {
            exc.printStackTrace();
        }
        AUTH_ENCRYPTOR = cipher;
    }

    public LoginController() {
        this.initLogInfo();
    }

    private void initLogInfo() {
        if (this.connDef.getLogin() == null) {
            String defaultDomain = InetUtils.getDomainName();
            String defaultUserName = JavaSystemUtils.getUserName();
            if (defaultDomain != null && defaultUserName != null) {
                this.connDef.setLogin(String.format(".\\%s", defaultUserName));
            } else {
                this.connDef.setLogin(defaultUserName);
            }
        }
    }

    public TaskUtils.ConsumableFuture<OperationResult> invokeNewUserRegn(final Scene scene, final User user, final String password) {
        if (user == null) {
            AlertDialogUtils.showWaitAlert((Alert.AlertType)Alert.AlertType.ERROR, (Window)scene.getWindow(), null, (String)Messages.login_LoginDataPanelController_WrongLoginFormat);
        }
        CallableTask<OperationResult> submitTask = new CallableTask<OperationResult>(){

            public OperationResult call() throws Exception {
                OperationResult operationResult;
                String targetUrl = ConnectionDefinition.INSTANCE.getConnectionUrl();
                KeyStoreManager ksManager = Activator.getKeyStoreManager();
                try {
                    Client.connect((String)targetUrl, (KeyStore)ksManager.getOwnCertKeyStore(), (KeyStore)ksManager.getTrustedKeyStore());
                }
                catch (UntrustedCertException trustCertExc) {
                    X509Certificate[] chain = trustCertExc.getCertChain();
                    X509Certificate cert = chain[0];
                    UntrustedCertDialog.UntrustedCertDialogResult certDialogResult = ((Optional)FXUtils.runAndWait(() -> {
                        UntrustedCertDialog certDialog = new UntrustedCertDialog(scene, cert);
                        return certDialog.showAndWait();
                    })).orElse(UntrustedCertDialog.UntrustedCertDialogResult.Reject);
                    switch (certDialogResult) {
                        case Reject: {
                            return new OperationResult(ResultType.ExpectedError, "Certificate Rejected");
                        }
                        case Accept: {
                            ksManager.addToTrustedKeyStore(cert, false);
                            Client.connect((String)targetUrl, (KeyStore)ksManager.getOwnCertKeyStore(), (KeyStore)ksManager.getTrustedKeyStore());
                            break;
                        }
                        case AcceptAndSave: {
                            ksManager.addToTrustedKeyStore(cert, true);
                            Client.connect((String)targetUrl, (KeyStore)ksManager.getOwnCertKeyStore(), (KeyStore)ksManager.getTrustedKeyStore());
                        }
                    }
                    LoginController.this.getConnDef().persistServerCredentials();
                }
                catch (Exception exc) {
                    String errorMessage;
                    if (exc instanceof ProcessingException && ((ProcessingException)exc).getCause() instanceof SSLHandshakeException) {
                        SSLHandshakeException sslExc = (SSLHandshakeException)((ProcessingException)exc).getCause();
                        errorMessage = String.format("SSL Certificat error: %s", sslExc.getMessage());
                    } else {
                        errorMessage = Messages.login_LoginDialog_Cannot_connect_server;
                    }
                    return new OperationResult(ResultType.UnexprectedError, errorMessage);
                }
                try {
                    String registrationPwd = user.getDomain() == null ? KeyStoreManager.PASSWORD_ENCRYPTOR.encryptPassword(password) : null;
                    UserDAO.register((User)user, (String)registrationPwd);
                    operationResult = OperationResult.SUCCESS;
                    return operationResult;
                }
                catch (DAOOperationException dAOOperationException) {
                    operationResult = new OperationResult(ResultType.ExpectedError, Messages.login_createuser_user_exists);
                    return operationResult;
                }
                finally {
                    Client.disconnect();
                }
            }
        };
        return TaskUtils.executeTask((CallableTask)submitTask);
    }

    public LoginResponse connect(String targetUrl, Scene scene, ThreadSynchronize uiSync) {
        KeyStoreManager ksManager = Activator.getKeyStoreManager();
        try {
            try {
                Client.connect((String)targetUrl, (KeyStore)ksManager.getOwnCertKeyStore(), (KeyStore)ksManager.getTrustedKeyStore());
            }
            catch (UntrustedCertException trustCertExc) {
                X509Certificate[] chain = trustCertExc.getCertChain();
                X509Certificate cert = chain[0];
                UntrustedCertDialog.UntrustedCertDialogResult certDialogResult = (UntrustedCertDialog.UntrustedCertDialogResult)((Object)uiSync.syncExec(() -> {
                    UntrustedCertDialog certDialog = new UntrustedCertDialog(scene, cert);
                    return (UntrustedCertDialog.UntrustedCertDialogResult)((Object)((Object)certDialog.showAndWait().get()));
                }, (Object)UntrustedCertDialog.UntrustedCertDialogResult.Reject));
                switch (certDialogResult) {
                    case Reject: {
                        return new LoginResponse(LoginResponse.LoginResponseType.CertificateError);
                    }
                    case Accept: {
                        ksManager.addToTrustedKeyStore(cert, false);
                        Client.connect((String)targetUrl, (KeyStore)ksManager.getOwnCertKeyStore(), (KeyStore)ksManager.getTrustedKeyStore());
                        break;
                    }
                    case AcceptAndSave: {
                        ksManager.addToTrustedKeyStore(cert, true);
                        Client.connect((String)targetUrl, (KeyStore)ksManager.getOwnCertKeyStore(), (KeyStore)ksManager.getTrustedKeyStore());
                    }
                }
            }
            this.getConnDef().persistServerCredentials();
            return new LoginResponse(LoginResponse.LoginResponseType.Success);
        }
        catch (Exception exc) {
            String errorMessage;
            logger.error("Error creating connection to EOS Server", (Throwable)exc);
            if (exc instanceof ProcessingException && ((ProcessingException)exc).getCause() instanceof SSLHandshakeException) {
                SSLHandshakeException sslExc = (SSLHandshakeException)((ProcessingException)exc).getCause();
                errorMessage = String.format("SSL Certificat error: %s", sslExc.getMessage());
            } else {
                errorMessage = Messages.login_LoginDialog_Cannot_connect_server;
            }
            return new LoginResponse(LoginResponse.LoginResponseType.InternalError, errorMessage);
        }
    }

    public boolean tryUpdate(ThreadSynchronize uiSync) {
        try {
            String updateUrl;
            IProfile selfProfile = Manager.getInstance().getSelfProfile();
            if (selfProfile != null && (updateUrl = ClientConfigDAO.getProductUpdateURL((String)selfProfile.getProfileId())) != null && !updateUrl.isBlank()) {
                logger.infof("Use update server URI %s for %s", new Object[]{updateUrl, selfProfile.getProfileId()});
                LifecycleRV rv = Manager.getInstance().executeUpdate(uiSync, updateUrl);
                if (rv == LifecycleRV.RESTART_CLEAR_STATE) {
                    logger.info("Update finisched. Need to reastart now\\!");
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error updating client", (Throwable)e);
        }
        return false;
    }

    public LoginResponse authenticate(String targetUrl, String loginPhrase, String domain, String login, String password) {
        byte[] passphraseData;
        LoginResponse response = UserDAO.requestLoginToken((String)domain, (String)login);
        if (LoginResponse.LoginResponseType.Success != response.getType()) {
            return response;
        }
        LoginRequest loginRequest = new LoginRequest(response.getMessage(), password);
        byte[] loginRequestStrData = loginRequest.serialize().getBytes(StandardCharsets.UTF_8);
        try {
            passphraseData = AUTH_ENCRYPTOR.doFinal(loginRequest.serialize().getBytes(StandardCharsets.UTF_8));
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            passphraseData = null;
        }
        response = UserDAO.login((String)domain, (String)login, (boolean)true, (String)Base64.getEncoder().encodeToString(passphraseData));
        if (response.getType() == LoginResponse.LoginResponseType.Success) {
            Client.saveAuthentication((String)targetUrl, (String)response.getUserPrincipal(), (String)response.getSessionKey());
            Client.initClient();
            this.getConnDef().setLogin(loginPhrase);
            if (domain == null) {
                this.getConnDef().setPassword(password);
            } else {
                this.getConnDef().setPassword(null);
            }
            this.getConnDef().persist();
        }
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static User parseUserCredentials(String userName) {
        String login;
        String domain;
        if (userName.contains("\\")) {
            parts = userName.split("\\\\");
            if (2 != parts.length) return null;
            domain = parts[0].trim();
            login = parts[1].trim();
        } else if (userName.contains("@")) {
            parts = userName.split("@");
            if (2 != parts.length) return null;
            login = parts[0].trim();
            domain = parts[1].trim();
        } else {
            domain = null;
            login = userName.trim();
        }
        User user = new User();
        user.setDomain(domain);
        user.setLogin(login);
        return user;
    }

    public boolean handleUserLogin(String loginPhrase, String password, Scene scene, ThreadSynchronize uiSync, ClientInfo clientInfo, ThreadSynchronize.BlockCondition<ILifeCycleHook.HookResult> loginBlock) {
        LoginResponse response;
        block16: {
            User user = LoginController.parseUserCredentials(loginPhrase);
            if (user == null) {
                AlertDialogUtils.showWaitAlert((Alert.AlertType)Alert.AlertType.ERROR, (Window)scene.getWindow(), null, (String)Messages.login_LoginDataPanelController_WrongLoginFormat);
                return false;
            }
            String targetUrl = this.getConnDef().getConnectionUrl();
            ThreadSynchronize.BlockCondition connectBlock = new ThreadSynchronize.BlockCondition();
            uiSync.asyncExec(() -> connectBlock.release((Object)this.connect(targetUrl, scene, uiSync)));
            response = (LoginResponse)uiSync.block(connectBlock);
            if (LoginResponse.LoginResponseType.Success == response.getType()) {
                if (this.tryUpdate(uiSync)) {
                    loginBlock.release((Object)ILifeCycleHook.RESTART_WITH_RESET);
                } else {
                    ServerInfo serverInfo = Client.getServerInfo();
                    try {
                        clientInfo.checkCompatibility(serverInfo);
                    }
                    catch (CompatibilityException compatibilityException) {
                        String versionWarning = Messages.LoginController_missmatchVersionsWarning;
                        AlertDialogUtils.showWaitAlert((Alert.AlertType)Alert.AlertType.WARNING, (Window)scene.getWindow(), (String)Messages.LoginController_missmatchVersionWarningTitle, (String)versionWarning);
                    }
                    ThreadSynchronize.BlockCondition authBlock = new ThreadSynchronize.BlockCondition();
                    uiSync.asyncExec(() -> {
                        try {
                            authBlock.release((Object)this.authenticate(targetUrl, loginPhrase, user.getDomain(), user.getLogin(), password));
                        }
                        catch (Exception exc) {
                            authBlock.release((Object)new LoginResponse(LoginResponse.LoginResponseType.InternalError, exc.getMessage()));
                        }
                    });
                    response = (LoginResponse)uiSync.block(authBlock);
                }
            }
            if (response.getType() != LoginResponse.LoginResponseType.Success) break block16;
            loginBlock.release((Object)ILifeCycleHook.CONTINUE);
            return true;
        }
        try {
            String message = null;
            switch (response.getType()) {
                case CertificateError: {
                    message = Messages.login_LoginDataPanelController_CertificateError;
                    break;
                }
                case WrongPassword: {
                    message = Messages.login_LoginDataPanelController_WrongPassword;
                    break;
                }
                case UserInactive: {
                    message = Messages.login_LoginDataPanelController_InactiveUser;
                    break;
                }
                case UserNotFound: {
                    message = Messages.login_LoginDataPanelController_UserNotFound;
                    break;
                }
                case InternalError: {
                    message = response.getMessage();
                    break;
                }
            }
            AlertDialogUtils.showAlert((Alert.AlertType)Alert.AlertType.ERROR, (Window)scene.getWindow(), null, (String)message);
        }
        catch (Exception exc) {
            AlertDialogUtils.showExceptionAlert((Window)scene.getWindow(), (Throwable)exc, (String)exc.getMessage(), null);
        }
        return false;
    }

    public ConnectionDefinition getConnDef() {
        return this.connDef;
    }
}

