/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.preferences.model;

import de.elpro.ewms.gui.preferences.Messages;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.stage.Window;
import org.controlsfx.dialog.ExceptionDialog;

public abstract class PreferenceEditor {
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty canSave = new SimpleBooleanProperty(true);
    private Node editor = null;
    private Window rootWindow = null;

    public PreferenceEditor(Window rootWindow) {
        this.rootWindow = rootWindow;
    }

    public Window getRootWindow() {
        return this.rootWindow;
    }

    public final Node getEditor() {
        if (this.editor == null) {
            try {
                this.editor = this.createEditor();
            }
            catch (Exception exc) {
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.initOwner(this.getRootWindow());
                dlg.setContentText(Messages.model_PreferenceEditor_ExceptionOcuredDuringCreatingEditor);
                dlg.showAndWait();
            }
            return this.editor;
        }
        return this.editor;
    }

    protected abstract Node createEditor();

    public final BooleanProperty hasChangesProperty() {
        return this.hasChanges;
    }

    public final BooleanProperty canSaveProperty() {
        return this.canSave;
    }

    public abstract void save();

    public abstract void discardChanges();
}

