/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.preferences.model.internal;

import de.elpro.ewms.gui.preferences.Messages;
import de.elpro.ewms.gui.preferences.bundle.Activator;
import de.elpro.ewms.gui.preferences.model.IPreferenceDefinition;
import de.elpro.ewms.gui.preferences.model.PreferenceEditor;
import de.elpro.ui.fx.cells.uimodel.UIModelTreeCell;
import de.elpro.ui.model.UILabeledElement;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Window;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class PreferencesStage
extends Dialog<ButtonType> {
    private static final String EXTENSION_POINT_ID = "de.elpro.ewms.gui.preferences.editors";
    private static final Map<String, IPreferenceDefinition> DEFINITIONS;
    private final TreeItem<UILabeledElement> rootItem = new TreeItem();
    private final Map<String, TreeItem<UILabeledElement>> items = new HashMap<String, TreeItem<UILabeledElement>>();
    private final Map<TreeItem<UILabeledElement>, String> itemsIds = new HashMap<TreeItem<UILabeledElement>, String>();
    private final Map<String, PreferenceEditor> editors = new HashMap<String, PreferenceEditor>();

    static {
        IConfigurationElement[] elements;
        DEFINITIONS = new HashMap<String, IPreferenceDefinition>();
        IConfigurationElement[] iConfigurationElementArray = elements = Activator.extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o = e.createExecutableExtension("definition");
                if (o instanceof IPreferenceDefinition) {
                    IPreferenceDefinition definition = (IPreferenceDefinition)o;
                    DEFINITIONS.put(definition.getId(), definition);
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            ++n2;
        }
    }

    public PreferencesStage(Window window) {
        this.initOwner(window);
        this.createUI();
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.setOnCloseRequest(event -> {
            if (this.getResult() != ButtonType.OK) {
                return;
            }
            for (PreferenceEditor editor : this.editors.values()) {
                if (editor == null || !editor.hasChangesProperty().get() || !editor.canSaveProperty().get()) continue;
                editor.save();
            }
        });
        this.initNavigation();
        this.setTitle(Messages.preferences_PreferencesStage_Preferences);
    }

    private void createUI() {
        BorderPane pane = new BorderPane();
        BorderPane centerPane = new BorderPane();
        Label title = new Label();
        TreeView navigation = new TreeView(this.rootItem);
        pane.setPrefHeight(600.0);
        pane.setPrefWidth(800.0);
        navigation.setPrefWidth(200.0);
        navigation.setShowRoot(false);
        navigation.setCellFactory(cf -> new UIModelTreeCell());
        navigation.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            UILabeledElement le = (UILabeledElement)nv.getValue();
            if (le != null) {
                title.setText((String)le.textProperty().getValue());
                PreferenceEditor editor = this.editors.get(this.itemsIds.get(nv));
                if (editor != null) {
                    centerPane.setCenter(editor.getEditor());
                } else {
                    centerPane.setCenter(null);
                }
            } else {
                title.setText(null);
                centerPane.setCenter(null);
            }
        });
        pane.setLeft((Node)navigation);
        title.setPadding(new Insets(10.0));
        title.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)12.0));
        centerPane.setTop((Node)new BorderPane((Node)title, null, null, (Node)new Separator(Orientation.HORIZONTAL), null));
        pane.setCenter((Node)centerPane);
        this.getDialogPane().setContent((Node)pane);
    }

    private void initNavigation() {
        IPreferenceDefinition definition;
        for (Map.Entry<String, IPreferenceDefinition> entry : DEFINITIONS.entrySet()) {
            definition = entry.getValue();
            TreeItem item = new TreeItem((Object)definition.getNavigationElement());
            this.items.put(entry.getKey(), (TreeItem<UILabeledElement>)item);
            this.itemsIds.put((TreeItem<UILabeledElement>)item, entry.getKey());
            PreferenceEditor editor = definition.createEditor(this.getOwner());
            if (editor == null) continue;
            this.editors.put(entry.getKey(), editor);
        }
        for (Map.Entry<String, IPreferenceDefinition> entry : DEFINITIONS.entrySet()) {
            definition = entry.getValue();
            TreeItem<UILabeledElement> treeItem = this.items.get(entry.getKey());
            String parentId = definition.getParentId();
            TreeItem<UILabeledElement> parentItem = parentId == null ? this.rootItem : this.items.get(parentId);
            parentItem.getChildren().add(treeItem);
            parentItem.getChildren().sort((Comparator)new Comparator<TreeItem<UILabeledElement>>(){

                @Override
                public int compare(TreeItem<UILabeledElement> o1, TreeItem<UILabeledElement> o2) {
                    return ((UILabeledElement)o2.getValue()).toString().compareTo(((UILabeledElement)o2.getValue()).toString());
                }
            });
        }
        SimpleBooleanProperty hasChangesProperty = new SimpleBooleanProperty(false);
        SimpleBooleanProperty canSaveProperty = new SimpleBooleanProperty(true);
        for (PreferenceEditor editor : this.editors.values()) {
            hasChangesProperty = Bindings.or((ObservableBooleanValue)hasChangesProperty, (ObservableBooleanValue)editor.hasChangesProperty());
            canSaveProperty = Bindings.and((ObservableBooleanValue)canSaveProperty, (ObservableBooleanValue)editor.canSaveProperty());
        }
        Button okButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        okButton.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)Bindings.and((ObservableBooleanValue)hasChangesProperty, (ObservableBooleanValue)canSaveProperty)));
    }
}

