/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.report.jasper;

import de.elpro.jfree.data.time.FixedLengthTimeSeries;
import de.elpro.jfree.data.time.FixedLengthTimeSeriesCollection;
import de.elpro.jfree.data.time.FixedLengthTimeTableXYDataset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRAbstractChartCustomizer;
import net.sf.jasperreports.engine.JRChart;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.Layer;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class JRJFreeChartCopyCustomizer
extends JRAbstractChartCustomizer {
    public void customize(JFreeChart dstJFreeChart, JRChart configChart) {
        try {
            XYPlot dstPlot;
            XYPlot srcPlot;
            JFreeChart srcJFreeChart = (JFreeChart)this.getFieldValue("jFreeChart");
            Integer expectedWidth = (Integer)this.getFieldValue("expectedWidth");
            Double dataItemToPixelRatio = (Double)this.getFieldValue("dataItemToPixelRatio");
            int maxItems = expectedWidth != null && expectedWidth > 0 && dataItemToPixelRatio != null && dataItemToPixelRatio > 0.0 ? (int)((double)expectedWidth.intValue() * dataItemToPixelRatio) : Integer.MAX_VALUE;
            dstJFreeChart.getLegend().setBackgroundPaint(srcJFreeChart.getBackgroundPaint());
            if (srcJFreeChart.getLegend() != null) {
                dstJFreeChart.getLegend().setPosition(srcJFreeChart.getLegend().getPosition());
            } else {
                dstJFreeChart.getLegend().setPosition(RectangleEdge.TOP);
            }
            dstJFreeChart.getPlot().setDrawingSupplier(srcJFreeChart.getPlot().getDrawingSupplier());
            if (dstJFreeChart.getPlot() instanceof XYPlot && srcJFreeChart.getPlot() instanceof XYPlot) {
                srcPlot = (XYPlot)srcJFreeChart.getPlot();
                dstPlot = (XYPlot)dstJFreeChart.getPlot();
                dstPlot.setDomainAxis(0, srcPlot.getDomainAxis(0));
                int i = 0;
                while (i < srcPlot.getRangeAxisCount()) {
                    ValueAxis srcAxis = srcPlot.getRangeAxis(i);
                    dstPlot.setRangeAxis(i, JRJFreeChartCopyCustomizer.copyValueAxis(srcAxis));
                    dstPlot.setRangeAxisLocation(i, srcPlot.getRangeAxisLocation(i));
                    ++i;
                }
                i = 0;
                while (i < srcPlot.getDatasetCount()) {
                    dstPlot.setDataset(i, JRJFreeChartCopyCustomizer.copyDataset(srcPlot.getDataset(i), maxItems));
                    ValueAxis axis = srcPlot.getRangeAxisForDataset(i);
                    dstPlot.mapDatasetToRangeAxis(i, srcPlot.getRangeAxisIndex(axis));
                    ++i;
                }
                i = 0;
                while (i < srcPlot.getRendererCount()) {
                    XYItemRenderer renderer = srcPlot.getRenderer(i);
                    dstPlot.setRenderer(i, renderer);
                    ++i;
                }
                Layer[] layerArray = Layer.values();
                int n = layerArray.length;
                int renderer = 0;
                while (renderer < n) {
                    Layer layer = layerArray[renderer];
                    Collection moc = srcPlot.getRangeMarkers(layer);
                    if (moc != null) {
                        for (Object mo : moc) {
                            dstPlot.addRangeMarker((Marker)mo, layer);
                        }
                    }
                    ++renderer;
                }
            }
            if (dstJFreeChart.getPlot() instanceof PiePlot) {
                PiePlot dstPlot2 = (PiePlot)dstJFreeChart.getPlot();
                if (srcJFreeChart.getPlot() instanceof PiePlot) {
                    srcPlot = (PiePlot)srcJFreeChart.getPlot();
                    dstPlot2.setDataset(srcPlot.getDataset());
                    dstPlot2.setLabelGenerator(srcPlot.getLabelGenerator());
                    for (Object key : srcPlot.getDataset().getKeys()) {
                        if (srcPlot.getSectionPaint((Comparable)key) == null) continue;
                        dstPlot2.setSectionPaint((Comparable)key, srcPlot.getSectionPaint((Comparable)key));
                    }
                } else if (srcJFreeChart.getPlot() instanceof RingPlot) {
                    srcPlot = (RingPlot)srcJFreeChart.getPlot();
                    dstPlot2.setDataset(srcPlot.getDataset());
                    dstPlot2.setLabelGenerator(srcPlot.getLabelGenerator());
                    for (Object key : srcPlot.getDataset().getKeys()) {
                        if (srcPlot.getSectionPaint((Comparable)key) == null) continue;
                        dstPlot2.setSectionPaint((Comparable)key, srcPlot.getSectionPaint((Comparable)key));
                    }
                }
            }
            if (dstJFreeChart.getPlot() instanceof CategoryPlot) {
                srcPlot = srcJFreeChart.getCategoryPlot();
                dstPlot = dstJFreeChart.getCategoryPlot();
                dstPlot.setDomainAxis(0, srcPlot.getDomainAxis(0));
                dstPlot.getDomainAxis(0).setLabelFont(srcPlot.getDomainAxis(0).getLabelFont());
                dstPlot.getDomainAxis(0).setTickLabelFont(srcPlot.getDomainAxis(0).getTickLabelFont());
                int i = 0;
                while (i < srcPlot.getRangeAxisCount()) {
                    dstPlot.setRangeAxis(i, JRJFreeChartCopyCustomizer.copyValueAxis(srcPlot.getRangeAxis(i)));
                    ++i;
                }
                i = 0;
                while (i < srcPlot.getDatasetCount()) {
                    dstPlot.setDataset(i, srcPlot.getDataset(i));
                    ValueAxis axis = srcPlot.getRangeAxisForDataset(i);
                    dstPlot.mapDatasetToRangeAxis(i, srcPlot.getRangeAxisIndex(axis));
                    ++i;
                }
                i = 0;
                while (i < srcPlot.getRendererCount()) {
                    CategoryItemRenderer renderer = srcPlot.getRenderer(i);
                    dstPlot.setRenderer(i, renderer);
                    ++i;
                }
            }
            dstJFreeChart.setBorderVisible(srcJFreeChart.isBorderVisible());
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private static ValueAxis copyValueAxis(ValueAxis srcAxis) {
        NumberAxis axisCopy = new NumberAxis(srcAxis.getLabel());
        axisCopy.setAxisLinePaint(srcAxis.getAxisLinePaint());
        axisCopy.setTickLabelPaint(srcAxis.getTickLabelPaint());
        axisCopy.setLabelPaint(srcAxis.getLabelPaint());
        axisCopy.setLabelAngle(srcAxis.getLabelAngle());
        axisCopy.setLowerMargin(srcAxis.getLowerMargin());
        axisCopy.setUpperMargin(srcAxis.getUpperMargin());
        axisCopy.setLabelFont(srcAxis.getLabelFont());
        axisCopy.setTickLabelFont(srcAxis.getTickLabelFont());
        return axisCopy;
    }

    private static XYDataset copyDataset(XYDataset src, int maxItems) {
        if (src instanceof TimeSeriesCollection) {
            TimeSeriesCollection tsc = (TimeSeriesCollection)src;
            TimeSeriesCollection dst = new TimeSeriesCollection(TimeZone.getTimeZone("UTC"));
            for (Object tsO : tsc.getSeries()) {
                TimeSeries ts = (TimeSeries)tsO;
                TimeSeries dTs = new TimeSeries(ts.getKey());
                int itemCount = ts.getItemCount();
                double ratio = (double)maxItems / (double)itemCount;
                double step = 1.0;
                if (ratio < 1.0) {
                    step = 1.0 / ratio;
                }
                double prevInsert = 0.0;
                int index = 0;
                Double val = null;
                int size = 0;
                for (Object itemO : ts.getItems()) {
                    TimeSeriesDataItem tsdi = (TimeSeriesDataItem)itemO;
                    int nextIndex = (int)(prevInsert + step);
                    if (tsdi.getValue() != null && Double.isFinite(tsdi.getValue().doubleValue())) {
                        val = val != null ? val + tsdi.getValue().doubleValue() : tsdi.getValue().doubleValue();
                        ++size;
                    }
                    if (nextIndex == index || index == itemCount - 1) {
                        Double resultVal = val != null ? Double.valueOf(val / (double)size) : null;
                        dTs.addOrUpdate(tsdi.getPeriod(), (Number)resultVal);
                        prevInsert += step;
                        val = null;
                        size = 0;
                    }
                    ++index;
                }
                dst.addSeries(dTs);
            }
            return dst;
        }
        if (src instanceof TimeTableXYDataset) {
            TimeTableXYDataset ttds = (TimeTableXYDataset)src;
            TimeTableXYDataset dst = new TimeTableXYDataset(TimeZone.getTimeZone("UTC"));
            int seriesIndex = 0;
            while (seriesIndex < ttds.getSeriesCount()) {
                Comparable seriesKey = ttds.getSeriesKey(seriesIndex);
                int itemCount = ttds.getItemCount();
                double ratio = (double)maxItems / (double)itemCount;
                double step = 1.0;
                if (ratio < 1.0) {
                    step = 1.0 / ratio;
                }
                double prevInsert = 0.0;
                Double val = null;
                int size = 0;
                int index = 0;
                while (index < itemCount) {
                    Number yValue = ttds.getY(seriesIndex, index);
                    int nextIndex = (int)(prevInsert + step);
                    if (yValue != null && Double.isFinite(yValue.doubleValue())) {
                        val = val != null ? val + yValue.doubleValue() : yValue.doubleValue();
                        ++size;
                    }
                    if (nextIndex == index || index == itemCount - 1) {
                        Double resultVal = val != null ? Double.valueOf(val / (double)size) : null;
                        dst.add(ttds.getTimePeriod(index), (Number)(resultVal != null ? resultVal : 0.0), seriesKey, false);
                        prevInsert += step;
                        val = null;
                        size = 0;
                    }
                    ++index;
                }
                ++seriesIndex;
            }
            return dst;
        }
        if (src instanceof FixedLengthTimeSeriesCollection) {
            FixedLengthTimeSeriesCollection tsc = (FixedLengthTimeSeriesCollection)src;
            TimeSeriesCollection dst = new TimeSeriesCollection(TimeZone.getTimeZone("UTC"));
            int seriesIndex = 0;
            for (Object tsO : tsc.getSeries()) {
                FixedLengthTimeSeries ts = (FixedLengthTimeSeries)tsO;
                TimeSeries dTs = new TimeSeries(ts.getKey());
                int itemCount = ts.getItemCount();
                double ratio = (double)maxItems / (double)itemCount;
                double step = 1.0;
                if (ratio < 1.0) {
                    step = 1.0 / ratio;
                }
                double prevInsert = 0.0;
                int index = 0;
                Double val = null;
                int size = 0;
                int i = 0;
                while (i < ts.getItemCount()) {
                    int nextIndex = (int)(prevInsert + step);
                    double yValue = tsc.getYValue(seriesIndex, i);
                    if (Double.isFinite(yValue)) {
                        val = val != null ? val + yValue : yValue;
                        ++size;
                    }
                    if (nextIndex == index || index == itemCount - 1) {
                        Double resultVal = val != null ? Double.valueOf(val / (double)size) : null;
                        Number xValue = tsc.getX(seriesIndex, i);
                        dTs.addOrUpdate((RegularTimePeriod)JRJFreeChartCopyCustomizer.toSecond(xValue.longValue()), (Number)resultVal);
                        prevInsert += step;
                        val = null;
                        size = 0;
                    }
                    ++index;
                    ++i;
                }
                dst.addSeries(dTs);
                ++seriesIndex;
            }
            return dst;
        }
        if (src instanceof FixedLengthTimeTableXYDataset) {
            FixedLengthTimeTableXYDataset ttds = (FixedLengthTimeTableXYDataset)src;
            TimeTableXYDataset dst = new TimeTableXYDataset(TimeZone.getTimeZone("UTC"));
            int seriesIndex = 0;
            while (seriesIndex < ttds.getSeriesCount()) {
                Comparable seriesKey = ttds.getSeriesKey(seriesIndex);
                int itemCount = ttds.getItemCount();
                double ratio = (double)maxItems / (double)itemCount;
                double step = 1.0;
                if (ratio < 1.0) {
                    step = 1.0 / ratio;
                }
                double prevInsert = 0.0;
                Double val = null;
                int size = 0;
                int index = 0;
                while (index < itemCount) {
                    Number yValue = ttds.getY(seriesIndex, index);
                    int nextIndex = (int)(prevInsert + step);
                    if (yValue != null && Double.isFinite(yValue.doubleValue())) {
                        val = val != null ? val + yValue.doubleValue() : yValue.doubleValue();
                        ++size;
                    }
                    if (nextIndex == index || index == itemCount - 1) {
                        Double resultVal = val != null ? Double.valueOf(val / (double)size) : null;
                        dst.add((TimePeriod)JRJFreeChartCopyCustomizer.toSecond(ttds.getX(seriesIndex, index).longValue()), (Number)(resultVal != null ? resultVal : 0.0), seriesKey, false);
                        prevInsert += step;
                        val = null;
                        size = 0;
                    }
                    ++index;
                }
                ++seriesIndex;
            }
            return dst;
        }
        return src;
    }

    private static Second toSecond(long endTimestamp) {
        LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(endTimestamp), ZoneOffset.UTC);
        Day day = new Day(ldt.getDayOfMonth(), ldt.getMonthValue(), ldt.getYear());
        Hour hour = new Hour(ldt.getHour(), day);
        Minute minute = new Minute(ldt.getMinute(), hour);
        return new Second(ldt.getSecond(), minute);
    }
}

