/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.report.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.report.ReportProfileDAO;
import de.elpro.ewms.core.client.report.ReportTemplateDAO;
import de.elpro.ewms.core.client.resources.ResourceDirectoryDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.tables.TableDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.model.IExportable;
import de.elpro.ewms.core.fx.tables.VarTableView;
import de.elpro.ewms.core.report.ReportItemGroupType;
import de.elpro.ewms.core.report.ReportProfile;
import de.elpro.ewms.core.report.ReportTemplate;
import de.elpro.ewms.core.report.TableReport;
import de.elpro.ewms.core.report.TableReportConfig;
import de.elpro.ewms.core.resources.ResourceDirectory;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.gui.report.Messages;
import de.elpro.ewms.gui.report.model.PDFExportDialog;
import de.elpro.ewms.gui.report.utils.PdfUtils;
import de.elpro.ui.fx.utils.ColumnsPersistedState;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.control.TableView;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;

public class ExportReportProfileHandler {
    private ReportProfile profile;

    public ExportReportProfileHandler(ReportProfile profile) {
        this.profile = profile;
    }

    @Execute
    public void execute(MApplication app, Stage stage, ITimeRangeFilter timeRangeFilter) {
        List<PdfUtils.ReportElement> reportStructure;
        ReportTemplate reportTemplate;
        ResourceDirectory defaultRD = ResourceDirectory.LOCAL_FS;
        ArrayList<ResourceDirectory> resourceDirectories = new ArrayList<ResourceDirectory>();
        Transaction trx = Transactions.begin();
        try {
            try {
                reportTemplate = ReportTemplateDAO.get((Transaction)trx, (int)this.profile.getTemplate().getId());
                reportStructure = ExportReportProfileHandler.createReportStructure(trx, this.profile, timeRangeFilter, stage.getOwner());
                resourceDirectories.add(defaultRD);
                Collections.addAll(resourceDirectories, ResourceDirectoryDAO.getAll((Transaction)trx));
            }
            catch (Exception exc) {
                ExceptionDialog dlg2 = new ExceptionDialog((Throwable)exc);
                dlg2.setContentText(Messages.report_ExportReportProfileHandler_Error_occured_during_loading);
                dlg2.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PDFExportDialog dialog = new PDFExportDialog(stage, reportTemplate, Arrays.asList(reportTemplate), defaultRD, resourceDirectories, dlg -> PdfUtils.export(this.profile.getName(), new ByteArrayInputStream(dlg.getTemplate().getData()), reportStructure, dlg.getReportParameters()));
        dialog.setInitialFileName(String.valueOf(this.profile.getName().replace('\\', '-').replace('/', '-')) + ".pdf");
        dialog.show();
    }

    private static List<PdfUtils.ReportElement> createReportStructure(Transaction trx, ReportProfile profile, ITimeRangeFilter timeRangeFilter, Window window) throws Exception {
        profile = ReportProfileDAO.loadNormalized((Transaction)trx, (int)profile.getId());
        LinkedList<PdfUtils.ReportElement> rootElements = new LinkedList<PdfUtils.ReportElement>();
        if (profile.getGroupBy() == ReportItemGroupType.Object) {
            StructureObject[] rootObjects;
            StructureObject[] structureObjectArray = rootObjects = StructureClassDAO.getAllObjects((Transaction)trx, (int)profile.getStructureClass().getId());
            int n = rootObjects.length;
            int n2 = 0;
            while (n2 < n) {
                StructureObject rootObject = structureObjectArray[n2];
                PdfUtils.ReportElement rootElement = new PdfUtils.ReportElement(rootObject.toString(), null);
                for (TableReport tableReport : profile.getTableReports()) {
                    for (TableReportConfig config : tableReport.getConfigs().stream().filter(c -> c.getStructureObject().equals((Object)rootObject)).collect(Collectors.toList())) {
                        if (!config.isEnabled()) continue;
                        VarTableView vtv = new VarTableView(TableDAO.loadNormalized((Transaction)trx, (int)tableReport.getTable().getId()), rootObject, window, timeRangeFilter, tableReport.getVirtualRaster());
                        vtv.reloadData().get();
                        TableView tableView = vtv.getReportObject();
                        if (config.getConfig() != null) {
                            try {
                                ColumnsPersistedState state = ColumnsPersistedState.parse((String)config.getConfig());
                                if (state != null) {
                                    state.restoreColumnsState(tableView.getColumns());
                                }
                            }
                            catch (Exception exc) {
                                exc.printStackTrace();
                            }
                        }
                        String reportElementName = tableReport.getTable().getLocalName();
                        rootElement.getChildren().add(new PdfUtils.ReportElement(reportElementName, (IExportable)vtv));
                    }
                }
                rootElements.add(rootElement);
                ++n2;
            }
        }
        return rootElements;
    }
}

