/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.report.handlers;

import de.elpro.ewms.core.fx.excel.ExcelUtils;
import de.elpro.ewms.core.fx.model.IExportable;
import de.elpro.ewms.gui.report.Messages;
import de.elpro.ewms.gui.utils.ExportUtils;
import de.elpro.ui.concurrent.CallableTask;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import javafx.application.Platform;
import javafx.stage.Stage;
import javax.inject.Named;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;

public class ExportToExcelHandler {
    @Execute
    public void execute(final @Named(value="exportable-items") @Named(value="exportable-items") List<IExportable> exportItems, final MPart part, final Stage stage) {
        String exportDescription = Messages.report_ExportItemToExcelHandler_EXCEL_files;
        String initialFileName = String.valueOf(part.getLabel().replace('\\', '-').replace('/', '-')) + ".xls";
        CallableTask<byte[]> exportTask = new CallableTask<byte[]>(){
            {
                this.updateTitle(Messages.report_ExportItemToExcelHandler_Exporting);
            }

            public byte[] call() throws Exception {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (HSSFWorkbook workbook = new HSSFWorkbook();){
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        this.updateProgress(0L, exportItems.size());
                        int progress = 0;
                        HashSet<String> labels = new HashSet<String>();
                        for (IExportable exportable : exportItems) {
                            String label = exportable.getReportLabel();
                            if (label == null || label.isEmpty()) {
                                label = part.getLabel();
                            }
                            if (labels.contains(label = label.replace('\\', '-').replace('/', '-'))) {
                                label = String.valueOf(label) + " #" + progress;
                            } else {
                                labels.add(label);
                            }
                            Object exportableObject = exportable.getReportObject();
                            if (ExcelUtils.isExportSupported((Object)exportableObject)) {
                                Sheet sheet = null;
                                try {
                                    sheet = workbook.createSheet(label);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    sheet = workbook.createSheet(String.valueOf(label.substring(0, Math.min(25, label.length()))) + "\u2026#" + progress);
                                }
                                ExcelUtils.export((Object)exportable.getReportObject(), (Sheet)sheet);
                            }
                            this.updateProgress(++progress, exportItems.size());
                        }
                        workbook.write((OutputStream)os);
                        return os.toByteArray();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exc) {
                    Platform.runLater(() -> {
                        ExceptionDialog eDlg = new ExceptionDialog((Throwable)exc);
                        eDlg.initOwner(stage.getScene().getWindow());
                        eDlg.show();
                    });
                    return null;
                }
            }
        };
        ExportUtils.exportFile((Stage)stage, (String)initialFileName, (String)exportDescription, (String)"*.xls", (CallableTask)exportTask);
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="exportable-items") @Named(value="exportable-items") List<IExportable> exportItems) {
        if (exportItems == null || exportItems.isEmpty()) {
            return false;
        }
        for (IExportable exportable : exportItems) {
            if (!ExcelUtils.isExportSupported((Object)exportable.getReportObject())) continue;
            return true;
        }
        return false;
    }
}

