/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.report.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.report.ReportTemplateDAO;
import de.elpro.ewms.core.client.resources.ResourceDirectoryDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.model.IExportable;
import de.elpro.ewms.core.report.ReportTemplate;
import de.elpro.ewms.core.resources.ResourceDirectory;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.gui.report.model.PDFExportDialog;
import de.elpro.ewms.gui.report.utils.PdfUtils;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.stage.Stage;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;

public class ExportToPDFHandler {
    @Execute
    public void execute(@Named(value="exportable-items") @Named(value="exportable-items") List<IExportable> exportItems, StructureObject object, MPart part, Stage stage) {
        ReportTemplate defaultTemplate;
        ReportTemplate[] templates;
        PdfUtils.ReportElement rootElement = new PdfUtils.ReportElement(object.toString(), null);
        for (IExportable exportItem : exportItems) {
            String title = exportItem.getReportLabel();
            rootElement.getChildren().add(new PdfUtils.ReportElement(title, exportItem));
        }
        Transaction trx = Transactions.begin();
        ResourceDirectory defaultRD = ResourceDirectory.LOCAL_FS;
        ArrayList<ResourceDirectory> resourceDirectories = new ArrayList<ResourceDirectory>();
        try {
            templates = ReportTemplateDAO.getAll((Transaction)trx);
            defaultTemplate = templates.length > 0 ? templates[0] : null;
            resourceDirectories.add(defaultRD);
            Collections.addAll(resourceDirectories, ResourceDirectoryDAO.getAll((Transaction)trx));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PDFExportDialog dialog = new PDFExportDialog(stage, defaultTemplate, Arrays.asList(templates), defaultRD, resourceDirectories, dlg -> PdfUtils.export(part.getLabel(), new ByteArrayInputStream(dlg.getTemplate().getData()), Collections.singletonList(rootElement), dlg.getReportParameters()));
        dialog.setInitialFileName(String.valueOf(part.getLabel().replace('\\', '-').replace('/', '-')) + ".pdf");
        dialog.show();
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="exportable-items") @Named(value="exportable-items") List<IExportable> exportItems) {
        return exportItems != null && !exportItems.isEmpty();
    }
}

