/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.report.model;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.auth.UserDAO;
import de.elpro.ewms.core.client.resources.ResourceDirectoryDAO;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.report.ReportTemplate;
import de.elpro.ewms.core.resources.ResourceDirectory;
import de.elpro.ewms.gui.Messages;
import de.elpro.ewms.gui.dialogs.ResourceDirectoryBrowser;
import de.elpro.ewms.gui.report.handlers.ChartDataItemToPixelRatio;
import de.elpro.ewms.gui.utils.ExportUtils;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.controlsfx.propertysheet.SeparatorItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.utils.TaskUtils;
import de.elpro.ui.fx.validator.Validators;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class PDFExportDialog
extends Dialog<ButtonType> {
    private static final IEclipsePreferences PREFERENCES = InstanceScope.INSTANCE.getNode("ExportDialogProperties");
    public static final FileChooser.ExtensionFilter PDF_EXTENSION_FILTER = new FileChooser.ExtensionFilter(de.elpro.ewms.gui.report.Messages.report_ExportReportProfileHandler_PDF_files, new String[]{"*.pdf"});
    private final SimpleObjectProperty<ReportTemplate> template = new SimpleObjectProperty();
    private final SimpleObjectProperty<User> user = new SimpleObjectProperty();
    private final SimpleStringProperty documentNr = new SimpleStringProperty();
    private final SimpleStringProperty documentName = new SimpleStringProperty();
    private final SimpleStringProperty documentTitle = new SimpleStringProperty();
    private final SimpleStringProperty documentInfoText = new SimpleStringProperty();
    private final SimpleObjectProperty<ChartDataItemToPixelRatio> dataItemToPixelRatio = new SimpleObjectProperty((Object)ChartDataItemToPixelRatio.X_1to8);
    private final SimpleObjectProperty<ResourceDirectory> resourceDirectory = new SimpleObjectProperty((Object)ResourceDirectory.LOCAL_FS);
    private final SimpleStringProperty initialFileName = new SimpleStringProperty();
    private final PropertySheet reportPropertiesSheet;
    private final ObservableBooleanValue propertiesSheetHasErrors;
    private ResourceDirectoryBrowser resourceDirectoryBrowser;

    public PDFExportDialog(Stage stage, ReportTemplate defaultTemplate, Collection<ReportTemplate> templates, ResourceDirectory defaultResourceDirectory, Collection<ResourceDirectory> resourceDirectories, PDFReportDataCallback exportDataCallback) {
        int resourceDirId;
        this.initOwner(stage.getScene().getWindow());
        this.setResizable(true);
        this.setTitle(de.elpro.ewms.gui.report.Messages.report_ExportPropertiesDialog_Export_Properties);
        this.documentNr.set(PREFERENCES.get("documentNr", null));
        this.documentName.set(PREFERENCES.get("documentName", null));
        this.documentTitle.set(PREFERENCES.get("documentTitle", null));
        this.documentInfoText.set(PREFERENCES.get("documentInfoText", null));
        this.dataItemToPixelRatio.set((Object)ChartDataItemToPixelRatio.values()[PREFERENCES.getInt("dataItemToPixelRatio", ChartDataItemToPixelRatio.X_1to8.ordinal())]);
        int templateNr = PREFERENCES.getInt("template_id", -1);
        if (templateNr >= 0) {
            for (ReportTemplate template : templates) {
                if (!Integer.valueOf(templateNr).equals(template.getId())) continue;
                defaultTemplate = template;
                break;
            }
        }
        if ((resourceDirId = PREFERENCES.getInt("resoure_directory_id", -1)) >= 0) {
            for (ResourceDirectory resDir : resourceDirectories) {
                if (!Integer.valueOf(resourceDirId).equals(resDir.getId())) continue;
                defaultResourceDirectory = resDir;
                break;
            }
        }
        this.template.set((Object)defaultTemplate);
        this.user.set((Object)UserDAO.get());
        this.resourceDirectory.set((Object)defaultResourceDirectory);
        this.reportPropertiesSheet = this.createReportPropertiesNode(defaultTemplate, templates, defaultResourceDirectory, resourceDirectories);
        this.propertiesSheetHasErrors = PropertyItemsHelper.createHasErrorsProperty((Collection)this.reportPropertiesSheet.getItems());
        this.showPropertiesPane();
        this.setOnCloseRequest(event -> {
            if (event.getSource() != null) {
                if (this.getTemplate() != null && this.getTemplate().getId() != null) {
                    PREFERENCES.putInt("template_id", this.getTemplate().getId().intValue());
                }
                PREFERENCES.put("documentNr", this.getDocumentNr() != null ? this.getDocumentNr() : "");
                PREFERENCES.put("documentName", this.getDocumentName() != null ? this.getDocumentName() : "");
                PREFERENCES.put("documentTitle", this.getDocumentTitle() != null ? this.getDocumentTitle() : "");
                PREFERENCES.put("documentInfoText", this.getInfoText() != null ? this.getInfoText() : "");
                PREFERENCES.putInt("dataItemToPixelRatio", this.getDataItemToPixelRatio().ordinal());
                PREFERENCES.putInt("resoure_directory_id", this.getResourceDirectory().getId() != null ? this.getResourceDirectory().getId() : -1);
                try {
                    PREFERENCES.flush();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
            if (this.getResult() == ButtonType.CANCEL) {
                return;
            }
            if (this.getResourceDirectory() == ResourceDirectory.LOCAL_FS) {
                if (this.getResult() == ButtonType.OK) {
                    FileChooser fileChooser = new FileChooser();
                    fileChooser.getExtensionFilters().add((Object)PDF_EXTENSION_FILTER);
                    fileChooser.setInitialFileName(this.getInitialFileName().replace('\\', '-').replace('/', '-'));
                    fileChooser.setInitialDirectory(ExportUtils.getDefaultExportFolder());
                    File file = fileChooser.showSaveDialog((Window)stage);
                    if (file != null) {
                        TaskUtils.executeTask(exportDataCallback.exportTask(this)).consumeResult((status, bytes) -> Platform.runLater(() -> {
                            if (status == Worker.State.SUCCEEDED && bytes != null) {
                                PDFExportDialog.writeDataToFile(stage, file, bytes);
                            }
                        }));
                    } else {
                        event.consume();
                    }
                }
            } else {
                if (this.getResult() != ButtonType.OK) {
                    event.consume();
                    return;
                }
                String fileName = this.resourceDirectoryBrowser.getFileName();
                String[] path = this.resourceDirectoryBrowser.getFolder().getPath();
                Transaction trx = Transactions.begin();
                try {
                    if (ResourceDirectoryDAO.checkFileExists((Transaction)trx, (ResourceDirectory)this.getResourceDirectory(), (String)fileName, (String[])path) == Boolean.TRUE) {
                        Transactions.close((Transaction)trx);
                        trx = null;
                        Alert replafeFileDialog = new Alert(Alert.AlertType.CONFIRMATION);
                        replafeFileDialog.initOwner(stage.getScene().getWindow());
                        replafeFileDialog.setContentText(Messages.report_utils_fileExistsReplace);
                        if (replafeFileDialog.showAndWait().get() != ButtonType.OK) {
                            event.consume();
                            return;
                        }
                    }
                }
                catch (Exception exc) {
                    ExceptionDialog excDlg = new ExceptionDialog((Throwable)exc);
                    excDlg.initOwner(stage.getScene().getWindow());
                    excDlg.show();
                    event.consume();
                    return;
                }
                finally {
                    if (trx != null) {
                        Transactions.close((Transaction)trx);
                    }
                }
                TaskUtils.executeTask(exportDataCallback.exportTask(this)).consumeResult((status, bytes) -> {
                    if (status == Worker.State.SUCCEEDED && bytes != null) {
                        OperationResult result;
                        Transaction t = Transactions.begin();
                        try {
                            result = ResourceDirectoryDAO.storeFile((byte[])bytes, (Transaction)t, (ResourceDirectory)this.getResourceDirectory(), (String)fileName, (String[])path);
                        }
                        finally {
                            Transactions.close((Transaction)t);
                        }
                        Platform.runLater(() -> {
                            if (result.getType() == ResultType.Success) {
                                Alert info = new Alert(Alert.AlertType.INFORMATION);
                                info.initOwner(stage.getScene().getWindow());
                                info.setContentText(de.elpro.ewms.gui.report.Messages.PDF_file_exported_successfully);
                                info.show();
                            } else {
                                Alert info = new Alert(Alert.AlertType.ERROR);
                                info.initOwner(stage.getScene().getWindow());
                                info.setContentText(result.getMessage());
                                info.show();
                            }
                        });
                    }
                });
            }
        });
    }

    private static void writeDataToFile(Stage stage, File file, byte[] bytes) {
        block13: {
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(file);
                    fos.write(bytes);
                    if (ExportUtils.STORE_EXPORT_FOLDER) {
                        ExportUtils.setDefaultExportFolderPath((String)file.getParentFile().getPath());
                    }
                    Alert info = new Alert(Alert.AlertType.INFORMATION);
                    info.initOwner(stage.getScene().getWindow());
                    info.setContentText(de.elpro.ewms.gui.report.Messages.PDF_file_exported_successfully);
                    info.show();
                }
                catch (Exception exc) {
                    ExceptionDialog excDlg = new ExceptionDialog((Throwable)exc);
                    excDlg.initOwner(stage.getScene().getWindow());
                    excDlg.setHeaderText(de.elpro.ewms.gui.report.Messages.report_ExportReportProfileHandler_Error);
                    excDlg.setContentText(de.elpro.ewms.gui.report.Messages.handlers_ExportReportProfileHandler_handlers_ExportReportProfileHandler_UnhandledErrorAtSavingOfPdfFile);
                    excDlg.show();
                    if (fos == null) break block13;
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void showPropertiesPane() {
        DialogPane dialogPane = this.getDialogPane();
        dialogPane.setContent((Node)this.reportPropertiesSheet);
        this.updatePropertiesPaneButtons();
    }

    private void updatePropertiesPaneButtons() {
        Button actionButton;
        if (this.getResourceDirectory() == ResourceDirectory.LOCAL_FS) {
            this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
            actionButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        } else {
            this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.NEXT, ButtonType.CANCEL});
            actionButton = (Button)this.getDialogPane().lookupButton(ButtonType.NEXT);
            actionButton.setOnAction(e -> this.showRemoteDirectoryExplorerPane(this.getResourceDirectory()));
        }
        actionButton.disableProperty().bind((ObservableValue)this.propertiesSheetHasErrors);
    }

    private void showRemoteDirectoryExplorerPane(ResourceDirectory resourceDirectory) {
        this.resourceDirectoryBrowser = new ResourceDirectoryBrowser(resourceDirectory, this.getInitialFileName().replace('\\', '-').replace('/', '-'));
        DialogPane dialogPane = this.getDialogPane();
        dialogPane.setContent((Node)this.resourceDirectoryBrowser);
        this.updateRemoteDirectoryPaneButtons();
    }

    private void updateRemoteDirectoryPaneButtons() {
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.PREVIOUS, ButtonType.OK, ButtonType.CANCEL});
        Button prevButton = (Button)this.getDialogPane().lookupButton(ButtonType.PREVIOUS);
        Button okButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        okButton.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableStringValue)this.resourceDirectoryBrowser.fileNameProperty()));
        prevButton.setOnAction(e -> this.showPropertiesPane());
    }

    private PropertySheet createReportPropertiesNode(ReportTemplate defaultTemplate, Collection<ReportTemplate> templates, ResourceDirectory defaultResourceDirectory, Collection<ResourceDirectory> resourceDirectories) {
        PropertySheet sheet = new PropertySheet();
        sheet.setPrefHeight(470.0);
        sheet.setPrefWidth(800.0);
        ChoicePropertyItem templateItem = new ChoicePropertyItem(de.elpro.ewms.gui.report.Messages.report_ExportPropertiesDialog_Template, this.template, templates);
        templateItem.setReadOnly(templates.size() <= 1);
        templateItem.setNullable(false);
        templateItem.setValidator(Validators.createNotEmptyValidator((String)de.elpro.ewms.gui.report.Messages.report_ExportPropertiesDialog_Select_Template));
        sheet.getItems().add((Object)templateItem);
        sheet.getItems().add((Object)new ChoicePropertyItem(de.elpro.ewms.gui.report.Messages.report_ExportPropertiesDialog_Username, this.user));
        sheet.getItems().add((Object)new StringPropertyItem(de.elpro.ewms.gui.report.Messages.report_ExportPropertiesDialog_Document_Nr, (ObservableValue)this.documentNr));
        sheet.getItems().add((Object)new StringPropertyItem(de.elpro.ewms.gui.report.Messages.report_ExportPropertiesDialog_Document_Name, (ObservableValue)this.documentName));
        sheet.getItems().add((Object)new StringPropertyItem(de.elpro.ewms.gui.report.Messages.report_ExportPropertiesDialog_Document_Title, (ObservableValue)this.documentTitle));
        StringPropertyItem descriptionItem = new StringPropertyItem(de.elpro.ewms.gui.report.Messages.report_ExportPropertiesDialog_Document_Info_Text, (ObservableValue)this.documentInfoText);
        descriptionItem.useAreaEditor(true);
        sheet.getItems().add((Object)descriptionItem);
        EnumPropertyItem ratio = new EnumPropertyItem(de.elpro.ewms.gui.report.Messages.report_ExportPropertiesDialog_ChartDataItemToPixelRatio, ChartDataItemToPixelRatio.class, this.dataItemToPixelRatio);
        ratio.setNullable(false);
        sheet.getItems().add((Object)ratio);
        sheet.getItems().add((Object)new SeparatorItem());
        ChoicePropertyItem resourceDirectoryItem = new ChoicePropertyItem(Messages.report_utils_saveDestination, this.resourceDirectory, resourceDirectories);
        resourceDirectoryItem.setReadOnly(resourceDirectories.size() <= 1);
        resourceDirectoryItem.setNullable(false);
        resourceDirectoryItem.valueProperty().addListener(il -> this.updatePropertiesPaneButtons());
        sheet.getItems().add((Object)resourceDirectoryItem);
        return sheet;
    }

    public String getInitialFileName() {
        return this.initialFileName.get();
    }

    public void setInitialFileName(String initialFileName) {
        this.initialFileName.set(initialFileName);
    }

    public User getUser() {
        return (User)this.user.get();
    }

    public String getDocumentNr() {
        return this.documentNr.get();
    }

    public String getDocumentName() {
        return this.documentName.get();
    }

    public String getInfoText() {
        return this.documentInfoText.get();
    }

    public String getDocumentTitle() {
        return this.documentTitle.get();
    }

    public ReportTemplate getTemplate() {
        return (ReportTemplate)this.template.get();
    }

    public ChartDataItemToPixelRatio getDataItemToPixelRatio() {
        return (ChartDataItemToPixelRatio)((Object)this.dataItemToPixelRatio.get());
    }

    public ResourceDirectory getResourceDirectory() {
        return (ResourceDirectory)this.resourceDirectory.get();
    }

    public Map<String, Object> getReportParameters() {
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put("documentNr", this.getDocumentNr());
        reportParameters.put("documentName", this.getDocumentName());
        reportParameters.put("documentTitle", this.getDocumentTitle());
        reportParameters.put("documentInfoText", this.getInfoText());
        reportParameters.put("user", this.getUser().toString());
        reportParameters.put("dataItemToPixelRatio", this.getDataItemToPixelRatio().getScale());
        return reportParameters;
    }

    public static interface PDFReportDataCallback {
        public CallableTask<byte[]> exportTask(PDFExportDialog var1);
    }
}

