/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.report.utils;

import de.elpro.ewms.core.fx.model.IExportable;
import de.elpro.ewms.core.fx.tables.VarTableCellData;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.gui.report.Messages;
import de.elpro.ewms.gui.report.handlers.ChartDataItemToPixelRatio;
import de.elpro.ewms.gui.report.model.ExportableReportData;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.formats.TimeFormatType;
import de.elpro.ui.fx.utils.FXUtils;
import java.awt.Color;
import java.awt.Font;
import java.io.InputStream;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableView;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Paint;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.charts.design.JRDesignCategorySeries;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.charts.design.JRDesignPieSeries;
import net.sf.jasperreports.charts.design.JRDesignTimeSeries;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesDataset;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignBreak;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.BreakTypeEnum;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRLoader;
import org.controlsfx.dialog.ExceptionDialog;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.Second;

public class PdfUtils {
    private static final Color WHITE_ROW = Color.WHITE;
    private static final Color WHITE_ROW_ODD = new Color(230, 230, 230);

    public static CallableTask<byte[]> export(String reportName, final InputStream templateIS, final List<ReportElement> reportStructure, final Map<String, Object> reportParameters) {
        final float fontSize = 7.0f;
        CallableTask<byte[]> task = new CallableTask<byte[]>(reportName){
            {
                this.updateTitle(String.format(Messages.report_PdfUtils_Exporting, string));
            }

            public byte[] call() throws Exception {
                try {
                    boolean addNavigation;
                    JRSubreport subreport = null;
                    JasperReport template = (JasperReport)JRLoader.loadObject((InputStream)templateIS);
                    JRBand[] jRBandArray = template.getAllBands();
                    int n = jRBandArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRBand band = jRBandArray[n2];
                        JRElement[] jRElementArray = band.getElements();
                        int n3 = jRElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            JRElement el = jRElementArray[n4];
                            if (el instanceof JRSubreport && "$P{content}".equals(((JRSubreport)el).getExpression().getText())) {
                                subreport = (JRSubreport)el;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    int maxContentHeight = template.getPageHeight() - template.getTopMargin() - template.getBottomMargin();
                    if (template.getPageHeader() != null) {
                        maxContentHeight -= template.getPageHeader().getHeight();
                    }
                    if (template.getPageFooter() != null) {
                        maxContentHeight -= template.getPageFooter().getHeight();
                    }
                    JasperDesign contentReportDesign = new JasperDesign();
                    contentReportDesign.setTopMargin(0);
                    contentReportDesign.setRightMargin(0);
                    contentReportDesign.setBottomMargin(0);
                    contentReportDesign.setLeftMargin(0);
                    contentReportDesign.setName(Messages.report_PdfUtils_Content_Report);
                    contentReportDesign.setPageWidth(subreport.getWidth());
                    JRDesignField field = new JRDesignField();
                    field.setName("subreport");
                    field.setValueClass(JasperReport.class);
                    contentReportDesign.addField((JRField)field);
                    field = new JRDesignField();
                    field.setName("contentData");
                    field.setValueClass(List.class);
                    contentReportDesign.addField((JRField)field);
                    JRDesignBand subReportBand = new JRDesignBand();
                    subReportBand.setHeight(20);
                    JRDesignSubreport subSubReport = new JRDesignSubreport(subreport.getDefaultStyleProvider());
                    subSubReport.setExpression((JRExpression)new JRDesignExpression("$F{subreport}"));
                    subSubReport.setDataSourceExpression((JRExpression)new JRDesignExpression("new net.sf.jasperreports.engine.data.JRBeanCollectionDataSource($F{contentData})"));
                    subSubReport.setStretchType(StretchTypeEnum.CONTAINER_HEIGHT);
                    subReportBand.addElement((JRDesignElement)subSubReport);
                    List<ReportElement> flatReportStructure = PdfUtils.toFlatStructure(reportStructure);
                    boolean bl = addNavigation = flatReportStructure.stream().filter(e -> e.getExportable() != null).count() > 1L;
                    if (!addNavigation) {
                        flatReportStructure = flatReportStructure.stream().filter(e -> e.getExportable() != null).collect(Collectors.toList());
                        if (template.getTitle() != null) {
                            maxContentHeight -= template.getTitle().getHeight();
                        }
                    }
                    this.updateProgress(0L, flatReportStructure.size() + 1);
                    int progress = 0;
                    LinkedList<ExportableReportData> contentParams = new LinkedList<ExportableReportData>();
                    if (addNavigation) {
                        contentParams.add(PdfUtils.createObjectNavigation(reportStructure, subreport.getWidth(), fontSize));
                    }
                    for (ReportElement reportElement : flatReportStructure) {
                        Object exportableObject;
                        String title = reportElement.getTitle();
                        if (title != null && !title.isEmpty()) {
                            this.updateMessage(String.format(Messages.report_PdfUtils_Exporting, title));
                        }
                        Object object = exportableObject = reportElement.getExportable() != null ? reportElement.getExportable().getReportObject() : null;
                        if (exportableObject instanceof TableView || exportableObject instanceof TreeTableView) {
                            contentParams.add(PdfUtils.createTableSubreport(reportElement.getNaviPrefix(), title, (Control)exportableObject, subreport.getWidth(), fontSize));
                        } else if (exportableObject instanceof JFreeChart) {
                            JFreeChart chart = (JFreeChart)exportableObject;
                            Double dataItemToPixelRatio = (Double)reportParameters.get("dataItemToPixelRatio");
                            contentParams.add(PdfUtils.createChartSubreport(reportElement.getNaviPrefix(), title, chart, subreport.getWidth(), maxContentHeight, fontSize, dataItemToPixelRatio));
                        } else if (exportableObject == null && addNavigation) {
                            contentParams.add(PdfUtils.createEmptySubreport(reportElement.getNaviPrefix(), title, subreport.getWidth(), fontSize));
                        }
                        this.updateProgress(++progress, flatReportStructure.size() + 1);
                    }
                    this.updateMessage(Messages.report_PdfUtils_Compile_and_fill_report);
                    ((JRDesignSection)contentReportDesign.getDetailSection()).addBand((JRBand)subReportBand);
                    JasperReport contentReport = JasperCompileManager.compileReport((JasperDesign)contentReportDesign);
                    Map parameters = reportParameters != null ? reportParameters : new HashMap();
                    parameters.put("content", contentReport);
                    parameters.put("contentParams", contentParams);
                    JasperPrint print = JasperFillManager.fillReport((JasperReport)template, (Map)parameters, (JRDataSource)new JRBeanArrayDataSource(new Object[1]));
                    byte[] bytes = JasperExportManager.exportReportToPdf((JasperPrint)print);
                    this.updateMessage(null);
                    this.updateProgress(flatReportStructure.size() + 1, flatReportStructure.size() + 1);
                    return bytes;
                }
                catch (Exception exc) {
                    Platform.runLater(() -> {
                        ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                        dlg.setHeaderText(Messages.report_PdfUtils_Error);
                        dlg.setContentText(Messages.utils_PdfUtils_UnhandledErrorAtCreatingOfReport);
                        dlg.show();
                    });
                    return null;
                }
            }
        };
        return task;
    }

    private static List<ReportElement> toFlatStructure(List<ReportElement> hierarchicalStructure) {
        LinkedList<ReportElement> flatStructure = new LinkedList<ReportElement>();
        for (ReportElement rs : hierarchicalStructure) {
            flatStructure.add(rs);
            flatStructure.addAll(PdfUtils.toFlatStructure(rs.getChildren()));
        }
        return flatStructure;
    }

    private static ExportableReportData createObjectNavigation(List<ReportElement> reportElemenets, int width, float fontSize) throws JRException {
        int rowHeight = ((int)((double)fontSize * 1.2) + 1) * 2;
        JasperDesign subReport = new JasperDesign();
        subReport.setTopMargin(0);
        subReport.setRightMargin(0);
        subReport.setBottomMargin(0);
        subReport.setLeftMargin(0);
        subReport.setName(Messages.utils_PdfUtils_ObjectNavigation);
        JRDesignBand band = new JRDesignBand();
        JRDesignStaticText info = new JRDesignStaticText();
        info.setText(Messages.report_PdfUtils_Inhaltsverzeichnis);
        info.setX(20);
        info.setY(0);
        info.setBold(true);
        info.setHeight(rowHeight);
        info.setWidth(width - 20);
        band.addElement((JRDesignElement)info);
        int height = rowHeight;
        int index = 1;
        for (ReportElement rootElement : reportElemenets) {
            height += PdfUtils.addObjectNavigationElementsRecursive(band, null, index++, 40, height, rootElement, width, rowHeight);
        }
        band.setHeight(height);
        subReport.setSummary((JRBand)band);
        return new ExportableReportData(JasperCompileManager.compileReport((JasperDesign)subReport), Collections.singletonList(new HashMap()));
    }

    private static int addObjectNavigationElementsRecursive(JRDesignBand band, String prefix, int index, int x, int y, ReportElement reportElement, int width, int rowHeight) {
        int height = rowHeight;
        String naviPrefix = String.valueOf(prefix != null ? String.valueOf(prefix) + index : Integer.toString(index)) + ".";
        reportElement.setNaviPrefix(naviPrefix);
        JRDesignTextField naviTextField = new JRDesignTextField();
        String title = reportElement.getTitle();
        if (title != null) {
            title = title.replaceAll("\\\"", "\\\\\"");
        }
        naviTextField.setExpression((JRExpression)new JRDesignExpression(String.format("\"%s %s\"", naviPrefix, title)));
        naviTextField.setX(x);
        naviTextField.setY(y);
        naviTextField.setHeight(height);
        naviTextField.setWidth(width - x);
        naviTextField.setHyperlinkAnchorExpression((JRExpression)new JRDesignExpression(String.format("\"anchor_%s\"", naviPrefix)));
        naviTextField.setHyperlinkType(HyperlinkTypeEnum.LOCAL_ANCHOR);
        band.addElement((JRDesignElement)naviTextField);
        int childIndex = 1;
        for (ReportElement childElement : reportElement.getChildren()) {
            height += PdfUtils.addObjectNavigationElementsRecursive(band, naviPrefix, childIndex++, x + 20, y + height, childElement, width, rowHeight);
        }
        return height;
    }

    private static ExportableReportData createEmptySubreport(String naviPrefix, String title, int width, float fontSize) throws JRException {
        int rowHeight = (int)((double)fontSize * 1.2) + 1;
        JasperDesign subReport = new JasperDesign();
        subReport.setTopMargin(0);
        subReport.setRightMargin(0);
        subReport.setBottomMargin(0);
        subReport.setLeftMargin(0);
        subReport.setName("Name1");
        JRDesignBand band = new JRDesignBand();
        JRDesignBreak breakElement = new JRDesignBreak();
        breakElement.setType(BreakTypeEnum.PAGE);
        breakElement.setX(0);
        breakElement.setY(0);
        breakElement.setHeight(0);
        breakElement.setWidth(width);
        band.addElement((JRDesignElement)breakElement);
        JRDesignTextField titleText = new JRDesignTextField();
        title = PdfUtils.escapeExpressionText(title);
        titleText.setExpression((JRExpression)new JRDesignExpression(String.format("\"%s %s\"", naviPrefix, title)));
        titleText.setX(20);
        titleText.setY(1);
        titleText.setHeight(rowHeight * 2 - 1);
        titleText.setWidth(width - 20);
        titleText.setVerticalTextAlign(VerticalTextAlignEnum.MIDDLE);
        titleText.setBold(true);
        if (naviPrefix != null) {
            titleText.setAnchorNameExpression((JRExpression)new JRDesignExpression(String.format("\"anchor_%s\"", naviPrefix)));
        }
        band.setHeight(titleText.getHeight() + 1);
        band.addElement((JRDesignElement)titleText);
        subReport.setSummary((JRBand)band);
        return new ExportableReportData(JasperCompileManager.compileReport((JasperDesign)subReport), Collections.singletonList(new HashMap()));
    }

    public static ExportableReportData createTableSubreport(Control tableControl, int width, float fontSize) throws JRException {
        return PdfUtils.createTableSubreport(null, null, tableControl, width, fontSize);
    }

    public static ExportableReportData createTableSubreport(String naviPrefix, String title, Control tableControl, int width, float fontSize) throws JRException {
        int rowHeight = (int)((double)fontSize * 1.2) + 1;
        Math.round((double)((float)rowHeight - fontSize) / 2.0);
        JRDesignStyle reportStyle = new JRDesignStyle();
        reportStyle.setName("RootStyle");
        reportStyle.setFontSize(Float.valueOf(fontSize));
        reportStyle.setBlankWhenNull(true);
        reportStyle.setFontName("DejaVu Sans");
        JRDesignStyle headerStyle = new JRDesignStyle();
        headerStyle.setName("HeaderStyle");
        headerStyle.setBold(true);
        headerStyle.setHorizontalTextAlign(HorizontalTextAlignEnum.CENTER);
        headerStyle.setVerticalTextAlign(VerticalTextAlignEnum.MIDDLE);
        headerStyle.setBackcolor(Color.LIGHT_GRAY);
        headerStyle.setMode(ModeEnum.OPAQUE);
        headerStyle.getLineBox().getPen().setLineWidth(0.5f);
        headerStyle.setParentStyle((JRStyle)reportStyle);
        JasperDesign subReport = new JasperDesign();
        subReport.setTopMargin(0);
        subReport.setRightMargin(0);
        subReport.setBottomMargin(0);
        subReport.setLeftMargin(0);
        subReport.setName("Name1");
        subReport.addStyle((JRStyle)reportStyle);
        subReport.addStyle((JRStyle)headerStyle);
        JRDesignDataset tableDataset = new JRDesignDataset(false);
        tableDataset.setName("TableDataset");
        subReport.addDataset(tableDataset);
        JRDesignField tableDataSourceField = new JRDesignField();
        tableDataSourceField.setName("tableDatasource");
        tableDataSourceField.setValueClass(List.class);
        subReport.addField((JRField)tableDataSourceField);
        JRDesignBand band = new JRDesignBand();
        band.setHeight(rowHeight);
        LinkedList rootColumns = new LinkedList();
        if (tableControl instanceof TableView) {
            rootColumns.addAll(((TableView)tableControl).getColumns());
        } else {
            rootColumns.addAll(((TreeTableView)tableControl).getColumns());
        }
        ArrayList<TableColumnBase<?, ?>> leafColumns = PdfUtils.getVisibleLeafColumns(new LinkedList(rootColumns));
        StandardTable table = new StandardTable();
        JRDesignDatasetRun datasetRun = new JRDesignDatasetRun();
        datasetRun.setDatasetName(tableDataset.getName());
        datasetRun.setDataSourceExpression((JRExpression)new JRDesignExpression("new net.sf.jasperreports.engine.data.JRBeanCollectionDataSource($F{tableDatasource})"));
        table.setDatasetRun((JRDatasetRun)datasetRun);
        HashMap columnKeys = new HashMap();
        int columnCounter = 0;
        Map<TableColumnBase<?, ?>, Integer> columnWidthes = PdfUtils.getColumnWidthes(leafColumns, width);
        subReport.setPageHeader(PdfUtils.createHeader(naviPrefix, title, new LinkedList(rootColumns), columnWidthes, width, fontSize, rowHeight, headerStyle));
        HashMap<String, Color> backgroundColors = new HashMap<String, Color>();
        HashMap<String, Color> textColors = new HashMap<String, Color>();
        ArrayList tableData = new ArrayList();
        Label tempStylableNode = PdfUtils.createLabelInFakeTree((Parent)tableControl);
        for (TableColumnBase<?, ?> leafColumn : leafColumns) {
            String columnKey = String.format("column_%d", columnCounter++);
            columnKeys.put(leafColumn, columnKey);
            Object[] columnData = PdfUtils.getControlItems(tableControl, leafColumn);
            int i = 0;
            while (i < columnData.length) {
                Map<String, Map<String, String>> row;
                if (tableData.size() <= i) {
                    row = new HashMap();
                    tableData.add(row);
                } else {
                    row = (Map)tableData.get(i);
                }
                Map<String, String> tableCellRenderingData = PdfUtils.getTableCellRenderingData(tempStylableNode, columnData[i], backgroundColors, textColors);
                row.put((String)columnKeys.get(leafColumn), tableCellRenderingData);
                ++i;
            }
        }
        for (String key : columnKeys.values()) {
            JRDesignField field = new JRDesignField();
            field.setName(key);
            field.setValueClass(Map.class);
            tableDataset.addField((JRField)field);
        }
        HashMap content = new HashMap();
        content.put(tableDataSourceField.getName(), tableData);
        for (TableColumnBase<?, ?> leafColumn : leafColumns) {
            int appearentWidth = columnWidthes.get(leafColumn);
            String columnKey = (String)columnKeys.get(leafColumn);
            StandardColumn sc = new StandardColumn();
            sc.setWidth(Integer.valueOf(appearentWidth));
            DesignCell cell = new DesignCell();
            cell.setHeight(Integer.valueOf(rowHeight));
            JRDesignTextField cellField = new JRDesignTextField();
            cellField.setWidth(appearentWidth);
            cellField.setHeight(rowHeight);
            cellField.setStretchWithOverflow(true);
            cellField.setExpression((JRExpression)new JRDesignExpression(String.format("$F{%s}.get(\"text\")", columnKey)));
            JRDesignConditionalStyle summaryStyle = new JRDesignConditionalStyle();
            summaryStyle.setConditionExpression((JRExpression)new JRDesignExpression(String.format("$F{%s}.get(\"style\").toString().contains(\"summary\")", columnKey)));
            summaryStyle.setBold(true);
            JRDesignConditionalStyle valueStyle = new JRDesignConditionalStyle();
            valueStyle.setConditionExpression((JRExpression)new JRDesignExpression(String.format("$F{%s}.get(\"style\").toString().contains(\"value\")", columnKey)));
            valueStyle.setHorizontalTextAlign(HorizontalTextAlignEnum.RIGHT);
            JRDesignStyle normalCellFieldStyle = new JRDesignStyle();
            normalCellFieldStyle.setName("normal-cell" + columnKey);
            normalCellFieldStyle.setParentStyle((JRStyle)reportStyle);
            normalCellFieldStyle.addConditionalStyle((JRConditionalStyle)summaryStyle);
            normalCellFieldStyle.addConditionalStyle((JRConditionalStyle)valueStyle);
            JRDesignConditionalStyle odStyle = new JRDesignConditionalStyle();
            odStyle.setMode(ModeEnum.OPAQUE);
            odStyle.setConditionExpression((JRExpression)new JRDesignExpression("$V{REPORT_COUNT}%2 == 0"));
            odStyle.setBackcolor(new Color(240, 240, 240));
            for (Map.Entry entry : backgroundColors.entrySet()) {
                JRDesignConditionalStyle backgroundColorStyle = new JRDesignConditionalStyle();
                backgroundColorStyle.setMode(ModeEnum.OPAQUE);
                backgroundColorStyle.setConditionExpression((JRExpression)new JRDesignExpression(String.format("$F{%s}.get(\"background-color\").toString().contains(\"%s\")  && $V{REPORT_COUNT}%%2 == 1", columnKey, entry.getKey())));
                backgroundColorStyle.setBackcolor((Color)entry.getValue());
                normalCellFieldStyle.addConditionalStyle((JRConditionalStyle)backgroundColorStyle);
                JRDesignConditionalStyle backgroundColorOddStyle = new JRDesignConditionalStyle();
                backgroundColorOddStyle.setMode(ModeEnum.OPAQUE);
                backgroundColorOddStyle.setConditionExpression((JRExpression)new JRDesignExpression(String.format("$F{%s}.get(\"background-color-odd\").toString().contains(\"%s\") && $V{REPORT_COUNT}%%2 == 0", columnKey, entry.getKey())));
                backgroundColorOddStyle.setBackcolor((Color)entry.getValue());
                normalCellFieldStyle.addConditionalStyle((JRConditionalStyle)backgroundColorOddStyle);
            }
            for (Map.Entry entry : textColors.entrySet()) {
                JRDesignConditionalStyle textColorStyle = new JRDesignConditionalStyle();
                textColorStyle.setMode(ModeEnum.OPAQUE);
                textColorStyle.setConditionExpression((JRExpression)new JRDesignExpression(String.format("$F{%s}.get(\"text-color\").toString().contains(\"%s\")", columnKey, entry.getKey())));
                textColorStyle.setForecolor((Color)entry.getValue());
                normalCellFieldStyle.addConditionalStyle((JRConditionalStyle)textColorStyle);
            }
            subReport.addStyle((JRStyle)normalCellFieldStyle);
            cellField.setStyle((JRStyle)normalCellFieldStyle);
            cell.addElement((JRDesignElement)cellField);
            sc.setDetailCell((Cell)cell);
            table.addColumn((BaseColumn)sc);
        }
        JRDesignComponentElement tableDE = new JRDesignComponentElement();
        tableDE.setX(0);
        tableDE.setY(0);
        tableDE.setWidth(width);
        tableDE.setHeight(rowHeight);
        tableDE.setComponent((Component)table);
        tableDE.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "table"));
        tableDE.setPositionType(PositionTypeEnum.FIX_RELATIVE_TO_TOP);
        tableDE.setStretchType(StretchTypeEnum.ELEMENT_GROUP_HEIGHT);
        band.addElement((JRDesignElement)tableDE);
        subReport.setSummary((JRBand)band);
        return new ExportableReportData(JasperCompileManager.compileReport((JasperDesign)subReport), Collections.singletonList(content));
    }

    private static <S> Object[] getControlItems(Object control, TableColumnBase<?, ?> column) {
        if (control instanceof TableView) {
            TableView tableView = (TableView)control;
            Object[] items = new Object[tableView.getItems().size()];
            int i = 0;
            while (i < items.length) {
                items[i] = column.getCellData(i);
                ++i;
            }
            return items;
        }
        TreeTableView tableView = (TreeTableView)control;
        LinkedList<Object> items = new LinkedList<Object>();
        PdfUtils.addLeafItems(tableView.getRoot(), items, column);
        return items.toArray();
    }

    private static <S> void addLeafItems(TreeItem<S> rootItem, LinkedList<Object> leafItems, TableColumnBase<TreeItem<S>, ?> column) {
        Object cellData;
        if (rootItem.getChildren().isEmpty() && rootItem.getValue() != null && (cellData = column.getCellData(rootItem)) != null) {
            leafItems.add(cellData);
        }
        for (TreeItem child : rootItem.getChildren()) {
            PdfUtils.addLeafItems(child, leafItems, column);
        }
    }

    private static JRBand createHeader(String naviPrefix, String title, Collection<TableColumnBase<?, ?>> rootColumns, Map<TableColumnBase<?, ?>, Integer> columnWidthes, int width, float fontSize, int rowHeight, JRDesignStyle headerStyle) {
        JRDesignBand band = new JRDesignBand();
        int x = 0;
        int y = 0;
        int columnTreeDepth = PdfUtils.getColumnTreeDepth(rootColumns);
        int totalHeigh = rowHeight * columnTreeDepth;
        if (title != null && !title.isEmpty()) {
            title = PdfUtils.escapeExpressionText(title);
            totalHeigh += 2 * rowHeight;
            JRDesignTextField titleText = new JRDesignTextField();
            if (naviPrefix != null) {
                titleText.setExpression((JRExpression)new JRDesignExpression(String.format("\"%s %s\"", naviPrefix, title)));
            } else {
                titleText.setExpression((JRExpression)new JRDesignExpression(String.format("\"%s\"", title)));
            }
            titleText.setX(20);
            titleText.setY(0);
            titleText.setHeight(rowHeight * 2);
            titleText.setWidth(width - 20);
            titleText.setBold(true);
            titleText.setStretchType(StretchTypeEnum.CONTAINER_HEIGHT);
            titleText.setVerticalTextAlign(VerticalTextAlignEnum.MIDDLE);
            if (naviPrefix != null) {
                titleText.setAnchorNameExpression((JRExpression)new JRDesignExpression(String.format("\"anchor_%s\"", naviPrefix)));
            }
            band.addElement((JRDesignElement)titleText);
            y += rowHeight * 2;
        }
        band.setHeight(totalHeigh);
        LinkedList headerRow = new LinkedList(rootColumns);
        LinkedList nextHeaderRow = new LinkedList();
        HashMap<TableColumnBase, Integer> parentTextXCoordinates = new HashMap<TableColumnBase, Integer>();
        while (!headerRow.isEmpty()) {
            TableColumnBase<?, ?> column = headerRow.removeFirst();
            Integer parentTextX = (Integer)parentTextXCoordinates.get(column);
            if (parentTextX != null) {
                x = parentTextX;
            }
            JRDesignStaticText text = new JRDesignStaticText();
            text.setStyle((JRStyle)headerStyle);
            text.setX(x);
            text.setY(y);
            text.setText(column.getText());
            text.setStretchType(StretchTypeEnum.NO_STRETCH);
            if (text.getText() != null && text.getText().startsWith("[") && text.getText().endsWith("]")) {
                text.setBold(false);
            }
            if (column.getColumns().isEmpty() && column.isVisible()) {
                text.setWidth(columnWidthes.get(column).intValue());
                text.setHeight(totalHeigh - y);
                band.addElement((JRDesignElement)text);
                x += text.getWidth();
            } else {
                ArrayList<TableColumnBase<?, ?>> visibleLeafs = PdfUtils.getVisibleLeafColumns(new ArrayList((Collection<TableColumnBase<?, ?>>)column.getColumns()));
                if (!visibleLeafs.isEmpty()) {
                    nextHeaderRow.addAll(column.getColumns());
                    TableColumnBase leftSubColumn = visibleLeafs.get(0);
                    while (leftSubColumn != null && leftSubColumn != column) {
                        parentTextXCoordinates.put(leftSubColumn, x);
                        leftSubColumn = leftSubColumn.getParentColumn();
                    }
                    int textWidth = 0;
                    for (TableColumnBase<?, ?> leafColumn : visibleLeafs) {
                        textWidth += columnWidthes.get(leafColumn).intValue();
                    }
                    text.setWidth(textWidth);
                    text.setHeight(rowHeight);
                    band.addElement((JRDesignElement)text);
                    x += text.getWidth();
                }
            }
            if (!headerRow.isEmpty()) continue;
            headerRow.addAll(nextHeaderRow);
            nextHeaderRow.clear();
            x = 0;
            y += rowHeight;
        }
        return band;
    }

    private static int getColumnTreeDepth(Collection<TableColumnBase<?, ?>> rootColumns) {
        int depth = 0;
        for (TableColumnBase<?, ?> rootColumn : rootColumns) {
            depth = rootColumn.getColumns().isEmpty() ? Math.max(depth, 1) : Math.max(depth, PdfUtils.getColumnTreeDepth(new LinkedList((Collection<TableColumnBase<?, ?>>)rootColumn.getColumns())) + 1);
        }
        return depth;
    }

    private static Map<TableColumnBase<?, ?>, Integer> getColumnWidthes(Collection<TableColumnBase<?, ?>> columns, int totalWidth) {
        HashMap columnWidthes = new HashMap();
        double totalColumnWidth = columns.stream().mapToDouble(c -> c.getWidth()).reduce(0.0, (s, w) -> s + w);
        for (TableColumnBase<?, ?> column : columns) {
            int appearentWidth = (int)(column.getWidth() * (double)totalWidth / totalColumnWidth);
            columnWidthes.put(column, appearentWidth);
            totalColumnWidth -= column.getWidth();
            totalWidth -= appearentWidth;
        }
        return columnWidthes;
    }

    private static Map<String, String> getTableCellRenderingData(Label tempStylableNode, Object value, Map<String, Color> backgroundColors, Map<String, Color> textColors) {
        String text = null;
        String style = "normal";
        String defaultBackgroundColorKey = "background-color-" + WHITE_ROW.toString();
        String defaultOddBackgroundColorKey = "background-color-" + WHITE_ROW_ODD.toString() + "-odd";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("background-color", "background-color-" + WHITE_ROW.toString());
        map.put("background-color-odd", "background-color-" + WHITE_ROW_ODD.toString() + "-odd");
        backgroundColors.put(defaultBackgroundColorKey, WHITE_ROW);
        backgroundColors.put(defaultOddBackgroundColorKey, WHITE_ROW_ODD);
        if (value != null) {
            VarTableCellData vtcd = null;
            if (value instanceof VarTableCellData) {
                vtcd = (VarTableCellData)value;
                if (vtcd.isSummary()) {
                    style = "summary";
                }
                if ((value = vtcd.getVarValue()) == null) {
                    value = vtcd.getObject();
                }
                if (!vtcd.getCellStyleClasses().isEmpty()) {
                    Paint textFill;
                    Paint backgroundFill;
                    tempStylableNode.getStyleClass().setAll((Object[])new String[]{"cell"});
                    if (vtcd.isSummary()) {
                        tempStylableNode.getStyleClass().add((Object)"summary");
                    }
                    if (vtcd.getObject() instanceof IVarValue) {
                        tempStylableNode.getStyleClass().add((Object)"var-value");
                    }
                    tempStylableNode.getStyleClass().addAll(vtcd.getCellStyleClasses());
                    tempStylableNode.applyCss();
                    if (tempStylableNode.getBackground() != null && !tempStylableNode.getBackground().getFills().isEmpty() && (backgroundFill = ((BackgroundFill)tempStylableNode.getBackground().getFills().get(tempStylableNode.getBackground().getFills().size() - 1)).getFill()) != null && backgroundFill instanceof javafx.scene.paint.Color) {
                        Color color = FXUtils.getAwtColor((Paint)backgroundFill);
                        Color colorOdd = FXUtils.getAwtColor((Paint)((javafx.scene.paint.Color)backgroundFill).deriveColor(1.0, 1.0, 0.9, 1.0));
                        String backgroundColorKey = "background-color-" + color.toString();
                        String backgroundColorKeyOdd = "background-color-" + colorOdd.toString() + "-odd";
                        map.put("background-color", backgroundColorKey);
                        map.put("background-color-odd", backgroundColorKeyOdd);
                        backgroundColors.put(backgroundColorKey, color);
                        backgroundColors.put(backgroundColorKeyOdd, colorOdd);
                    }
                    if ((textFill = tempStylableNode.getTextFill()) != null && textFill instanceof javafx.scene.paint.Color) {
                        Color textColor = FXUtils.getAwtColor((Paint)textFill);
                        String textColorKey = "text-color-" + textColor.toString();
                        map.put("text-color", textColorKey);
                        textColors.put(textColorKey, textColor);
                    }
                }
            }
            if (value instanceof IVarValue) {
                IVarValue iVal = (IVarValue)value;
                if (Double.isFinite(iVal.getValue())) {
                    style = String.valueOf(style) + "-value";
                    text = vtcd != null ? vtcd.getDisplayUnit().formatValue(iVal.getValue(), vtcd.getValueUnit(), vtcd.getDisplayUnitFormat(), false) : Double.toString(iVal.getValue());
                    if (!iVal.isValid()) {
                        style = String.valueOf(style) + "-error";
                    }
                }
            } else if (value instanceof Number) {
                style = String.valueOf(style) + "-value";
                text = vtcd != null ? vtcd.getDisplayUnit().formatValue(((Number)value).doubleValue(), vtcd.getValueUnit(), vtcd.getDisplayUnitFormat(), false) : value.toString();
            } else if (value instanceof Instant) {
                Instant ts = (Instant)value;
                ZonedDateTime zdt = ts.atZone(ZoneId.systemDefault());
                text = TimeFormatType.DateTimeHMs.format((TemporalAccessor)zdt);
            } else if (value instanceof LocalDate) {
                LocalDate ld = (LocalDate)value;
                text = TimeFormatType.Date.format((TemporalAccessor)ld);
            } else if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                text = boolValue != false ? "\u2714" : null;
            } else if (value != null) {
                text = value.toString();
            }
        }
        map.put("text", text);
        map.put("style", style);
        return map;
    }

    private static ArrayList<TableColumnBase<?, ?>> getVisibleLeafColumns(Collection<TableColumnBase<?, ?>> rootColumns) {
        ArrayList visibleColumns = new ArrayList();
        for (TableColumnBase<?, ?> column : rootColumns) {
            if (column.getColumns().isEmpty()) {
                if (!column.isVisible()) continue;
                visibleColumns.add(column);
                continue;
            }
            visibleColumns.addAll(PdfUtils.getVisibleLeafColumns(new LinkedList((Collection<TableColumnBase<?, ?>>)column.getColumns())));
        }
        return visibleColumns;
    }

    public static ExportableReportData createChartSubreport(JFreeChart chart, int width, int maxContentHeight) throws JRException {
        return PdfUtils.createChartSubreport(null, null, chart, width, maxContentHeight, 12.0f, ChartDataItemToPixelRatio.X_1to8.getScale());
    }

    private static ExportableReportData createChartSubreport(String naviPrefix, String title, JFreeChart chart, int width, int maxContentHeight, float fontSize, double dataItemToPixelRatio) throws JRException {
        String titleText;
        int rowHeight = (int)((double)fontSize * 1.2) + 1;
        JasperDesign subReport = new JasperDesign();
        subReport.setTopMargin(0);
        subReport.setRightMargin(0);
        subReport.setBottomMargin(0);
        subReport.setLeftMargin(0);
        subReport.setName("Name1");
        JRDesignBand sb = new JRDesignBand();
        int y = 0;
        if (title != null && !title.isEmpty()) {
            title = PdfUtils.escapeExpressionText(title);
            JRDesignTextField titleText2 = new JRDesignTextField();
            if (naviPrefix != null) {
                titleText2.setExpression((JRExpression)new JRDesignExpression(String.format("\"%s %s\"", naviPrefix, title)));
            } else {
                titleText2.setExpression((JRExpression)new JRDesignExpression(String.format("\"%s\"", title)));
            }
            titleText2.setX(20);
            titleText2.setY(0);
            titleText2.setHeight(rowHeight * 2);
            titleText2.setWidth(width - 20);
            titleText2.setBold(true);
            titleText2.setStretchType(StretchTypeEnum.CONTAINER_HEIGHT);
            titleText2.setVerticalTextAlign(VerticalTextAlignEnum.MIDDLE);
            if (naviPrefix != null) {
                titleText2.setAnchorNameExpression((JRExpression)new JRDesignExpression(String.format("\"anchor_%s\"", naviPrefix)));
            }
            sb.addElement((JRDesignElement)titleText2);
            y += titleText2.getHeight();
        }
        if (naviPrefix == null && title == null) {
            sb.setHeight(maxContentHeight);
        } else {
            sb.setHeight(maxContentHeight - rowHeight * 3 - (naviPrefix != null && naviPrefix.endsWith(".1.") ? rowHeight * 4 : 0));
        }
        subReport.setPageHeight(sb.getHeight());
        LinkedList<Object> contentData = new LinkedList<Object>();
        JRDesignChart dChart = PdfUtils.createFictiveChart(subReport, chart, contentData, dataItemToPixelRatio, width);
        String string = titleText = chart.getTitle() != null ? chart.getTitle().getText() : null;
        if (titleText != null && !titleText.isEmpty()) {
            dChart.setTitleExpression((JRExpression)new JRDesignExpression(String.format("\"%s\"", PdfUtils.escapeExpressionText(titleText))));
            Font titleFont = chart.getTitle().getFont();
            JRBaseFont jrTitleFont = new JRBaseFont();
            jrTitleFont.setBold(titleFont.isBold());
            jrTitleFont.setFontSize(Float.valueOf(titleFont.getSize()));
            dChart.setTitleFont((JRFont)jrTitleFont);
        }
        dChart.setLegendPosition(EdgeEnum.TOP);
        dChart.setEvaluationTime(EvaluationTimeEnum.REPORT);
        sb.addElement((JRDesignElement)dChart);
        dChart.setX(0);
        dChart.setY(y);
        dChart.setWidth(width);
        dChart.setHeight(sb.getHeight() - y);
        subReport.setSummary((JRBand)sb);
        return new ExportableReportData(JasperCompileManager.compileReport((JasperDesign)subReport), contentData);
    }

    private static JRDesignChart createFictiveChart(JasperDesign subReport, JFreeChart jFreeChart, List<Object> contentData, double dataItemToPixelRatio, int expectedWidth) throws JRException {
        int chartType;
        if (jFreeChart.getPlot() instanceof XYPlot) {
            chartType = 16;
        } else if (jFreeChart.getPlot() instanceof PiePlot || jFreeChart.getPlot() instanceof RingPlot) {
            chartType = 9;
        } else if (jFreeChart.getPlot() instanceof CategoryPlot) {
            chartType = 3;
        } else {
            throw new JRException("Unsupported chart plot type " + jFreeChart.getPlot().getClass());
        }
        JRDesignChart dChart = new JRDesignChart(null, (byte)chartType);
        dChart.setCustomizerClass("de.elpro.ewms.gui.report.jasper.JRJFreeChartCopyCustomizer");
        HashMap<String, Object> rootData = new HashMap<String, Object>();
        JRDesignField jFreeChartField = new JRDesignField();
        jFreeChartField.setName("jFreeChart");
        jFreeChartField.setValueClass(JFreeChart.class);
        subReport.addField((JRField)jFreeChartField);
        rootData.put(jFreeChartField.getName(), jFreeChart);
        JRDesignField jExpectedWidth = new JRDesignField();
        jExpectedWidth.setName("expectedWidth");
        jExpectedWidth.setValueClass(Integer.class);
        subReport.addField((JRField)jExpectedWidth);
        rootData.put(jExpectedWidth.getName(), expectedWidth);
        JRDesignField jPixelToItemsRatio = new JRDesignField();
        jPixelToItemsRatio.setName("dataItemToPixelRatio");
        jPixelToItemsRatio.setValueClass(Double.class);
        subReport.addField((JRField)jPixelToItemsRatio);
        rootData.put(jPixelToItemsRatio.getName(), dataItemToPixelRatio);
        JRDesignDataset chartValuesDataset = new JRDesignDataset(false);
        chartValuesDataset.setName("yAxisChartValuesDataset");
        subReport.addDataset(chartValuesDataset);
        JRDesignField chartDatasetField = new JRDesignField();
        chartDatasetField.setName("yAxisChartDataset");
        chartDatasetField.setValueClass(List.class);
        subReport.addField((JRField)chartDatasetField);
        JRChartDataset ds = dChart.getDataset();
        if (chartType == 16) {
            JRDesignTimeSeriesDataset timeseriesDs = new JRDesignTimeSeriesDataset(ds);
            timeseriesDs.setTimePeriod(Second.class);
            JRDesignTimeSeries jrTimeSeries = new JRDesignTimeSeries();
            String seriesTitle = PdfUtils.escapeExpressionText("fictive series");
            String dateKey = String.format("key", new Object[0]);
            String valueKey = String.format("value", new Object[0]);
            JRDesignField dateField = new JRDesignField();
            dateField.setValueClass(Date.class);
            dateField.setName(dateKey);
            chartValuesDataset.addField((JRField)dateField);
            JRDesignField valueField = new JRDesignField();
            valueField.setValueClass(Double.class);
            valueField.setName(valueKey);
            chartValuesDataset.addField((JRField)valueField);
            jrTimeSeries.setSeriesExpression((JRExpression)new JRDesignExpression(String.format("\"%s\"", seriesTitle)));
            jrTimeSeries.setTimePeriodExpression((JRExpression)new JRDesignExpression(String.format("$F{%s}", dateKey)));
            jrTimeSeries.setValueExpression((JRExpression)new JRDesignExpression(String.format("$F{%s}", valueKey)));
            HashMap[] values = new HashMap[]{new HashMap()};
            values[0].put(dateKey, Date.from(Instant.now()));
            values[0].put(valueKey, 5.0);
            JRDesignDatasetRun datasetRun = new JRDesignDatasetRun();
            datasetRun.setDatasetName(chartValuesDataset.getName());
            datasetRun.setDataSourceExpression((JRExpression)new JRDesignExpression(String.format("new net.sf.jasperreports.engine.data.JRBeanCollectionDataSource($F{%s})", chartDatasetField.getName())));
            timeseriesDs.setDatasetRun((JRDatasetRun)datasetRun);
            dChart.setDataset((JRChartDataset)timeseriesDs);
            rootData.put(chartDatasetField.getName(), Arrays.asList(values));
        } else if (chartType == 9) {
            JRDesignField nameField = new JRDesignField();
            nameField.setName("name");
            nameField.setValueClass(String.class);
            subReport.addField((JRField)nameField);
            JRDesignField pieValueField = new JRDesignField();
            pieValueField.setName("pieValue");
            pieValueField.setValueClass(Double.class);
            subReport.addField((JRField)pieValueField);
            JRDesignPieDataset piDs = new JRDesignPieDataset(ds);
            JRDesignPieSeries dps = new JRDesignPieSeries();
            dps.setKeyExpression((JRExpression)new JRDesignExpression("\"dummy\""));
            dps.setValueExpression((JRExpression)new JRDesignExpression("0"));
            piDs.addPieSeries((JRPieSeries)dps);
            dChart.setDataset((JRChartDataset)piDs);
        } else if (chartType == 3) {
            JRDesignField nameField = new JRDesignField();
            nameField.setName("name");
            nameField.setValueClass(String.class);
            subReport.addField((JRField)nameField);
            JRDesignField valueField = new JRDesignField();
            valueField.setName("catValue");
            valueField.setValueClass(Double.class);
            subReport.addField((JRField)valueField);
            JRDesignCategoryDataset piDs = new JRDesignCategoryDataset(ds);
            JRDesignCategorySeries dps = new JRDesignCategorySeries();
            dps.setCategoryExpression((JRExpression)new JRDesignExpression("0"));
            dps.setValueExpression((JRExpression)new JRDesignExpression("0"));
            dps.setSeriesExpression((JRExpression)new JRDesignExpression("\"dummy\""));
            piDs.addCategorySeries((JRCategorySeries)dps);
            dChart.setDataset((JRChartDataset)piDs);
        }
        contentData.add(rootData);
        return dChart;
    }

    private static final String escapeExpressionText(String text) {
        if (text != null && !text.isEmpty()) {
            text = text.replaceAll("\\\"", "\\\\\"");
            text = text.replaceAll("\\r", "\\\\r");
            text = text.replaceAll("\\n", "\\\\n");
        }
        return text;
    }

    private static final Label createLabelInFakeTree(Parent control) {
        Label label;
        Label root = label = new Label();
        while (control != null) {
            BorderPane pane = new BorderPane();
            pane.setStyle(control.getStyle());
            pane.getStylesheets().addAll((Collection)control.getStylesheets());
            pane.getStyleClass().addAll((Collection)control.getStyleClass());
            pane.setCenter((Node)root);
            root = pane;
            control = control.getParent();
        }
        new Scene((Parent)root);
        return label;
    }

    public static class ReportElement {
        private final String title;
        private String naviPrefix = null;
        private final IExportable exportable;
        private final List<ReportElement> children = new LinkedList<ReportElement>();

        public ReportElement(String title, IExportable exportable) {
            this.title = title;
            this.exportable = exportable;
        }

        public String getTitle() {
            return this.title;
        }

        public IExportable getExportable() {
            return this.exportable;
        }

        public List<ReportElement> getChildren() {
            return this.children;
        }

        public String getNaviPrefix() {
            return this.naviPrefix;
        }

        public void setNaviPrefix(String naviPrefix) {
            this.naviPrefix = naviPrefix;
        }
    }
}

