/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.server.handlers;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.client.auth.UserDAO;
import de.elpro.ewms.core.client.worker.BackgroundWorkerDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.worker.BackgroundWorkerDescriptor;
import de.elpro.ewms.core.worker.WorkerState;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public class StartWorkerHandler {
    @Execute
    public void execute(@Optional @Named(value="background-worker-selection") @Named(value="background-worker-selection") BackgroundWorkerDescriptor aw) throws Exception {
        if (aw != null) {
            if (aw.getState() == WorkerState.Paused) {
                BackgroundWorkerDAO.resume((String)aw.getId());
            } else {
                new Thread(() -> {
                    try {
                        BackgroundWorkerDAO.startAsync((String)aw.getId());
                    }
                    catch (DAOOperationException e) {
                        e.printStackTrace();
                    }
                }).start();
            }
        }
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="background-worker-selection") @Named(value="background-worker-selection") BackgroundWorkerDescriptor aw) {
        if (aw == null) {
            return false;
        }
        User user = UserDAO.get();
        if (!user.isAdmin()) {
            return false;
        }
        return aw.getState() == WorkerState.New || aw.getState() == WorkerState.Paused || aw.getState() == WorkerState.Stopped || aw.getState() == WorkerState.Interrupted;
    }
}

