/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.server.parts;

import de.elpro.ewms.core.client.worker.BackgroundWorkerDAO;
import de.elpro.ewms.core.worker.BackgroundWorkerDescriptor;
import de.elpro.ewms.core.worker.BackgroundWorkerGroup;
import de.elpro.resources.Icons;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.di.Refresh;
import de.elpro.ui.formats.TimeFormatType;
import de.elpro.ui.fx.cells.DurationTreeTableCell;
import de.elpro.ui.fx.cells.InstantTreeTableCell;
import de.elpro.ui.fx.cells.uimodel.UIModelTreeTableCell;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.TaskUtils;
import de.elpro.ui.model.UIModelElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.fx.core.di.ContextValue;

public class BackgroundWorkerTreePart {
    public static final String MENU_ID = "de.elpro.ewms.gui.server.popupmenu.workers";
    private final TreeItem<UIModelElement> rootItem = new TreeItem();
    private final TreeTableView<UIModelElement> view = new TreeTableView(this.rootItem);
    private final ProgressIndicatorPane progressIndicator = new ProgressIndicatorPane(this.view);
    private final Map<String, TreeItem<UIModelElement>> workerTreeItems = new HashMap<String, TreeItem<UIModelElement>>();
    private volatile boolean isVisible = false;
    @Inject
    private EMenuService menuService;
    @Inject
    @ContextValue(value="background-worker-selection")
    private Property<BackgroundWorkerDescriptor> workerSelection;
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void postConstruct(BorderPane parent, MPerspective perspective) {
        this.isVisible = perspective.isVisible();
        TreeTableColumn workerColumn = new TreeTableColumn();
        workerColumn.setCellFactory(cf -> new UIModelTreeTableCell());
        workerColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)((UIModelElement)cf.getValue().getValue())));
        workerColumn.setPrefWidth(350.0);
        TreeTableColumn lastExecutionHeader = new TreeTableColumn("Last Execition");
        TreeTableColumn lastExecutionColumn = new TreeTableColumn("Timestamp");
        lastExecutionColumn.setCellValueFactory(cf -> {
            if (cf.getValue().getValue() instanceof BackgroundWorkerDescriptor) {
                BackgroundWorkerDescriptor worker = (BackgroundWorkerDescriptor)cf.getValue().getValue();
                return worker.lastExecutionProperty();
            }
            return new ReadOnlyObjectWrapper();
        });
        lastExecutionColumn.setCellFactory(cf -> new InstantTreeTableCell(TimeFormatType.TimeHMsMs.getFormatter()));
        lastExecutionColumn.setPrefWidth(120.0);
        TreeTableColumn exectutionResultColumn = new TreeTableColumn("Result");
        exectutionResultColumn.setCellValueFactory(cf -> {
            if (cf.getValue().getValue() instanceof BackgroundWorkerDescriptor) {
                BackgroundWorkerDescriptor worker = (BackgroundWorkerDescriptor)cf.getValue().getValue();
                return worker.lastExecutionResultProperty();
            }
            return new ReadOnlyObjectWrapper();
        });
        exectutionResultColumn.setCellFactory(cf -> new ObjectTreeTableCell());
        TreeTableColumn lastDurationColumn = new TreeTableColumn("Duration");
        lastDurationColumn.setCellValueFactory(cf -> {
            if (cf.getValue().getValue() instanceof BackgroundWorkerDescriptor) {
                BackgroundWorkerDescriptor worker = (BackgroundWorkerDescriptor)cf.getValue().getValue();
                return worker.lastExecutionDurationProperty();
            }
            return new ReadOnlyObjectWrapper();
        });
        lastDurationColumn.setCellFactory(cf -> new NanoDurationTreeTableCell());
        lastDurationColumn.setGraphic((Node)new ImageView(Icons.CLOCK_ITEM_URL.toString()));
        lastExecutionHeader.getColumns().addAll((Object[])new TreeTableColumn[]{lastExecutionColumn, exectutionResultColumn, lastDurationColumn});
        TreeTableColumn nextExecutionColumn = new TreeTableColumn("Next Execution");
        nextExecutionColumn.setCellValueFactory(cf -> {
            if (cf.getValue().getValue() instanceof BackgroundWorkerDescriptor) {
                BackgroundWorkerDescriptor worker = (BackgroundWorkerDescriptor)cf.getValue().getValue();
                return worker.nextExecutionProperty();
            }
            return new ReadOnlyObjectWrapper();
        });
        nextExecutionColumn.setCellFactory(cf -> new InstantTreeTableCell(TimeFormatType.TimeHMsMs.getFormatter()));
        nextExecutionColumn.setPrefWidth(120.0);
        TreeTableColumn statsHeaderColumn = new TreeTableColumn("Overall Statistic");
        TreeTableColumn totalUtilizationDurationColumn = new TreeTableColumn("Total Utilization");
        totalUtilizationDurationColumn.setCellValueFactory(cf -> {
            if (cf.getValue().getValue() instanceof BackgroundWorkerDescriptor) {
                BackgroundWorkerDescriptor worker = (BackgroundWorkerDescriptor)cf.getValue().getValue();
                return worker.totalUtilizationProperty();
            }
            return new ReadOnlyObjectWrapper();
        });
        totalUtilizationDurationColumn.setCellFactory(cf -> new DurationTreeTableCell());
        TreeTableColumn totalAgeColumn = new TreeTableColumn("Total Age");
        totalAgeColumn.setCellValueFactory(cf -> {
            if (cf.getValue().getValue() instanceof BackgroundWorkerDescriptor) {
                BackgroundWorkerDescriptor worker = (BackgroundWorkerDescriptor)cf.getValue().getValue();
                return worker.totalAgeProperty();
            }
            return new ReadOnlyObjectWrapper();
        });
        totalAgeColumn.setCellFactory(cf -> new DurationTreeTableCell());
        TreeTableColumn utilizationColumn = new TreeTableColumn("Utilizations");
        utilizationColumn.setCellValueFactory(cf -> {
            if (cf.getValue().getValue() instanceof BackgroundWorkerDescriptor) {
                BackgroundWorkerDescriptor worker = (BackgroundWorkerDescriptor)cf.getValue().getValue();
                long milliUtilization = worker.getTotalUtilization().getSeconds() * 1000L + (long)(worker.getTotalUtilization().getNano() / 1000000);
                long milliTotal = worker.getTotalAge().getSeconds() * 1000L + (long)(worker.getTotalAge().getNano() / 1000000);
                double percent = 100.0 * (double)milliUtilization / (double)milliTotal;
                return new ReadOnlyStringWrapper(String.format("%.1f %%", percent));
            }
            return new ReadOnlyObjectWrapper();
        });
        utilizationColumn.setCellFactory(cf -> new ObjectTreeTableCell());
        statsHeaderColumn.getColumns().addAll((Object[])new TreeTableColumn[]{totalUtilizationDurationColumn, totalAgeColumn, utilizationColumn});
        this.view.getColumns().addAll((Object[])new TreeTableColumn[]{workerColumn, lastExecutionHeader, nextExecutionColumn, statsHeaderColumn});
        this.view.setShowRoot(false);
        Runnable updateWorkerSelection = () -> {
            if (this.view.getSelectionModel().getSelectedItem() != null && ((TreeItem)this.view.getSelectionModel().getSelectedItem()).getValue() instanceof BackgroundWorkerDescriptor) {
                this.workerSelection.setValue((Object)((BackgroundWorkerDescriptor)((TreeItem)this.view.getSelectionModel().getSelectedItem()).getValue()));
            } else {
                this.workerSelection.setValue(null);
            }
        };
        this.view.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> updateWorkerSelection.run());
        this.view.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.SECONDARY) {
                updateWorkerSelection.run();
            }
        });
        parent.setCenter(this.view);
        this.menuService.registerContextMenu(this.view, MENU_ID);
        this.refresh();
        new Thread(() -> {
            while (!Thread.interrupted()) {
                try {
                    if (this.isVisible) {
                        this.updateData().get();
                    }
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, "Update Server Statistics Thread").start();
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", event -> {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            MPerspectiveStack perspectiveStack = (MPerspectiveStack)changedElement;
            if (!perspectiveStack.isToBeRendered()) {
                return;
            }
            MPerspective selectedElement = (MPerspective)perspectiveStack.getSelectedElement();
            this.isVisible = perspective == selectedElement;
        });
    }

    private synchronized Future<?> updateData() {
        String[] ids = (String[])this.workerTreeItems.keySet().toArray(String[]::new);
        CallableTask loadTask = CallableTask.create(() -> BackgroundWorkerDAO.getBackgroundWorkers((String[])ids));
        return TaskUtils.executeUITask((ProgressIndicatorPane)this.progressIndicator, (CallableTask)loadTask).consumeResult(result -> Platform.runLater(() -> {
            int i = 0;
            while (i < ids.length) {
                String id = ids[i];
                BackgroundWorkerDescriptor worker = result[i];
                TreeItem<UIModelElement> treeItem = this.workerTreeItems.get(id);
                if (worker == null) {
                    treeItem.getParent().getChildren().remove(treeItem);
                    this.workerTreeItems.remove(id);
                } else {
                    treeItem.setValue((Object)worker);
                }
                ++i;
            }
        }));
    }

    @Refresh
    public synchronized void refresh() {
        CallableTask task = CallableTask.create(() -> {
            TreeItem rootItem = new TreeItem();
            BackgroundWorkerGroup[] backgroundWorkerGroupArray = BackgroundWorkerDAO.getBackgroundWorkerGroups();
            int n = backgroundWorkerGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                BackgroundWorkerGroup group = backgroundWorkerGroupArray[n2];
                TreeItem groupItem = new TreeItem((Object)group);
                BackgroundWorkerDescriptor[] backgroundWorkerDescriptorArray = BackgroundWorkerDAO.getBackgroundWorkers((BackgroundWorkerGroup)group);
                int n3 = backgroundWorkerDescriptorArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    BackgroundWorkerDescriptor worker = backgroundWorkerDescriptorArray[n4];
                    TreeItem workerItem = new TreeItem((Object)worker);
                    groupItem.getChildren().add((Object)workerItem);
                    ++n4;
                }
                rootItem.getChildren().add((Object)groupItem);
                groupItem.setExpanded(true);
                ++n2;
            }
            return rootItem;
        });
        TaskUtils.executeUITask((ProgressIndicatorPane)this.progressIndicator, (CallableTask)task).consumeResult(rootItem -> Platform.runLater(() -> {
            this.workerTreeItems.clear();
            this.rootItem.getChildren().setAll((Collection)rootItem.getChildren());
            for (TreeItem topChild : rootItem.getChildren()) {
                for (TreeItem workerTreeItem : topChild.getChildren()) {
                    BackgroundWorkerDescriptor worker = (BackgroundWorkerDescriptor)workerTreeItem.getValue();
                    this.workerTreeItems.put(worker.getId(), (TreeItem<UIModelElement>)workerTreeItem);
                }
            }
        }));
    }

    private static class NanoDurationTreeTableCell<S>
    extends TreeTableCell<S, Long> {
        public NanoDurationTreeTableCell() {
            this.setStyle("-fx-alignment: center-right");
        }

        protected void updateItem(Long item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
                this.textProperty().unbind();
                this.setText(null);
            } else {
                this.setText(String.format("%.2f ms", (double)item.longValue() / 1000000.0));
            }
        }
    }

    private static class ObjectTreeTableCell<S, T>
    extends TreeTableCell<S, T> {
        public ObjectTreeTableCell() {
            this.setStyle("-fx-alignment: center-right");
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
                this.textProperty().unbind();
                this.setText(null);
            } else {
                this.setText(item.toString());
            }
        }
    }
}

