/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.server.parts;

import de.elpro.ewms.core.client.log.LogMessageDAO;
import de.elpro.ewms.core.log.LogLevel;
import de.elpro.ewms.core.log.LogMessage;
import de.elpro.ewms.core.log.LogType;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.formats.NumberFormats;
import de.elpro.ui.formats.TimeFormatType;
import de.elpro.ui.fx.controls.NumericField;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.TaskUtils;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.concurrent.Worker;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javax.annotation.PostConstruct;

public class ServerLogPart {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private final TextFlow logTF = new TextFlow();
    private final NumericField countField = new NumericField(Integer.TYPE, NumberFormats.F0);
    private final ComboBox<LogLevel> levelCb = new ComboBox(FXCollections.observableArrayList((Object[])LogLevel.values()));
    private final Button searchButton = new Button("Load");
    private final ScrollPane sp = new ScrollPane((Node)this.logTF);
    private final HBox toolbar = new HBox(10.0, new Node[]{new Label("Count:"){
        {
            this.setPadding(new Insets(3.0));
        }
    }, this.countField, new Label("Level:"){
        {
            this.setPadding(new Insets(3.0));
        }
    }, this.levelCb, this.searchButton});
    private final VBox box = new VBox(new Node[]{this.toolbar, this.sp});
    private final ProgressIndicatorPane progressPane = new ProgressIndicatorPane((Node)this.box);

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        this.countField.setValue((Number)100);
        this.countField.setPositiveOnly(true);
        this.levelCb.getSelectionModel().selectFirst();
        this.toolbar.setPadding(new Insets(2.0));
        VBox.setVgrow((Node)this.sp, (Priority)Priority.ALWAYS);
        this.searchButton.setOnAction(e -> this.loadMessages());
        parent.setCenter((Node)this.progressPane);
        this.loadMessages();
    }

    private void loadMessages() {
        CallableTask<LogMessage[]> task = new CallableTask<LogMessage[]>(){

            public LogMessage[] call() throws Exception {
                return LogMessageDAO.getLastMessages((LogType)LogType.Logger, (int)ServerLogPart.this.countField.getValue().intValue(), (LogLevel)((LogLevel)ServerLogPart.this.levelCb.getValue()));
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.progressPane, (CallableTask)task).consumeResult((status, messages) -> {
            if (status == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> this.showMessages((LogMessage[])messages));
            }
        });
    }

    private void showMessages(LogMessage[] messages) {
        this.logTF.getChildren().clear();
        LogMessage[] logMessageArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            LogMessage message = logMessageArray[n2];
            LocalDateTime localTime = LocalDateTime.ofInstant(message.getTimestamp(), ZoneOffset.systemDefault());
            Text tsText = new Text(String.valueOf(TimeFormatType.DateTimeHMs.format((TemporalAccessor)localTime)) + " ");
            tsText.setFont(Font.font((String)"Helvetica", (FontWeight)FontWeight.BOLD, (double)12.0));
            LogLevel level = message.getLevel();
            Text levelText = new Text(String.format("  %s: ", level.name()));
            if (level == LogLevel.ERROR) {
                levelText.setFill((Paint)Color.DARKRED);
            } else if (level == LogLevel.WARNING) {
                levelText.setFill((Paint)Color.DARKORANGE);
            } else if (level == LogLevel.INFO) {
                levelText.setFont(Font.font((String)"Helvetica", (FontWeight)FontWeight.BOLD, (double)12.0));
            }
            Text sourceText = new Text(String.format("%s - ", message.getSource()));
            Text messageText = new Text(String.valueOf(message.getMessage()) + LINE_SEP);
            this.logTF.getChildren().addAll((Object[])new Node[]{tsText, levelText, sourceText, messageText});
            ++n2;
        }
    }
}

