/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.server.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.statistics.StatisticsDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.statistics.RasterizedValuesStatistics;
import de.elpro.ewms.core.statistics.VariableInstancesStatistics;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.resources.Icons;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.di.Refresh;
import de.elpro.ui.fx.cells.DurationTreeTableCell;
import de.elpro.ui.fx.cells.uimodel.UIModelTreeTableCell;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.TaskUtils;
import de.elpro.ui.model.UIModelElement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;

public class VariableStatisticsPart {
    private TreeItem<StatsEntry> rootItem = new TreeItem();
    private TreeTableView<StatsEntry> view = new TreeTableView(this.rootItem);
    private ProgressIndicatorPane progressPane = new ProgressIndicatorPane(this.view);

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        this.view.setShowRoot(false);
        TreeTableColumn nameColumn = new TreeTableColumn();
        nameColumn.setCellValueFactory(cf -> cf.getValue().valueProperty());
        nameColumn.setCellFactory(cf -> new UIModelTreeTableCell());
        nameColumn.setPrefWidth(300.0);
        TreeTableColumn percentColumn = new TreeTableColumn("Ratio");
        percentColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)((StatsEntry)cf.getValue().getValue()).getPercentage()));
        percentColumn.setCellFactory(cf -> new PercentageTreeTableCell());
        percentColumn.setPrefWidth(360.0);
        TreeTableColumn durationColumn = new TreeTableColumn("Duration");
        durationColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)((StatsEntry)cf.getValue().getValue()).getDuration()));
        durationColumn.setCellFactory(cf -> new DurationTreeTableCell());
        durationColumn.setPrefWidth(100.0);
        MenuItem refreshItem = new MenuItem("Refresh", (Node)new ImageView(Icons.REFRESH_ITEM_URL.toExternalForm()));
        refreshItem.setOnAction(e -> this.refresh());
        MenuItem clearStatsItem = new MenuItem("Clear Stats", (Node)new ImageView(Icons.DELETE_ITEM_URL.toExternalForm()));
        clearStatsItem.setOnAction(e -> {
            StatisticsDAO.clearRasterizedValuesStatistics();
            this.refresh();
        });
        ContextMenu menu = new ContextMenu(new MenuItem[]{refreshItem, clearStatsItem});
        this.view.setContextMenu(menu);
        this.view.getColumns().addAll((Object[])new TreeTableColumn[]{nameColumn, percentColumn, durationColumn});
        parent.setCenter((Node)this.progressPane);
        this.refresh();
    }

    @Refresh
    public void refresh() {
        SimpleObjectProperty totalDuration = new SimpleObjectProperty((Object)Duration.ZERO);
        CallableTask task = CallableTask.create(() -> VariableStatisticsPart.lambda$8((ObjectProperty)totalDuration));
        TaskUtils.executeUITask((ProgressIndicatorPane)this.progressPane, (CallableTask)task).consumeResult(arg_0 -> this.lambda$11((ObjectProperty)totalDuration, arg_0));
    }

    private static /* synthetic */ List lambda$8(ObjectProperty objectProperty) throws Exception {
        Transaction trx = Transactions.begin();
        try {
            HashMap<Variable, VariableStatistics> varStats = new HashMap<Variable, VariableStatistics>();
            HashMap<Variable, VariableInstanceStatistics> varInstStats = new HashMap<Variable, VariableInstanceStatistics>();
            HashMap<Integer, Variable> objects = new HashMap<Integer, Variable>();
            Object object = VariableDAO.getAll((Transaction)trx);
            int n = ((Variable[])object).length;
            int n2 = 0;
            while (n2 < n) {
                Variable var = object[n2];
                varStats.put(var, new VariableStatistics(var, Duration.ZERO));
                ++n2;
            }
            object = StructureObjectDAO.getAll((Transaction)trx);
            n = ((StructureObject[])object).length;
            n2 = 0;
            while (n2 < n) {
                Variable obj = object[n2];
                objects.put(obj.getId(), obj);
                ++n2;
            }
            object = VariableInstanceDAO.getAll((Transaction)trx);
            n = ((VariableInstance[])object).length;
            n2 = 0;
            while (n2 < n) {
                Variable instance = object[n2];
                varInstStats.put(instance, new VariableInstanceStatistics((VariableInstance)instance, Duration.ZERO));
                instance.setStructureObject((StructureObject)objects.get(instance.getStructureObject().getId()));
                ++n2;
            }
            RasterizedValuesStatistics rvs = StatisticsDAO.getRasterizedValuesStatistics();
            for (VariableInstancesStatistics vis : rvs.getInstanceStatistics()) {
                if (vis.getDuration() == null) continue;
                VariableInstanceStatistics is = (VariableInstanceStatistics)varInstStats.get(vis.getInstance());
                is.duration = vis.getDuration();
                VariableStatistics vs = (VariableStatistics)varStats.get(is.variableInstance.getVariable());
                vs.duration = vs.duration.plus(vis.getDuration());
                objectProperty.set((Object)((Duration)objectProperty.get()).plus(vis.getDuration()));
                vs.instanceStatistics.add(is);
            }
            ArrayList stats = new ArrayList(varStats.values());
            stats.sort((s1, s2) -> s2.duration.compareTo(s1.duration));
            for (VariableStatistics vs : stats) {
                vs.instanceStatistics.sort((s1, s2) -> s2.duration.compareTo(s1.duration));
            }
            ArrayList arrayList = stats;
            return arrayList;
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private /* synthetic */ void lambda$11(ObjectProperty objectProperty, List varStats) {
        Platform.runLater(() -> {
            ArrayList<TreeItem> varTIs = new ArrayList<TreeItem>();
            long totalDurationMilis = ((Duration)objectProperty.getValue()).toMillis();
            for (VariableStatistics vs : varStats) {
                vs.percent = 100.0 * (double)vs.duration.toMillis() / (double)totalDurationMilis;
                TreeItem vsTI = new TreeItem((Object)vs);
                for (VariableInstanceStatistics vis : vs.instanceStatistics) {
                    vis.percent = 100.0 * (double)vis.duration.toMillis() / (double)totalDurationMilis;
                    TreeItem visTI = new TreeItem((Object)vis);
                    vsTI.getChildren().add((Object)visTI);
                }
                if (vsTI.getChildren().isEmpty()) continue;
                varTIs.add(vsTI);
            }
            this.rootItem.getChildren().setAll(varTIs);
        });
    }

    private static class PercentageTreeTableCell<S>
    extends TreeTableCell<S, Double> {
        BorderPane pane = new BorderPane();
        ProgressBar pb = new ProgressBar();
        Label label = new Label();

        public PercentageTreeTableCell() {
            this.pb.setMaxWidth(Double.MAX_VALUE);
            this.label.setMinWidth(50.0);
            this.label.setAlignment(Pos.CENTER_RIGHT);
            this.pane.setCenter((Node)this.pb);
            this.pane.setRight((Node)this.label);
        }

        protected void updateItem(Double item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
                this.textProperty().unbind();
                this.setText(null);
            } else {
                this.pb.setProgress(item / 100.0);
                this.label.setText(String.format("%.1f %%", item));
                this.setGraphic((Node)this.pane);
                this.setText(null);
            }
        }
    }

    private static interface StatsEntry
    extends UIModelElement {
        public UIModelElement getNode();

        public Duration getDuration();

        public double getPercentage();
    }

    private static class VariableInstanceStatistics
    implements StatsEntry {
        private final VariableInstance variableInstance;
        private Duration duration;
        private double percent;

        public VariableInstanceStatistics(VariableInstance variableInstance, Duration duration) {
            this.variableInstance = variableInstance;
            this.duration = duration;
        }

        public Node getGraphic() {
            return this.variableInstance.getGraphic();
        }

        public String toString() {
            return this.variableInstance.toString();
        }

        @Override
        public UIModelElement getNode() {
            return this.variableInstance;
        }

        @Override
        public Duration getDuration() {
            return this.duration;
        }

        @Override
        public double getPercentage() {
            return this.percent;
        }
    }

    private static class VariableStatistics
    implements StatsEntry {
        private final Variable variable;
        private Duration duration;
        private double percent;
        private final List<VariableInstanceStatistics> instanceStatistics = new ArrayList<VariableInstanceStatistics>();

        public VariableStatistics(Variable variable, Duration duration) {
            this.variable = variable;
            this.duration = duration;
        }

        public String getIconUri() {
            return this.variable.getIconUri();
        }

        public String toString() {
            return this.variable.toString();
        }

        @Override
        public UIModelElement getNode() {
            return this.variable;
        }

        @Override
        public Duration getDuration() {
            return this.duration;
        }

        @Override
        public double getPercentage() {
            return this.percent;
        }
    }
}

