/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.addons;

import de.elpro.ewms.gui.addons.AddonFlags;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DashboardAddon {
    public static final String DASHBOARD_PERSPECTIVE_ID = "de.elpro.ewms.gui.prespecticestack.dashboard";
    public static final String DASHBOARD_MAINAREA_ID = "de.elpro.ewms.gui.dashboard.mainarea";
    @Inject
    IEventBroker eventBroker;
    @Inject
    MApplication app;
    @Inject
    EModelService modelService;
    @Inject
    EPartService partService;
    private EventHandler perspectiveChangedHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MArea) && !changedElement.getElementId().equals(DashboardAddon.DASHBOARD_PERSPECTIVE_ID)) {
                return;
            }
            MArea mainArea = (MArea)changedElement;
            MPerspective perspective = (MPerspective)mainArea.getParent();
            if (!DashboardAddon.DASHBOARD_PERSPECTIVE_ID.equals(perspective.getElementId())) {
                return;
            }
            if (perspective.getChildren().size() == 1 && mainArea.getChildren().isEmpty()) {
                if (AddonFlags.reoderInProgress.get()) {
                    return;
                }
                MPerspectiveStack stack = (MPerspectiveStack)DashboardAddon.this.modelService.find("de.elpro.ewms.gui.perspectivestack.main", (MUIElement)DashboardAddon.this.app);
                stack.getChildren().remove(perspective);
                if (stack.getSelectedElement() == perspective) {
                    DashboardAddon.this.partService.switchPerspective((MPerspective)stack.getChildren().get(0));
                }
                return;
            }
        }
    };

    public static void movePartToDashboard(MApplication app, EModelService modelService, MPart part) {
        try {
            MArea mainArea;
            AddonFlags.reoderInProgress.set(true);
            MPerspectiveStack perspectiveStack = (MPerspectiveStack)modelService.find("de.elpro.ewms.gui.perspectivestack.main", (MUIElement)app);
            MPerspective dashboardPerspective = (MPerspective)modelService.find(DASHBOARD_PERSPECTIVE_ID, (MUIElement)perspectiveStack);
            if (dashboardPerspective == null) {
                dashboardPerspective = (MPerspective)modelService.createModelElement(MPerspective.class);
                dashboardPerspective.setElementId(DASHBOARD_PERSPECTIVE_ID);
                dashboardPerspective.setLabel("Dashboard");
                dashboardPerspective.setIconURI("platform:/plugin/de.elpro.resources/icons/16x16/ewms/dashboard_perspective_white.png");
                dashboardPerspective.getPersistedState().put("icon-uri-selected", "platform:/plugin/de.elpro.resources/icons/16x16/ewms/dashboard_perspective.png");
                mainArea = (MArea)modelService.createModelElement(MArea.class);
                mainArea.setElementId(DASHBOARD_MAINAREA_ID);
                mainArea.getTags().add("NoAutoCollapse");
                dashboardPerspective.getChildren().add(mainArea);
                perspectiveStack.getChildren().add(0, dashboardPerspective);
            } else {
                mainArea = (MArea)modelService.find(DASHBOARD_MAINAREA_ID, (MUIElement)dashboardPerspective);
            }
            if (mainArea.getChildren().isEmpty()) {
                MPartStack partStack = (MPartStack)modelService.createModelElement(MPartStack.class);
                mainArea.getChildren().add(partStack);
                partStack.getChildren().add(part);
            } else if (mainArea.getChildren().size() == 1 && mainArea.getChildren().get(0) instanceof MPartSashContainer && ((MPartSashContainer)mainArea.getChildren().get(0)).isHorizontal()) {
                MPartStack partStack = (MPartStack)modelService.createModelElement(MPartStack.class);
                partStack.getChildren().add(part);
                ((MPartSashContainer)mainArea.getChildren().get(0)).getChildren().add(partStack);
            } else {
                MPartSashContainer sashContainer = (MPartSashContainer)modelService.createModelElement(MPartSashContainer.class);
                sashContainer.setHorizontal(true);
                MPartStack partStack = (MPartStack)modelService.createModelElement(MPartStack.class);
                partStack.getChildren().add(part);
                ArrayList<MPartStack> elements = new ArrayList<MPartStack>(mainArea.getChildren());
                elements.add(partStack);
                sashContainer.getChildren().addAll(elements);
                mainArea.getChildren().clear();
                mainArea.getChildren().add(sashContainer);
            }
            if (!part.getTags().contains("ContextUnbound")) {
                part.getTags().add("ContextUnbound");
            }
        }
        finally {
            AddonFlags.reoderInProgress.set(false);
        }
    }

    @PostConstruct
    void hookListeners() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this.perspectiveChangedHandler);
    }

    @PreDestroy
    void unhookListeners() {
        this.eventBroker.unsubscribe(this.perspectiveChangedHandler);
    }
}

