/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.addons;

import javax.annotation.PostConstruct;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class WindowCloseAddon {
    @PostConstruct
    public void postConstruct(IEventBroker eventBroker, final EPartService partService, EModelService modelService, MApplication app) {
        final MWindow window = (MWindow)modelService.find("de.elpro.ewms.gui.trimmedwindow.main", (MUIElement)app);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/Context/context/*", new EventHandler(){

            public void handleEvent(Event event) {
                if (UIEvents.isSET((Event)event) && window.equals(event.getProperty("ChangedElement")) && window.getContext() != null) {
                    window.getContext().runAndTrack(new RunAndTrack(partService){
                        private final IWindowCloseHandler quitHandler;
                        {
                            this.quitHandler = new IWindowCloseHandler(){

                                public boolean close(MWindow window) {
                                    if (ePartService.getDirtyParts().size() > 0) {
                                        return ePartService.saveAll(true);
                                    }
                                    return true;
                                }
                            };
                        }

                        public boolean changed(IEclipseContext context) {
                            Object value = context.get(IWindowCloseHandler.class);
                            if (!this.quitHandler.equals(value)) {
                                context.set(IWindowCloseHandler.class, (Object)this.quitHandler);
                            }
                            return true;
                        }
                    });
                }
            }
        });
    }
}

