/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.components;

import de.elpro.ewms.gui.Messages;
import de.elpro.ewms.gui.bundle.Activator;
import de.elpro.ewms.gui.components.GUIExceptionHandlerAddon;
import java.net.ConnectException;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.ProcessingException;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.core.ExceptionHandler;
import org.eclipse.fx.core.log.Logger;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class GUIExceptionHandler
implements ExceptionHandler {
    static volatile Dialog<?> popupDialog = null;
    private static Logger logger = Activator.getLoggerFactory().createLogger(GUIExceptionHandler.class.getName());

    public void handleException(ExceptionHandler.ExceptionData data) {
        GUIExceptionHandler.guiHandler(data.throwable());
    }

    public static void guiHandler(Throwable t) {
        MApplication app = GUIExceptionHandlerAddon.getAppication();
        Platform.runLater(() -> {
            block9: {
                if (popupDialog != null) {
                    return;
                }
                Throwable throwable2 = t;
                try {
                    try {
                        ExceptionDialog dlg;
                        if (app == null) {
                            ExceptionDialog dlg2;
                            popupDialog = dlg2 = new ExceptionDialog(throwable2);
                            dlg2.setHeaderText(Messages.component_GUIExceptionHandler_unhandled_exception);
                            dlg2.showAndWait();
                            break block9;
                        }
                        IWorkbench workbench = (IWorkbench)app.getContext().get(IWorkbench.class);
                        EModelService modelService = (EModelService)app.getContext().get(EModelService.class);
                        MWindow window = (MWindow)modelService.find("de.elpro.ewms.gui.trimmedwindow.main", (MUIElement)app);
                        Stage stage = (Stage)window.getContext().get(Stage.class);
                        while ((throwable2 instanceof ProcessingException || throwable2 instanceof ExecutionException) && throwable2.getCause() != null) {
                            throwable2 = throwable2.getCause();
                        }
                        if (throwable2 instanceof NotAuthorizedException || throwable2 instanceof ConnectException) {
                            Alert dlg3;
                            String msg = throwable2 instanceof NotAuthorizedException ? Messages.component_GUIExceptionHandler_session_expired : Messages.component_GUIExceptionHandler_connction_lost;
                            popupDialog = dlg3 = new Alert(Alert.AlertType.ERROR, msg, new ButtonType[]{ButtonType.YES, ButtonType.NO});
                            dlg3.initOwner((Window)stage);
                            dlg3.showAndWait().ifPresent(type -> {
                                if (type.equals(ButtonType.YES)) {
                                    workbench.restart();
                                }
                            });
                            break block9;
                        }
                        popupDialog = dlg = new ExceptionDialog(throwable2);
                        dlg.initOwner((Window)stage);
                        dlg.setHeaderText("Unhandler Error occured");
                        dlg.showAndWait();
                    }
                    catch (Exception exc) {
                        logger.error("Error at handling uncaught exception", (Throwable)exc);
                        popupDialog = null;
                    }
                }
                finally {
                    popupDialog = null;
                }
            }
        });
    }
}

