/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.components;

import de.elpro.ui.model.IdObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.eclipse.fx.core.ObjectSerializer;
import org.osgi.service.component.annotations.Component;

@Component
public class IdObjectSerializer
implements ObjectSerializer {
    public String getId() {
        return "fx.idobject_serializer";
    }

    public String serialize(Object object) {
        if (object instanceof IdObject) {
            return ((IdObject)object).getFullId();
        }
        if (object instanceof IdObject[]) {
            IdObject[] array = (IdObject[])object;
            StringBuilder value = new StringBuilder("[");
            int i = 0;
            while (i < array.length) {
                if (i > 0) {
                    value.append(", ");
                }
                value.append(this.serialize(array[i]));
                ++i;
            }
            value.append(']');
            return value.toString();
        }
        throw new IllegalArgumentException(String.format("Object of class '%s' do not implements IdObject interface", object.getClass().getName()));
    }

    public <O> O deserialize(Class<O> clazz, String value) {
        if (IdObject.class.isAssignableFrom(clazz)) {
            return (O)IdObject.getObjectByFullId((ClassLoader)clazz.getClassLoader(), (String)value);
        }
        if (clazz.isArray() && IdObject[].class.isAssignableFrom(clazz)) {
            if (!(value = value.replace(" ", "")).startsWith("[") || !value.endsWith("]")) {
                throw new IllegalArgumentException();
            }
            value = value.substring(1, value.length() - 1);
            ArrayList<String> parts = new ArrayList<String>();
            while (value.contains("},{")) {
                String part = value.substring(0, value.indexOf("},{") + 1);
                parts.add(part);
                value = value.substring(part.length() + 1);
            }
            if (!value.isEmpty()) {
                parts.add(value);
            }
            IdObject[] array = (IdObject[])Array.newInstance(clazz.getComponentType(), parts.size());
            int i = 0;
            for (String part : parts) {
                array[i++] = IdObject.getObjectByFullId((ClassLoader)clazz.getClassLoader(), (String)part);
            }
            return (O)array;
        }
        throw new IllegalArgumentException();
    }
}

