/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.dialogs;

import com.google.common.base.Charsets;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import de.elpro.ewms.core.changelog.ChangeLogUtils;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.component.ClientInfo;
import de.elpro.ewms.core.component.ComponentBase;
import de.elpro.ewms.core.component.ServerInfo;
import de.elpro.ewms.core.component.VersionUtils;
import de.elpro.ewms.core.html.HTMLPage;
import de.elpro.ewms.gui.dialogs.InstalledComponentsDialog;
import de.elpro.ewms.gui.utils.e4.EOSPartUtils;
import de.elpro.resources.Icons;
import de.elpro.ui.formats.TimeFormatType;
import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import javafx.event.Event;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javax.inject.Inject;
import org.controlsfx.control.HyperlinkLabel;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.fx.core.log.LoggerFactory;
import org.eclipse.fx.ui.controls.image.GraphicNode;
import org.osgi.framework.Version;

public class AboutEOSDialog
extends Dialog<ButtonType> {
    private static final Parser parser;
    private static final HtmlRenderer renderer;
    @Inject
    private IEclipseContext context;

    static {
        MutableDataSet options = new MutableDataSet();
        options.set(Parser.EXTENSIONS, Arrays.asList(TablesExtension.create(), StrikethroughExtension.create(), AbbreviationExtension.create(), AutolinkExtension.create()));
        parser = Parser.builder((DataHolder)options).build();
        renderer = HtmlRenderer.builder((DataHolder)options).build();
    }

    @Inject
    public AboutEOSDialog(MApplication app, Scene scene, LoggerFactory loggerFactory, ClientInfo clientInfo, ServerInfo serverInfo) {
        this.initOwner(scene.getWindow());
        this.setTitle("About EOS");
        BorderPane content = new BorderPane();
        VBox leftBox = new VBox();
        ImageView logo = new ImageView(AboutEOSDialog.class.getResource("/icons/eos_logo_256.png").toExternalForm().toString());
        logo.setScaleX(0.6);
        logo.setScaleY(0.6);
        leftBox.getChildren().add((Object)logo);
        leftBox.setAlignment(Pos.CENTER);
        content.setLeft((Node)leftBox);
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPrefSize(500.0, 320.0);
        grid.setPadding(new Insets(10.0, 10.0, 0.0, 0.0));
        grid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(){
            {
                this.setMinWidth(150.0);
            }
        }, new ColumnConstraints(){
            {
                this.setMinWidth(130.0);
            }
        }, new ColumnConstraints(){
            {
                this.setMinWidth(130.0);
            }
        }});
        int row = 0;
        grid.add((Node)AboutEOSDialog.label(clientInfo.getProductName(), 24.0, FontWeight.BOLD, HPos.CENTER), 0, row++, 3, 1);
        grid.add((Node)AboutEOSDialog.label(String.format("%s (version: %s)", clientInfo.getProductId(), VersionUtils.toStringNoQualifier((Version)clientInfo.getProductVersion())), 14.0, FontWeight.BOLD, HPos.CENTER), 0, row++, 3, 1);
        grid.addRow(row++, new Node[]{AboutEOSDialog.label(null), AboutEOSDialog.label("Client", FontWeight.BOLD), AboutEOSDialog.label("Server", FontWeight.BOLD)});
        Hyperlink clientCoreVersionLink = new Hyperlink(VersionUtils.toStringNoQualifier((Version)clientInfo.getCoreComponent().getVersion()));
        clientCoreVersionLink.setAccessibleHelp("Open EOS Core ChangeLog");
        clientCoreVersionLink.setOnAction(e -> {
            URL changelogURL = ChangeLogUtils.getCoreChangeLogURL();
            if (changelogURL == null) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream is = changelogURL.openStream();){
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (InputStreamReader reader = new InputStreamReader(is, Charsets.UTF_8);){
                        HTMLPage page = new HTMLPage("eos-core-changelog.md", Icons.MARKDOWN_ITEM_URL.toExternalForm(), AboutEOSDialog.convertMDtoHTML(reader));
                        this.close();
                        EOSPartUtils.showPart("de.elpro.ewms.gui.partdescriptor.htmlviewer", app, page);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                Alert error = new Alert(Alert.AlertType.ERROR);
                error.initOwner(scene.getWindow());
                error.setContentText("Could not open ChangeLog file");
            }
        });
        Hyperlink serverCoreVersionLink = new Hyperlink(serverInfo != null ? VersionUtils.toStringNoQualifier((Version)serverInfo.getCoreComponent().getVersion()) : "?");
        serverCoreVersionLink.setAccessibleHelp("Open EOS Core ChangeLog");
        serverCoreVersionLink.setOnAction(e -> {
            try {
                HTMLPage page = new HTMLPage("eos-core-changelog.md (Server)", Icons.MARKDOWN_ITEM_URL.toExternalForm(), AboutEOSDialog.convertMDtoHTML(ServerDAO.getEOSCoreChangelog()));
                this.close();
                EOSPartUtils.showPart("de.elpro.ewms.gui.partdescriptor.htmlviewer", app, page);
            }
            catch (Exception exception) {
                Alert error = new Alert(Alert.AlertType.ERROR);
                error.initOwner(scene.getWindow());
                error.setContentText("Could not open ChangeLog file");
            }
        });
        grid.addRow(row++, new Node[]{AboutEOSDialog.label("EOS Core Version:", FontWeight.BOLD), clientCoreVersionLink, serverCoreVersionLink});
        ZonedDateTime clientCoreBuildTimestamp = VersionUtils.getBuildTimestamp((Version)clientInfo.getCoreComponent().getVersion());
        String clientCoreQualifier = "unavailable";
        if (clientCoreBuildTimestamp != null) {
            clientCoreQualifier = String.format("%s (%s)", TimeFormatType.DateTimeHM.format((TemporalAccessor)clientCoreBuildTimestamp), ZoneId.systemDefault().toString());
        }
        ZonedDateTime serverCoreBuildTimestamp = serverInfo != null ? VersionUtils.getBuildTimestamp((Version)serverInfo.getCoreComponent().getVersion()) : null;
        String serverCoreQualifier = "unavailable";
        if (serverCoreBuildTimestamp != null) {
            serverCoreQualifier = String.format("%s (%s)", TimeFormatType.DateTimeHM.format((TemporalAccessor)serverCoreBuildTimestamp), ZoneId.systemDefault().toString());
        }
        grid.addRow(row++, new Node[]{AboutEOSDialog.label("Build Timestamp:", FontWeight.BOLD), AboutEOSDialog.label(clientCoreQualifier), AboutEOSDialog.label(serverCoreQualifier)});
        grid.addRow(row++, new Node[]{AboutEOSDialog.label("Java Runtime:", FontWeight.BOLD), AboutEOSDialog.label(clientInfo.getJavaVersion()), AboutEOSDialog.label(serverInfo != null ? serverInfo.getJavaVersion() : "?")});
        HyperlinkLabel copyrightText = new HyperlinkLabel("(c) Copyright Elpro GmbH 2017, 2023. All rights reserved. EOS and the EOS logo are trademarks of the Elpro GmbH, [https://elpro.de/]. The EOS logo cannot be altered without Elpro GmbH permission. EOS functionality is build dependent and can vary within same version. For more information visit our product site [https://eos-ready.com/de/].");
        copyrightText.setPadding(new Insets(40.0, 0.0, 40.0, 0.0));
        copyrightText.setOnAction(AboutEOSDialog::onHyperLinkClick);
        grid.add((Node)copyrightText, 0, row++, 3, 1);
        HyperlinkLabel foreignLibrariesText = new HyperlinkLabel("This product includes software developed by other open source projects including the Apache Software Foundation, [https://www.apache.org/].");
        foreignLibrariesText.setOnAction(AboutEOSDialog::onHyperLinkClick);
        grid.add((Node)foreignLibrariesText, 0, row++, 3, 1);
        Separator separator = new Separator();
        HBox separatorContainer = new HBox(new Node[]{separator});
        HBox.setHgrow((Node)separator, (Priority)Priority.ALWAYS);
        separatorContainer.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
        content.setBottom((Node)separatorContainer);
        content.setCenter((Node)grid);
        this.getDialogPane().setContent((Node)content);
        ButtonType installedComponentsButtonType = new ButtonType("Installed Components", ButtonBar.ButtonData.HELP_2);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE, installedComponentsButtonType});
        Button installedComponentsButton = (Button)this.getDialogPane().lookupButton(installedComponentsButtonType);
        installedComponentsButton.setGraphic((Node)new GraphicNode(){
            {
                this.setGraphic(ComponentBase.DEFAULT_ICON.toString());
            }
        });
        installedComponentsButton.setOnAction(e -> {
            this.close();
            InstalledComponentsDialog installedComponentsDialog = (InstalledComponentsDialog)((Object)((Object)ContextInjectionFactory.make(InstalledComponentsDialog.class, (IEclipseContext)this.context)));
            installedComponentsDialog.show();
        });
    }

    private static void onHyperLinkClick(Event e) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE) && e.getTarget() instanceof Hyperlink) {
            Hyperlink link = (Hyperlink)e.getTarget();
            try {
                Desktop.getDesktop().browse(new URI(link.getText()));
                e.consume();
            }
            catch (Exception exception) {}
        }
    }

    static Label label(String text, double fontSize, FontWeight fontWeight, HPos hPos) {
        return AboutEOSDialog.label(text, fontSize, fontWeight, hPos, null);
    }

    static Label label(String text, double fontSize) {
        return AboutEOSDialog.label(text, fontSize, null, null, null);
    }

    static Label label(String text, FontWeight fontWeight) {
        return AboutEOSDialog.label(text, -1.0, fontWeight, null, null);
    }

    static Label label(String text) {
        return AboutEOSDialog.label(text, -1.0, null, null, null);
    }

    private static Label label(String text, double fontSize, FontWeight fontWeight, HPos hPos, VPos vPos) {
        Label label = new Label(text);
        label.setFont(Font.font(null, (FontWeight)fontWeight, (double)fontSize));
        if (hPos != null) {
            GridPane.setHalignment((Node)label, (HPos)hPos);
        }
        GridPane.setValignment((Node)label, (VPos)(vPos != null ? vPos : VPos.CENTER));
        return label;
    }

    static String convertMDtoHTML(Reader reader) throws IOException {
        Document document = parser.parseReader(reader);
        String html = renderer.render((com.vladsch.flexmark.util.ast.Node)document);
        return html;
    }

    static String convertMDtoHTML(String mdText) throws IOException {
        Document document = parser.parse(mdText);
        String html = renderer.render((com.vladsch.flexmark.util.ast.Node)document);
        return html;
    }
}

