/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.dialogs;

import de.elpro.ewms.core.client.rawvalues.RawValuesViewDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.rawvalues.RawValuesViewDescriptor;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.gui.Messages;
import de.elpro.ui.formats.TimeFormatType;
import de.elpro.ui.fx.cells.DataSizeTableCell;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.fx.core.ThreadSynchronize;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.dashicons.Dashicons;
import org.kordamp.ikonli.javafx.FontIcon;

public class AdjustCustomViewDialog
extends Dialog<ButtonType> {
    private final ObservableList<CustomViewOperation> operations = FXCollections.observableArrayList();

    public AdjustCustomViewDialog(Window owner, ThreadSynchronize sync) {
        this.initOwner(owner);
        BorderPane pane = new BorderPane();
        TableView tableView = new TableView(FXCollections.observableArrayList((Object[])RawValuesViewDAO.getViews((RawValuesViewType)RawValuesViewType.CustomView)));
        tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        TableColumn nameColumn = new TableColumn(Messages.dialogs_AdjustCustomViewDialog_view);
        nameColumn.setCellValueFactory(cf -> new ReadOnlyStringWrapper(AdjustCustomViewDialog.getViewName((RawValuesViewDescriptor)cf.getValue())));
        TableColumn daysColumn = new TableColumn(Messages.dialogs_AdjustCustomViewDialog_days);
        daysColumn.setCellFactory(cf -> new DaysCell());
        daysColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)(((RawValuesViewDescriptor)cf.getValue()).getTimeRangeEnd().toEpochMilli() - ((RawValuesViewDescriptor)cf.getValue()).getTimeRangeBegin().toEpochMilli())));
        TableColumn rasterColumn = new TableColumn(Messages.dialogs_AdjustCustomViewDialog_raster);
        rasterColumn.setCellValueFactory(cf -> ((RawValuesViewDescriptor)cf.getValue()).rasterProperty());
        TableColumn ramSizeColumn = new TableColumn(Messages.dialogs_AdjustCustomViewDialog_ram);
        ramSizeColumn.setCellValueFactory(cf -> ((RawValuesViewDescriptor)cf.getValue()).ramSizeProperty());
        ramSizeColumn.setCellFactory(cf -> new DataSizeTableCell());
        TableColumn hddSizeColumn = new TableColumn(Messages.dialogs_AdjustCustomViewDialog_hdd);
        hddSizeColumn.setCellFactory(cf -> new DataSizeTableCell());
        hddSizeColumn.setCellValueFactory(cf -> ((RawValuesViewDescriptor)cf.getValue()).hddSizeProperty());
        tableView.getColumns().addAll((Object[])new TableColumn[]{nameColumn, daysColumn, rasterColumn, ramSizeColumn, hddSizeColumn});
        pane.setCenter((Node)tableView);
        Button removeButton = new Button(Messages.dialogs_AdjustCustomViewDialog_remove, (Node)FontIcon.of((Ikon)Dashicons.NO, (int)18, (Color)Color.WHITE));
        removeButton.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)tableView.getSelectionModel().getSelectedItems()));
        removeButton.setOnAction(e -> {
            for (RawValuesViewDescriptor valuesView : tableView.getSelectionModel().getSelectedItems()) {
                this.operations.add((Object)new CustomViewOperation(valuesView, CustomViewOperationType.DELETE));
            }
            tableView.getItems().removeAll((Collection)tableView.getSelectionModel().getSelectedItems());
            tableView.getSelectionModel().clearSelection();
        });
        VBox buttons = new VBox(5.0, new Node[]{removeButton});
        buttons.setPadding(new Insets(5.0, 0.0, 0.0, 10.0));
        pane.setRight((Node)buttons);
        this.getDialogPane().setPrefWidth(600.0);
        this.getDialogPane().setContent((Node)pane);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.APPLY});
        this.getDialogPane().lookupButton(ButtonType.APPLY).disableProperty().bind((ObservableValue)Bindings.isEmpty(this.operations));
        this.setResultConverter(btn -> {
            if (btn != ButtonType.APPLY) {
                return btn;
            }
            ProgressBar progressBar = new ProgressBar(0.0);
            progressBar.setPadding(new Insets(3.0));
            progressBar.setMaxWidth(Double.MAX_VALUE);
            Label progressLabel = new Label();
            progressLabel.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
            VBox box = new VBox(3.0, new Node[]{progressBar, progressLabel});
            VBox.setVgrow((Node)progressBar, (Priority)Priority.ALWAYS);
            pane.setBottom((Node)box);
            ThreadSynchronize.BlockCondition condition = new ThreadSynchronize.BlockCondition();
            Runnable task = () -> {
                try {
                    int i = 0;
                    for (CustomViewOperation operation : this.operations) {
                        int index = operation.getValuesView().getId();
                        if (operation.getType() != CustomViewOperationType.DELETE) continue;
                        double progressBefore = (double)i / (double)this.operations.size();
                        Platform.runLater(() -> progressLabel.setText(String.format(Messages.dialogs_AdjustCustomViewDialog_removing, operation.getValuesView(), progressBefore)));
                        RawValuesViewDAO.remove((int)index);
                        double progressAfter = (double)(++i) / (double)this.operations.size();
                        Platform.runLater(() -> progressBar.setProgress(progressAfter));
                    }
                    sync.asyncExec(() -> condition.release((Object)ButtonType.APPLY));
                }
                catch (DAOOperationException e) {
                    ExceptionDialog excDlg = new ExceptionDialog((Throwable)e);
                    excDlg.initOwner(owner);
                    excDlg.show();
                    sync.asyncExec(() -> condition.release((Object)ButtonType.CANCEL));
                }
            };
            new Thread(task).start();
            return (ButtonType)sync.block(condition);
        });
    }

    protected static String getViewName(RawValuesViewDescriptor descriptor) {
        LocalDateTime from = LocalDateTime.ofInstant(descriptor.getTimeRangeBegin(), ZoneOffset.systemDefault());
        LocalDateTime to = LocalDateTime.ofInstant(descriptor.getTimeRangeEnd(), ZoneOffset.systemDefault());
        LocalDate fromDate = from.toLocalDate();
        LocalDate toDate = to.toLocalDate();
        String text = "";
        String localName = descriptor.getLocalName();
        if (localName != null && !localName.isEmpty()) {
            text = String.valueOf(text) + localName + " - ";
        }
        text = fromDate.equals(toDate) ? String.valueOf(text) + String.format("%s (%s <-> %s)", TimeFormatType.Date.format((TemporalAccessor)fromDate), TimeFormatType.TimeHM.format((TemporalAccessor)from), TimeFormatType.TimeHM.format((TemporalAccessor)to)) : String.valueOf(text) + String.format("%s <-> %s", TimeFormatType.Date.format((TemporalAccessor)fromDate), TimeFormatType.Date.format((TemporalAccessor)toDate));
        return text;
    }

    static class CustomViewOperation {
        private final RawValuesViewDescriptor valuesView;
        private final CustomViewOperationType type;

        public CustomViewOperation(RawValuesViewDescriptor valuesView, CustomViewOperationType type) {
            this.valuesView = valuesView;
            this.type = type;
        }

        public RawValuesViewDescriptor getValuesView() {
            return this.valuesView;
        }

        public CustomViewOperationType getType() {
            return this.type;
        }
    }

    static enum CustomViewOperationType {
        DELETE;

    }

    private static final class DaysCell
    extends TableCell<RawValuesViewDescriptor, Long> {
        public DaysCell() {
            this.setStyle("-fx-alignment: center-right;");
        }

        protected void updateItem(Long item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null) {
                this.setText(null);
            } else {
                double days = (double)item.longValue() / (double)(Raster.Hour.toMilli() * 24L);
                if (days < 1.0) {
                    this.setText("1");
                } else {
                    this.setText(Long.toString(Math.round(days)));
                }
            }
        }
    }
}

