/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.dialogs;

import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import javafx.scene.control.Alert;
import javafx.stage.Window;
import org.controlsfx.dialog.ExceptionDialog;

public class DialogFactory {
    public static void showExceptionDialog(String titleText, Exception exception, Window owner) {
        if (exception instanceof DAOOperationException) {
            DAOOperationException daoOperationException = (DAOOperationException)((Object)exception);
            OperationResult result = daoOperationException.getOperationResult();
            if (result.getType() == ResultType.ExpectedError) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.initOwner(owner);
                alert.setTitle(titleText);
                if (result.getInternalMessage() == null) {
                    alert.setContentText(exception.getMessage());
                } else {
                    alert.setHeaderText(result.getMessage());
                    alert.setContentText(result.getInternalMessage());
                }
                alert.show();
            } else {
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exception);
                dlg.initOwner(owner);
                dlg.setTitle(titleText);
                dlg.setHeaderText(result.getType().toString());
                dlg.setContentText(exception.toString());
                dlg.show();
            }
        } else {
            ExceptionDialog dlg = new ExceptionDialog((Throwable)exception);
            dlg.initOwner(owner);
            dlg.setTitle(titleText);
            dlg.setContentText(exception.getMessage());
            dlg.show();
        }
    }
}

