/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.dialogs;

import de.elpro.ewms.core.client.rawvalues.RawValuesViewFutureTimeRangeDAO;
import de.elpro.ewms.core.rawvalues.RawValuesViewFutureTimeRange;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.FutureTimeRangeType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.gui.Messages;
import de.elpro.ui.formats.NumberFormats;
import de.elpro.ui.fx.controls.DateTimePicker;
import de.elpro.ui.fx.controls.NumericField;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Separator;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Window;

public class FutureConfigDialog
extends Dialog<ButtonType> {
    private RawValuesViewFutureTimeRange future;

    public FutureConfigDialog(Window owner) {
        this.initOwner(owner);
        this.setTitle(Messages.dialogs_FutureConfigDialog_forecast);
        this.future = RawValuesViewFutureTimeRangeDAO.get((RawValuesViewType)RawValuesViewType.GlobalView);
        if (this.future == null) {
            this.future = new RawValuesViewFutureTimeRange(RawValuesViewType.GlobalView);
            this.future.setFutureType(FutureTimeRangeType.FixedRange);
            this.future.setFutureRangeRaster(Raster.Hour);
            this.future.setFutureRangeRasterCount(Integer.valueOf(24));
            this.future.setEnabled(false);
        }
        ToggleGroup toggleGroup = new ToggleGroup();
        RadioButton disableRb = new RadioButton(Messages.dialogs_FutureConfigDialog_deactivated);
        disableRb.setToggleGroup(toggleGroup);
        RadioButton fixedEndTimestampRb = new RadioButton(Messages.dialogs_FutureConfigDialog_fixed_end_time);
        fixedEndTimestampRb.setToggleGroup(toggleGroup);
        RadioButton fixedRangeRb = new RadioButton(Messages.dialogs_FutureConfigDialog_fixed_time_range);
        fixedRangeRb.setToggleGroup(toggleGroup);
        double minLabelWidth = 95.0;
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPrefWidth(500.0);
        gridPane.setPadding(new Insets(10.0));
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(){
            {
                this.setHgrow(Priority.ALWAYS);
            }
        }});
        gridPane.addRow(0, new Node[]{disableRb});
        gridPane.addRow(1, new Node[]{new Separator(Orientation.HORIZONTAL)});
        gridPane.addRow(2, new Node[]{fixedEndTimestampRb});
        GridPane fixedEndTsPane = new GridPane();
        fixedEndTsPane.setHgap(5.0);
        fixedEndTsPane.setVgap(5.0);
        fixedEndTsPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(minLabelWidth){
            {
                this.setMinWidth(d);
            }
        }, new ColumnConstraints(){
            {
                this.setHgrow(Priority.ALWAYS);
            }
        }});
        DateTimePicker fixedEndTsPicker = new DateTimePicker();
        if (this.future.getFutureEndTimestamp() != null) {
            fixedEndTsPicker.setDateTimeValue(LocalDateTime.ofInstant(Instant.ofEpochMilli(this.future.getFutureEndTimestamp()), ZoneId.systemDefault()));
        }
        fixedEndTsPane.addRow(0, new Node[]{new Label(Messages.dialogs_FutureConfigDialog_timestamp), fixedEndTsPicker});
        fixedEndTsPane.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)fixedEndTimestampRb.selectedProperty()));
        gridPane.addRow(3, new Node[]{fixedEndTsPane});
        gridPane.addRow(4, new Node[]{new Separator(Orientation.HORIZONTAL)});
        gridPane.addRow(5, new Node[]{fixedRangeRb});
        GridPane fixedRangePane = new GridPane();
        fixedRangePane.setHgap(5.0);
        fixedRangePane.setVgap(5.0);
        fixedRangePane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(minLabelWidth){
            {
                this.setMinWidth(d);
            }
        }, new ColumnConstraints(){
            {
                this.setHgrow(Priority.ALWAYS);
            }
        }});
        gridPane.addRow(6, new Node[]{fixedRangePane});
        gridPane.addRow(7, new Node[]{new Separator(Orientation.HORIZONTAL)});
        ComboBox rasters = new ComboBox(FXCollections.observableArrayList((Object[])Raster.values()));
        rasters.getSelectionModel().select((Object)this.future.getFutureRangeRaster());
        fixedRangePane.addRow(0, new Node[]{new Label(Messages.dialogs_FutureConfigDialog_base_raster), rasters});
        NumericField rasterCount = new NumericField(Integer.class, NumberFormats.F0);
        rasterCount.setValue((Number)this.future.getFutureRangeRasterCount());
        fixedRangePane.addRow(1, new Node[]{new Label(Messages.dialogs_FutureConfigDialog_raster_count), rasterCount});
        fixedRangePane.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)fixedRangeRb.selectedProperty()));
        if (this.future.isEnabled()) {
            switch (this.future.getFutureType()) {
                case FixedEndTimestamp: {
                    fixedEndTimestampRb.setSelected(true);
                    break;
                }
                case FixedRange: {
                    fixedRangeRb.setSelected(true);
                }
            }
        } else {
            disableRb.setSelected(true);
        }
        disableRb.selectedProperty().addListener((o, ov, nv) -> this.future.setEnabled(nv == false));
        fixedEndTimestampRb.selectedProperty().addListener((o, ov, nv) -> {
            if (nv.booleanValue()) {
                this.future.setFutureType(FutureTimeRangeType.FixedEndTimestamp);
            }
        });
        fixedRangeRb.selectedProperty().addListener((o, ov, nv) -> {
            if (nv.booleanValue()) {
                this.future.setFutureType(FutureTimeRangeType.FixedRange);
            }
        });
        this.future.futureRangeRasterProperty().bind((ObservableValue)rasters.getSelectionModel().selectedItemProperty());
        rasterCount.valueProperty().addListener((o, ov, nv) -> this.future.setFutureRangeRasterCount(nv != null ? Integer.valueOf(nv.intValue()) : null));
        fixedEndTsPicker.dateTimeValueProperty().addListener((o, ov, nv) -> this.future.setFutureEndTimestamp(nv != null ? Long.valueOf(ZonedDateTime.of(nv, ZoneId.systemDefault()).toInstant().toEpochMilli()) : null));
        this.getDialogPane().setContent((Node)gridPane);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
    }

    public RawValuesViewFutureTimeRange getFuture() {
        return this.future;
    }
}

