/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.dialogs;

import com.google.common.base.Charsets;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.component.ClientComponentBase;
import de.elpro.ewms.core.component.ClientInfo;
import de.elpro.ewms.core.component.ComponentBase;
import de.elpro.ewms.core.component.ComponentDependency;
import de.elpro.ewms.core.component.ServerInfo;
import de.elpro.ewms.core.component.VersionUtils;
import de.elpro.ewms.core.html.HTMLPage;
import de.elpro.ewms.gui.dialogs.AboutEOSDialog;
import de.elpro.ewms.gui.utils.e4.EOSPartUtils;
import de.elpro.resources.Icons;
import de.elpro.ui.fx.cells.uimodel.UIModelTableCell;
import de.elpro.ui.model.UIModelElement;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.function.Consumer;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Separator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.text.FontWeight;
import javax.inject.Inject;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.fx.core.log.LoggerFactory;
import org.eclipse.fx.ui.controls.image.GraphicNode;
import org.osgi.framework.Version;

public class InstalledComponentsDialog
extends Dialog<ButtonType> {
    private final MApplication app;
    private final Scene scene;

    @Inject
    public InstalledComponentsDialog(MApplication app, Scene scene, LoggerFactory loggerFactory, ClientInfo clientInfo, ServerInfo serverInfo) {
        this.initOwner(scene.getWindow());
        this.setResizable(true);
        this.app = app;
        this.scene = scene;
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(){
            {
                this.setHgrow(Priority.ALWAYS);
            }
        }});
        grid.setPrefSize(800.0, 700.0);
        int row = 0;
        BorderPane content = new BorderPane((Node)grid);
        ClientComponentBase[] clientComponents = clientInfo != null ? clientInfo.getComponents() : new ClientComponentBase[]{};
        ComponentBase[] serverComponents = serverInfo != null ? serverInfo.getComponents() : new ClientComponentBase[]{};
        TableView<ComponentBase> clientComponentsView = InstalledComponentsDialog.createComponentsView((ComponentBase[])clientComponents, this::showClientChangeLogPart);
        grid.addRow(row++, new Node[]{AboutEOSDialog.label("Client", FontWeight.BOLD)});
        grid.addRow(row++, new Node[]{clientComponentsView});
        TableView<ComponentBase> serverComponentsView = InstalledComponentsDialog.createComponentsView(serverComponents, this::showServerChangeLogPart);
        grid.addRow(row++, new Node[]{AboutEOSDialog.label("Server", FontWeight.BOLD)});
        grid.addRow(row++, new Node[]{serverComponentsView});
        TreeTableView<DependencyViewEntry> dependencyView = InstalledComponentsDialog.createDependencyView(clientInfo, serverInfo);
        grid.addRow(row++, new Node[]{AboutEOSDialog.label("Dependencies", FontWeight.BOLD)});
        grid.addRow(row++, new Node[]{dependencyView});
        Separator separator = new Separator();
        HBox separatorContainer = new HBox(new Node[]{separator});
        HBox.setHgrow((Node)separator, (Priority)Priority.ALWAYS);
        separatorContainer.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
        content.setBottom((Node)separatorContainer);
        this.getDialogPane().setContent((Node)content);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
    }

    private static TreeTableView<DependencyViewEntry> createDependencyView(ClientInfo clientInfo, ServerInfo serverInfo) {
        TreeItem rootItem = new TreeItem();
        ClientComponentBase[] clientComponentBaseArray = clientInfo.getComponents();
        int n = clientComponentBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientComponentBase clientComponent = clientComponentBaseArray[n2];
            DependencyViewEntry clientEntry = new DependencyViewEntry(clientComponent);
            TreeItem clientItem = new TreeItem((Object)clientEntry);
            ComponentDependency[] componentDependencyArray = clientComponent.getServerDependencies();
            int n3 = componentDependencyArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ComponentDependency dependency = componentDependencyArray[n4];
                ComponentBase serverComponent = serverInfo != null ? serverInfo.getComponent(dependency.getId()) : null;
                DependencyViewEntry dependencyEntry = new DependencyViewEntry(dependency, serverComponent);
                TreeItem dependencyItem = new TreeItem((Object)dependencyEntry);
                clientItem.getChildren().add((Object)dependencyItem);
                ++n4;
            }
            clientItem.setExpanded(true);
            rootItem.getChildren().add((Object)clientItem);
            ++n2;
        }
        TreeTableView dependencyView = new TreeTableView(rootItem);
        dependencyView.setShowRoot(false);
        TreeTableColumn nameColumn = new TreeTableColumn("Component");
        nameColumn.setCellValueFactory(cf -> cf.getValue().valueProperty());
        nameColumn.setCellFactory(cf -> new DependencyComponentTreeTableCell());
        TreeTableColumn dependencyRangeColumn = new TreeTableColumn("Version Range");
        dependencyRangeColumn.setCellValueFactory(cf -> new ReadOnlyStringWrapper(((DependencyViewEntry)cf.getValue().getValue()).dependencyRange));
        TreeTableColumn versionColumn = new TreeTableColumn("Version");
        versionColumn.setCellValueFactory(cf -> new ReadOnlyStringWrapper(((DependencyViewEntry)cf.getValue().getValue()).version));
        dependencyView.getColumns().setAll((Object[])new TreeTableColumn[]{nameColumn, dependencyRangeColumn, versionColumn});
        return dependencyView;
    }

    private void showClientChangeLogPart(ComponentBase componentBase) {
        URL changelogURL = componentBase.getChangeLogUrl();
        if (changelogURL == null) {
            return;
        }
        String fileName = new File(changelogURL.getFile()).getName();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream is = changelogURL.openStream();){
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (InputStreamReader reader = new InputStreamReader(is, Charsets.UTF_8);){
                    HTMLPage page = new HTMLPage(fileName, Icons.MARKDOWN_ITEM_URL.toExternalForm(), AboutEOSDialog.convertMDtoHTML(reader));
                    EOSPartUtils.showPart("de.elpro.ewms.gui.partdescriptor.htmlviewer", this.app, page);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            Alert error = new Alert(Alert.AlertType.ERROR);
            error.initOwner(this.scene.getWindow());
            error.setContentText("Could not open ChangeLog file");
        }
    }

    private void showServerChangeLogPart(ComponentBase componentBase) {
        try {
            String fileName = new File(componentBase.getChangeLogUrl().getFile()).getName();
            HTMLPage page = new HTMLPage(String.format("%s (Server)", fileName), Icons.MARKDOWN_ITEM_URL.toExternalForm(), AboutEOSDialog.convertMDtoHTML(ServerDAO.getChangelog((String)componentBase.getId())));
            EOSPartUtils.showPart("de.elpro.ewms.gui.partdescriptor.htmlviewer", this.app, page);
        }
        catch (Exception exception) {
            Alert error = new Alert(Alert.AlertType.ERROR);
            error.initOwner(this.scene.getWindow());
            error.setContentText("Could not open ChangeLog file");
        }
    }

    private static TableView<ComponentBase> createComponentsView(ComponentBase[] components, Consumer<ComponentBase> showPartCallback) {
        TableView table = new TableView(FXCollections.observableArrayList((Object[])components));
        TableColumn idColumn = new TableColumn("Component ID");
        idColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)((ComponentBase)cf.getValue())));
        idColumn.setCellFactory(cf -> new UIModelTableCell());
        TableColumn nameColumn = new TableColumn("Name");
        nameColumn.setCellValueFactory(cf -> new ReadOnlyStringWrapper(((ComponentBase)cf.getValue()).getName()));
        TableColumn versionColumn = new TableColumn("Version");
        versionColumn.setCellFactory(cf -> new VersionTableCell(showPartCallback));
        versionColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)((ComponentBase)cf.getValue())));
        table.getColumns().setAll((Object[])new TableColumn[]{idColumn, nameColumn, versionColumn});
        return table;
    }

    private static final class DependencyComponentTreeTableCell
    extends TreeTableCell<DependencyViewEntry, DependencyViewEntry> {
        private DependencyComponentTreeTableCell() {
        }

        protected void updateItem(DependencyViewEntry item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
                this.setText(null);
            } else if (item.entry instanceof ClientComponentBase) {
                ClientComponentBase clientComponentBase = (ClientComponentBase)item.entry;
                this.setGraphic(clientComponentBase.getGraphic());
                this.setText(String.format("%s (%s)", clientComponentBase.getId(), clientComponentBase.getName()));
            } else {
                ComponentDependency dependency = (ComponentDependency)item.entry;
                if (item.serverComponent != null) {
                    this.setText(String.format("%s (%s)", dependency.getId(), item.serverComponent.getName()));
                    if (dependency.matchNoQualifier(item.serverComponent.getVersion())) {
                        this.setGraphic(dependency.getGraphic());
                    } else {
                        GraphicNode graphic = new GraphicNode();
                        graphic.setGraphic(ComponentDependency.MISSING_ICON.toString());
                        this.setGraphic((Node)graphic);
                    }
                } else {
                    this.setText(dependency.getId());
                    GraphicNode graphic = new GraphicNode();
                    graphic.setGraphic(ComponentDependency.MISSING_ICON.toString());
                    this.setGraphic((Node)graphic);
                }
            }
        }
    }

    private static class DependencyViewEntry {
        private final UIModelElement entry;
        private final String dependencyRange;
        private final String version;
        private final ComponentBase serverComponent;

        public DependencyViewEntry(ClientComponentBase clientComponent) {
            this.entry = clientComponent;
            this.dependencyRange = null;
            this.version = clientComponent.getVersion().toString();
            this.serverComponent = null;
        }

        public DependencyViewEntry(ComponentDependency dependency, ComponentBase serverComponent) {
            this.entry = dependency;
            if (dependency.getMinVersion().equals((Object)dependency.getMaxVersion())) {
                this.dependencyRange = String.format("[%s]", VersionUtils.noQualifier((Version)dependency.getMinVersion()));
            } else {
                String format = dependency.isIncludeMaxVersion() ? "[%s, %s]" : "[%s, %s)";
                this.dependencyRange = String.format(format, VersionUtils.noQualifier((Version)dependency.getMinVersion()), VersionUtils.noQualifier((Version)dependency.getMaxVersion()));
            }
            this.version = serverComponent != null ? serverComponent.getVersion().toString() : null;
            this.serverComponent = serverComponent;
        }
    }

    private static final class VersionTableCell
    extends TableCell<ComponentBase, ComponentBase> {
        private final Consumer<ComponentBase> showPartCallback;

        public VersionTableCell(Consumer<ComponentBase> showPartCallback) {
            this.showPartCallback = showPartCallback;
        }

        protected void updateItem(ComponentBase item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
                this.setText(null);
            } else {
                Hyperlink link = new Hyperlink(item.getVersion().toString());
                link.setOnAction(e -> this.showPartCallback.accept(item));
                this.setGraphic((Node)link);
            }
        }
    }
}

