/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.dialogs;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.resources.ResourceDirectoryDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.cells.LocalDateTimeTableCell;
import de.elpro.ewms.core.resources.RDFolder;
import de.elpro.ewms.core.resources.RDItem;
import de.elpro.ewms.core.resources.ResourceDirectory;
import de.elpro.ewms.gui.Messages;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.cells.uimodel.UIModelTableCell;
import de.elpro.ui.fx.cells.uimodel.UIModelTreeCell;
import de.elpro.ui.fx.controls.tree.LazyTreeItem;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.fx.utils.TaskUtils;
import de.elpro.ui.fx.validator.Validators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Cell;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.PickResult;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import jidefx.scene.control.validation.ValidationUtils;
import jidefx.scene.control.validation.Validator;

public class ResourceDirectoryBrowser
extends BorderPane {
    private final TreeView<RDFolder> foldersView = new TreeView();
    private final TableView<RDItem> itemsView = new TableView();
    private final ProgressIndicatorPane itemsProgressIndicator = new ProgressIndicatorPane(this.itemsView);
    private final TextField fileNameField = new TextField();
    private final BorderPane itemsBox = new BorderPane(this.itemsView, null, null, (Node)new VBox(new Node[]{this.fileNameField}), null);
    private final SplitPane splitPane = new SplitPane(new Node[]{this.foldersView, this.itemsBox});
    private final ProgressIndicatorPane rootProgressIndicator = new ProgressIndicatorPane((Node)this.splitPane);
    private final ResourceDirectory resourceDirectory;
    private final RDFolder rootFolder = new RDFolder();
    private final ObjectProperty<RDFolder> folderProperty = new SimpleObjectProperty((Object)this.rootFolder);
    private final StringProperty fileNameProperty = new SimpleStringProperty();
    private final Function<TreeItem<RDFolder>, List<TreeItem<RDFolder>>> FOLDER_EXPLORER = new Function<TreeItem<RDFolder>, List<TreeItem<RDFolder>>>(){

        @Override
        public List<TreeItem<RDFolder>> apply(TreeItem<RDFolder> item) {
            Transaction trx = Transactions.begin();
            try {
                LinkedList<TreeItem<RDFolder>> treeItems = new LinkedList<TreeItem<RDFolder>>();
                RDFolder[] rDFolderArray = ResourceDirectoryDAO.getResourceDirectoryFolders((Transaction)trx, (ResourceDirectory)ResourceDirectoryBrowser.this.getResourceDirectory(), (String[])((RDFolder)item.getValue()).getPath());
                int n = rDFolderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RDFolder folder = rDFolderArray[n2];
                    treeItems.add((TreeItem<RDFolder>)new LazyTreeItem((Object)folder, ResourceDirectoryBrowser.this.FOLDER_EXPLORER));
                    ++n2;
                }
                LinkedList<TreeItem<RDFolder>> linkedList = treeItems;
                return linkedList;
            }
            finally {
                Transactions.close((Transaction)trx);
            }
        }
    };

    public ResourceDirectoryBrowser(final ResourceDirectory resourceDirectory, String defaultFileName) {
        this.resourceDirectory = resourceDirectory;
        this.rootFolder.setName("./");
        this.rootFolder.setPath(new String[0]);
        this.fileNameProperty.bindBidirectional((Property)this.fileNameField.textProperty());
        this.fileNameProperty.set((Object)defaultFileName);
        ((Pane)this.fileNameField.getParent()).setPadding(new Insets(5.0));
        this.fileNameField.setPadding(new Insets(5.0));
        this.splitPane.setDividerPositions(new double[]{0.25});
        this.foldersView.setCellFactory(cf -> new UIModelTreeCell());
        this.setCenter((Node)this.rootProgressIndicator);
        TableColumn nameColumn = new TableColumn(Messages.dialogs_ResourceDirectoryBrowser_namecolumn);
        nameColumn.setPrefWidth(300.0);
        nameColumn.setCellFactory(cf -> new UIModelTableCell());
        nameColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)((RDItem)cf.getValue())));
        TableColumn sizeColumn = new TableColumn(Messages.dialogs_ResourceDirectoryBrowser_sizecolumn);
        sizeColumn.setPrefWidth(100.0);
        sizeColumn.setCellValueFactory(cf -> new ReadOnlyStringWrapper(((RDItem)cf.getValue()).getFormattedSize()));
        TableColumn lastModifiedColumn = new TableColumn(Messages.dialogs_ResourceDirectoryBrowser_lastmodcolumn);
        lastModifiedColumn.setPrefWidth(150.0);
        lastModifiedColumn.setCellFactory(cf -> new LocalDateTimeTableCell(false));
        lastModifiedColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)((RDItem)cf.getValue()).getLastModified()));
        this.itemsView.getColumns().addAll((Object[])new TableColumn[]{nameColumn, sizeColumn, lastModifiedColumn});
        this.itemsView.setMinWidth(380.0);
        this.foldersView.setOnMouseClicked(me -> {
            if (me.getClickCount() == 1) {
                PickResult pr = me.getPickResult();
                Node intersectedNode = pr.getIntersectedNode();
                if (intersectedNode.getStyleClass().contains((Object)"arrow") || intersectedNode.getStyleClass().contains((Object)"tree-disclosure-node")) {
                    return;
                }
                Cell cell = (Cell)FXUtils.findParent((Node)intersectedNode, Cell.class);
                if (cell == null || !(cell.getItem() instanceof RDFolder)) {
                    return;
                }
                RDFolder rdFolder = (RDFolder)cell.getItem();
                if (me.getButton() == MouseButton.PRIMARY) {
                    this.onSelectFolder(rdFolder);
                }
            }
        });
        this.itemsView.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            if (nv != null) {
                this.fileNameProperty.set((Object)nv.getName());
            }
        });
        CallableTask<Void> loadRootElementsTask = new CallableTask<Void>(){

            public Void call() throws Exception {
                Transaction trx = Transactions.begin();
                try {
                    ArrayList<LazyTreeItem> rootFolders = new ArrayList<LazyTreeItem>();
                    RDFolder[] folders = ResourceDirectoryDAO.getResourceDirectoryFolders((Transaction)trx, (ResourceDirectory)resourceDirectory, (String[])new String[0]);
                    if (folders == null) {
                        Platform.runLater(() -> {
                            Alert alert = new Alert(Alert.AlertType.ERROR);
                            alert.initOwner(ResourceDirectoryBrowser.this.getScene().getWindow());
                            alert.setContentText("Connection data or credentials incorrect");
                            alert.show();
                        });
                        return null;
                    }
                    RDFolder[] rDFolderArray = folders;
                    int n = folders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RDFolder folder = rDFolderArray[n2];
                        rootFolders.add(new LazyTreeItem((Object)folder, ResourceDirectoryBrowser.this.FOLDER_EXPLORER));
                        ++n2;
                    }
                    RDItem[] rootItems = ResourceDirectoryDAO.getResourceDirectoryItems((Transaction)trx, (ResourceDirectory)resourceDirectory, (String[])new String[0]);
                    Platform.runLater(() -> {
                        TreeItem rootItem = new TreeItem((Object)ResourceDirectoryBrowser.this.rootFolder);
                        rootItem.getChildren().addAll((Collection)rootFolders);
                        ResourceDirectoryBrowser.this.foldersView.setRoot(rootItem);
                        ResourceDirectoryBrowser.this.itemsView.setItems(FXCollections.observableArrayList((Object[])rootItems));
                    });
                    return null;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        };
        ValidationUtils.install((Node)this.fileNameField, (Validator)Validators.createNotEmptyValidator());
        TaskUtils.executeUITask((ProgressIndicatorPane)this.rootProgressIndicator, (CallableTask)loadRootElementsTask);
    }

    public ObjectProperty<RDFolder> folderProperty() {
        return this.folderProperty;
    }

    public RDFolder getFolder() {
        return (RDFolder)this.folderProperty.get();
    }

    public StringProperty fileNameProperty() {
        return this.fileNameProperty;
    }

    public String getFileName() {
        return (String)this.fileNameProperty().get();
    }

    private void onSelectFolder(final RDFolder folder) {
        this.folderProperty.set((Object)folder);
        CallableTask<RDItem[]> loadItemsTask = new CallableTask<RDItem[]>(){

            public RDItem[] call() throws Exception {
                Transaction trx = Transactions.begin();
                try {
                    RDItem[] rootItems;
                    RDItem[] rDItemArray = rootItems = ResourceDirectoryDAO.getResourceDirectoryItems((Transaction)trx, (ResourceDirectory)ResourceDirectoryBrowser.this.resourceDirectory, (String[])folder.getPath());
                    return rDItemArray;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.itemsProgressIndicator, (CallableTask)loadItemsTask).consumeResult((state, items) -> Platform.runLater(() -> {
            this.itemsView.getSelectionModel().clearSelection();
            this.itemsView.setItems(FXCollections.observableArrayList((Object[])items));
        }));
    }

    private ResourceDirectory getResourceDirectory() {
        return this.resourceDirectory;
    }
}

