/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.lifecycle;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.client.time.TimeRangeFilterPreferenceDAO;
import de.elpro.ewms.core.client.time.TimelinePhaseDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.time.TimeRangeFilterPreference;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.ewms.gui.model.ILifeCycleHook;
import de.elpro.ewms.gui.toolbar.TimeRangeFilterEditor;
import de.elpro.ui.fx.controls.DateTimePicker;
import de.elpro.ui.fx.e4.FXPartService;
import de.elpro.ui.utils.e4.NamedContextValue;
import de.elpro.ui.utils.e4.PartUtils;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javafx.scene.Node;
import javafx.stage.Stage;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.osgi.service.component.annotations.Component;

@Component
public class InitializeContextHook
implements ILifeCycleHook {
    @Override
    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    @Override
    public String getJobName() {
        return "Initialize context";
    }

    @Override
    public ILifeCycleHook.HookResult hook(final IEclipseContext context, Stage loaderStage) throws Exception {
        Transaction trx = Transactions.begin();
        TimeRangeFilterPreference timeRangeFilterPrefs = null;
        try {
            timeRangeFilterPrefs = TimeRangeFilterPreferenceDAO.getUserPreferences((Transaction)trx);
            if (timeRangeFilterPrefs != null) {
                if (timeRangeFilterPrefs.getPhaseFrom() != null) {
                    timeRangeFilterPrefs.setPhaseFrom(TimelinePhaseDAO.get((Transaction)trx, (int)timeRangeFilterPrefs.getPhaseFrom().getId()));
                }
                if (timeRangeFilterPrefs.getPhaseTo() != null) {
                    timeRangeFilterPrefs.setPhaseTo(TimelinePhaseDAO.get((Transaction)trx, (int)timeRangeFilterPrefs.getPhaseTo().getId()));
                }
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        try {
            if (timeRangeFilterPrefs == null) {
                timeRangeFilterPrefs = new TimeRangeFilterPreference();
                timeRangeFilterPrefs.setType(TimeRangeFilterType.GlobalView_Date);
                timeRangeFilterPrefs.setDateFrom(VirtualZone.INSTANCE.getOffsetDateTime(ServerDAO.getGlobalViewTimeRange().getFrom()).toLocalDate());
            }
            ITimeRangeFilter trf = TimeRangeFilterEditor.createFilter(timeRangeFilterPrefs);
            context.set(ITimeRangeFilter.class, (Object)trf);
        }
        catch (Exception exception) {}
        context.set(FXPartService.class, (Object)new FXPartService(){

            public void showPart(String targetPartStackId, boolean replaceUndirtyParts, Node content) {
                PartUtils.showOrReplacePartWithNamedContext((String)"de.elpro.ewms.gui.partstack.editors", (String)"de.elpro.ewms.gui.partdescriptor.genericcontent", (MApplication)((MApplication)context.get(MApplication.class)), (boolean)replaceUndirtyParts, (NamedContextValue[])new NamedContextValue[]{new NamedContextValue((Object)"generic-content-node", (Object)content)});
            }
        });
        DateTimePicker.setDefaultDateConverter(ld -> {
            ZonedDateTime zdt = ZonedDateTime.of(ld, LocalTime.of(0, 0), ZoneId.systemDefault());
            LocalDateTime ldt = LocalDateTime.ofInstant(VirtualRaster.Day.getRasterEnd(zdt.toInstant()), ZoneId.systemDefault());
            return ldt;
        });
        return CONTINUE;
    }
}

