/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.gui.lifecycle;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.units.MeasuringUnitDAO;
import de.elpro.ewms.core.client.units.PhysicalUnitDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.units.DynamicMeasuringUnit;
import de.elpro.ewms.core.units.DynamicPhysicalUnit;
import de.elpro.ewms.core.units.MeasuringUnitDefinition;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.units.PhysicalUnitDefinition;
import de.elpro.ewms.core.units.PhysicalUnitRegistry;
import de.elpro.ewms.gui.model.ILifeCycleHook;
import java.util.Arrays;
import java.util.LinkedList;
import javafx.stage.Stage;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.service.component.annotations.Component;

@Component
public class InitializePhysicalUnitsHook
implements ILifeCycleHook {
    @Override
    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    @Override
    public String getJobName() {
        return "Initialize Dynamic Physical Units Definitions";
    }

    @Override
    public ILifeCycleHook.HookResult hook(IEclipseContext context, Stage loaderStage) throws Exception {
        PhysicalUnitRegistry.cleadDynamicDefinitions();
        Transaction trx = Transactions.begin();
        try {
            LinkedList<PhysicalUnitDefinition> serverPUDefinitions = new LinkedList<PhysicalUnitDefinition>();
            serverPUDefinitions.addAll(Arrays.asList(PhysicalUnitDAO.getAllPredefined()));
            serverPUDefinitions.addAll(Arrays.asList(PhysicalUnitDAO.getAllDynamic((Transaction)trx)));
            for (PhysicalUnitDefinition pud : serverPUDefinitions) {
                if (!PhysicalUnitRegistry.containsPhysicalUnit((String)pud.getKey())) {
                    DynamicPhysicalUnit dpu = new DynamicPhysicalUnit(pud);
                    dpu.init();
                }
                PhysicalUnit pu = PhysicalUnit.getPhysicalUnit((String)pud.getKey());
                LinkedList<MeasuringUnitDefinition> serverMUDefinitions = new LinkedList<MeasuringUnitDefinition>();
                serverMUDefinitions.addAll(Arrays.asList(MeasuringUnitDAO.getAllPredefined((String)pud.getKey())));
                serverMUDefinitions.addAll(Arrays.asList(MeasuringUnitDAO.getAllDynamic((Transaction)trx, (String)pud.getKey())));
                for (MeasuringUnitDefinition mud : serverMUDefinitions) {
                    if (pu.containsMeasuringUnit(mud.getKey())) continue;
                    DynamicMeasuringUnit dmu = new DynamicMeasuringUnit(mud);
                    dmu.init();
                }
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        return CONTINUE;
    }
}

